/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.session;

import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.remote.RmServer3DEngine;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.jami.remote.RmRenderConnection;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.remote.codec.PassThruPBCodec;
import com.ge.med.terra.jami.render.remote.RmServer2DEngine;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class LocalRenderSession
implements RmRenderSession {
    private boolean closed = false;

    @Override
    public RmRenderConnection createConnection(String connectionType, String[] args) {
        if (!this.closed) {
            if (connectionType.equalsIgnoreCase("3D")) {
                return new Client3DRenderConnection(args[0]);
            }
            if (connectionType.equalsIgnoreCase("2D")) {
                return new Client2DRenderConnection(args[0]);
            }
        }
        return null;
    }

    @Override
    public Object getRemoteData(String[] args) {
        DMSession dms = new DMSession(new String[]{"file", args[1]});
        DMObject[] dmo = dms.getRelated("series");
        if (args[0].equalsIgnoreCase("volume")) {
            DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
            return vol;
        }
        if (args[0].equalsIgnoreCase("images")) {
            DMImage[] imgs = dmo[0].getImages(null);
            return imgs;
        }
        return null;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private static class Client3DRenderConnection
    implements RmRenderConnection {
        private RmServer3DEngine serverEngine = null;
        protected static int ID_CNT = 0;
        private int connection_id = 0;
        private List tmonitors = new ArrayList();
        private RmPixelBufferCodec pbcodec = new PassThruPBCodec();

        public Client3DRenderConnection(String render_engine) {
            this.setId(ID_CNT++);
            T3DRenderEngine engine = Commons3D.createRenderEngine(render_engine);
            if (engine != null) {
                this.serverEngine = new RmServer3DEngine(engine);
                return;
            }
            throw new RuntimeException("Invalid render engine class: " + render_engine);
        }

        @Override
        public void close() {
        }

        @Override
        public Object execute(RmCommand cmd) {
            return this.serverEngine.executeCommand(cmd);
        }

        @Override
        public String[] getSupportedCodecs() {
            return (String[])this.serverEngine.executeCommand(new RmCommand(35, null));
        }

        @Override
        public String getCodec() {
            if (this.pbcodec != null) {
                return this.pbcodec.getName();
            }
            return null;
        }

        @Override
        public boolean setCodec(String codecName) {
            Class<?> codecClass = null;
            String currCodec = this.getCodec();
            try {
                codecClass = Class.forName(codecName);
            }
            catch (ClassNotFoundException e2) {
                return false;
            }
            String[] supportedCodecs = this.getSupportedCodecs();
            boolean found = false;
            for (int i2 = 0; i2 < supportedCodecs.length; ++i2) {
                if (!supportedCodecs[i2].equals(codecName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            boolean success = (Boolean)this.serverEngine.executeCommand(new RmCommand(36, new Object[]{codecName}));
            if (success) {
                try {
                    Constructor<?> con = codecClass.getConstructor(null);
                    this.pbcodec = (RmPixelBufferCodec)con.newInstance(null);
                }
                catch (Exception e3) {
                    success = false;
                    this.serverEngine.executeCommand(new RmCommand(36, new Object[]{currCodec}));
                }
            }
            return success;
        }

        @Override
        public RmPixelBuffer render(int renderOutputLayer, int passno, byte renderType) {
            RmCommand cmd = new RmCommand(5, new Object[]{new Integer(renderOutputLayer), new Integer(passno), new Byte(renderType)});
            Object retval = this.serverEngine.executeCommand(cmd);
            Object[] retvals = (Object[])retval;
            int pboffset = (Integer)retvals[0];
            int pblen = (Integer)retvals[1];
            byte[] pbstream = (byte[])retvals[2];
            return this.pbcodec.decode(pbstream, pboffset, pblen);
        }

        @Override
        public void addTaskMonitor(TaskMonitor tm) {
            this.tmonitors.add(tm);
        }

        @Override
        public void removeTaskMonitor(TaskMonitor tm) {
            this.tmonitors.remove(tm);
        }

        protected void setId(int id) {
            this.connection_id = id;
        }

        @Override
        public int getId() {
            return this.connection_id;
        }
    }

    private static class Client2DRenderConnection
    implements RmRenderConnection {
        private RmServer2DEngine serverEngine = null;
        protected static int ID_CNT = 0;
        private int connection_id = 0;
        private List tmonitors = new ArrayList();
        private RmPixelBufferCodec pbcodec = new PassThruPBCodec();

        public Client2DRenderConnection(String arg) {
            this.setId(ID_CNT++);
            this.serverEngine = new RmServer2DEngine(null);
        }

        @Override
        public void addTaskMonitor(TaskMonitor tm) {
            this.tmonitors.add(tm);
        }

        @Override
        public void close() {
        }

        @Override
        public Object execute(RmCommand cmd) {
            return this.serverEngine.executeCommand(cmd);
        }

        @Override
        public String getCodec() {
            return null;
        }

        @Override
        public int getId() {
            return this.connection_id;
        }

        protected void setId(int id) {
            this.connection_id = id;
        }

        @Override
        public String[] getSupportedCodecs() {
            return null;
        }

        @Override
        public void removeTaskMonitor(TaskMonitor tm) {
            this.tmonitors.remove(tm);
        }

        @Override
        public RmPixelBuffer render(int renderOutputLayer, int passno, byte renderType) {
            Object retval = this.serverEngine.executeCommand(new RmCommand(1, new Object[]{new Integer(renderOutputLayer), new Integer(passno), new Byte(renderType)}));
            Object[] retvals = (Object[])retval;
            int pblen = (Integer)retvals[0];
            byte[] pbstream = (byte[])retvals[1];
            return this.pbcodec.decode(pbstream, 0, pblen);
        }

        @Override
        public boolean setCodec(String codecName) {
            return false;
        }
    }
}

