/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.session;

import com.ge.med.idc.RemoteVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.jami.remote.session.WSCaller;
import java.util.HashMap;
import java.util.Map;

public class WSVolume
implements RemoteVolume {
    private int volumeId = -1;
    private WSCaller caller = null;
    private XjVolumeInfo vinfo = null;
    private String remotePath = null;
    private Map<String, Object> dcmMap = new HashMap<String, Object>();

    public WSVolume(WSCaller caller, String remotePath) {
        this.caller = caller;
        this.remotePath = remotePath;
        this.volumeId = caller.loadVolume(remotePath);
    }

    @Override
    public int getBitsPerVoxel() {
        return this.getVolInfo().getBitsPerVoxel();
    }

    @Override
    public int getPixelType() {
        return this.getVolInfo().getPixelType();
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        String key = "" + group + "," + element;
        if (this.dcmMap.containsKey(key)) {
            return this.dcmMap.get(key);
        }
        XjTagValue tv = new XjTagValue(group, element);
        this.caller.getValues(this.volumeId, sliceNo, new XjTagValue[]{tv});
        this.dcmMap.put(key, tv.value);
        return tv.value;
    }

    @Override
    public String getRelatedComposite() {
        return this.getVolInfo().getRelatedComposite();
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getVSliceValue(-1, group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        for (int i2 = 0; i2 < tv.length; ++i2) {
            Object value = this.getValue(tv[i2].group, tv[i2].element);
            if (value == null) continue;
            tv[i2].value = value;
        }
        return tv.length;
    }

    private XjVolumeInfo getVolInfo() {
        if (this.vinfo == null) {
            this.vinfo = this.caller.getVolumeInfo(this.volumeId);
        }
        return this.vinfo;
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        return this.getVolInfo().getVolumeDimensions(dims);
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        return this.getVolInfo().getRASOfOrigin(ras_ulc);
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        return this.getVolInfo().getXDirectionRAS(ras_dx);
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        return this.getVolInfo().getYDirectionRAS(ras_dy);
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dz) {
        return this.getVolInfo().getZDirectionRAS(ras_dz);
    }

    @Override
    public String getRemoteDescriptor() {
        return this.remotePath;
    }

    @Override
    public int getRemoteId() {
        return this.volumeId;
    }
}

