/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.render.Interpolation;
import java.util.Arrays;

public class Bicubic
extends Interpolation {
    public static final int SHIFT = 14;
    public static final int SCALE = 16384;
    public static final int MASK = 16383;
    private static final double A = -0.5;
    private static final double A_PLUS2 = 1.5;
    private static final double A_PLUS3 = 2.5;
    public static int[] ctable = null;

    public static double cubic(double x2) {
        double x22 = x2 * x2;
        double x3 = x22 * x2;
        double y2 = 0.0;
        if (x2 >= 0.0 && x2 < 1.0) {
            y2 = 1.5 * x3 - 2.5 * x22 + 1.0;
        } else if (x2 >= 1.0 && x2 < 2.0) {
            y2 = -0.5 * x3 - -2.5 * x22 + -4.0 * x2 - -2.0;
        }
        return y2;
    }

    private static void buildTable(int[] cubicTable) {
        for (int i2 = 0; i2 < cubicTable.length; ++i2) {
            double x2 = (double)i2 / 16384.0;
            double cvalue = Bicubic.cubic(x2);
            cubicTable[i2] = (int)(cvalue * 16384.0);
        }
    }

    public final void shortToshort(double[] tx, double[] itx, short[] input, int ioffset, int iw, int ih, short[] output, int ow, int oh, int xstart, int ystart, int width, int height, int stepx, int stepy) {
        int x_end;
        int y_end;
        int x_start;
        int y_start;
        int m00 = (int)(itx[0] * 16384.0);
        int m10 = (int)(itx[1] * 16384.0);
        int m01 = (int)(itx[2] * 16384.0);
        int m11 = (int)(itx[3] * 16384.0);
        int m02 = (int)(itx[4] * 16384.0);
        int m12 = (int)(itx[5] * 16384.0);
        double xdir_x = itx[0] * 1.0 + itx[2] * 0.0;
        double xdir_y = itx[1] * 1.0 + itx[3] * 0.0;
        int ixdir_x = (int)((double)stepx * xdir_x * 16384.0);
        int ixdir_y = (int)((double)stepx * xdir_y * 16384.0);
        JnPoint2D.Double p2 = new JnPoint2D.Double();
        int PAD = 3;
        boolean START = true;
        ((JnPoint2D)p2).setLocation(1.0, 1.0);
        double xxul = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yyul = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        double dx1 = xxul;
        double dy1 = yyul;
        double dx2 = xxul;
        double dy2 = yyul;
        ((JnPoint2D)p2).setLocation(1.0, ih - 1 - 3);
        double xxbl = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yybl = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        dx1 = Math.min(dx1, xxbl);
        dx2 = Math.max(dx2, xxbl);
        dy1 = Math.min(dy1, yybl);
        dy2 = Math.max(dy2, yybl);
        ((JnPoint2D)p2).setLocation(iw - 1 - 3, 1.0);
        double xxur = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yyur = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        dx1 = Math.min(dx1, xxur);
        dx2 = Math.max(dx2, xxur);
        dy1 = Math.min(dy1, yyur);
        dy2 = Math.max(dy2, yyur);
        ((JnPoint2D)p2).setLocation(iw - 1 - 3, ih - 1 - 3);
        double xxbr = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yybr = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        dx1 = Math.min(dx1, xxbr);
        dx2 = Math.max(dx2, xxbr);
        dy1 = Math.min(dy1, yybr);
        dy2 = Math.max(dy2, yybr);
        int x1 = (int)Math.max(Math.ceil(dx1), 0.0);
        int x2 = (int)Math.min(Math.floor(dx2), (double)(ow - 2));
        int y1 = (int)Math.max(Math.ceil(dy1), 0.0);
        int y2 = (int)Math.min(Math.floor(dy2), (double)(oh - 2));
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (y_start = ystart; y_start < y1; y_start += stepy) {
        }
        for (x_start = xstart; x_start < x1; x_start += stepx) {
        }
        int yend = Math.min(ystart + height, oh);
        int xend = Math.min(xstart + width, ow);
        for (y_end = yend; y_end > y2; y_end -= stepy) {
        }
        for (x_end = xend; x_end > x2; x_end -= stepx) {
        }
        int lastX = 0;
        int lastY = 0;
        for (int y3 = y_start; y3 < y_end; y3 += stepy) {
            int offset = y3 * ow;
            int pos_x = m00 * x_start + m01 * y3 + m02;
            int pos_y = m10 * x_start + m11 * y3 + m12;
            lastY = y3;
            for (int x3 = x_start; x3 < x_end; x3 += stepx) {
                int xc = pos_x >> 14;
                int yc = pos_y >> 14;
                int yoffset = ioffset + yc * iw;
                int yoffset0 = yoffset - iw;
                int yoffset1 = yoffset;
                int yoffset2 = yoffset + iw;
                int yoffset3 = yoffset2 + iw;
                int xfrac = pos_x & 0x3FFF;
                int yfrac = pos_y & 0x3FFF;
                int xfrac_1 = 16384 - xfrac;
                int yfrac_1 = 16384 - yfrac;
                short v00 = input[yoffset0 + xc - 1];
                short v01 = input[yoffset0 + xc];
                short v02 = input[yoffset0 + xc + 1];
                short v03 = input[yoffset0 + xc + 2];
                short v10 = input[yoffset1 + xc - 1];
                short v11 = input[yoffset1 + xc];
                short v12 = input[yoffset1 + xc + 1];
                short v13 = input[yoffset1 + xc + 2];
                short v20 = input[yoffset2 + xc - 1];
                short v21 = input[yoffset2 + xc];
                short v22 = input[yoffset2 + xc + 1];
                short v23 = input[yoffset2 + xc + 2];
                short v30 = input[yoffset3 + xc - 1];
                short v31 = input[yoffset3 + xc];
                short v32 = input[yoffset3 + xc + 1];
                short v33 = input[yoffset3 + xc + 2];
                int k0 = ctable[xfrac];
                int k1 = ctable[xfrac + 16384];
                int k2 = ctable[xfrac_1];
                int k3 = ctable[xfrac_1 + 16384];
                int v0 = k0 * v01 + k1 * v00 + k2 * v02 + k3 * v03 >> 14;
                int v1 = k0 * v11 + k1 * v10 + k2 * v12 + k3 * v13 >> 14;
                int v2 = k0 * v21 + k1 * v20 + k2 * v22 + k3 * v23 >> 14;
                int v3 = k0 * v31 + k1 * v30 + k2 * v32 + k3 * v33 >> 14;
                int v4 = ctable[yfrac] * v1 + ctable[yfrac + 16384] * v0 + ctable[yfrac_1] * v2 + ctable[yfrac_1 + 16384] * v3 >> 14;
                output[offset + x3] = (short)v4;
                pos_x += ixdir_x;
                pos_y += ixdir_y;
                lastX = x3;
            }
        }
        Bicubic.fillBorderLinear(itx, input, ioffset, iw, ih, output, ow, oh, xdir_x, xdir_y, stepx, stepy, xstart, ystart, xend, yend, x_start, x_end, y_start, y_end, lastX, lastY);
    }

    public final void shortToshortXZ(double[] tx, double[] itx, short[] input, int ioffset, int dx, int dy, int dz, short[] output, int ow, int oh, int xstart, int ystart, int width, int height, int stepx, int stepy) {
        int x_end;
        int y_end;
        int x_start;
        int y_start;
        int pgsize = dx * dy;
        int m00 = (int)(itx[0] * 16384.0);
        int m10 = (int)(itx[1] * 16384.0);
        int m01 = (int)(itx[2] * 16384.0);
        int m11 = (int)(itx[3] * 16384.0);
        int m02 = (int)(itx[4] * 16384.0);
        int m12 = (int)(itx[5] * 16384.0);
        double xdir_x = itx[0] * 1.0 + itx[2] * 0.0;
        double xdir_y = itx[1] * 1.0 + itx[3] * 0.0;
        int ixdir_x = (int)((double)stepx * xdir_x * 16384.0);
        int ixdir_y = (int)((double)stepx * xdir_y * 16384.0);
        JnPoint2D.Double p2 = new JnPoint2D.Double();
        int PAD = 2;
        ((JnPoint2D)p2).setLocation(2.0, 2.0);
        double xxul = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yyul = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        double dx1 = xxul;
        double dy1 = yyul;
        double dx2 = xxul;
        double dy2 = yyul;
        ((JnPoint2D)p2).setLocation(2.0, dz - 1 - 2);
        double xxbl = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yybl = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        dx1 = Math.min(dx1, xxbl);
        dx2 = Math.max(dx2, xxbl);
        dy1 = Math.min(dy1, yybl);
        dy2 = Math.max(dy2, yybl);
        ((JnPoint2D)p2).setLocation(dx - 1 - 2, 2.0);
        double xxur = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yyur = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        dx1 = Math.min(dx1, xxur);
        dx2 = Math.max(dx2, xxur);
        dy1 = Math.min(dy1, yyur);
        dy2 = Math.max(dy2, yyur);
        ((JnPoint2D)p2).setLocation(dx - 1 - 2, dz - 1 - 2);
        double xxbr = tx[0] * ((JnPoint2D)p2).getX() + tx[2] * ((JnPoint2D)p2).getY() + tx[4];
        double yybr = tx[1] * ((JnPoint2D)p2).getX() + tx[3] * ((JnPoint2D)p2).getY() + tx[5];
        dx1 = Math.min(dx1, xxbr);
        dx2 = Math.max(dx2, xxbr);
        dy1 = Math.min(dy1, yybr);
        dy2 = Math.max(dy2, yybr);
        int x1 = (int)Math.max(Math.ceil(dx1), 0.0);
        int x2 = (int)Math.min(Math.floor(dx2), (double)(ow - 2));
        int y1 = (int)Math.max(Math.ceil(dy1), 0.0);
        int y2 = (int)Math.min(Math.floor(dy2), (double)(oh - 2));
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (y_start = ystart; y_start < y1; y_start += stepy) {
        }
        for (x_start = xstart; x_start < x1; x_start += stepx) {
        }
        int yend = Math.min(ystart + height, oh);
        int xend = Math.min(xstart + width, ow);
        for (y_end = yend; y_end > y2; y_end -= stepy) {
        }
        for (x_end = xend; x_end > x2; x_end -= stepx) {
        }
        int lastX = 0;
        int lastY = 0;
        for (int y3 = y_start; y3 < y_end; y3 += stepy) {
            int offset = y3 * ow;
            int pos_x = m00 * x_start + m01 * y3 + m02;
            int pos_z = m10 * x_start + m11 * y3 + m12;
            lastY = y3;
            for (int x3 = x_start; x3 < x_end; x3 += stepx) {
                int xc = pos_x >> 14;
                int zc = pos_z >> 14;
                int zoffset = ioffset + zc * pgsize;
                int zoffset0 = zoffset - pgsize;
                int zoffset1 = zoffset;
                int zoffset2 = zoffset + pgsize;
                int zoffset3 = zoffset2 + pgsize;
                int xfrac = pos_x & 0x3FFF;
                int zfrac = pos_z & 0x3FFF;
                int xfrac_1 = 16384 - xfrac;
                int zfrac_1 = 16384 - zfrac;
                short v00 = input[zoffset0 + xc - 1];
                short v01 = input[zoffset0 + xc];
                short v02 = input[zoffset0 + xc + 1];
                short v03 = input[zoffset0 + xc + 2];
                short v10 = input[zoffset1 + xc - 1];
                short v11 = input[zoffset1 + xc];
                short v12 = input[zoffset1 + xc + 1];
                short v13 = input[zoffset1 + xc + 2];
                short v20 = input[zoffset2 + xc - 1];
                short v21 = input[zoffset2 + xc];
                short v22 = input[zoffset2 + xc + 1];
                short v23 = input[zoffset2 + xc + 2];
                short v30 = input[zoffset3 + xc - 1];
                short v31 = input[zoffset3 + xc];
                short v32 = input[zoffset3 + xc + 1];
                short v33 = input[zoffset3 + xc + 2];
                int k0 = ctable[xfrac];
                int k1 = ctable[xfrac + 16384];
                int k2 = ctable[xfrac_1];
                int k3 = ctable[xfrac_1 + 16384];
                int v0 = k0 * v01 + k1 * v00 + k2 * v02 + k3 * v03 >> 14;
                int v1 = k0 * v11 + k1 * v10 + k2 * v12 + k3 * v13 >> 14;
                int v2 = k0 * v21 + k1 * v20 + k2 * v22 + k3 * v23 >> 14;
                int v3 = k0 * v31 + k1 * v30 + k2 * v32 + k3 * v33 >> 14;
                int v4 = ctable[zfrac] * v1 + ctable[zfrac + 16384] * v0 + ctable[zfrac_1] * v2 + ctable[zfrac_1 + 16384] * v3 >> 14;
                output[offset + x3] = (short)v4;
                pos_x += ixdir_x;
                pos_z += ixdir_y;
                lastX = x3;
            }
        }
        Bicubic.fillBorderLinearXZ(itx, input, ioffset, dx, dy, dz, output, ow, oh, xdir_x, xdir_y, stepx, stepy, xstart, ystart, xend, yend, x_start, x_end, y_start, y_end, lastX, lastY);
    }

    public final void doBicubicARGBToARGB(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
        long t1 = System.currentTimeMillis();
        JnPoint2D.Double iul = new JnPoint2D.Double();
        JnPoint2D.Double ibl = new JnPoint2D.Double();
        JnPoint2D.Double iur = new JnPoint2D.Double();
        JnPoint2D.Double ibr = new JnPoint2D.Double();
        ((JnPoint2D)iul).setLocation(0.0, 0.0);
        ((JnPoint2D)ibl).setLocation(0.0, ih - 1);
        ((JnPoint2D)iur).setLocation(iw - 1, 0.0);
        ((JnPoint2D)ibr).setLocation(iw - 1, ih - 1);
        double xxul = tx[0] * ((JnPoint2D)iul).getX() + tx[2] * ((JnPoint2D)iul).getY() + tx[4];
        double yyul = tx[1] * ((JnPoint2D)iul).getX() + tx[3] * ((JnPoint2D)iul).getY() + tx[5];
        int x1 = (int)xxul;
        int y1 = (int)yyul;
        int x2 = (int)xxul;
        int y2 = (int)yyul;
        double xxbl = tx[0] * ((JnPoint2D)ibl).getX() + tx[2] * ((JnPoint2D)ibl).getY() + tx[4];
        double yybl = tx[1] * ((JnPoint2D)ibl).getX() + tx[3] * ((JnPoint2D)ibl).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbl);
        x2 = Math.max(x2, (int)xxbl);
        y1 = Math.min(y1, (int)yybl);
        y2 = Math.max(y2, (int)yybl);
        double xxur = tx[0] * ((JnPoint2D)iur).getX() + tx[2] * ((JnPoint2D)iur).getY() + tx[4];
        double yyur = tx[1] * ((JnPoint2D)iur).getX() + tx[3] * ((JnPoint2D)iur).getY() + tx[5];
        x1 = Math.min(x1, (int)xxur);
        x2 = Math.max(x2, (int)xxur);
        y1 = Math.min(y1, (int)yyur);
        y2 = Math.max(y2, (int)yyur);
        double xxbr = tx[0] * ((JnPoint2D)ibr).getX() + tx[2] * ((JnPoint2D)ibr).getY() + tx[4];
        double yybr = tx[1] * ((JnPoint2D)ibr).getX() + tx[3] * ((JnPoint2D)ibr).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbr);
        x2 = Math.max(x2, (int)xxbr);
        y1 = Math.min(y1, (int)yybr);
        y2 = Math.max(y2, (int)yybr);
        x1 = Math.max(x1, 0);
        x2 = Math.min(x2, ow - 2);
        y1 = Math.max(y1, 0);
        y2 = Math.min(y2, oh - 2);
        Arrays.fill(output, background);
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (int y3 = y1; y3 < y2; ++y3) {
            int offset = y3 * ow;
            for (int x3 = x1; x3 < x2; ++x3) {
                double xx = itx[0] * (double)x3 + itx[2] * (double)y3 + itx[4];
                double yy = itx[1] * (double)x3 + itx[3] * (double)y3 + itx[5];
                int xc = (int)xx;
                int yc = (int)yy;
                int yoffset0 = ioffset + (yc - 1) * iw;
                int yoffset1 = ioffset + yc * iw;
                int yoffset2 = ioffset + (yc + 1) * iw;
                int yoffset3 = ioffset + (yc + 2) * iw;
                double xfrac = xx - (double)xc;
                double yfrac = yy - (double)yc;
                double xfrac_1 = 1.0 - xfrac;
                double yfrac_1 = 1.0 - yfrac;
                int v00 = 0;
                int v01 = 0;
                int v02 = 0;
                int v03 = 0;
                int v10 = 0;
                int v11 = 0;
                int v12 = 0;
                int v13 = 0;
                int v20 = 0;
                int v21 = 0;
                int v22 = 0;
                int v23 = 0;
                int v30 = 0;
                int v31 = 0;
                int v32 = 0;
                int v33 = 0;
                if (xc >= 1 && xc < iw - 2 && yc >= 1 && yc < ih - 2) {
                    v00 = input[yoffset0 + xc - 1] & 0xFF;
                    v01 = input[yoffset0 + xc] & 0xFF;
                    v02 = input[yoffset0 + xc + 1] & 0xFF;
                    v03 = input[yoffset0 + xc + 2] & 0xFF;
                    v10 = input[yoffset1 + xc - 1] & 0xFF;
                    v11 = input[yoffset1 + xc] & 0xFF;
                    v12 = input[yoffset1 + xc + 1] & 0xFF;
                    v13 = input[yoffset1 + xc + 2] & 0xFF;
                    v20 = input[yoffset2 + xc - 1] & 0xFF;
                    v21 = input[yoffset2 + xc] & 0xFF;
                    v22 = input[yoffset2 + xc + 1] & 0xFF;
                    v23 = input[yoffset2 + xc + 2] & 0xFF;
                    v30 = input[yoffset3 + xc - 1] & 0xFF;
                    v31 = input[yoffset3 + xc] & 0xFF;
                    v32 = input[yoffset3 + xc + 1] & 0xFF;
                    v33 = input[yoffset3 + xc + 2] & 0xFF;
                }
                double v0 = Bicubic.cubic(xfrac) * (double)v01 + Bicubic.cubic(xfrac + 1.0) * (double)v00 + Bicubic.cubic(xfrac_1) * (double)v02 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v03;
                double v1 = Bicubic.cubic(xfrac) * (double)v11 + Bicubic.cubic(xfrac + 1.0) * (double)v10 + Bicubic.cubic(xfrac_1) * (double)v12 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v13;
                double v2 = Bicubic.cubic(xfrac) * (double)v21 + Bicubic.cubic(xfrac + 1.0) * (double)v20 + Bicubic.cubic(xfrac_1) * (double)v22 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v23;
                double v3 = Bicubic.cubic(xfrac) * (double)v31 + Bicubic.cubic(xfrac + 1.0) * (double)v30 + Bicubic.cubic(xfrac_1) * (double)v32 + Bicubic.cubic(xfrac_1 + 1.0) * (double)v33;
                double v4 = Bicubic.cubic(yfrac) * v1 + Bicubic.cubic(yfrac + 1.0) * v0 + Bicubic.cubic(yfrac_1) * v2 + Bicubic.cubic(yfrac_1 + 1.0) * v3;
                int ival = v4 > 255.0 ? 255 : (int)v4;
                ival = v4 < 0.0 ? 0 : ival;
                output[offset + x3] = 0xFF000000 | ival << 16 | ival << 8 | ival;
            }
        }
    }

    public final void doIBicubicARGBToARGB(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
        int inputY;
        int inputX;
        long t1 = System.currentTimeMillis();
        int m00 = (int)(itx[0] * 16384.0);
        int m10 = (int)(itx[1] * 16384.0);
        int m01 = (int)(itx[2] * 16384.0);
        int m11 = (int)(itx[3] * 16384.0);
        int m02 = (int)(itx[4] * 16384.0);
        int m12 = (int)(itx[5] * 16384.0);
        JnPoint2D.Double iul = new JnPoint2D.Double();
        JnPoint2D.Double ibl = new JnPoint2D.Double();
        JnPoint2D.Double iur = new JnPoint2D.Double();
        JnPoint2D.Double ibr = new JnPoint2D.Double();
        ((JnPoint2D)iul).setLocation(0.0, 0.0);
        ((JnPoint2D)ibl).setLocation(0.0, ih - 1);
        ((JnPoint2D)iur).setLocation(iw - 1, 0.0);
        ((JnPoint2D)ibr).setLocation(iw - 1, ih - 1);
        double xxul = tx[0] * ((JnPoint2D)iul).getX() + tx[2] * ((JnPoint2D)iul).getY() + tx[4];
        double yyul = tx[1] * ((JnPoint2D)iul).getX() + tx[3] * ((JnPoint2D)iul).getY() + tx[5];
        int x1 = (int)xxul;
        int y1 = (int)yyul;
        int x2 = (int)xxul;
        int y2 = (int)yyul;
        double xxbl = tx[0] * ((JnPoint2D)ibl).getX() + tx[2] * ((JnPoint2D)ibl).getY() + tx[4];
        double yybl = tx[1] * ((JnPoint2D)ibl).getX() + tx[3] * ((JnPoint2D)ibl).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbl);
        x2 = Math.max(x2, (int)xxbl);
        y1 = Math.min(y1, (int)yybl);
        y2 = Math.max(y2, (int)yybl);
        double xxur = tx[0] * ((JnPoint2D)iur).getX() + tx[2] * ((JnPoint2D)iur).getY() + tx[4];
        double yyur = tx[1] * ((JnPoint2D)iur).getX() + tx[3] * ((JnPoint2D)iur).getY() + tx[5];
        x1 = Math.min(x1, (int)xxur);
        x2 = Math.max(x2, (int)xxur);
        y1 = Math.min(y1, (int)yyur);
        y2 = Math.max(y2, (int)yyur);
        double xxbr = tx[0] * ((JnPoint2D)ibr).getX() + tx[2] * ((JnPoint2D)ibr).getY() + tx[4];
        double yybr = tx[1] * ((JnPoint2D)ibr).getX() + tx[3] * ((JnPoint2D)ibr).getY() + tx[5];
        x1 = Math.min(x1, (int)xxbr);
        x2 = Math.max(x2, (int)xxbr);
        y1 = Math.min(y1, (int)yybr);
        y2 = Math.max(y2, (int)yybr);
        x1 = Math.max(x1, 0);
        x2 = Math.min(x2, ow - 2);
        y1 = Math.max(y1, 0);
        y2 = Math.min(y2, oh - 2);
        int outX = 0;
        int outY = 0;
        boolean found = false;
        for (outY = y1; outY <= y2; ++outY) {
            for (outX = x1; outX <= x2; ++outX) {
                inputX = m00 * outX + m01 * outY + m02 >> 14;
                inputY = m10 * outX + m11 * outY + m12 >> 14;
                if (inputX < 1 || inputY < 1 || inputX >= iw - 2 || inputY >= ih - 2) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        x1 = outX;
        y1 = outY;
        found = false;
        for (outY = y2; outY >= y1; --outY) {
            for (outX = x2; outX >= x1; --outX) {
                inputX = m00 * outX + m01 * outY + m02 >> 14;
                inputY = m10 * outX + m11 * outY + m12 >> 14;
                if (inputX < 1 || inputY < 1 || inputX >= iw - 2 || inputY >= ih - 2) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        x2 = outX;
        y2 = outY;
        Arrays.fill(output, background);
        if (y2 < 0 || x2 < 0 || x1 >= ow || y1 >= oh) {
            return;
        }
        for (int y3 = y1; y3 < y2; ++y3) {
            int offset = y3 * ow;
            int tr_1 = m01 * y3 + m02;
            int tr_2 = m11 * y3 + m12;
            for (int x3 = x1; x3 < x2; ++x3) {
                int tx_x = m00 * x3 + tr_1;
                int tx_y = m10 * x3 + tr_2;
                int xc = tx_x >> 14;
                int yc = tx_y >> 14;
                if (xc < 1 || xc >= iw - 2 || yc < 1 || yc >= ih - 2) continue;
                int yoffset0 = ioffset + (yc - 1) * iw;
                int yoffset1 = ioffset + yc * iw;
                int yoffset2 = ioffset + (yc + 1) * iw;
                int yoffset3 = ioffset + (yc + 2) * iw;
                int xfrac = tx_x & 0x3FFF;
                int yfrac = tx_y & 0x3FFF;
                int xfrac_1 = 16384 - xfrac;
                int yfrac_1 = 16384 - yfrac;
                int v00 = input[yoffset0 + xc - 1] & 0xFF;
                int v01 = input[yoffset0 + xc] & 0xFF;
                int v02 = input[yoffset0 + xc + 1] & 0xFF;
                int v03 = input[yoffset0 + xc + 2] & 0xFF;
                int v10 = input[yoffset1 + xc - 1] & 0xFF;
                int v11 = input[yoffset1 + xc] & 0xFF;
                int v12 = input[yoffset1 + xc + 1] & 0xFF;
                int v13 = input[yoffset1 + xc + 2] & 0xFF;
                int v20 = input[yoffset2 + xc - 1] & 0xFF;
                int v21 = input[yoffset2 + xc] & 0xFF;
                int v22 = input[yoffset2 + xc + 1] & 0xFF;
                int v23 = input[yoffset2 + xc + 2] & 0xFF;
                int v30 = input[yoffset3 + xc - 1] & 0xFF;
                int v31 = input[yoffset3 + xc] & 0xFF;
                int v32 = input[yoffset3 + xc + 1] & 0xFF;
                int v33 = input[yoffset3 + xc + 2] & 0xFF;
                int v0 = ctable[xfrac] * v01 + ctable[xfrac + 16384] * v00 + ctable[xfrac_1] * v02 + ctable[xfrac_1 + 16384] * v03;
                int v1 = ctable[xfrac] * v11 + ctable[xfrac + 16384] * v10 + ctable[xfrac_1] * v12 + ctable[xfrac_1 + 16384] * v13;
                int v2 = ctable[xfrac] * v21 + ctable[xfrac + 16384] * v20 + ctable[xfrac_1] * v22 + ctable[xfrac_1 + 16384] * v23;
                int v3 = ctable[xfrac] * v31 + ctable[xfrac + 16384] * v30 + ctable[xfrac_1] * v32 + ctable[xfrac_1 + 16384] * v33;
                int v4 = ctable[yfrac] * (v1 >>= 14) + ctable[yfrac + 16384] * (v0 >>= 14) + ctable[yfrac_1] * (v2 >>= 14) + ctable[yfrac_1 + 16384] * (v3 >>= 14);
                int ival = (v4 >>= 14) > 255 ? 255 : v4;
                ival = v4 < 0 ? 0 : ival;
                output[offset + x3] = 0xFF000000 | ival << 16 | ival << 8 | ival;
            }
        }
    }

    static {
        ctable = new int[32769];
        Bicubic.buildTable(ctable);
    }
}

