/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.platform.dm.XpDMSessionProvider;
import com.ge.med.terra.jami.render.Bicubic;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpJImage2DRenderer;
import com.ge.med.terra.jami.render.XpJPipeline;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import javax.swing.JFrame;

public abstract class BicubicPipeline
extends XpJPipeline {
    protected Bicubic bc = new Bicubic();
    private int outWidth = 0;
    private int outHeight = 0;
    private int inWidth;
    private int inHeight;
    private BufferedImage cacheImage = null;
    private AffineTransform inverse = new AffineTransform();
    private double[] md = new double[6];
    private double[] imd = new double[6];
    public int BG_VAL = -16777216;

    @Override
    protected void renderImage(Graphics2D g2, Rectangle viewport, XpJImage2DRenderer r2, AffineTransform tx) {
        XpImageDrawable drawable = r2.getDrawable();
        if (drawable == null) {
            return;
        }
        if (this.outWidth != viewport.width || this.outHeight != viewport.height) {
            this.outWidth = viewport.width;
            this.outHeight = viewport.height;
            this.cacheImage = new BufferedImage(this.outWidth, this.outHeight, 2);
            this.setChangeRender(true);
        }
        BufferedImage image = drawable.getBufferedImage();
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        if (this.inWidth != w2 || this.inHeight != h2) {
            this.inWidth = w2;
            this.inHeight = h2;
        }
        if (r2.isComputePixelTransfer()) {
            r2.computePixelTransfer();
            r2.setComputePixelTransfer(false);
        }
        tx.getMatrix(this.md);
        this.geomUtils.calcInverse(tx, this.inverse);
        this.inverse.getMatrix(this.imd);
        if (w2 == this.outWidth && h2 == this.outHeight && this.md[0] == 1.0 && this.md[1] == 0.0 && this.md[2] == 0.0 && this.md[3] == 1.0) {
            int itx = (int)this.md[4];
            int ity = (int)this.md[5];
            g2.drawImage((Image)image, itx, ity, null);
            return;
        }
        Object iHint = r2.getInterpolationHint();
        if (this.isChangeRender() && iHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            this.calcInverse(tx, this.inverse);
            this.inverse.getMatrix(this.imd);
            tx.getMatrix(this.md);
            DataBuffer db = image.getRaster().getDataBuffer();
            int[] input = ((DataBufferInt)db).getData();
            int[] output = ((DataBufferInt)this.cacheImage.getRaster().getDataBuffer()).getData();
            this.affineMap(this.md, this.imd, input, 0, w2, h2, output, this.outWidth, this.outHeight, this.BG_VAL);
        }
        r2.applyClip(g2);
        if (iHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            g2.drawImage((Image)this.cacheImage, 0, 0, null);
        } else {
            g2.drawRenderedImage(image, tx);
        }
        r2.clearClip(g2);
    }

    public abstract void affineMap(double[] var1, double[] var2, int[] var3, int var4, int var5, int var6, int[] var7, int var8, int var9, int var10);

    public static void main(String[] args) {
        Bicubic b2 = new Bicubic();
        XpDMSessionProvider dmsp = new XpDMSessionProvider(new String[]{"file", args[0]});
        JFrame jf = new JFrame("Bicubic");
        XpImageViewport iv = new XpImageViewport();
        XpMedicalImage[] imgs = dmsp.getImages();
        BufferedImage bimg = (BufferedImage)imgs[imgs.length >> 1].getPixelData();
        int w2 = 1024;
        int h2 = 1024;
        int imgWidth = bimg.getWidth();
        int imgHeight = bimg.getHeight();
        short[] data = ((DataBufferUShort)bimg.getRaster().getDataBuffer()).getData();
        BufferedImage outimg = new BufferedImage(1024, 1024, 11);
        short[] outdata = ((DataBufferUShort)outimg.getRaster().getDataBuffer()).getData();
        XpBufferedImage medimg = new XpBufferedImage(outimg, -1024.0, 1.0);
        iv.setImages(new XpMedicalImage[]{medimg});
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        at.translate(512.0, 512.0);
        at.scale(1536.0 / (double)imgWidth, 1536.0 / (double)imgHeight);
        at.translate((double)(-imgWidth) * 0.5, (double)(-imgHeight) * 0.5);
        double[] tx = new double[6];
        double[] itx = new double[6];
        at.getMatrix(tx);
        AffineTransform inv = null;
        try {
            inv = at.createInverse();
            inv.getMatrix(itx);
        }
        catch (NoninvertibleTransformException e2) {
            e2.printStackTrace();
        }
        System.err.println(">>>> " + imgWidth + " " + imgHeight + " " + 1024 + " " + 1024);
        long t0 = System.currentTimeMillis();
        for (int i2 = 0; i2 < 128; ++i2) {
            b2.shortToshort(tx, itx, data, 0, imgWidth, imgHeight, outdata, 1024, 1024, 0, 0, 1023, 1023, 1, 1);
        }
        long t2 = System.currentTimeMillis() - t0;
        System.err.println(">>> time = " + (double)t2 / 128.0);
        iv.setWindowing(750.0, 150.0);
        jf.setContentPane(iv);
        iv.setPreferredSize(new Dimension(784, 784));
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }

    public static class IRenderer
    extends XpJImage2DRenderer {
        public IRenderer() {
            super(LuminanceIBicubic.class);
            this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
    }

    public static class Renderer
    extends XpJImage2DRenderer {
        public Renderer() {
            super(LuminanceBicubic.class);
            this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
    }

    public static class LuminanceIBicubic
    extends BicubicPipeline {
        @Override
        public void affineMap(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
            this.bc.doIBicubicARGBToARGB(tx, itx, input, ioffset, iw, ih, output, ow, oh, background);
        }
    }

    public static class LuminanceBicubic
    extends BicubicPipeline {
        @Override
        public void affineMap(double[] tx, double[] itx, int[] input, int ioffset, int iw, int ih, int[] output, int ow, int oh, int background) {
            this.bc.doBicubicARGBToARGB(tx, itx, input, ioffset, iw, ih, output, ow, oh, background);
        }
    }
}

