/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.render.XpImageDrawableBase;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpPixels;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public abstract class XpImageDrawable
extends XpImageDrawableBase {
    private BufferedImage bi = null;
    private int bufferedImageType = 0;

    public final int getBufferedImageType() {
        return this.bufferedImageType;
    }

    protected void setBufferedImage(BufferedImage bi) {
        this.bi = bi;
        this.bufferedImageType = bi.getType();
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    @Override
    public int getWidth() {
        return this.bi.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bi.getHeight();
    }

    public static class LuminanceByte
    extends XpImageDrawable {
        private byte[] pixels = null;

        public LuminanceByte(int w2, int h2) {
            BufferedImage bi = new BufferedImage(w2, h2, 10);
            this.setBufferedImage(bi);
            this.init(bi);
        }

        public LuminanceByte(BufferedImage bi) {
            this.setBufferedImage(bi);
            this.init(bi);
        }

        private void init(BufferedImage bi) {
            WritableRaster renderedRaster = bi.getRaster();
            DataBufferByte dbi = (DataBufferByte)renderedRaster.getDataBuffer();
            this.pixels = dbi.getData();
        }

        @Override
        public final void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            this.maskPixelTransferLuminanceByte(sourcePixels, colorTable, ira, this.pixels);
        }

        @Override
        public final void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            this.basicPixelTransferLuminanceByte(sourcePixels, colorTable, ira, this.pixels);
        }
    }

    public static class IntRGB
    extends XpImageDrawable {
        private int[] pixels = null;

        public IntRGB(int w2, int h2) {
            BufferedImage bi = new BufferedImage(w2, h2, 1);
            this.setBufferedImage(bi);
            this.init(bi);
        }

        public IntRGB(BufferedImage bi) {
            this.setBufferedImage(bi);
            this.init(bi);
        }

        private void init(BufferedImage bi) {
            WritableRaster renderedRaster = bi.getRaster();
            DataBufferInt dbi = (DataBufferInt)renderedRaster.getDataBuffer();
            this.pixels = dbi.getData();
        }

        @Override
        public final void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            this.maskPixelTransferIntRGB(sourcePixels, colorTable, ira, this.pixels);
        }

        @Override
        public final void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            this.basicPixelTransferIntRGB(sourcePixels, colorTable, ira, this.pixels);
        }
    }

    public static class ByteBGR
    extends XpImageDrawable {
        private byte[] pixels = null;
        private int nPixels = 0;

        public ByteBGR(int w2, int h2) {
            BufferedImage bi = new BufferedImage(w2, h2, 5);
            this.setBufferedImage(bi);
            this.init(bi);
            this.nPixels = w2 * h2;
        }

        public ByteBGR(BufferedImage bi) {
            this.setBufferedImage(bi);
            this.init(bi);
        }

        private void init(BufferedImage bi) {
            WritableRaster renderedRaster = bi.getRaster();
            DataBufferByte dbb = (DataBufferByte)renderedRaster.getDataBuffer();
            this.pixels = dbb.getData();
        }

        @Override
        public final void maskPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            this.maskPixelTransferByteBGR(sourcePixels, colorTable, ira, this.nPixels, this.pixels);
        }

        @Override
        public final void basicPixelTransfer(XpPixels sourcePixels, int[] colorTable, XpImageRenderAttributes ira) {
            this.basicPixelTransferByteBGR(sourcePixels, colorTable, ira, this.nPixels, this.pixels);
        }
    }
}

