/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.render.XpImagePixelAttributesBase;

public class XpImagePixelAttributes
extends XpImagePixelAttributesBase {
    private double windowWidth = 600.0;
    private double windowLevel = 1200.0;
    private boolean inverseVideo = false;

    public XpImagePixelAttributes() {
    }

    public XpImagePixelAttributes(XpImagePixelAttributes other) {
        this.set(other);
    }

    public final void set(XpImagePixelAttributes other) {
        this.windowWidth = other.windowWidth;
        this.windowLevel = other.windowLevel;
        this.colormap = other.colormap;
        this.inverseVideo = other.inverseVideo;
    }

    public Object clone() {
        return new XpImagePixelAttributes(this);
    }

    public final boolean equals(XpImagePixelAttributes other) {
        return this.equalsPixelTransfer(other);
    }

    public final double getWindowWidth() {
        return this.windowWidth;
    }

    public final double getWindowLevel() {
        return this.windowLevel;
    }

    public final void setWindowMinMax(double min, double max) {
        this.windowWidth = max - min;
        this.windowLevel = (max + min) / 2.0;
    }

    public final double getWindowMin() {
        double winMax = (2.0 * this.windowLevel + this.windowWidth) / 2.0;
        double winMin = 2.0 * this.windowLevel - winMax;
        return winMin;
    }

    public final double getWindowMax() {
        double winMax = (2.0 * this.windowLevel + this.windowWidth) / 2.0;
        return winMax;
    }

    public final void setWindowWidth(double w2) {
        if (w2 >= 0.0) {
            this.windowWidth = w2;
        }
    }

    public final void setWindowLevel(double l2) {
        this.windowLevel = l2;
    }

    public final void setWindowing(double ww, double wl) {
        if (ww >= 0.0) {
            this.windowWidth = ww;
        }
        this.windowLevel = wl;
    }

    public final void setVideoInverted(boolean inverse) {
        this.inverseVideo = inverse;
    }

    public final boolean isVideoInverted() {
        return this.inverseVideo;
    }

    public final void clearColorMap() {
        this.colormap = null;
    }

    public final boolean equalsPixelTransfer(XpImagePixelAttributes other) {
        if (this == other) {
            return true;
        }
        if (this.windowWidth != other.windowWidth) {
            return false;
        }
        if (this.windowLevel != other.windowLevel) {
            return false;
        }
        if (this.colormap != other.colormap) {
            return false;
        }
        return this.inverseVideo == other.inverseVideo;
    }

    @Override
    protected final boolean equalsPixelTransfer(double windowWidth, double windowLevel, boolean invVideo) {
        if (windowWidth != this.windowWidth) {
            return false;
        }
        if (windowLevel != this.windowLevel) {
            return false;
        }
        return invVideo == this.inverseVideo;
    }

    public final void reset() {
        this.inverseVideo = false;
        this.colormap = null;
    }

    public final void resetPixel(double ww, double wl) {
        this.windowLevel = wl;
        this.windowWidth = ww;
        this.inverseVideo = false;
        this.colormap = null;
    }

    public String toString() {
        return this.getClass().getName() + ": {" + this.windowWidth + "W " + this.windowLevel + "L " + this.colormap + "=colormap [" + this.inverseVideo + "]=inverseVideo";
    }
}

