/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.remote.Rm2DDispatcher;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Rm2DClientDispatcher
extends Rm2DDispatcher {
    private byte[] rendering_args = new byte[10];
    private byte[] setOutput_args = new byte[9];
    private byte[] clearBuffers_args = new byte[1];
    private byte[] setImage_args = new byte[9];
    private byte[] suppMpass_args = new byte[1];
    private byte[] imgLayer_args = new byte[1];
    private byte[] setFitVp_args = new byte[2];
    private byte[] setClipGraph_args = new byte[2];
    private byte[] setImgLayer_args = new byte[5];
    private byte[] getFitVp_args = new byte[1];
    private byte[] getNumImgLayers_args = new byte[1];
    private byte[] attribute_args = new byte[53];
    private RemoteCaller caller = null;

    public Rm2DClientDispatcher(RemoteCaller c2) {
        this.caller = c2;
    }

    public Object remoteCommand(RmCommand rmc) {
        byte cmdId = rmc.getCommandId();
        Object[] args = rmc.getArgs();
        byte[] data = null;
        int data_offset = 0;
        int data_len = 0;
        switch (cmdId) {
            case 1: {
                int renderOutputLayer = (Integer)args[0];
                int passno = (Integer)args[1];
                byte renderType = (Byte)args[2];
                CodecUtils.putInt(this.rendering_args, 1, renderOutputLayer);
                CodecUtils.putInt(this.rendering_args, 5, passno);
                this.rendering_args[9] = renderType;
                data = this.rendering_args;
                data_len = data.length;
                break;
            }
            case 10: {
                data = this.suppMpass_args;
                data_len = data.length;
                break;
            }
            case 9: {
                int width = (Integer)args[0];
                int height = (Integer)args[1];
                CodecUtils.putInt(this.setOutput_args, 1, width);
                CodecUtils.putInt(this.setOutput_args, 5, height);
                data = this.setOutput_args;
                data_len = data.length;
                break;
            }
            case 11: {
                data = this.clearBuffers_args;
                data_len = data.length;
                break;
            }
            case 2: {
                boolean fit = (Boolean)args[0];
                CodecUtils.putBoolean(this.setFitVp_args, 1, fit);
                data = this.setFitVp_args;
                data_len = data.length;
                break;
            }
            case 3: {
                data = this.getFitVp_args;
                data_len = data.length;
                break;
            }
            case 4: {
                XpImage image = (XpImage)args[0];
                XjMedicalImage img = (XjMedicalImage)image;
                XpDicomElement de = new XpDicomElement(39321, 0);
                img.getValue(de);
                int id = (Integer)de.value;
                de = new XpDicomElement(39320, 0);
                img.getValue(de);
                int setId = (Integer)de.value;
                CodecUtils.putInt(this.setImage_args, 1, setId);
                CodecUtils.putInt(this.setImage_args, 5, id);
                data = this.setImage_args;
                data_len = data.length;
                break;
            }
            case 5: {
                data = this.imgLayer_args;
                data_len = data.length;
                break;
            }
            case 12: {
                int layer = (Integer)args[0];
                CodecUtils.putInt(this.setImgLayer_args, 1, layer);
                data = this.setImgLayer_args;
                data_len = data.length;
                break;
            }
            case 6: {
                data = this.getNumImgLayers_args;
                data_len = data.length;
                break;
            }
            case 7: {
                XpImageRenderAttributes ira = (XpImageRenderAttributes)args[0];
                double angle = ira.getAngle();
                double panX = ira.getPanX();
                double panY = ira.getPanY();
                int pSize = ira.getPresentationSizeMode();
                double wl = ira.getWindowLevel();
                double ww = ira.getWindowWidth();
                double zoom = ira.getZoom();
                CodecUtils.putDouble(this.attribute_args, 1, angle);
                CodecUtils.putDouble(this.attribute_args, 9, panX);
                CodecUtils.putDouble(this.attribute_args, 17, panY);
                CodecUtils.putInt(this.attribute_args, 25, pSize);
                CodecUtils.putDouble(this.attribute_args, 29, wl);
                CodecUtils.putDouble(this.attribute_args, 37, ww);
                CodecUtils.putDouble(this.attribute_args, 45, zoom);
                data = this.attribute_args;
                data_len = data.length;
                break;
            }
            case 8: {
                boolean graphics = (Boolean)args[0];
                CodecUtils.putBoolean(this.setClipGraph_args, 1, graphics);
                data = this.setClipGraph_args;
                data_len = data.length;
            }
        }
        if (data_len == 0 || data == null) {
            return null;
        }
        data[0] = cmdId;
        byte[] ret = this.caller.call(data, data_offset, data_len);
        Object retval = null;
        switch (cmdId) {
            case 1: {
                retval = ret;
                break;
            }
            case 10: {
                String mpass_alg = CodecUtils.getString(ret, 0);
                StringTokenizer stmp = new StringTokenizer(mpass_alg, "#");
                ArrayList<String> mp_list = new ArrayList<String>();
                while (stmp.hasMoreTokens()) {
                    String mp = stmp.nextToken();
                    mp_list.add(mp);
                }
                Class[] mpass_table = new Class[mp_list.size()];
                for (int i2 = 0; i2 < mpass_table.length; ++i2) {
                    String clName = (String)mp_list.get(i2);
                    try {
                        mpass_table[i2] = Class.forName(clName);
                        continue;
                    }
                    catch (ClassNotFoundException e2) {
                        System.err.println("Rm2DDispatcher ERROR: Non-existent class=" + clName);
                    }
                }
                retval = mpass_table;
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                boolean ftvp = CodecUtils.getBoolean(ret, 0);
                retval = new Boolean(ftvp);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int layer = CodecUtils.getInt(ret, 0);
                retval = new Integer(layer);
                break;
            }
            case 12: {
                break;
            }
            case 6: {
                retval = new Integer(CodecUtils.getInt(ret, 0));
                break;
            }
            case 7: {
                break;
            }
        }
        return retval;
    }

    public static interface RemoteCaller {
        public byte[] call(byte[] var1, int var2, int var3);
    }
}

