/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.idc.GridMultipassAlgorithm;
import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.terra.jami.JImage2DVc;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.j3d.mprender.DefaultMultipassMap;
import com.ge.med.terra.jami.j3d.mprender.MultipassMap;
import com.ge.med.terra.jami.j3d.mprender.MultipassPolicy;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.jami.remote.RmServerEngine;
import com.ge.med.terra.jami.remote.codec.PassThruPBCodec;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.remote.Rm2DClientServerIF;
import com.ge.med.terra.jami.render.remote.RmServer2DEngineBase;
import java.io.IOException;
import java.io.InputStream;

public class RmServer2DEngine
extends RmServer2DEngineBase
implements RmServerEngine,
Rm2DClientServerIF,
IterativeRenderer {
    private static int RMSERVER_CNT = 0;
    private ParallelTaskManager ptm = null;
    private int currPass = 0;
    private int totalPass = 0;
    private ServerPixelBuffer spixbuff = new ServerPixelBuffer();
    private RmPixelBufferCodec pbcodec = new PassThruPBCodec();
    private int rmserver_id = 0;
    private byte[] txbuffer = new byte[4096];
    private static MultipassPolicy mpassPolicy = null;
    private MultipassMap mpassMap = null;

    public RmServer2DEngine() {
        this.jvc = new JImage2DVc();
        this.init();
    }

    public RmServer2DEngine(String renderer) {
        this.jvc = new JImage2DVc(renderer);
        this.init();
    }

    private void init() {
        this.ptm = new ParallelTaskManager();
        this.mpassMap = mpassPolicy != null ? mpassPolicy.createMultipassMap((IterativeRenderer)this, this.ptm) : new DefaultMultipassMap(this, this.ptm);
        this.mpassMap.setRenderStyle("IMAGE_2D_RENDER");
        this.setImageRenderAttributes(this.jvc.getImageRenderAttributes());
        this.rmserver_id = RMSERVER_CNT++;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public RmPixelBufferCodec getPixelBufferCodec() {
        return this.pbcodec;
    }

    public int getServer2DEngineId() {
        return this.rmserver_id;
    }

    @Override
    public XpMedicalImage getMedicalImage() {
        if (this.image instanceof XpMedicalImage) {
            return (XpMedicalImage)this.jvc.getFrame();
        }
        return null;
    }

    @Override
    public MultipassAlgorithm getMultipassAlgorithm(int renderOutputLayer) {
        int width = this.getBufferWidth();
        int height = this.getBufferHeight();
        return this.mpassMap.getMultipassAlgorithm(width, height, 0.0);
    }

    @Override
    public void syncRender() {
    }

    public Object executeCommand(RmCommand rm_cmd) {
        byte cmdId = rm_cmd.getCommandId();
        Object[] args = rm_cmd.getArgs();
        Object[] retval = null;
        switch (cmdId) {
            case 1: {
                int width = this.getBufferWidth();
                int height = this.getBufferHeight();
                int renderOutputLayer = (Integer)args[0];
                int passno = (Integer)args[1];
                byte renderType = (Byte)args[2];
                int rempasses = 0;
                MultipassAlgorithm ma = null;
                if (renderType == 55) {
                    ma = this.getMultipassAlgorithm(renderOutputLayer);
                    GridMultipassAlgorithm gma = (GridMultipassAlgorithm)ma;
                    this.currPass = passno;
                    if (passno == 0) {
                        this.render(renderOutputLayer);
                        this.totalPass = gma.getXStep(0) * gma.getYStep(0);
                    }
                    this.spixbuff.pixbuff.remainingPasses = rempasses = this.totalPass - this.currPass - 1;
                    this.spixbuff.pixbuff.pixBufferHeight = height;
                    this.spixbuff.pixbuff.pixBufferWidth = width;
                    this.spixbuff.pixbuff.xstep = gma.getXStep(passno);
                    this.spixbuff.pixbuff.ystep = gma.getYStep(passno);
                    this.fillPixelBuffer(this.spixbuff, ma, passno);
                } else {
                    this.render(renderOutputLayer);
                    this.spixbuff.pixbuff.remainingPasses = 0;
                    this.spixbuff.pixbuff.pixBufferHeight = height;
                    this.spixbuff.pixbuff.pixBufferWidth = width;
                    this.spixbuff.pixbuff.xstep = 1;
                    this.spixbuff.pixbuff.ystep = 1;
                    this.spixbuff.pixbuff.x0 = 0;
                    this.spixbuff.pixbuff.y0 = 0;
                    this.spixbuff.pixbuff.bpp = 24;
                    this.spixbuff.pixbuff.nchannels = 3;
                    this.spixbuff.pixbuff.pixBuffer = this.getPixelBuffer();
                }
                int len = this.pbcodec.encode(this.spixbuff.pixbuff, this.txbuffer, 0);
                retval = new Object[]{new Integer(len), this.txbuffer};
                break;
            }
            case 10: {
                MultipassAlgorithm[] mpalg = this.getSupportedMultipassAlgorithms();
                Class[] mpclass = new Class[mpalg.length];
                for (int i2 = 0; i2 < mpalg.length; ++i2) {
                    mpclass[i2] = mpalg[i2].getClass();
                }
                retval = mpclass;
                break;
            }
            case 9: {
                int newWidth = (Integer)args[0];
                int newHeight = (Integer)args[1];
                this.txbuffer = new byte[newWidth * newHeight * 4];
                this.jvc.setSize(newWidth, newHeight);
                this.setOutput(newWidth, newHeight);
                break;
            }
            case 11: {
                this.clearBuffers();
                break;
            }
            case 2: {
                Boolean fToViewport = (Boolean)args[0];
                this.jvc.setFitToViewport(fToViewport);
                break;
            }
            case 3: {
                Boolean fToVp = new Boolean(this.jvc.getFitToViewport());
                retval = fToVp;
                break;
            }
            case 4: {
                XpImage image = (XpImage)args[0];
                this.jvc.setImage(image);
                break;
            }
            case 5: {
                retval = new Integer(this.jvc.getImageLayer());
                break;
            }
            case 12: {
                Integer val = (Integer)args[0];
                this.jvc.selectImageLayer(val);
                break;
            }
            case 6: {
                retval = new Integer(this.jvc.getNumImageLayers());
                break;
            }
            case 7: {
                XpImageRenderAttributes attributes = (XpImageRenderAttributes)args[0];
                this.jvc.setImageRenderAttributes(attributes);
                break;
            }
            case 8: {
                Boolean val = (Boolean)args[0];
                this.jvc.setClipGraphics(val);
            }
        }
        return retval;
    }

    @Override
    public MultipassAlgorithm[] getSupportedMultipassAlgorithms() {
        return this.mpassMap.getSupportedMultipassAlgorithms();
    }

    @Override
    public Object createThreadData() {
        return null;
    }

    @Override
    public int getNumOutputLayers() {
        return 0;
    }

    @Override
    public boolean isRenderChange() {
        return false;
    }

    @Override
    public int renderPixel(int thread_id, int renderOutputLayer, int x2, int y2, Object thread_data) {
        this.render(renderOutputLayer);
        return 0;
    }

    @Override
    public void renderPixels(int thread_id, int renderOutputLayer, int x0, int y0, int width, int height, int stepx, int stepy, Object thread_data) {
        this.render(renderOutputLayer);
    }

    private void fillPixelBuffer(ServerPixelBuffer spb, MultipassAlgorithm ma, int passno) {
        RmPixelBuffer pb = spb.pixbuff;
        Object out_pixelbuffer = this.getPixelBuffer();
        if (out_pixelbuffer instanceof short[]) {
            spb.setDataType(1);
        } else {
            spb.setDataType(0);
        }
        MultipassAlgorithm[] supp_ma = this.getSupportedMultipassAlgorithms();
        for (int i2 = 0; i2 < supp_ma.length; ++i2) {
            if (ma != supp_ma[i2]) continue;
            pb.mpAlgorithmId = i2;
            break;
        }
        pb.encodeMultipass(ma, passno);
    }

    @Override
    protected void spixBuffSetSize(int w2, int h2) {
        this.spixbuff.setSize(w2, h2);
    }

    static {
        String propValue = XpPropertiesManager.getProperty("com.ge.med.idc.mprender.MultipassPolicy", "profile,local");
        InputStream is = RmServer2DEngine.mpassInputStream(propValue);
        if (is != null) {
            mpassPolicy = new MultipassPolicy(is);
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ServerPixelBuffer {
        public static final int RGB = 0;
        public static final int LUMINANCE = 1;
        public int[] rgbbuff = null;
        public short[] lumbuff = null;
        public RmPixelBuffer pixbuff = new RmPixelBuffer();

        public ServerPixelBuffer() {
            this.pixbuff.pixBuffer = this.lumbuff;
        }

        public void setDataType(int type) {
            switch (type) {
                case 0: {
                    this.pixbuff.pixBuffer = this.rgbbuff;
                    break;
                }
                case 1: {
                    this.pixbuff.pixBuffer = this.lumbuff;
                }
            }
        }

        public void setSize(int w2, int h2) {
            this.rgbbuff = new int[w2 * h2];
            this.lumbuff = new short[w2 * h2];
        }
    }
}

