/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.roi.RoiStatistics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;

public class GvtkRoiStatistics
implements RoiStatistics {
    public static final byte[] bitmasks = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final int BLOCK_DIM = 128;
    public static final byte EDGE = 2;
    public static final byte UNDEF = 1;
    public static final byte EMPTY = 0;
    private XpImage img = null;
    private XpPixelStatistics ps = new XpPixelStatistics();
    private BufferedImage bitimg = null;
    private int width = 0;
    private int height = 0;
    private int numPixels = -1;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private Point2D[] pts = null;
    private AffineTransform rot = new AffineTransform();
    private Point2D tmpPoint1 = new Point2D.Double();
    private Point2D dirx = new Point2D.Double();
    private Point2D diry = new Point2D.Double();
    private Point2D tempPt1 = new Point2D.Double();
    private Point2D tempPt2 = new Point2D.Double();
    private AffineTransform tempAT = new AffineTransform();
    private Point2D tmpPt000 = new Point2D.Double();
    private Point2D tmpPt001 = new Point2D.Double();
    private Point2D tmpPt002 = new Point2D.Double();
    private Point2D tmpPt003 = new Point2D.Double();
    private Point2D ept = new Point2D.Double();
    private Point2D rpt = new Point2D.Double();
    private static byte[] internalBuffer = null;
    private static int[] stack = null;
    private static int len = 0;
    private static double[] _reg = new double[6];

    @Override
    public void setImage(XpImage img) {
        this.img = img;
        if (img != null) {
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
            this.rescaleSlope = img.getRescaleSlope();
            this.rescaleIntercept = img.getRescaleIntercept();
            if (this.bitimg == null || this.width != this.bitimg.getWidth() || this.height != this.bitimg.getHeight()) {
                this.bitimg = new BufferedImage(this.width, this.height, 12);
            }
        }
    }

    @Override
    public double getArea(Shape s2, double angle) {
        if (this.img != null) {
            double pdx = this.img.getPixelDimensionX();
            double pdy = this.img.getPixelDimensionY();
            if (this.numPixels == -1) {
                this.getPixelStatistics(s2, angle);
            }
            return (double)this.numPixels * pdx * pdy;
        }
        return -1.0;
    }

    @Override
    public double getLength(Shape s2, double angle) {
        if (this.img != null) {
            double pdx = this.img.getPixelDimensionX();
            double pdy = this.img.getPixelDimensionY();
            return XpImageUtils.calcShapeLength(s2, pdx, pdy);
        }
        return -1.0;
    }

    @Override
    public XpPixelStatistics getPixelStatistics(Shape s2, double angle) {
        if (this.img != null) {
            this.drawBitmap(s2, angle);
            Rectangle2D r2d = s2.getBounds2D();
            double w2 = r2d.getWidth();
            double h2 = r2d.getHeight();
            double x2 = r2d.getX();
            double y2 = r2d.getY();
            if (angle != 0.0) {
                double hw = r2d.getWidth() * 0.5;
                double hh = r2d.getHeight() * 0.5;
                double maxDist = Math.sqrt(hw * hw + hh * hh);
                double cx = r2d.getX() + hw;
                double cy = r2d.getY() + hh;
                w2 = h2 = 2.0 * maxDist;
                x2 = cx - maxDist;
                y2 = cy - maxDist;
            }
            int x1 = (int)x2;
            int y1 = (int)y2;
            int x22 = (int)(x2 + w2);
            int y22 = (int)(y2 + h2);
            this.calcStats(x1 -= 2, y1 -= 2, x22 += 2, y22 += 2);
            this.numPixels = this.ps.getNumPixels();
        }
        return this.ps;
    }

    private static Raster getRaster(RenderedImage ri) {
        Raster r2 = null;
        if (ri != null) {
            r2 = ri instanceof BufferedImage ? ((BufferedImage)ri).getRaster() : ri.getData();
        }
        return r2;
    }

    protected void calcStats(int x1, int y1, int x2, int y2) {
        if (this.img != null) {
            int pixelRepresentation = XpImageUtils.getPixelRepresentation(this.img);
            XpImageUtils.calcStats(this.img.getPixelData(), this.bitimg, this.rescaleSlope, this.rescaleIntercept, pixelRepresentation, x1, y1, x2, y2, this.ps);
        }
    }

    public RenderedImage getPixelData() {
        if (this.img != null) {
            return this.img.getPixelData();
        }
        return null;
    }

    protected BufferedImage getBitImage() {
        return this.bitimg;
    }

    public double getRescaleSlope() {
        return this.rescaleSlope;
    }

    public double getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    @Override
    public BufferedImage getPixels(Shape s2, double angle) {
        if (this.img != null) {
            this.drawBitmap(s2, angle);
            return this.bitimg;
        }
        return null;
    }

    @Override
    public JnHistogram calcHistogram(Shape s2, double angle, JnHistogram hist) {
        if (this.img != null) {
            if (hist == null) {
                hist = new JnHistogram(80);
            }
            int[] histogram = hist.histogram;
            Point maximumPt = hist.maximumPt;
            Arrays.fill(histogram, 0);
            XpPixelStatistics ps = this.getPixelStatistics(s2, angle);
            int nHistogramPts = histogram.length;
            double bucketSize = (ps.max - ps.min) / (double)nHistogramPts;
            int rowByteLength = this.width / 8;
            if (this.width % 8 != 0) {
                ++rowByteLength;
            }
            Raster r2 = GvtkRoiStatistics.getRaster(this.img.getPixelData());
            DataBuffer db = r2.getDataBuffer();
            short[] sdata = null;
            byte[] bdata = null;
            int[] idata = null;
            if (db instanceof DataBufferUShort) {
                sdata = ((DataBufferUShort)db).getData();
            } else if (db instanceof DataBufferShort) {
                sdata = ((DataBufferShort)db).getData();
            } else if (db instanceof DataBufferByte) {
                bdata = ((DataBufferByte)db).getData();
            } else if (db instanceof DataBufferInt) {
                idata = ((DataBufferInt)db).getData();
            }
            int maxX = 0;
            int maxY = 0;
            byte[] bitmap = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
            int sX = ps.bounds.x;
            int sY = ps.bounds.y;
            int eX = ps.bounds.x + ps.bounds.width;
            int eY = ps.bounds.y + ps.bounds.height;
            for (int y2 = sY; y2 <= eY; ++y2) {
                int idx_offset = y2 * rowByteLength;
                for (int x2 = sX; x2 <= eX; ++x2) {
                    int idx = idx_offset + x2 / 8;
                    int bit = x2 % 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx];
                    if (on == 0) continue;
                    int pval = 0;
                    if (sdata != null) {
                        pval = sdata[y2 * this.width + x2];
                    } else if (bdata != null) {
                        pval = bdata[y2 * this.width + x2];
                    } else if (idata != null) {
                        pval = idata[y2 * this.width + x2];
                    }
                    int bucket = (int)(((double)pval - ps.min) / bucketSize);
                    if (bucket >= nHistogramPts) {
                        bucket = nHistogramPts - 1;
                    }
                    try {
                        int n2 = bucket;
                        histogram[n2] = histogram[n2] + 1;
                        if (histogram[bucket] <= maxY) continue;
                        maxY = histogram[bucket];
                        maxX = bucket;
                        continue;
                    }
                    catch (Exception ex) {
                        XpLog.logger().warning("Histogram Array Indexing problem: " + bucket + " min=" + ps.min + " pval=" + pval + " bSize=" + bucketSize);
                    }
                }
            }
            hist.bucketSize = bucketSize;
            hist.startX = ps.min;
            hist.endX = ps.max;
            maximumPt.setLocation(maxX, maxY);
        }
        return hist;
    }

    private final void drawBitmap(Shape shape, double angle) {
        if (this.bitimg != null) {
            GvtkRoiStatistics.getCenter(shape, this.tmpPoint1);
            double cx = this.tmpPoint1.getX();
            double cy = this.tmpPoint1.getY();
            this.rot.setToIdentity();
            this.rot.setToRotation(angle);
            this.tmpPoint1.setLocation(1.0, 0.0);
            this.rot.transform(this.tmpPoint1, this.dirx);
            this.tmpPoint1.setLocation(0.0, 1.0);
            this.rot.transform(this.tmpPoint1, this.diry);
            if (shape instanceof Rectangle2D) {
                Rectangle2D r2 = (Rectangle2D)shape;
                this.rectangleFill(this.bitimg, r2, -angle);
            } else if (shape instanceof Ellipse2D) {
                Ellipse2D ell = (Ellipse2D)shape;
                this.ellipseFill(this.bitimg, ell, -angle);
            } else if (shape instanceof GeneralPath) {
                GeneralPath gp = (GeneralPath)shape;
                if (this.pts == null) {
                    this.initPts();
                }
                int npts = this.configurePath(gp, this.pts);
                GvtkRoiStatistics.polyLineFill(this.bitimg, npts, this.pts);
            } else {
                Graphics2D g2 = (Graphics2D)this.bitimg.getGraphics();
                byte[] data = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
                Arrays.fill(data, (byte)0);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.rotate(-angle, cx, cy);
                g2.draw(shape);
                g2.fill(shape);
            }
        }
    }

    private static void getCenter(Shape shape, Point2D center) {
        Rectangle2D bounds = shape.getBounds2D();
        double cx = bounds.getX() + bounds.getWidth() / 2.0;
        double cy = bounds.getY() + bounds.getHeight() / 2.0;
        center.setLocation(cx, cy);
    }

    public void ellipseFill(BufferedImage drawbuffer, Ellipse2D ell, double angle) {
        byte[] bitmap = ((DataBufferByte)drawbuffer.getRaster().getDataBuffer()).getData();
        int dbwidth = drawbuffer.getWidth();
        int dbheight = drawbuffer.getHeight();
        int len = dbwidth * dbheight;
        Arrays.fill(bitmap, (byte)0);
        int nrowbytes = (int)Math.ceil((double)dbwidth / 8.0);
        double x2 = ell.getX();
        double y2 = ell.getY();
        double w2 = ell.getWidth();
        double h2 = ell.getHeight();
        double cx = ell.getCenterX();
        double cy = ell.getCenterY();
        this.tempAT.setToIdentity();
        this.tempAT.setToRotation(angle, cx, cy);
        this.tempPt1.setLocation(x2, y2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x1 = this.tempPt2.getX();
        double y1 = this.tempPt2.getY();
        this.tempPt1.setLocation(x2 + w2, y2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x22 = this.tempPt2.getX();
        double y22 = this.tempPt2.getY();
        this.tempPt1.setLocation(x2 + w2, y2 + h2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x3 = this.tempPt2.getX();
        double y3 = this.tempPt2.getY();
        this.tempPt1.setLocation(x2, y2 + h2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x4 = this.tempPt2.getX();
        double y4 = this.tempPt2.getY();
        double xx1 = Math.min(x1, x22);
        xx1 = Math.min(xx1, x3);
        xx1 = Math.min(xx1, x4);
        double yy1 = Math.min(y1, y22);
        yy1 = Math.min(yy1, y3);
        yy1 = Math.min(yy1, y4);
        double xx2 = Math.max(x1, x22);
        xx2 = Math.max(xx2, x3);
        xx2 = Math.max(xx2, x4);
        double yy2 = Math.max(y1, y22);
        yy2 = Math.max(yy2, y3);
        yy2 = Math.max(yy2, y4);
        double a2 = w2 * 0.5;
        double b2 = h2 * 0.5;
        double A_INV = 1.0 / (a2 * a2);
        double B_INV = 1.0 / (b2 * b2);
        this.tempAT.setToRotation(-angle);
        int ix1 = (int)xx1;
        int iy1 = (int)yy1;
        int ix2 = (int)xx2;
        int iy2 = (int)yy2;
        ix1 = ix1 < 0 ? 0 : ix1;
        ix1 = ix1 > dbwidth - 1 ? dbwidth - 1 : ix1;
        iy1 = iy1 < 0 ? 0 : iy1;
        iy1 = iy1 > dbheight - 1 ? dbheight - 1 : iy1;
        ix2 = ix2 < 0 ? 0 : ix2;
        ix2 = ix2 > dbwidth - 1 ? dbwidth - 1 : ix2;
        iy2 = iy2 < 0 ? 0 : iy2;
        iy2 = iy2 > dbheight - 1 ? dbheight - 1 : iy2;
        int npixels = 0;
        if (w2 > 128.0 && h2 > 128.0) {
            for (int iy = iy1; iy <= iy2; iy += 128) {
                int limy = Math.min(iy + 128 - 1, iy2);
                for (int ix = ix1; ix <= ix2; ix += 128) {
                    int limx = Math.min(ix + 128 - 1, ix2);
                    boolean in1 = this.isInsideEllipse((double)ix - cx + 0.5, (double)iy - cy + 0.5, A_INV, B_INV, this.tempAT);
                    boolean in2 = this.isInsideEllipse((double)limx - cx, (double)iy - cy + 0.5, A_INV, B_INV, this.tempAT);
                    boolean in3 = this.isInsideEllipse((double)limx - cx, (double)limy - cy, A_INV, B_INV, this.tempAT);
                    boolean in4 = this.isInsideEllipse((double)ix - cx + 0.5, (double)limy - cy, A_INV, B_INV, this.tempAT);
                    if (in1 && in2 && in3 && in4) {
                        this.fastFill(ix, iy, limx, limy, nrowbytes, bitmap);
                        npixels += 16384;
                        continue;
                    }
                    if (!in1 && !in2 && !in3 && !in4) continue;
                    npixels += this.markEllipse(ix, iy, limx, limy, nrowbytes, cx, cy, A_INV, B_INV, bitmap, this.dirx, this.diry);
                }
            }
        } else {
            npixels = this.markEllipse(ix1, iy1, ix2, iy2, nrowbytes, cx, cy, A_INV, B_INV, bitmap, this.dirx, this.diry);
        }
        if (npixels == 0 && w2 > 0.0 && h2 > 0.0) {
            npixels = this.markEllipse(ix1, iy1, ix2, iy2, nrowbytes, 0.5, 0.5, cx, cy, A_INV, B_INV, bitmap, this.tempAT);
        }
    }

    public void rectangleFill(BufferedImage drawbuffer, Rectangle2D rect, double angle) {
        byte[] bitmap = ((DataBufferByte)drawbuffer.getRaster().getDataBuffer()).getData();
        int dbwidth = drawbuffer.getWidth();
        int dbheight = drawbuffer.getHeight();
        Arrays.fill(bitmap, (byte)0);
        int nrowbytes = (int)Math.ceil((double)dbwidth / 8.0);
        double x2 = rect.getX();
        double y2 = rect.getY();
        double w2 = rect.getWidth();
        double h2 = rect.getHeight();
        double cx = rect.getCenterX();
        double cy = rect.getCenterY();
        this.tempAT.setToIdentity();
        this.tempAT.setToRotation(angle, cx, cy);
        this.tempPt1.setLocation(x2, y2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x1 = this.tempPt2.getX();
        double y1 = this.tempPt2.getY();
        this.tempPt1.setLocation(x2 + w2, y2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x22 = this.tempPt2.getX();
        double y22 = this.tempPt2.getY();
        this.tempPt1.setLocation(x2 + w2, y2 + h2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x3 = this.tempPt2.getX();
        double y3 = this.tempPt2.getY();
        this.tempPt1.setLocation(x2, y2 + h2);
        this.tempAT.transform(this.tempPt1, this.tempPt2);
        double x4 = this.tempPt2.getX();
        double y4 = this.tempPt2.getY();
        double xx1 = Math.min(x1, x22);
        xx1 = Math.min(xx1, x3);
        xx1 = Math.min(xx1, x4);
        double yy1 = Math.min(y1, y22);
        yy1 = Math.min(yy1, y3);
        yy1 = Math.min(yy1, y4);
        double xx2 = Math.max(x1, x22);
        xx2 = Math.max(xx2, x3);
        xx2 = Math.max(xx2, x4);
        double yy2 = Math.max(y1, y22);
        yy2 = Math.max(yy2, y3);
        yy2 = Math.max(yy2, y4);
        this.tempAT.setToRotation(-angle, cx, cy);
        int ix1 = (int)xx1;
        int iy1 = (int)yy1;
        int ix2 = (int)xx2;
        int iy2 = (int)yy2;
        ix1 = ix1 < 0 ? 0 : ix1;
        ix1 = ix1 > dbwidth - 1 ? dbwidth - 1 : ix1;
        iy1 = iy1 < 0 ? 0 : iy1;
        iy1 = iy1 > dbheight - 1 ? dbheight - 1 : iy1;
        ix2 = ix2 < 0 ? 0 : ix2;
        ix2 = ix2 > dbwidth - 1 ? dbwidth - 1 : ix2;
        iy2 = iy2 < 0 ? 0 : iy2;
        iy2 = iy2 > dbheight - 1 ? dbheight - 1 : iy2;
        int npixels = 0;
        if (w2 > 128.0 && h2 > 128.0) {
            for (int iy = iy1; iy <= iy2; iy += 128) {
                int limy = Math.min(iy + 128 - 1, iy2);
                for (int ix = ix1; ix <= ix2; ix += 128) {
                    int limx = Math.min(ix + 128 - 1, ix2);
                    boolean in1 = this.isInsideRect((double)ix + 0.5, (double)iy + 0.5, x2, y2, x2 + w2, y2 + h2, this.tempAT);
                    boolean in2 = this.isInsideRect(limx, (double)iy + 0.5, x2, y2, x2 + w2, y2 + h2, this.tempAT);
                    boolean in3 = this.isInsideRect(limx, limy, x2, y2, x2 + w2, y2 + h2, this.tempAT);
                    boolean in4 = this.isInsideRect((double)ix + 0.5, limy, x2, y2, x2 + w2, y2 + h2, this.tempAT);
                    if (in1 && in2 && in3 && in4) {
                        this.fastFill(ix, iy, limx, limy, nrowbytes, bitmap);
                        npixels += 16384;
                        continue;
                    }
                    if (!in1 && !in2 && !in3 && !in4) continue;
                    npixels += this.markRectangle(ix, iy, limx, limy, nrowbytes, x2, y2, x2 + w2, y2 + h2, bitmap, this.tempAT, this.dirx, this.diry);
                }
            }
        } else {
            npixels = this.markRectangle(ix1, iy1, ix2, iy2, nrowbytes, x2, y2, x2 + w2, y2 + h2, bitmap, this.tempAT, this.dirx, this.diry);
        }
        if (npixels == 0 && w2 > 0.0 && h2 > 0.0) {
            this.markRectangle(ix1, iy1, ix2, iy2, nrowbytes, 0.5, 0.5, x2, y2, x2 + w2, y2 + h2, bitmap, this.tempAT);
        }
    }

    private boolean isInsideRect(double x2, double y2, double x1, double y1, double x22, double y22, AffineTransform at) {
        this.tmpPt000.setLocation(x2, y2);
        at.transform(this.tmpPt000, this.tmpPt001);
        double tx = this.tmpPt001.getX();
        double ty = this.tmpPt001.getY();
        return tx > x1 && ty > y1 && tx < x22 && ty < y22;
    }

    private boolean isInsideEllipse(double x2, double y2, double A_INV, double B_INV, AffineTransform at) {
        this.tmpPt002.setLocation(x2, y2);
        at.transform(this.tmpPt002, this.tmpPt003);
        double x_c = this.tmpPt003.getX();
        double y_c = this.tmpPt003.getY();
        double val = x_c * x_c * A_INV + y_c * y_c * B_INV;
        return val < 1.0;
    }

    private int markRectangle(int ix1, int iy1, int ix2, int iy2, int nrowbytes, double dx, double dy, double x1, double y1, double x2, double y2, byte[] bitmap, AffineTransform at) {
        int npixels = 0;
        for (int iy = iy1; iy <= iy2; ++iy) {
            int offset = iy * nrowbytes;
            for (int ix = ix1; ix <= ix2; ++ix) {
                this.tempPt1.setLocation((double)ix + dx, (double)iy + dy);
                this.tempAT.transform(this.tempPt1, this.tempPt2);
                double tx = this.tempPt2.getX();
                double ty = this.tempPt2.getY();
                if (!(tx >= x1) || !(ty >= y1) || !(tx <= x2) || !(ty <= y2)) continue;
                int bitidx = offset + ix / 8;
                byte mask = bitmasks[ix % 8];
                int n2 = bitidx;
                bitmap[n2] = (byte)(bitmap[n2] | mask);
                ++npixels;
            }
        }
        return npixels;
    }

    private int markRectangle(int ix1, int iy1, int ix2, int iy2, int nrowbytes, double x1, double y1, double x2, double y2, byte[] bitmap, AffineTransform tempAT, Point2D dirx, Point2D diry) {
        int npixels = 0;
        this.tempPt1.setLocation(ix1 + 1, iy1 + 1);
        tempAT.transform(this.tempPt1, this.rpt);
        for (int iy = iy1 + 1; iy <= iy2; ++iy) {
            this.ept.setLocation(this.rpt);
            int offset = iy * nrowbytes;
            int offset1 = (iy - 1) * nrowbytes;
            for (int ix = ix1 + 1; ix <= ix2; ++ix) {
                int bitidx = offset + ix / 8;
                byte mask = bitmasks[ix % 8];
                double tx = this.rpt.getX();
                double ty = this.rpt.getY();
                if (tx >= x1 && ty >= y1 && tx <= x2 && ty <= y2) {
                    int n2 = bitidx;
                    bitmap[n2] = (byte)(bitmap[n2] | mask);
                    byte mask1 = bitmasks[(ix - 1) % 8];
                    int divx1 = (ix - 1) / 8;
                    int bitidx1 = offset + divx1;
                    int bitidx2 = offset1 + ix / 8;
                    int bitidx3 = offset1 + divx1;
                    int n3 = bitidx2;
                    bitmap[n3] = (byte)(bitmap[n3] | mask);
                    int n4 = bitidx1;
                    bitmap[n4] = (byte)(bitmap[n4] | mask1);
                    int n5 = bitidx3;
                    bitmap[n5] = (byte)(bitmap[n5] | mask1);
                    ++npixels;
                }
                this.rpt.setLocation(tx + dirx.getX(), ty + dirx.getY());
            }
            this.rpt.setLocation(this.ept.getX() + diry.getX(), this.ept.getY() + diry.getY());
        }
        return npixels;
    }

    private int markEllipse(int ix1, int iy1, int ix2, int iy2, int nrowbytes, double dx, double dy, double cx, double cy, double A_INV, double B_INV, byte[] bitmap, AffineTransform at) {
        int npixels = 0;
        for (int iy = iy1; iy <= iy2; ++iy) {
            int offset = iy * nrowbytes;
            for (int ix = ix1; ix <= ix2; ++ix) {
                this.tempPt1.setLocation((double)ix - cx + dx, (double)iy - cy + dy);
                this.tempAT.transform(this.tempPt1, this.tempPt2);
                double x_c = this.tempPt2.getX();
                double y_c = this.tempPt2.getY();
                double val = x_c * x_c * A_INV + y_c * y_c * B_INV;
                if (!(val < 1.0)) continue;
                int bitidx = offset + ix / 8;
                byte mask = bitmasks[ix % 8];
                int n2 = bitidx;
                bitmap[n2] = (byte)(bitmap[n2] | mask);
                ++npixels;
            }
        }
        return npixels;
    }

    private int markEllipse(int ix1, int iy1, int ix2, int iy2, int nrowbytes, double cx, double cy, double A_INV, double B_INV, byte[] bitmap, Point2D dirx, Point2D diry) {
        int npixels = 0;
        this.tempPt1.setLocation((double)(ix1 + 1) - cx, (double)(iy1 + 1) - cy);
        this.tempAT.transform(this.tempPt1, this.ept);
        for (int iy = iy1 + 1; iy <= iy2; ++iy) {
            this.rpt.setLocation(this.ept);
            int offset = iy * nrowbytes;
            int offset1 = (iy - 1) * nrowbytes;
            for (int ix = ix1 + 1; ix <= ix2; ++ix) {
                double y_c;
                int divx = ix / 8;
                int bitidx = offset + divx;
                byte mask = bitmasks[ix % 8];
                double x_c = this.ept.getX();
                double val = x_c * x_c * A_INV + (y_c = this.ept.getY()) * y_c * B_INV;
                if (val < 1.0) {
                    int n2 = bitidx;
                    bitmap[n2] = (byte)(bitmap[n2] | mask);
                    byte mask1 = bitmasks[(ix - 1) % 8];
                    int divx1 = (ix - 1) / 8;
                    int bitidx1 = offset + divx1;
                    int bitidx2 = offset1 + divx;
                    int bitidx3 = offset1 + divx1;
                    int n3 = bitidx2;
                    bitmap[n3] = (byte)(bitmap[n3] | mask);
                    int n4 = bitidx1;
                    bitmap[n4] = (byte)(bitmap[n4] | mask1);
                    int n5 = bitidx3;
                    bitmap[n5] = (byte)(bitmap[n5] | mask1);
                    ++npixels;
                }
                this.ept.setLocation(x_c + dirx.getX(), y_c + dirx.getY());
            }
            this.ept.setLocation(this.rpt.getX() + diry.getX(), this.rpt.getY() + diry.getY());
        }
        return npixels;
    }

    private void fastFill(int ix1, int iy1, int ix2, int iy2, int nrowbytes, byte[] bitmap) {
        for (int iy = iy1; iy <= iy2; ++iy) {
            int offset = iy * nrowbytes;
            for (int ix = ix1; ix <= ix2; ++ix) {
                int bitidx;
                int n2 = bitidx = offset + ix / 8;
                bitmap[n2] = (byte)(bitmap[n2] | bitmasks[ix % 8]);
            }
        }
    }

    private static void polyLineFill(BufferedImage drawbuffer, int numPoints, Point2D[] imagePoints) {
        int j2;
        int i2;
        int maxy;
        int maxx;
        byte[] bitmap = ((DataBufferByte)drawbuffer.getRaster().getDataBuffer()).getData();
        int dbwidth = drawbuffer.getWidth();
        int dbheight = drawbuffer.getHeight();
        int len = dbwidth * dbheight;
        Arrays.fill(bitmap, (byte)0);
        int nrowbytes = (int)Math.ceil((double)dbwidth / 8.0);
        if (numPoints < 2) {
            return;
        }
        int minx = maxx = (int)imagePoints[0].getX();
        int miny = maxy = (int)imagePoints[0].getY();
        for (i2 = 1; i2 < numPoints; ++i2) {
            if (imagePoints[i2].getX() > (double)maxx) {
                maxx = (int)imagePoints[i2].getX();
            } else if (imagePoints[i2].getX() < (double)minx) {
                minx = (int)imagePoints[i2].getX();
            }
            if (imagePoints[i2].getY() > (double)maxy) {
                maxy = (int)imagePoints[i2].getY();
                continue;
            }
            if (!(imagePoints[i2].getY() < (double)miny)) continue;
            miny = (int)imagePoints[i2].getY();
        }
        int ox = minx;
        int oy = miny;
        int width = maxx - minx + 1;
        int height = maxy - miny + 1;
        if (internalBuffer == null || internalBuffer.length != len) {
            internalBuffer = new byte[len];
        }
        Arrays.fill(internalBuffer, (byte)1);
        if (width * height > 1) {
            i2 = 0;
            for (j2 = 1; j2 < numPoints; ++j2) {
                GvtkRoiStatistics.DrawLine(imagePoints, i2, j2, bitmap, internalBuffer, dbwidth, dbheight);
                ++i2;
            }
            GvtkRoiStatistics.DrawLine(imagePoints, i2, 0, bitmap, internalBuffer, dbwidth, dbheight);
            int start = oy * dbwidth;
            for (i2 = ox; i2 < ox + width; ++i2) {
                if (internalBuffer[start + i2] == 2 || internalBuffer[start + i2] == 0) continue;
                GvtkRoiStatistics.FillArea(i2, oy, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
            for (i2 = ox; i2 < ox + width; ++i2) {
                if (internalBuffer[i2 + (height - 1) * dbwidth] == 2 || internalBuffer[i2 + (height - 1) * dbwidth] == 0) continue;
                GvtkRoiStatistics.FillArea(i2, oy + height - 1, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
            for (i2 = oy; i2 < oy + height; ++i2) {
                if (internalBuffer[(i2 + 1) * dbwidth - 1] == 2 || internalBuffer[(i2 + 1) * dbwidth - 1] == 0) continue;
                GvtkRoiStatistics.FillArea(ox + width - 1, i2, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
            for (i2 = oy; i2 < oy + height; ++i2) {
                if (internalBuffer[i2 * dbwidth] == 2 || internalBuffer[i2 * dbwidth] == 0) continue;
                GvtkRoiStatistics.FillArea(ox, i2, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
        }
        for (j2 = oy; j2 < oy + height; ++j2) {
            int offset = j2 * nrowbytes;
            int rowoffset = j2 * dbwidth;
            for (i2 = ox; i2 < ox + width; ++i2) {
                int bitidx = offset + i2 / 8;
                if (internalBuffer[rowoffset + i2] == 0) continue;
                int n2 = bitidx;
                bitmap[n2] = (byte)(bitmap[n2] | bitmasks[i2 % 8]);
            }
        }
    }

    private static void DrawLine(Point2D[] imagePoints, int i2, int j2, byte[] bitmap, byte[] internalBuffer, int width, int height) {
        int pixelsInLine;
        double dy;
        double dx;
        double adeltaY;
        int nrowbytes = (int)Math.ceil((double)width / 8.0);
        double startX = (int)imagePoints[i2].getX();
        double startY = (int)imagePoints[i2].getY();
        double endX = (int)imagePoints[j2].getX();
        double endY = (int)imagePoints[j2].getY();
        double deltaX = endX - startX;
        double deltaY = endY - startY;
        double adeltaX = Math.abs(deltaX);
        if (adeltaX > (adeltaY = Math.abs(deltaY))) {
            dx = deltaX / adeltaX;
            dy = deltaY / adeltaX;
            pixelsInLine = (int)Math.ceil(adeltaX + 1.0);
        } else if (adeltaY > 0.0) {
            dx = deltaX / adeltaY;
            dy = deltaY / adeltaY;
            pixelsInLine = (int)Math.ceil(adeltaY + 1.0);
        } else {
            dx = 0.0;
            dy = 0.0;
            pixelsInLine = 0;
        }
        double x2 = startX;
        double y2 = startY;
        for (int d2 = 0; d2 < pixelsInLine; ++d2) {
            int bitidx;
            int ix = (int)(x2 + 0.5);
            int iy = (int)(y2 + 0.5);
            if (ix < 0) {
                ix = 0;
            } else if (ix >= width) {
                ix = width - 1;
            }
            if (iy < 0) {
                iy = 0;
            } else if (iy >= height) {
                iy = height - 1;
            }
            internalBuffer[ix + iy * width] = 2;
            int n2 = bitidx = iy * nrowbytes + ix / 8;
            bitmap[n2] = (byte)(bitmap[n2] | bitmasks[ix % 8]);
            x2 += dx;
            y2 += dy;
        }
    }

    private static int PUSH(int sp, int X, int Y) {
        GvtkRoiStatistics.stack[2 * sp] = X;
        GvtkRoiStatistics.stack[2 * sp + 1] = Y;
        return sp + 1;
    }

    private static void FillArea(int i2, int j2, byte[] internalBuffer, int width, int height, int ox, int oy, int domainWidth, int domainHeight) {
        int floodWidth = width + 2;
        int floodHeight = height + 2;
        if (floodWidth * floodHeight * 4 > len) {
            len = floodWidth * floodHeight * 4;
            stack = new int[2 * len];
        }
        int sp = 0;
        sp = GvtkRoiStatistics.PUSH(sp, i2, j2);
        while (sp > 0) {
            int m2;
            i2 = stack[2 * --sp];
            j2 = stack[2 * sp + 1];
            if (i2 < ox || i2 >= ox + domainWidth || j2 < oy || j2 >= oy + domainHeight || internalBuffer[m2 = i2 + j2 * width] == 0 || internalBuffer[m2] == 2) continue;
            internalBuffer[m2] = 0;
            sp = GvtkRoiStatistics.PUSH(sp, i2 + 1, j2);
            sp = GvtkRoiStatistics.PUSH(sp, i2 - 1, j2);
            sp = GvtkRoiStatistics.PUSH(sp, i2, j2 + 1);
            sp = GvtkRoiStatistics.PUSH(sp, i2, j2 + 1);
        }
    }

    private void initPts() {
        this.pts = new Point2D[2048];
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            this.pts[i2] = new Point2D.Double();
        }
    }

    private int configurePath(GeneralPath shape, Point2D[] pts) {
        int idx = 0;
        PathIterator pi = shape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            pi.currentSegment(_reg);
            double x2 = _reg[0];
            double y2 = _reg[1];
            int segType = pi.getWindingRule();
            switch (segType) {
                case 0: {
                    pts[idx++].setLocation(x2, y2);
                    break;
                }
                case 1: {
                    pts[idx++].setLocation(x2, y2);
                    break;
                }
            }
            pi.next();
            if (!pi.isDone()) continue;
            break;
        }
        return idx;
    }
}

