/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.Selectable;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RoiShapeModel
implements Selectable,
Serializable {
    public static final String ROI_SHAPE_MODEL = "ROI_SHAPE_MODEL";
    private static int shapeCounter = 1;
    private transient Shape shape = null;
    private double angle = 0.0;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean selected = false;
    private boolean editable = true;
    private int shapeId = 0;
    private String tooltip = null;
    private String roiLabel = null;
    private Color color = null;
    private boolean visible = true;
    static boolean debug = false;

    public RoiShapeModel(Shape shape) {
        this.shape = shape;
        this.shapeId = shapeCounter++;
        this.roiLabel = "" + this.getShapeId();
        if (debug) {
            new RuntimeException().printStackTrace();
        }
    }

    public final Shape getShape() {
        return this.shape;
    }

    public final int getShapeId() {
        return this.shapeId;
    }

    public final Rectangle getBounds() {
        return this.shape.getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.shape.getBounds2D();
    }

    public final boolean contains(double x2, double y2) {
        return this.shape.contains(x2, y2);
    }

    public final boolean contains(Point2D p2) {
        return this.shape.contains(p2);
    }

    public final boolean intersects(double x2, double y2, double w2, double h2) {
        return this.shape.intersects(x2, y2, w2, h2);
    }

    public final boolean intersects(Rectangle2D r2) {
        return this.shape.intersects(r2);
    }

    public final boolean contains(double x2, double y2, double w2, double h2) {
        return this.shape.contains(x2, y2, w2, h2);
    }

    public final boolean contains(Rectangle2D r2) {
        return this.shape.contains(r2);
    }

    public final PathIterator getPathIterator(AffineTransform at) {
        return this.shape.getPathIterator(at);
    }

    public final PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.shape.getPathIterator(at, flatness);
    }

    public final void setToolTipText(String text) {
        this.tooltip = text;
    }

    public final String getToolTipText() {
        return this.tooltip;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void syncModel() {
        this.firePropertyChange(ROI_SHAPE_MODEL, this);
    }

    public final void setAngle(double angle) {
        this.angle = angle;
        this.syncModel();
    }

    @Override
    public final void setSelected(boolean selection) {
        if (selection && !this.editable) {
            return;
        }
        if (this.selected == selection) {
            return;
        }
        this.selected = selection;
        if (this.selected) {
            this.pcs.firePropertyChange("COMPONENT_SELECTED", null, this);
        } else {
            this.pcs.firePropertyChange("COMPONENT_UNSELECTED", null, this);
        }
    }

    @Override
    public final boolean isSelected() {
        return this.selected;
    }

    public final void setEditable(boolean editable) {
        this.editable = editable;
        if (this.isSelected() && !editable) {
            this.setSelected(false);
        }
    }

    public String getRoiLabel() {
        return this.roiLabel;
    }

    public void setRoiLabel(String label) {
        this.roiLabel = label;
        this.syncModel();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.syncModel();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.syncModel();
        }
    }

    public final boolean isEditable() {
        return this.editable;
    }

    @Override
    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    private void firePropertyChange(String property, Object value) {
        PropertyChangeEvent e2 = new PropertyChangeEvent(this, property, null, value);
        this.pcs.firePropertyChange(e2);
    }

    public void getCenter(Point2D center) {
        Rectangle2D bounds = this.shape.getBounds2D();
        double cx = bounds.getX() + bounds.getWidth() / 2.0;
        double cy = bounds.getY() + bounds.getHeight() / 2.0;
        center.setLocation(cx, cy);
    }

    public Object clone() {
        return this;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        try {
            s2.defaultWriteObject();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

