/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XpCubicCurveRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private transient XpHandle _handle1 = null;
    private transient XpHandle _handle2 = null;
    private transient XpHandle _handle3 = null;
    private transient XpHandle _handle4 = null;
    private transient CubicCurve2D drawShape = null;
    private transient CubicCurve2D modelShape = null;
    private transient Point2D tmpPoint1 = new Point2D.Double();

    public XpCubicCurveRoi(CubicCurve2D cc2d) {
        super(cc2d);
        this.modelShape = cc2d;
        this.drawShape = (CubicCurve2D)cc2d.clone();
        this.createHandles();
    }

    @Override
    public Object clone() {
        CubicCurve2D cc = (CubicCurve2D)this.getModelShape();
        CubicCurve2D clonecc = (CubicCurve2D)cc.clone();
        XpCubicCurveRoi ccr = new XpCubicCurveRoi(clonecc);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g2) {
        super.render(vc, g2);
        XpHandle h2 = this.get(0);
        this.drawRoiId(vc, g2, h2);
    }

    @Override
    public Shape getDrawShape() {
        this.updateDrawShape();
        return this.drawShape;
    }

    private void updateDrawShape() {
        CubicCurve2D cc2d = (CubicCurve2D)this.getModelShape();
        CubicCurve2D drs = this.drawShape;
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlP1();
        Point2D cp2 = cc2d.getCtrlP2();
        this.getDisplayPoint(ep1, this.tmpPoint1);
        double tx1 = this.tmpPoint1.getX();
        double ty1 = this.tmpPoint1.getY();
        this.getDisplayPoint(ep2, this.tmpPoint1);
        double tx2 = this.tmpPoint1.getX();
        double ty2 = this.tmpPoint1.getY();
        this.getDisplayPoint(cp1, this.tmpPoint1);
        double tcx1 = this.tmpPoint1.getX();
        double tcy1 = this.tmpPoint1.getY();
        this.getDisplayPoint(cp2, this.tmpPoint1);
        double tcx2 = this.tmpPoint1.getX();
        double tcy2 = this.tmpPoint1.getY();
        drs.setCurve(tx1, ty1, tcx1, tcy1, tcx2, tcy2, tx2, ty2);
    }

    @Override
    protected final void dragMouse(CPoint drag) {
        CubicCurve2D cc2d = (CubicCurve2D)this.getModelShape();
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlP1();
        Point2D cp2 = cc2d.getCtrlP2();
        ep1.setLocation(ep1.getX() + drag.x, ep1.getY() + drag.y);
        ep2.setLocation(ep2.getX() + drag.x, ep2.getY() + drag.y);
        cp1.setLocation(cp1.getX() + drag.x, cp1.getY() + drag.y);
        cp2.setLocation(cp2.getX() + drag.x, cp2.getY() + drag.y);
        cc2d.setCurve(ep1, cp1, cp2, ep2);
        this.syncModel();
    }

    @Override
    protected void updateHandles() {
        CubicCurve2D cc2d = (CubicCurve2D)this.getModelShape();
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlP1();
        Point2D cp2 = cc2d.getCtrlP2();
        this.get(0).setLocation(ep1);
        this.get(1).setLocation(cp1);
        this.get(2).setLocation(cp2);
        this.get(3).setLocation(ep2);
    }

    private void createHandles() {
        this._handle1 = new XpHandle((XpAnchorable)this, 0, 16);
        this.add(this._handle1);
        this._handle2 = new XpHandle((XpAnchorable)this, 1, 16);
        this.add(this._handle2);
        this._handle3 = new XpHandle((XpAnchorable)this, 2, 16);
        this.add(this._handle3);
        this._handle4 = new XpHandle((XpAnchorable)this, 3, 16);
        this.add(this._handle4);
        this._handle1.setFilled(false);
        this._handle2.setFilled(false);
        this._handle3.setFilled(false);
        this._handle4.setFilled(false);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        XpHandle xph = (XpHandle)source;
        CubicCurve2D cc2d = (CubicCurve2D)this.getModelShape();
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlP1();
        Point2D cp2 = cc2d.getCtrlP2();
        if (xph == this._handle1) {
            ep1.setLocation(ep1.getX() + drag.x, ep1.getY() + drag.y);
            cc2d.setCurve(ep1, cp1, cp2, ep2);
        } else if (xph == this._handle2) {
            cp1.setLocation(cp1.getX() + drag.x, cp1.getY() + drag.y);
            cc2d.setCurve(ep1, cp1, cp2, ep2);
        } else if (xph == this._handle3) {
            cp2.setLocation(cp2.getX() + drag.x, cp2.getY() + drag.y);
            cc2d.setCurve(ep1, cp1, cp2, ep2);
        } else if (xph == this._handle4) {
            ep2.setLocation(ep2.getX() + drag.x, ep2.getY() + drag.y);
            cc2d.setCurve(ep1, cp1, cp2, ep2);
        }
        this.syncModel();
        super.anchorDragged(e2, drag, source);
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new CubicCurveCreator();
        }
        return null;
    }

    @Override
    public final GSPSGraphic gspsDescription() {
        return null;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        try {
            s2.defaultWriteObject();
            s2.writeDouble(this.modelShape.getX1());
            s2.writeDouble(this.modelShape.getY1());
            s2.writeDouble(this.modelShape.getCtrlX1());
            s2.writeDouble(this.modelShape.getCtrlY1());
            s2.writeDouble(this.modelShape.getCtrlX2());
            s2.writeDouble(this.modelShape.getCtrlY2());
            s2.writeDouble(this.modelShape.getX2());
            s2.writeDouble(this.modelShape.getY2());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
            this.modelShape = new CubicCurve2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
            this.setRoiShapeModel(new RoiShapeModel(this.modelShape));
            this.drawShape = (CubicCurve2D)this.modelShape.clone();
            this.tmpPoint1 = new Point2D.Double();
            this.createHandles();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static class CubicCurveCreator
    extends XpRoiComponentCreator {
        private CubicCurveCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            int w2 = 100;
            int h2 = 50;
            XpCubicCurveRoi m2 = new XpCubicCurveRoi(new CubicCurve2D.Double(x2, y2, x2 + (double)(w2 / 4), y2 + (double)h2 - 15.0, x2 + (double)w2 * 0.75, y2 + 15.0, x2 + (double)w2 - 2.0, y2 + (double)h2 - 2.0));
            return m2;
        }
    }
}

