/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XpQuadCurveRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private transient XpHandle _handle1 = null;
    private transient XpHandle _handle2 = null;
    private transient XpHandle _handle3 = null;
    private transient QuadCurve2D drawShape = null;
    private transient QuadCurve2D modelShape = null;
    private transient Point2D tmpPoint1 = new Point2D.Double();

    public XpQuadCurveRoi(QuadCurve2D cc2d) {
        super(cc2d);
        this.modelShape = cc2d;
        this.drawShape = (QuadCurve2D)cc2d.clone();
        this.createHandles();
    }

    @Override
    public Object clone() {
        QuadCurve2D qc = (QuadCurve2D)this.getModelShape();
        QuadCurve2D cloneqc = (QuadCurve2D)qc.clone();
        XpQuadCurveRoi ccr = new XpQuadCurveRoi(cloneqc);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g2) {
        super.render(vc, g2);
        this.drawRoiId(vc, g2, this._handle1);
    }

    @Override
    protected final void dragMouse(CPoint drag) {
        QuadCurve2D cc2d = (QuadCurve2D)this.getModelShape();
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlPt();
        ep1.setLocation(ep1.getX() + drag.x, ep1.getY() + drag.y);
        ep2.setLocation(ep2.getX() + drag.x, ep2.getY() + drag.y);
        cp1.setLocation(cp1.getX() + drag.x, cp1.getY() + drag.y);
        cc2d.setCurve(ep1, cp1, ep2);
        this.syncModel();
    }

    @Override
    protected void updateHandles() {
        QuadCurve2D cc2d = (QuadCurve2D)this.getModelShape();
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlPt();
        this._handle1.setLocation(ep1.getX(), ep1.getY());
        this._handle2.setLocation(cp1.getX(), cp1.getY());
        this._handle3.setLocation(ep2.getX(), ep2.getY());
    }

    public void createHandles() {
        this._handle1 = new XpHandle((XpAnchorable)this, 0, 16);
        this.add(this._handle1);
        this._handle2 = new XpHandle((XpAnchorable)this, 1, 16);
        this.add(this._handle2);
        this._handle3 = new XpHandle((XpAnchorable)this, 2, 16);
        this.add(this._handle3);
        this._handle1.setFilled(false);
        this._handle2.setFilled(false);
        this._handle3.setFilled(false);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        XpHandle xph = (XpHandle)source;
        QuadCurve2D cc2d = (QuadCurve2D)this.getModelShape();
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlPt();
        if (xph == this._handle1) {
            ep1.setLocation(ep1.getX() + drag.x, ep1.getY() + drag.y);
            cc2d.setCurve(ep1, cp1, ep2);
            this.syncModel();
        } else if (xph == this._handle2) {
            cp1.setLocation(cp1.getX() + drag.x, cp1.getY() + drag.y);
            cc2d.setCurve(ep1, cp1, ep2);
            this.syncModel();
        } else if (xph == this._handle3) {
            ep2.setLocation(ep2.getX() + drag.x, ep2.getY() + drag.y);
            cc2d.setCurve(ep1, cp1, ep2);
            this.syncModel();
        }
        super.anchorDragged(e2, drag, source);
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new QuadCurveCreator();
        }
        return null;
    }

    @Override
    public final Shape getDrawShape() {
        this.updateDrawShape();
        return this.drawShape;
    }

    private void updateDrawShape() {
        QuadCurve2D cc2d = (QuadCurve2D)this.getModelShape();
        QuadCurve2D drs = this.drawShape;
        Point2D ep1 = cc2d.getP1();
        Point2D ep2 = cc2d.getP2();
        Point2D cp1 = cc2d.getCtrlPt();
        this.getDisplayPoint(ep1, this.tmpPoint1);
        double tx1 = this.tmpPoint1.getX();
        double ty1 = this.tmpPoint1.getY();
        this.getDisplayPoint(ep2, this.tmpPoint1);
        double tx2 = this.tmpPoint1.getX();
        double ty2 = this.tmpPoint1.getY();
        this.getDisplayPoint(cp1, this.tmpPoint1);
        double tcx1 = this.tmpPoint1.getX();
        double tcy1 = this.tmpPoint1.getY();
        drs.setCurve(tx1, ty1, tcx1, tcy1, tx2, ty2);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        try {
            s2.defaultWriteObject();
            s2.writeDouble(this.modelShape.getX1());
            s2.writeDouble(this.modelShape.getY1());
            s2.writeDouble(this.modelShape.getCtrlX());
            s2.writeDouble(this.modelShape.getCtrlY());
            s2.writeDouble(this.modelShape.getX2());
            s2.writeDouble(this.modelShape.getY2());
            s2.writeBoolean(this.isVisible());
            s2.writeObject(this.getRoiLabel());
            s2.writeObject(this.getColor());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
            this.modelShape = new QuadCurve2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
            RoiShapeModel rsm = new RoiShapeModel(this.modelShape);
            boolean visibility = s2.readBoolean();
            String roiLabel = (String)s2.readObject();
            Color color = (Color)s2.readObject();
            rsm.setVisible(visibility);
            rsm.setRoiLabel(roiLabel);
            rsm.setColor(color);
            this.setRoiShapeModel(rsm);
            this.drawShape = (QuadCurve2D)this.modelShape.clone();
            this.tmpPoint1 = new Point2D.Double();
            this.createHandles();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static class QuadCurveCreator
    extends XpRoiComponentCreator {
        private QuadCurveCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            int w2 = 100;
            int h2 = 50;
            XpQuadCurveRoi m2 = new XpQuadCurveRoi(new QuadCurve2D.Double(x2, y2, x2 + (double)(w2 / 4), y2 + (double)h2 - 15.0, x2 + (double)w2 - 2.0, y2 + (double)h2 - 2.0));
            return m2;
        }
    }
}

