/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import com.ge.med.terra.jami.roi.aw.XpAwRectangle;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;

public class XpAwEllipse
extends XpRectangularRoi.Ellipse {
    private int centerHandleId = this.getNumHandles();
    private XpHandle centerHandle = new XpHandle((XpAnchorable)this, this.centerHandleId, 16);
    private static final double EPSILON = 1.0E-4;

    public XpAwEllipse(Ellipse2D e2) {
        super(e2);
        XpHandle.setHandleColor(Color.CYAN);
        this.add(this.centerHandle);
        double hx = e2.getX() + e2.getWidth() * 0.5;
        double hy = e2.getY() + e2.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i2 = 0; i2 < noHandles - 1; ++i2) {
            this.getHandle(i2).setVisible(false);
        }
        this.centerHandle.setVisible(false);
        super.anchorPressed(e2, jc);
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiPressed(e2);
        }
    }

    @Override
    public void anchorReleased(MouseEvent e2, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i2 = 0; i2 < noHandles - 1; ++i2) {
            this.getHandle(i2).setVisible(true);
        }
        this.centerHandle.setVisible(true);
        this.sync();
        super.anchorReleased(e2, jc);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object jc) {
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiDragged(e2);
            RectangularShape r2 = (RectangularShape)this.getModelShape();
            double hx = r2.getX() + r2.getWidth() * 0.5;
            double hy = r2.getY() + r2.getHeight() * 0.5;
            this.centerHandle.setLocation(hx, hy);
            this.syncModel();
        } else {
            super.anchorDragged(e2, drag, jc);
        }
    }

    @Override
    public void roiDragged(MouseEvent e2) {
        super.roiDragged(e2);
        RectangularShape r2 = (RectangularShape)this.getModelShape();
        double hx = r2.getX() + r2.getWidth() * 0.5;
        double hy = r2.getY() + r2.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
        this.syncModel();
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new AwEllipseCreator();
        }
        return null;
    }

    private static List<Point2D> dupPointList(List<Point2D> data) {
        ArrayList<Point2D> dupdata = new ArrayList<Point2D>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Point2D p2 = data.get(i2);
            Point2D.Double np = new Point2D.Double();
            np.setLocation(p2);
            dupdata.add(np);
        }
        return dupdata;
    }

    public static final XpAwEllipse createRoiActor(List<Point2D> gdata, boolean filled, byte csystem) {
        List<Point2D> rgdata = XpAwEllipse.dupPointList(gdata);
        double ulX = Double.MAX_VALUE;
        double ulY = Double.MAX_VALUE;
        double brX = Double.MIN_VALUE;
        double brY = Double.MIN_VALUE;
        Point2D p1 = rgdata.get(0);
        Point2D p2 = rgdata.get(1);
        Point2D p3 = rgdata.get(2);
        Point2D p4 = rgdata.get(3);
        double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
        double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
        double num = p1.getY() - p2.getY();
        double denom = p2.getX() - p1.getX();
        if (Math.abs(denom) > 1.0E-4 || Math.abs(num) > 1.0E-4) {
            double angle = 0.0;
            if (Math.abs(denom) > 1.0E-4) {
                angle = Math.atan(num / denom);
            }
            XpGeomUtils gu = new XpGeomUtils();
            gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
            gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
            gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
            gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
            for (int i2 = 0; i2 < rgdata.size(); ++i2) {
                Point2D p5 = rgdata.get(i2);
                double x2 = p5.getX();
                double y2 = p5.getY();
                if (x2 < ulX) {
                    ulX = x2;
                }
                if (x2 > brX) {
                    brX = x2;
                }
                if (y2 < ulY) {
                    ulY = y2;
                }
                if (!(y2 > brY)) continue;
                brY = y2;
            }
            double w2 = Math.abs(ulX - brX);
            double h2 = Math.abs(ulY - brY);
            Ellipse2D.Double e2 = new Ellipse2D.Double(ulX, ulY, w2, h2);
            XpAwEllipse rr = new XpAwEllipse(e2);
            rr.setAngle(angle);
            return rr;
        }
        return null;
    }

    private static class AwEllipseCreator
    extends XpAwRectangle.RectComponentCreator {
        private AwEllipseCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            return new XpAwEllipse(new Ellipse2D.Double(x2 - 5.0, y2 - 3.0, 5.0, 3.0));
        }
    }
}

