/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpHandleVc;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XpTAGTRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private static int LINE_SENSITIVITY = 4;
    private transient GeneralPath polygon = null;
    private transient GeneralPath drawPolygon = new GeneralPath();
    private transient List points = new ArrayList();
    private transient List txpoints = new ArrayList();
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D containsTemp = new Point2D.Double();
    private transient Point2D clipPt = new Point2D.Double();
    private transient List approxPts = new ArrayList();
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private transient Point2D accumPoint = new Point2D.Double();
    private transient Point2D firstPtOffset = new Point2D.Double();
    private boolean closed = false;
    private boolean idealMetrics = true;
    private boolean doHandles = true;
    private double a_alpha = 0.0;
    private static int SecondHandle = 2;
    private static int ThirdHandle = 5;

    public XpTAGTRoi(double x1, double y1, double x2, double y2, boolean imageRelated) {
        super(new GeneralPath());
        Point2D.Double pA = new Point2D.Double(x1, y2);
        Point2D.Double pB = new Point2D.Double(x1 + (x2 - x1) * 0.3, y1);
        Point2D.Double pC = new Point2D.Double(x2 - (x2 - x1) * 0.3, y1);
        Point2D.Double pD = new Point2D.Double(x2, y2);
        this.init(pA, pB, pC, pD);
    }

    private void init(Point2D ppA, Point2D ppB, Point2D ppC, Point2D ppD) {
        Point2D pA = ppA;
        Point2D pB = ppB;
        Point2D pC = ppC;
        Point2D pD = ppD;
        Point2D.Double qB = new Point2D.Double(0.0, 0.0);
        Point2D.Double qC = new Point2D.Double(0.0, 0.0);
        Point2D.Double qD = new Point2D.Double(0.0, 0.0);
        this.a_alpha = Math.atan2(pD.getY() - pA.getY(), pD.getX() - pA.getX());
        XpTAGTRoi.basicToInternal(pA, this.a_alpha, pB, qB);
        XpTAGTRoi.basicToInternal(pA, this.a_alpha, pC, qC);
        XpTAGTRoi.basicToInternal(pA, this.a_alpha, pD, qD);
        if (qB.getX() < 0.0) {
            qB.x = 0.0;
            this.internalToBasic(pA, this.a_alpha, pB, qB);
        }
        if (qC.getX() < qB.getX()) {
            qC.x = qB.getX();
            this.internalToBasic(pA, this.a_alpha, pC, qC);
        }
        if (qD.getX() < qC.getX()) {
            qD.x = qC.getX();
            this.internalToBasic(pA, this.a_alpha, pD, qD);
        }
        Point2D.Double pE = new Point2D.Double(0.0, 0.0);
        Point2D.Double pF = new Point2D.Double(0.0, 0.0);
        this.calculateEFfromABCD(pA, pB, pC, pD, pE, pF, this.a_alpha);
        Point2D[] pts = new Point2D[]{pA, pE, pB, pE, pF, pC, pF, pD};
        this.polygon = (GeneralPath)this.getModelShape();
        this.setCalcPixelStats(true);
        if (pts.length > 0) {
            for (int i2 = 0; i2 < pts.length; ++i2) {
                this.points.add(pts[i2]);
                this.txpoints.add(new Point2D.Double());
                if (i2 != 0 && i2 != 2 && i2 != 5 && i2 != 7) continue;
                XpHandle handle = new XpHandle((XpAnchorable)this, i2, 16);
                handle.setFilled(false);
                this.add(handle);
            }
            this.generateModelPolygon();
        }
    }

    @Override
    protected void updateHandles() {
        int len = this.points.size();
        int handleIndex = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 != 0 && i2 != 2 && i2 != 5 && i2 != 7) continue;
            XpHandle h2 = this.get(handleIndex);
            Point2D p2 = (Point2D)this.points.get(i2);
            h2.setLocation(p2);
            ++handleIndex;
        }
    }

    public static void basicToInternal(Point2D pA, double alpha, Point2D pP, Point2D qP) {
        qP.setLocation(Math.cos(alpha) * (pP.getX() - pA.getX()) + Math.sin(alpha) * (pP.getY() - pA.getY()), Math.cos(alpha) * (pP.getY() - pA.getY()) - Math.sin(alpha) * (pP.getX() - pA.getX()));
    }

    public void internalToBasic(Point2D pA, double alpha, Point2D pP, Point2D qP) {
        pP.setLocation(pA.getX() + Math.cos(alpha) * qP.getX() - Math.sin(alpha) * qP.getY(), pA.getY() + Math.sin(alpha) * qP.getX() + Math.cos(alpha) * qP.getY());
    }

    public void calculateEFfromABCD(Point2D A2, Point2D B, Point2D C, Point2D D, Point2D E, Point2D F, double angle) {
        double dx = D.getX() - A2.getX();
        double dy = D.getY() - A2.getY();
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double dxdy = dx * dy;
        double N2 = dx2 + dy2;
        if (N2 != 0.0) {
            double ex = (dx2 * B.getX() + dy2 * A2.getX() + dxdy * (B.getY() - A2.getY())) / N2;
            double ey = (dx2 * A2.getY() + dy2 * B.getY() + dxdy * (B.getX() - A2.getX())) / N2;
            E.setLocation(ex, ey);
            double fx = (dx2 * C.getX() + dy2 * A2.getX() + dxdy * (C.getY() - A2.getY())) / N2;
            double fy = (dx2 * A2.getY() + dy2 * C.getY() + dxdy * (C.getX() - A2.getX())) / N2;
            F.setLocation(fx, fy);
            angle = Math.atan2(dy, dx);
        } else {
            E = A2;
            F = D;
            angle = 0.0;
        }
        this.a_alpha = angle;
    }

    public void resizeTAGT(int a_draggingHandle) {
        Point2D pA = (Point2D)this.points.get(0);
        Point2D pB = (Point2D)this.points.get(2);
        Point2D pC = (Point2D)this.points.get(5);
        Point2D pD = (Point2D)this.points.get(7);
        Point2D.Double qB = new Point2D.Double(0.0, 0.0);
        Point2D.Double qC = new Point2D.Double(0.0, 0.0);
        Point2D.Double qD = new Point2D.Double(0.0, 0.0);
        XpTAGTRoi.basicToInternal(pA, this.a_alpha, pB, qB);
        XpTAGTRoi.basicToInternal(pA, this.a_alpha, pC, qC);
        XpTAGTRoi.basicToInternal(pA, this.a_alpha, pD, qD);
        Point2D pAnew = pA;
        Point2D pBnew = pB;
        Point2D pCnew = pC;
        Point2D pDnew = pD;
        switch (a_draggingHandle) {
            case 0: {
                Point2D pAtmp = (Point2D)this.points.get(0);
                Point2D.Double qBnew = qB;
                Point2D.Double qCnew = qC;
                Point2D.Double qDnew = new Point2D.Double(0.0, 0.0);
                double alphaNew = Math.atan2(pDnew.getY() - pAtmp.getY(), pDnew.getX() - pAtmp.getX());
                XpTAGTRoi.basicToInternal(pAtmp, alphaNew, pD, qDnew);
                double delta = ((Point2D)qDnew).getX() - ((Point2D)qD).getX();
                qBnew.x = qB.getX() + delta;
                qCnew.x = qC.getX() + delta;
                if (qBnew.getX() < 0.0) break;
                pAnew = pAtmp;
                this.internalToBasic(pAtmp, alphaNew, pBnew, qBnew);
                this.internalToBasic(pAtmp, alphaNew, pCnew, qCnew);
                this.points.set(SecondHandle, pBnew);
                this.points.set(ThirdHandle, pCnew);
                break;
            }
            case 2: {
                pBnew = (Point2D)this.points.get(2);
                Point2D.Double qBnew = new Point2D.Double(0.0, 0.0);
                XpTAGTRoi.basicToInternal(pA, this.a_alpha, pBnew, qBnew);
                if (qBnew.x < 0.0) {
                    qBnew.x = 0.0;
                }
                if (qBnew.x > qC.getX()) {
                    qBnew.x = qC.getX();
                }
                this.internalToBasic(pA, this.a_alpha, pBnew, qBnew);
                break;
            }
            case 5: {
                pCnew = (Point2D)this.points.get(5);
                Point2D.Double qCnew = new Point2D.Double(0.0, 0.0);
                XpTAGTRoi.basicToInternal(pA, this.a_alpha, pCnew, qCnew);
                if (qCnew.x < qB.getX()) {
                    qCnew.x = qB.getX();
                }
                if (qCnew.x > ((Point2D)qD).getX()) {
                    qCnew.x = ((Point2D)qD).getX();
                }
                this.internalToBasic(pA, this.a_alpha, pCnew, qCnew);
                break;
            }
            case 7: {
                pDnew = (Point2D)this.points.get(7);
                Point2D.Double qDnew = new Point2D.Double(0.0, 0.0);
                double alphaNew = Math.atan2(pDnew.getY() - pAnew.getY(), pDnew.getX() - pAnew.getX());
                XpTAGTRoi.basicToInternal(pA, alphaNew, pDnew, qDnew);
                if (qDnew.x < qC.getX()) {
                    qDnew.x = qC.getX();
                }
                this.internalToBasic(pA, alphaNew, pDnew, qDnew);
                this.internalToBasic(pA, alphaNew, pBnew, qB);
                this.internalToBasic(pA, alphaNew, pCnew, qC);
                this.points.set(SecondHandle, pBnew);
                this.points.set(ThirdHandle, pCnew);
                break;
            }
        }
        this.points.set(0, pAnew);
        this.points.set(2, pBnew);
        this.points.set(5, pCnew);
        this.points.set(7, pDnew);
        Point2D.Double pEnew = new Point2D.Double(0.0, 0.0);
        Point2D.Double pFnew = new Point2D.Double(0.0, 0.0);
        this.calculateEFfromABCD(pAnew, pBnew, pCnew, pDnew, pEnew, pFnew, this.a_alpha);
        this.points.set(3, pEnew);
        this.points.set(4, pFnew);
        this.points.set(1, pEnew);
        this.points.set(6, pFnew);
    }

    @Override
    protected void copyObject(Object o2) {
        XpTAGTRoi pr = (XpTAGTRoi)o2;
        super.copyObject(pr);
        pr.closed = this.closed;
        pr.idealMetrics = this.idealMetrics;
        pr.doHandles = this.doHandles;
    }

    @Override
    public final Shape getDrawShape() {
        this.generateDrawPolygon();
        return this.drawPolygon;
    }

    @Override
    public final String createRoiStatLabel(XpPixelStatistics ps) {
        double distance = this.getLength();
        int len = this.points.size();
        String roiStat = this.getRoiLabel() + ": ";
        roiStat = roiStat + "distance " + this.statFormat0(distance) + " mm";
        return roiStat;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g2) {
        super.render(vc, g2);
        g2.setColor(XpHandleVc.getHandleColor());
        this.drawRoiId(g2, this.firstPtOffset.getX(), this.firstPtOffset.getY());
    }

    public final Point2D getPoint(int i2) {
        return (Point2D)this.points.get(i2);
    }

    public final int getNumPoints() {
        return this.points.size();
    }

    private final void generateModelPolygon() {
        this.polygon.reset();
        this.approxPts.clear();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p2;
            Point2D prev = p2 = (Point2D)this.points.get(0);
            this.approxPts.add(p2);
            float x2 = (float)p2.getX();
            float y2 = (float)p2.getY();
            this.polygon.moveTo(x2, y2);
            for (int i2 = 1; i2 < nPts; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                x2 = (float)p2.getX();
                y2 = (float)p2.getY();
                this.polygon.lineTo(x2, y2);
                double distance = p2.distanceSq(prev);
                if (!(distance > 6.0) && nPts >= 100) continue;
                this.approxPts.add(p2);
                prev = p2;
            }
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
            }
        }
    }

    private final void generateDrawPolygon() {
        this.polygon.reset();
        this.drawPolygon.reset();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p2 = (Point2D)this.points.get(0);
            float x2 = (float)p2.getX();
            float y2 = (float)p2.getY();
            this.getDisplayPoint(p2, this.tmpPoint1);
            float t_x = (float)this.tmpPoint1.getX();
            float t_y = (float)this.tmpPoint1.getY();
            this.polygon.moveTo(x2, y2);
            this.drawPolygon.moveTo(t_x, t_y);
            this.firstPtOffset.setLocation(t_x + 4.0f, t_y - 2.0f);
            this.minX = this.maxX = (double)x2;
            this.minY = this.maxY = (double)y2;
            for (int i2 = 1; i2 < nPts; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                x2 = (float)p2.getX();
                y2 = (float)p2.getY();
                this.getDisplayPoint(p2, this.tmpPoint1);
                t_x = (float)this.tmpPoint1.getX();
                t_y = (float)this.tmpPoint1.getY();
                this.polygon.lineTo(x2, y2);
                this.drawPolygon.lineTo(t_x, t_y);
                if ((double)x2 < this.minX) {
                    this.minX = x2;
                }
                if ((double)x2 > this.maxX) {
                    this.maxX = x2;
                }
                if ((double)y2 < this.minY) {
                    this.minY = y2;
                }
                if (!((double)y2 > this.maxY)) continue;
                this.maxY = y2;
            }
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
                this.drawPolygon.closePath();
            }
        }
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object source) {
        super.anchorPressed(e2, source);
        XpHandle xph = (XpHandle)source;
        int i2 = xph.getAnchorPointIndex();
        Point2D p2 = (Point2D)this.points.get(i2);
        this.accumPoint.setLocation(p2);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        super.anchorDragged(e2, drag, source);
        XpHandle xph = (XpHandle)source;
        int i2 = xph.getAnchorPointIndex();
        Point2D p2 = (Point2D)this.points.get(i2);
        this.accumPoint.setLocation(this.accumPoint.getX() + drag.x, this.accumPoint.getY() + drag.y);
        double x2 = this.accumPoint.getX();
        double y2 = this.accumPoint.getY();
        this.clipPoint(x2, y2, this.clipPt);
        if (x2 == this.clipPt.getX() && y2 == this.clipPt.getY()) {
            p2.setLocation(this.clipPt);
        }
        this.resizeTAGT(i2);
        this.syncModel();
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x2, int y2) {
        this.getImagePoint(x2, y2, this.containsTemp);
        double xx = this.containsTemp.getX();
        double yy = this.containsTemp.getY();
        if (xx > this.minX && xx < this.maxX && yy > this.minY && yy < this.maxY) {
            Point2D first;
            Point2D prev = first = (Point2D)this.approxPts.get(0);
            int len = this.approxPts.size();
            for (int i2 = 1; i2 < len; ++i2) {
                Point2D p2 = (Point2D)this.approxPts.get(i2);
                if (XpGeomUtils.containsCoord((int)xx, (int)yy, prev, p2, LINE_SENSITIVITY)) {
                    return true;
                }
                prev = p2;
            }
            if (this.closed && XpGeomUtils.containsCoord((int)xx, (int)yy, prev, first, LINE_SENSITIVITY)) {
                return true;
            }
        }
        return false;
    }

    private void translate(double tx, double ty) {
        Point2D txp;
        Point2D p2;
        int i2;
        int len = this.points.size();
        boolean dotranslate = true;
        for (i2 = 0; i2 < len; ++i2) {
            p2 = (Point2D)this.points.get(i2);
            txp = (Point2D)this.txpoints.get(i2);
            double x2 = p2.getX() + tx;
            double y2 = p2.getY() + ty;
            this.clipPoint(x2, y2, this.clipPt);
            double cx = this.clipPt.getX();
            double cy = this.clipPt.getY();
            if ((x2 != cx || y2 != cy) && this.isClipRoi()) {
                dotranslate = false;
                break;
            }
            txp.setLocation(cx, cy);
        }
        if (dotranslate) {
            for (i2 = 0; i2 < len; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                txp = (Point2D)this.txpoints.get(i2);
                p2.setLocation(txp);
            }
            this.generateDrawPolygon();
        }
    }

    @Override
    protected final void dragMouse(CPoint drag) {
        this.translate(drag.x, drag.y);
        this.syncModel();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public GSPSGraphic gspsDescription() {
        int len = this.points.size();
        Point2D[] pts = new Point2D[len];
        for (int i2 = 0; i2 < len; ++i2) {
            Point2D p2 = (Point2D)this.points.get(i2);
            pts[i2] = new Point2D.Double(p2.getX(), p2.getY());
        }
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    public void setIdealMetrics(boolean idealMetric) {
        this.idealMetrics = idealMetric;
    }

    public boolean isIdealMetrics() {
        return this.idealMetrics;
    }

    @Override
    public double getLength() {
        if (!this.idealMetrics) {
            return super.getLength();
        }
        XpImage img = this.getImage();
        double len = 0.0;
        if (img != null) {
            double pdx = img.getPixelDimensionX();
            double pdy = img.getPixelDimensionY();
            Point2D p1 = (Point2D)this.points.get(1);
            Point2D p0 = (Point2D)this.points.get(4);
            double x1 = p1.getX() * pdx;
            double y1 = p1.getY() * pdy;
            double x0 = p0.getX() * pdx;
            double y0 = p0.getY() * pdy;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len = Math.sqrt(dx * dx + dy * dy);
        }
        return len;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int i2;
        s2.defaultWriteObject();
        if (this.points != null && this.points.size() > 0) {
            s2.writeInt(this.points.size());
            for (i2 = 0; i2 < this.points.size(); ++i2) {
                s2.writeDouble(((Point2D)this.points.get(i2)).getX());
                s2.writeDouble(((Point2D)this.points.get(i2)).getY());
            }
        }
        s2.writeInt(this.approxPts.size());
        for (i2 = 0; i2 < this.approxPts.size(); ++i2) {
            s2.writeDouble(((Point2D)this.approxPts.get(i2)).getX());
            s2.writeDouble(((Point2D)this.approxPts.get(i2)).getY());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            int i2;
            s2.defaultReadObject();
            int size = s2.readInt();
            ArrayList ds_points = new ArrayList();
            ArrayList ds_txpoints = new ArrayList();
            ArrayList<Point2D.Double> ds_approxPts = new ArrayList<Point2D.Double>();
            Point2D[] pts = new Point2D[size];
            for (i2 = 0; i2 < size; ++i2) {
                double x2 = s2.readDouble();
                double y2 = s2.readDouble();
                pts[i2] = new Point2D.Double(x2, y2);
            }
            size = s2.readInt();
            for (i2 = 0; i2 < size; ++i2) {
                ds_approxPts.add(new Point2D.Double(s2.readDouble(), s2.readDouble()));
            }
            this.points = ds_points;
            this.txpoints = ds_txpoints;
            this.approxPts = ds_approxPts;
            this.drawPolygon = new GeneralPath();
            this.tmpPoint1 = new Point2D.Double();
            this.containsTemp = new Point2D.Double();
            this.clipPt = new Point2D.Double();
            this.accumPoint = new Point2D.Double();
            this.firstPtOffset = new Point2D.Double();
            this.setRoiShapeModel(new RoiShapeModel(new GeneralPath()));
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new XpTAGTComponentCreator();
        }
        return null;
    }

    static {
        String ls = XpPropertiesManager.getProperty("jami.roi.polygon.linesensitivity");
        int ils = 4;
        if (ls != null && (ils = Integer.parseInt(ls)) <= 0) {
            ils = 4;
        }
        LINE_SENSITIVITY = ils;
    }

    private static class XpTAGTComponentCreator
    extends XpRoiComponentCreator {
        private XpTAGTComponentCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            double ax = x2;
            double ay = y2;
            double ax1 = x2 + 20.0;
            double ay1 = y2 + 20.0;
            XpTAGTRoi tagt = new XpTAGTRoi(ax, ay, ax1, ay1, true);
            return tagt;
        }
    }
}

