/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.j3d;

import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.roi.RoiStatistics;
import com.ge.med.terra.jami.roi.RoiStatisticsCreator;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.roi.j3d.Roi3DStatImage;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.util.Arrays;

public class Jami3DRoiStatistics
implements RoiStatistics {
    private static int[] volumeRasterFreq = new int[]{1, 1};
    protected XpImage image = null;
    protected XpPixelStatistics ps = new XpPixelStatistics();
    protected XpSlice rasterSlice = null;
    protected BufferedImage rasterBitmap = null;

    @Override
    public void setImage(XpImage img) {
        this.image = img;
    }

    public boolean isVolumeStatistics(Roi3DStatImage img) {
        boolean retval = img.getT3DRenderEngine().getRenderStyle().startsWith("REFORMAT");
        return retval;
    }

    @Override
    public double getArea(Shape s2, double angle) {
        XpPixelStatistics ps = this.getPixelStatistics(s2, angle);
        Roi3DStatImage img = (Roi3DStatImage)this.image;
        XpSlice refSlice = img.getReferenceSlice();
        double pdx = refSlice.pixelSizeX;
        double pdy = refSlice.pixelSizeY;
        return (double)ps.npixels * pdx * pdy;
    }

    @Override
    public double getLength(Shape s2, double angle) {
        Roi3DStatImage img = (Roi3DStatImage)this.image;
        if (img != null) {
            XpSlice refSlice = img.getReferenceSlice();
            double pdx = refSlice.pixelSizeX;
            double pdy = refSlice.pixelSizeY;
            return XpImageUtils.calcShapeLength(s2, pdx, pdy);
        }
        return -1.0;
    }

    protected void computeBitmap(Shape s2, double angle) {
        Rectangle2D bbox = s2.getBounds2D();
        Roi3DStatImage rsimg = (Roi3DStatImage)this.image;
        XpSlice refSlice = rsimg.getReferenceSlice();
        if (refSlice == null) {
            rsimg.syncReferenceSlice();
        }
        if (refSlice != null) {
            AffineTransform at = new AffineTransform();
            at.setToIdentity();
            at.rotate(-angle, bbox.getCenterX(), bbox.getCenterY());
            double minX = 9999999.0;
            double maxX = -9999999.0;
            double minY = 9999999.0;
            double maxY = -9999999.0;
            Point2D.Double p0 = new Point2D.Double();
            ((Point2D)p0).setLocation(bbox.getMinX(), bbox.getMinY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            ((Point2D)p0).setLocation(bbox.getMaxX(), bbox.getMinY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            ((Point2D)p0).setLocation(bbox.getMaxX(), bbox.getMaxY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            ((Point2D)p0).setLocation(bbox.getMinX(), bbox.getMaxY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            double boxHeight = Math.abs(maxY - minY);
            double boxWidth = Math.abs(maxX - minX);
            CPoint imgpt = new CPoint(minX, minY, 0.0, 0);
            CPoint ulras = new CPoint(2);
            CPoint urras = new CPoint(2);
            CPoint brras = new CPoint(2);
            refSlice.imageToRas.transform(imgpt, ulras);
            imgpt.set(maxX, minY, 0.0);
            refSlice.imageToRas.transform(imgpt, urras);
            imgpt.set(maxX, maxY, 0.0);
            refSlice.imageToRas.transform(imgpt, brras);
            T3DRenderEngine renderEngine = rsimg.getT3DRenderEngine();
            XjVolumeInfo volumeInfo = null;
            if (renderEngine != null) {
                volumeInfo = renderEngine.getVolumeModel().getVolume();
            }
            CTransform vox2ras = new CTransform();
            CTransform ras2vox = new CTransform();
            XjVolumeUtils.calculateVoxelRASTransform((XjVolumeGeometry)volumeInfo, vox2ras, ras2vox);
            CPoint ulvox = new CPoint(5);
            CPoint urvox = new CPoint(5);
            CPoint brvox = new CPoint(5);
            ras2vox.transform(ulras, ulvox);
            ras2vox.transform(urras, urvox);
            ras2vox.transform(brras, brvox);
            int voxBoxHeight = (int)Math.round(urvox.distance(brvox) * (double)volumeRasterFreq[1]);
            int voxBoxWidth = (int)Math.round(urvox.distance(ulvox) * (double)volumeRasterFreq[0]);
            this.rasterBitmap = new BufferedImage(voxBoxWidth, voxBoxHeight, 12);
            this.rasterSlice = new XpSlice(voxBoxWidth, voxBoxHeight);
            this.rasterSlice.setCorners(ulras, urras, brras);
            CTransform ras2img = this.rasterSlice.rasToImage;
            CTransform tx = refSlice.imageToRas.multiplyBy(ras2img);
            byte[] data = ((DataBufferByte)this.rasterBitmap.getRaster().getDataBuffer()).getData();
            Arrays.fill(data, (byte)0);
            tx.getTransform2D(at);
            Graphics2D g2 = (Graphics2D)this.rasterBitmap.getGraphics();
            g2.transform(at);
            g2.rotate(-angle, bbox.getCenterX(), bbox.getCenterY());
            g2.fill(s2);
        }
    }

    @Override
    public XpPixelStatistics getPixelStatistics(Shape s2, double angle) {
        Roi3DStatImage rsimg = (Roi3DStatImage)this.image;
        if (rsimg != null) {
            if (this.isVolumeStatistics(rsimg)) {
                this.computeBitmap(s2, angle);
                Jami3DRoiStatistics.calcPixelStatistics(this.rasterBitmap, this.rasterSlice, rsimg.getT3DRenderEngine().getVolumeModel(), this.ps);
            } else {
                Jami3DRoiStatistics.getStatisticsFromDrawRaster(rsimg, this.ps);
            }
        }
        return this.ps;
    }

    public XpPixelStatistics getRenderedPixelStatistics() {
        XpPixelStatistics dps = null;
        Roi3DStatImage rsimg = (Roi3DStatImage)this.image;
        if (rsimg != null) {
            dps = Jami3DRoiStatistics.getStatisticsFromDrawRaster(rsimg, null);
        }
        return dps;
    }

    protected static XpPixelStatistics getStatisticsFromDrawRaster(Roi3DStatImage rsimg, XpPixelStatistics ps) {
        BufferedImage dbitmap;
        XpStatisticsRoi sr = (XpStatisticsRoi)rsimg.getRoiActor();
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        if ((dbitmap = sr.getDisplayBitmap()) != null) {
            int pixelRepresentation = XpImageUtils.getPixelRepresentation(rsimg);
            RenderedImage rimg = rsimg.getPixelData();
            XpImageUtils.calcStats(rimg, dbitmap, rsimg.getRescaleSlope(), rsimg.getRescaleIntercept(), pixelRepresentation, 0, 0, rimg.getWidth() - 1, rimg.getHeight() - 1, ps);
        }
        return ps;
    }

    @Override
    public BufferedImage getPixels(Shape s2, double angle) {
        this.computeBitmap(s2, angle);
        return this.rasterBitmap;
    }

    public static JnHistogram calcHistogram(BufferedImage bitimg, XpPixelStatistics ps, XpSlice sample, XjVolumeModel vm, JnHistogram hist) {
        if (hist == null) {
            hist = new JnHistogram(128);
        }
        int PAD = 0;
        short[] sdata = null;
        byte[] bdata = null;
        Object idata = null;
        int dx = 0;
        int dy = 0;
        int dz = 0;
        double rescaleIntercept = 0.0;
        double rescaleSlope = 1.0;
        double[] xdir = new double[3];
        double[] ydir = new double[3];
        double[] rowstart = new double[3];
        double[] currpt = new double[3];
        double[] zero_point = new double[3];
        int[] histogram = hist.histogram;
        Point maximumPt = hist.maximumPt;
        Arrays.fill(histogram, 0);
        double maxval = (ps.max - rescaleIntercept) / rescaleSlope;
        double minval = (ps.min - rescaleIntercept) / rescaleSlope;
        double BUCKETSIZE = (maxval - minval) / (double)histogram.length;
        int maxX = 0;
        int maxY = 0;
        sample.ul.get(rowstart);
        xdir[0] = sample.I.x * sample.pixelSizeX;
        xdir[1] = sample.I.y * sample.pixelSizeX;
        xdir[2] = sample.I.z * sample.pixelSizeX;
        ydir[0] = sample.J.x * sample.pixelSizeY;
        ydir[1] = sample.J.y * sample.pixelSizeY;
        ydir[2] = sample.J.z * sample.pixelSizeY;
        if (vm instanceof J3DVolumeModel) {
            JVolume.LinearVolume jls;
            J3DVolumeModel jvm = (J3DVolumeModel)vm;
            JVolume.LinearVolume jvol = jvm.j_vol;
            rescaleIntercept = jvol.rescaleIntercept;
            rescaleSlope = jvol.rescaleSlope;
            PAD = jvol.PAD;
            dx = jvol.dx;
            dy = jvol.dy;
            dz = jvol.dz;
            if (jvol instanceof JVolume.LinearShort) {
                jls = (JVolume.LinearShort)jvol;
                sdata = jls.volume;
            } else if (jvol instanceof JVolume.LinearByte) {
                jls = (JVolume.LinearByte)jvol;
                bdata = ((JVolume.LinearByte)jls).volume;
            }
            jvm.rasToVoxels(rowstart, rowstart);
            jvm.rasToVoxels(xdir, xdir);
            jvm.rasToVoxels(ydir, ydir);
            jvm.rasToVoxels(zero_point, zero_point);
            JnVector3d.sub(xdir, zero_point, xdir);
            JnVector3d.sub(ydir, zero_point, ydir);
        }
        int rowlen_bitmap = (sample.width + 7) / 8;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        int psize = dx * dy;
        if (sdata != null) {
            for (int y2 = 0; y2 < sample.height; ++y2) {
                int boffset = y2 * rowlen_bitmap;
                currpt[0] = rowstart[0];
                currpt[1] = rowstart[1];
                currpt[2] = rowstart[2];
                for (int x2 = 0; x2 < sample.width; ++x2) {
                    int bit = x2 & 7;
                    int idx = boffset + x2 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on != 0) {
                        int sx = (int)currpt[0];
                        int sy = (int)currpt[1];
                        int sz = (int)currpt[2];
                        if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                            int volidx = PAD + sz * psize + sy * dx + sx;
                            short pval = sdata[volidx];
                            int bucket = (int)(((double)pval - minval) / BUCKETSIZE);
                            if (bucket >= histogram.length) {
                                bucket = histogram.length - 1;
                            }
                            try {
                                int n2 = bucket;
                                histogram[n2] = histogram[n2] + 1;
                                if (histogram[bucket] > maxY) {
                                    maxY = histogram[bucket];
                                    maxX = bucket;
                                }
                            }
                            catch (Exception ex) {
                                XpLog.logger().warning("Histogram Array Indexing problem: bucket=" + bucket + " | min=" + ps.min + " | pval=" + pval + " | BucketSize=" + BUCKETSIZE);
                            }
                        }
                    }
                    JnVector3d.add(currpt, xdir, currpt);
                }
                JnVector3d.add(rowstart, ydir, rowstart);
            }
        } else if (bdata != null) {
            for (int y3 = 0; y3 < sample.height; ++y3) {
                int boffset = y3 * rowlen_bitmap;
                currpt[0] = rowstart[0];
                currpt[1] = rowstart[1];
                currpt[2] = rowstart[2];
                for (int x3 = 0; x3 < sample.width; ++x3) {
                    int bit = x3 & 7;
                    int idx = boffset + x3 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on != 0) {
                        int sx = (int)currpt[0];
                        int sy = (int)currpt[1];
                        int sz = (int)currpt[2];
                        if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                            int volidx = PAD + sz * psize + sy * dx + sx;
                            byte pval = bdata[volidx];
                            int bucket = (int)(((double)pval - minval) / BUCKETSIZE);
                            if (bucket >= histogram.length) {
                                bucket = histogram.length - 1;
                            }
                            try {
                                int n3 = bucket;
                                histogram[n3] = histogram[n3] + 1;
                                if (histogram[bucket] > maxY) {
                                    maxY = histogram[bucket];
                                    maxX = bucket;
                                }
                            }
                            catch (Exception ex) {
                                XpLog.logger().warning("Histogram Array Indexing problem: bucket=" + bucket + " | min=" + ps.min + " | pval=" + pval + " | BucketSize=" + BUCKETSIZE);
                            }
                        }
                    }
                    JnVector3d.add(currpt, xdir, currpt);
                }
                JnVector3d.add(rowstart, ydir, rowstart);
            }
        }
        hist.bucketSize = BUCKETSIZE;
        hist.startX = ps.min;
        hist.endX = ps.max;
        maximumPt.setLocation(maxX, maxY);
        return hist;
    }

    private static double square(double val) {
        return val * val;
    }

    public static XpPixelStatistics calcPixelStatistics(BufferedImage bitimg, XpSlice sample, XjVolumeModel vm, XpPixelStatistics ps) {
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        int PAD = 0;
        short[] sdata = null;
        byte[] bdata = null;
        Object idata = null;
        int dx = 0;
        int dy = 0;
        int dz = 0;
        double rescaleIntercept = 0.0;
        double rescaleSlope = 1.0;
        double[] xdir = new double[3];
        double[] ydir = new double[3];
        double[] rowstart = new double[3];
        double[] currpt = new double[3];
        double[] zero_point = new double[3];
        sample.ul.get(rowstart);
        xdir[0] = sample.I.x * sample.pixelSizeX;
        xdir[1] = sample.I.y * sample.pixelSizeX;
        xdir[2] = sample.I.z * sample.pixelSizeX;
        ydir[0] = sample.J.x * sample.pixelSizeY;
        ydir[1] = sample.J.y * sample.pixelSizeY;
        ydir[2] = sample.J.z * sample.pixelSizeY;
        if (vm instanceof J3DVolumeModel) {
            JVolume.LinearVolume jls;
            J3DVolumeModel jvm = (J3DVolumeModel)vm;
            JVolume.LinearVolume jvol = jvm.getJVolume();
            rescaleIntercept = jvol.rescaleIntercept;
            rescaleSlope = jvol.rescaleSlope;
            PAD = jvol.PAD;
            dx = jvol.dx;
            dy = jvol.dy;
            dz = jvol.dz;
            if (jvol instanceof JVolume.LinearShort) {
                jls = (JVolume.LinearShort)jvol;
                sdata = jls.volume;
            } else if (jvol instanceof JVolume.LinearByte) {
                jls = (JVolume.LinearByte)jvol;
                bdata = ((JVolume.LinearByte)jls).volume;
            }
            jvm.rasToVoxels(rowstart, rowstart);
            jvm.rasToVoxels(xdir, xdir);
            jvm.rasToVoxels(ydir, ydir);
            jvm.rasToVoxels(zero_point, zero_point);
            JnVector3d.sub(xdir, zero_point, xdir);
            JnVector3d.sub(ydir, zero_point, ydir);
        }
        ps.resetStatistics();
        int rowlen_bitmap = (sample.width + 7) / 8;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        int psize = dx * dy;
        int bx1 = Integer.MAX_VALUE;
        int by1 = Integer.MAX_VALUE;
        int bx2 = Integer.MIN_VALUE;
        int by2 = Integer.MIN_VALUE;
        ps.min = 3.4028234663852886E38;
        ps.max = 1.4E-45f;
        if (sdata != null) {
            for (int y2 = 0; y2 < sample.height; ++y2) {
                int boffset = y2 * rowlen_bitmap;
                currpt[0] = rowstart[0];
                currpt[1] = rowstart[1];
                currpt[2] = rowstart[2];
                for (int x2 = 0; x2 < sample.width; ++x2) {
                    int bit = x2 & 7;
                    int idx = boffset + x2 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on != 0) {
                        int sx = (int)currpt[0];
                        int sy = (int)currpt[1];
                        int sz = (int)currpt[2];
                        if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                            int volidx = PAD + sz * psize + sy * dx + sx;
                            short pval = sdata[volidx];
                            if ((double)pval < ps.min) {
                                ps.min = pval;
                            }
                            if ((double)pval > ps.max) {
                                ps.max = pval;
                            }
                            if (x2 < bx1) {
                                bx1 = x2;
                            }
                            if (y2 < by1) {
                                by1 = y2;
                            }
                            if (x2 > bx2) {
                                bx2 = x2;
                            }
                            if (y2 > by2) {
                                by2 = y2;
                            }
                            ps.sum += (double)pval;
                            ps.sumSq += (double)(pval * pval);
                            ++ps.npixels;
                        }
                    }
                    JnVector3d.add(currpt, xdir, currpt);
                }
                JnVector3d.add(rowstart, ydir, rowstart);
            }
        } else if (bdata != null) {
            for (int y3 = 0; y3 < sample.height; ++y3) {
                int boffset = y3 * rowlen_bitmap;
                currpt[0] = rowstart[0];
                currpt[1] = rowstart[1];
                currpt[2] = rowstart[2];
                for (int x3 = 0; x3 < sample.width; ++x3) {
                    int bit = x3 & 7;
                    int idx = boffset + x3 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on != 0) {
                        int sx = (int)currpt[0];
                        int sy = (int)currpt[1];
                        int sz = (int)currpt[2];
                        if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                            int volidx = PAD + sz * psize + sy * dx + sx;
                            byte pval = bdata[volidx];
                            if ((double)pval < ps.min) {
                                ps.min = pval;
                            }
                            if ((double)pval > ps.max) {
                                ps.max = pval;
                            }
                            if (x3 < bx1) {
                                bx1 = x3;
                            }
                            if (y3 < by1) {
                                by1 = y3;
                            }
                            if (x3 > bx2) {
                                bx2 = x3;
                            }
                            if (y3 > by2) {
                                by2 = y3;
                            }
                            ps.sum += (double)pval;
                            ps.sumSq += (double)(pval * pval);
                            ++ps.npixels;
                        }
                    }
                    JnVector3d.add(currpt, xdir, currpt);
                }
                JnVector3d.add(rowstart, ydir, rowstart);
            }
        }
        ps.bounds.setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        ps.min = ps.min == 3.4028234663852886E38 ? 0.0 : ps.min;
        ps.max = ps.max == (double)1.4E-45f ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = rescaleSlope * ps.mean + rescaleIntercept;
        ps.max = rescaleSlope * ps.max + rescaleIntercept;
        ps.min = rescaleSlope * ps.min + rescaleIntercept;
        ps.sumSq = Jami3DRoiStatistics.square(rescaleSlope) * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * Jami3DRoiStatistics.square(rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
        return ps;
    }

    @Override
    public JnHistogram calcHistogram(Shape s2, double angle, JnHistogram hist) {
        Roi3DStatImage img = (Roi3DStatImage)this.image;
        if (img != null) {
            XjVolumeModel vm = img.getT3DRenderEngine().getVolumeModel();
            XpPixelStatistics ps = Jami3DRoiStatistics.calcPixelStatistics(this.rasterBitmap, this.rasterSlice, vm, null);
            if (this.isVolumeStatistics(img)) {
                this.computeBitmap(s2, angle);
                hist = Jami3DRoiStatistics.calcHistogram(this.rasterBitmap, ps, this.rasterSlice, vm, hist);
            } else {
                XpStatisticsRoi sr = (XpStatisticsRoi)img.getRoiActor();
                BufferedImage dbitmap = sr.getDisplayBitmap();
                if (dbitmap != null) {
                    RenderedImage rimg = img.getPixelData();
                    if (hist == null) {
                        hist = new JnHistogram(128);
                    }
                    double rescaleSlope = 1.0;
                    double rescaleIntercept = 0.0;
                    if (vm instanceof J3DVolumeModel) {
                        J3DVolumeModel jvm = (J3DVolumeModel)vm;
                        JVolume.LinearVolume jvol = jvm.j_vol;
                        rescaleIntercept = jvol.rescaleIntercept;
                        rescaleSlope = jvol.rescaleSlope;
                    }
                    int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
                    XpImageUtils.calcHistogram(rimg, ps, dbitmap, rescaleSlope, rescaleIntercept, pixelRepresentation, hist);
                }
            }
        }
        return hist;
    }

    public static void setVolumeRasterFreq(int xRasterFreq, int yRasterFreq) {
        Jami3DRoiStatistics.volumeRasterFreq[0] = xRasterFreq;
        Jami3DRoiStatistics.volumeRasterFreq[1] = yRasterFreq;
    }

    public static class Jami3DRoiStatisticsCreator
    implements RoiStatisticsCreator {
        @Override
        public RoiStatistics createRoiStatistics(XpImage img) {
            return new Jami3DRoiStatistics();
        }
    }
}

