/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.terra.tap.dm.DMCompositeBase;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.MultiFrameSupport;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dm.sessionFile.fileComposite;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DMComposite
extends DMCompositeBase
implements DMTagValueInterface {
    private DMSession session;

    public DMComposite(DMiComposite peer, DMSession s2) {
        this.peer = peer;
        this.session = s2;
    }

    public DMSession getSession() {
        return this.session;
    }

    public DMiComposite getPeer() {
        return this.peer;
    }

    @Override
    public String getType() {
        return this.peer.getType();
    }

    public String getID() {
        return this.peer.getID();
    }

    public InputStream getInputStream() {
        return this.peer.getInputStream();
    }

    @Override
    public Object getValue(DMTag t2) {
        Object o2 = this.peer.getValue(t2);
        if (o2 instanceof DMiSequence) {
            return new DMSequence((DMiSequence)o2);
        }
        return o2;
    }

    public Object getValue(int group, int element) {
        return this.getValue(new DMTag(group, element));
    }

    public Object getValue(int group, int element, String privateCID) {
        return this.getValue(new DMTag(privateCID, group, element));
    }

    public Object getValue(String tag2) {
        return Util.getValue(this, tag2);
    }

    public void getValues(DMElement[] elements) {
        this.peer.getValues(elements);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            if (!(elements[i2].value instanceof DMiSequence)) continue;
            elements[i2].value = new DMSequence((DMiSequence)elements[i2].value);
        }
    }

    public DMImage[] getImages(DMTag[] tags) {
        DMiImage[] o2 = this.peer.getImages(tags);
        if (o2 == null) {
            return new DMImage[0];
        }
        DMImage[] img = new DMImage[o2.length];
        MultiFrameSupport mfSupport = new MultiFrameSupport();
        for (int i2 = 0; i2 < o2.length; ++i2) {
            img[i2] = new DMImage(o2[i2], this.session, mfSupport);
        }
        return img;
    }

    public void setValues(DMElement[] elements) {
        this.peer.setValues(elements);
    }

    public void delete() {
        this.peer.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilePath() {
        FileOutputStream out = null;
        InputStream in = null;
        try {
            String string = this.peer.getFilePath();
            return string;
        }
        catch (UnsupportedOperationException e2) {
            System.out.println("" + this.peer.getClass().getName() + " does not implement getFilePath!");
            String[] resp = this.session.send("getPESI" + this.getID());
            if (resp != null && resp.length > 0 && resp[0] != null && resp[0].length() > 0 && new File(resp[0]).exists()) {
                String ioex = resp[0];
                return ioex;
            }
            resp = this.session.send("GetFilePath" + this.getID());
            if (resp != null && resp.length > 0 && resp[0] != null && resp[0].length() > 0 && new File(resp[0]).exists()) {
                String ioex = resp[0];
                return ioex;
            }
            if (this.peer instanceof fileComposite) {
                String ioex = ((fileComposite)this.peer).getFileName();
                return ioex;
            }
            File temp = File.createTempFile("tap", "cmp");
            temp.deleteOnExit();
            out = new FileOutputStream(temp);
            in = this.getInputStream();
            byte[] chunk = new byte[256];
            int len = in.read(chunk);
            while (len != -1) {
                out.write(chunk, 0, len);
                len = in.read(chunk);
            }
            String string = temp.getAbsolutePath();
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ioex) {}
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof DMComposite) {
            return this.getID().equals(((DMComposite)obj).getID());
        }
        return false;
    }
}

