/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.idc.XjImageFrame;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMImageBase;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.MultiFrameSupportIF;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.peerutils.Util;

public final class DMImage
extends DMImageBase
implements XjImageFrame {
    private DMSession session;
    private MultiFrameSupportIF multiFrameSupport;

    public DMImage(DMiImage peer, DMSession s2, MultiFrameSupportIF mfSupport) {
        this.peer = peer;
        this.session = s2;
        this.multiFrameSupport = mfSupport;
    }

    public Object getProperty(Object key) {
        return this.peer.getProperty(key);
    }

    public DMiImage getPeer() {
        return this.peer;
    }

    public DMComposite getComposite() {
        return new DMComposite(this.peer.getComposite(), this.session);
    }

    @Override
    public String getFilePath() {
        return this.getComposite().getFilePath();
    }

    @Override
    public int getIconWidth() {
        return this.peer.getIconWidth();
    }

    @Override
    public int getWidth() {
        return this.peer.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.peer.getIconHeight();
    }

    @Override
    public int getHeight() {
        return this.peer.getIconHeight();
    }

    @Override
    public long getPixelOffset() {
        DMElement dme = new DMElement(32736, 16);
        dme.setFillValue(false);
        this.getComposite().getValues(new DMElement[]{dme});
        return dme.getOffset();
    }

    public void preLoad() {
        this.peer.preLoad();
    }

    public void preUnload() {
        this.peer.preUnload();
    }

    public void refresh() {
        this.peer.refresh();
    }

    @Override
    public int getFrameNumber() {
        return this.peer.getFrameNumber();
    }

    @Override
    public int getNumberOfFrames() {
        return this.multiFrameSupport.getNumberOfFrames(this.peer);
    }

    @Override
    public XjDicomObjectFrame.MultiFrameType getMultiFrameType() {
        return this.multiFrameSupport.getMultiFrameType(this.peer);
    }

    public Object getValue(DMTag tag2) {
        return this.getValue(this.getFrameNumber(), tag2);
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getValue(this.getFrameNumber(), group, element);
    }

    @Override
    public Object getValue(XjTagValue tag2) {
        return this.getValue(tag2.group, tag2.element);
    }

    @Override
    public Object getValue(String tagPath) {
        return Util.getValue(this.peer, tagPath);
    }

    @Override
    public int getValues(XjTagValue[] tags) {
        return this.getValues(this.getFrameNumber(), tags);
    }

    public Object getValue(int frameNumber, DMTag tag2) {
        if (tag2.getGroup() == 0 && tag2.getElement() == 1) {
            return new Integer(this.getFrameNumber());
        }
        return this.multiFrameSupport.getValue(this.peer, frameNumber, tag2);
    }

    @Override
    public Object getValue(int frameNumber, int group, int element) {
        return this.getValue(frameNumber, new DMTag(group, element));
    }

    @Override
    public Object getValue(int frameNumber, XjTagValue tag2) {
        return this.getValue(frameNumber, tag2.group, tag2.element);
    }

    @Override
    public int getValues(int frameNumber, XjTagValue[] tags) {
        DMElement[] elements = DMElement.genDMelements(tags);
        this.peer.getComposite().getValues(elements);
        int mfCount = 0;
        for (int i2 = 0; i2 < elements.length; ++i2) {
            if (elements[i2].value instanceof DMiSequence) {
                elements[i2].value = new DMSequence((DMiSequence)elements[i2].value);
            }
            if (null != elements[i2].value || this.getNumberOfFrames() <= 1) continue;
            elements[i2].value = this.getValue(frameNumber, tags[i2].group, tags[i2].element);
            if (null == elements[i2].value) continue;
            ++mfCount;
        }
        return DMElement.getXjTagValue(elements, tags) + mfCount;
    }

    public XjTagValue[] getFrameTags() {
        return this.getFrameTags(this.getFrameNumber());
    }

    public XjTagValue[] getFrameTags(int frameNumber) {
        return this.multiFrameSupport.getFrameTags(this.peer, frameNumber);
    }
}

