/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObjectBase;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.MultiFrameSupport;
import com.ge.med.terra.tap.dm.MultiFrameSupportIF;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectExt1;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.peerutils.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class DMObject
extends DMObjectBase
implements DMTagValueInterface {
    private static final DMTag SOP_INST_UID_TAG = new DMTag(8, 24);
    public static final int LOCK_NONE = 0;
    public static final int LOCK_SOME = 1;
    public static final int LOCK_ALL = 2;
    private DMSession session;

    public DMObject(DMiObject peer, DMSession s2) {
        this.peer = peer;
        peer.attach();
        this.session = s2;
    }

    @Override
    public String getType() {
        return this.peer.getType();
    }

    public Object getValue(int group, int element) {
        return this.getValue(new DMTag(group, element));
    }

    public Object getValue(int group, int element, String privateCID) {
        return this.getValue(new DMTag(privateCID, group, element));
    }

    @Override
    public Object getValue(DMTag t2) {
        Object o2;
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getValue(" + t2 + ")");
        }
        if ((o2 = this.peer.getValue(t2)) instanceof DMiSequence) {
            return new DMSequence((DMiSequence)o2);
        }
        return o2;
    }

    public Object getValue(String tag2) {
        return Util.getValue(this, tag2);
    }

    public void getValues(DMElement[] elements) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getValues(elements)");
        }
        this.peer.getValues(elements);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            if (!(elements[i2].value instanceof DMiSequence)) continue;
            elements[i2].value = new DMSequence((DMiSequence)elements[i2].value);
        }
    }

    public DMComposite[] getComposites() {
        DMiComposite[] ci;
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getComposites()");
        }
        int len = null == (ci = this.peer.getComposites(null)) ? 0 : ci.length;
        DMComposite[] c2 = new DMComposite[len];
        for (int i2 = 0; i2 < c2.length; ++i2) {
            c2[i2] = new DMComposite(ci[i2], this.session);
        }
        return c2;
    }

    public DMObject[] getRelated(String ieType) {
        return this.getRelated(ieType, null);
    }

    public DMObject[] getRelated(String ieType, DMQuery q2) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getRelated(" + ieType + "," + q2 + ")");
        }
        DMiObject[] oi = this.peer.getRelated(ieType, q2);
        DMObject[] o2 = new DMObject[oi.length];
        for (int i2 = 0; i2 < o2.length; ++i2) {
            o2[i2] = new DMObject(oi[i2], this.session);
        }
        return o2;
    }

    @Override
    public void getRelated(String ieType, DMQuery q2, final DMObjectReceiver cb) {
        this.peer.getRelated(ieType, q2, new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o2) {
                return cb.gotOne(new DMObject(o2, DMObject.this.session));
            }
        });
    }

    public int getNumberOfRelated(String ieType) {
        return this.peer.getNumberOfRelated(ieType, null);
    }

    public DMiObject getPeer() {
        return this.peer;
    }

    public void delete() {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.fine("delete()");
        }
        this.peer.delete();
    }

    protected void finalize() throws Throwable {
        this.peer.detach();
        super.finalize();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DMObject) {
            return this.getID().equals(((DMObject)obj).getID());
        }
        return false;
    }

    public void setValues(DMElement[] elements) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("setValues(elements)");
        }
        this.peer.setValues(elements);
    }

    public String getID() {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getID()");
        }
        return this.peer.getID();
    }

    public DMImage[] getImages(DMTag[] tags) {
        DMiImage[] o2;
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getImages(tags)");
        }
        int len = null == (o2 = this.peer.getImages(tags)) ? 0 : o2.length;
        DMImage[] imgs = new DMImage[len];
        HashMap<String, MultiFrameSupport> instanceMap = new HashMap<String, MultiFrameSupport>();
        for (int i2 = 0; i2 < imgs.length; ++i2) {
            MultiFrameSupportIF mfSupport;
            String sopUID = (String)o2[i2].getValue(SOP_INST_UID_TAG);
            if (instanceMap.containsKey(sopUID)) {
                mfSupport = (MultiFrameSupportIF)instanceMap.get(sopUID);
            } else {
                mfSupport = new MultiFrameSupport();
                instanceMap.put(sopUID, (MultiFrameSupport)mfSupport);
            }
            imgs[i2] = new DMImage(o2[i2], this.session, mfSupport);
        }
        return imgs;
    }

    public DMSession getSession() {
        return this.session;
    }

    public String toString() {
        int level = 0;
        if (this.getType().equalsIgnoreCase("patient")) {
            level = 1;
        } else if (this.getType().equalsIgnoreCase("study")) {
            level = 2;
        } else if (this.getType().equalsIgnoreCase("series")) {
            level = 3;
        } else if (this.getType().equalsIgnoreCase("image")) {
            level = 4;
        }
        switch (level) {
            case 1: {
                Object pname = this.getValue(16, 16);
                return "" + (pname != null ? pname : "Empty");
            }
            case 2: {
                Object v2 = this.getValue(32, 16);
                return "Ex: " + (v2 != null ? v2 : "Empty");
            }
            case 3: {
                Object snum = this.getValue(32, 17);
                return "Se: " + (snum != null ? snum : "Empty");
            }
            case 4: {
                Object inum = this.getValue(32, 19);
                return "Im: " + (inum != null ? inum : "Empty");
            }
        }
        return "DMObject with unknown level";
    }

    public void setLock(int lockType) {
        this.peer.setLock(lockType);
    }

    public int getLock() {
        return this.peer.getLock();
    }

    public DMAuxObject getAuxObject(String type, Properties info) {
        DMAuxObject obj = null;
        if (this.peer instanceof DMiObjectExt1) {
            obj = ((DMiObjectExt1)this.peer).getAuxObject(type, info);
        }
        if (null == obj) {
            obj = new IconAuxObject(type, info);
        }
        return obj;
    }

    public Object send(String[] str) {
        Object obj = null;
        if (this.peer instanceof DMiObjectExt1) {
            obj = ((DMiObjectExt1)this.peer).send(str);
        }
        return obj;
    }

    protected class IconAuxObject
    extends DMObjectBase.IconAuxObjectBase
    implements DMAuxObject {
        String type;
        Properties info;
        DMObjectBase.IconConverter ic;

        public IconAuxObject(String type, Properties info) {
            super(DMObject.this, type, info);
            this.ic = new DMObjectBase.IconConverter();
            this.type = type;
            this.info = info;
        }

        @Override
        public Class getConverterClass() {
            return DMObjectBase.IconConverter.class;
        }

        @Override
        public String getFileName() {
            File f2;
            try {
                f2 = File.createTempFile(this.type, ".jpg");
            }
            catch (IOException e2) {
                throw new DMException(e2);
            }
            this.ic.writeFileFromObject(this.getObject(), f2.getAbsolutePath());
            f2.deleteOnExit();
            return f2.getAbsolutePath();
        }

        @Override
        public InputStream getInputStream() {
            return this.ic.getStreamFromObject(this.getObject());
        }

        @Override
        public Object getObject() {
            String[] a2 = this.type.split("\\D+");
            return this.computeIconImage(Integer.parseInt(a2[1]), Integer.parseInt(a2[2]), this.info);
        }

        @Override
        public Properties getProperties() {
            return this.info;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public void putFile(String path) {
            throw new UnsupportedOperationException("Save Unsupported");
        }
    }
}

