/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.PrintService;
import javax.swing.JPanel;

public abstract class DMSystem {
    static LinkedList factory = new LinkedList();

    public static void removeSystem(DMSystem cl) {
        factory.iterator();
        registeredSystem togo = null;
        for (registeredSystem sys : factory) {
            if (sys.dmsystem != cl) continue;
            togo = sys;
        }
        if (togo != null) {
            factory.remove(togo);
        }
    }

    public static void removeSystem(String name) {
        factory.iterator();
        registeredSystem togo = null;
        for (registeredSystem sys : factory) {
            if (!sys.systemName.equals(name)) continue;
            togo = sys;
        }
        if (togo != null) {
            factory.remove(togo);
        }
    }

    public static void insertSystem(String name, DMSystem cl) {
        DMSystem.removeSystem(name);
        factory.addFirst(new registeredSystem(name, cl));
    }

    public static void insertSystem(String name, String className) {
        try {
            Class<?> c2 = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            DMSystem.insertSystem(name, (DMSystem)c2.newInstance());
        }
        catch (Throwable ex) {
            Tap.log.log(Level.WARNING, "Failed to install DMSystem: name=" + name + ", className=" + className + ", ", ex);
        }
    }

    protected static boolean isIOS() {
        String terraDir;
        File file;
        boolean isIOS = false;
        String userHome = System.getProperty("user.home");
        if (userHome != null && (file = new File(terraDir = userHome + File.separator + "terra")).exists() && file.isDirectory()) {
            isIOS = true;
        }
        return isIOS;
    }

    public static DMSystem getDMSystem(String system) {
        try {
            registeredSystem rsys;
            Object dmsys = null;
            Iterator it = factory.iterator();
            if (system != null) {
                while (it.hasNext()) {
                    rsys = (registeredSystem)it.next();
                    System.out.println("check system = " + rsys.systemName);
                    if (!rsys.systemName.equals(system)) continue;
                    dmsys = rsys.dmsystem;
                    break;
                }
            } else {
                while (it.hasNext()) {
                    rsys = (registeredSystem)it.next();
                    System.out.print("tested system = " + rsys.systemName + " ... ");
                    if (rsys.dmsystem.isSupportedSystem()) {
                        System.out.println(" supported");
                        dmsys = rsys.dmsystem;
                        break;
                    }
                    System.out.println(" not supported");
                }
            }
            if (dmsys != null) {
                try {
                    Method m2 = dmsys.getClass().getMethod("getSystem", new Class[0]);
                    System.out.println(" invoking = " + ((DMSystem)dmsys).getSystemName());
                    return (DMSystem)m2.invoke(dmsys, new Object[0]);
                }
                catch (Exception ex) {
                    System.out.println(" no getSystem() method");
                    return (DMSystem)dmsys.getClass().newInstance();
                }
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error: Unable to find DMSystem", ex);
        }
        throw new RuntimeException("Error: Unable to find system" + (null == system ? "" : " \"" + system + "\""));
    }

    public abstract boolean isSupportedSystem();

    public abstract void init(String var1, Properties var2, String[] var3);

    public abstract DMObject[] getSelection();

    public abstract void setSelection(DMObject[] var1);

    public abstract DMObject getNextInBrowser(DMObject var1, boolean var2);

    public abstract String getSystemName();

    public abstract String send(String var1);

    public abstract int spaceReserve(long var1);

    public abstract void spaceRelease(int var1);

    public abstract DMSession getLocalDB();

    public abstract void setRepresentativeDMObjet(DMObject var1);

    public abstract DMObject getRepresentativeDMObjet();

    public abstract PrintService getPrintService();

    public abstract void setControlAndDisplayAreaBounds(JPanel var1, JPanel[] var2);

    public abstract void installWatchDog(int var1);

    public abstract Properties getDMSystemProperties();

    public abstract void positionSplashScreen(Component var1);

    public String[] getConfigured(String nodeType) {
        return null;
    }

    public DMSession getSystemSession(String nodeType, String nodeName) {
        return null;
    }

    public void exit(int status) {
        System.exit(status);
    }

    static {
        if (Tap.getProperty("tap.dm.system.install", "true").equalsIgnoreCase("true")) {
            DMSystem.insertSystem("default", "com.ge.med.terra.tap.dm.peerutils.DefaultSystem");
            DMSystem.insertSystem("ios", "com.ge.med.xjplugins.tap.dm.iosSystem.IOSSystem");
            DMSystem.insertSystem("aw", "com.ge.med.xjplugins.tap.dm.awSystem.AWSystem");
        }
    }

    private static class registeredSystem {
        public String systemName;
        public DMSystem dmsystem;

        public registeredSystem(String systemName, DMSystem dmsystem) {
            this.systemName = systemName;
            this.dmsystem = dmsystem;
        }
    }
}

