/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.dicomdir.Dicomdir;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirComposite;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryEntityLevel;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecord;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;

public class DicomdirObject
implements DMiObject,
DMTagValueInterface {
    private long offset = -1L;
    private String level;
    private DicomdirComposite repComposite = null;
    private Dicomdir dicomdir = null;

    public DicomdirObject(String deLevel, Dicomdir dicomdir, long offset) {
        if (deLevel == null) {
            throw new DMException("Directory Entity Level cannot be null.");
        }
        this.level = deLevel.trim().toUpperCase(Locale.ENGLISH);
        this.dicomdir = dicomdir;
        this.offset = offset;
    }

    @Override
    public String getID() {
        return Long.toString(this.offset);
    }

    @Override
    public String getType() {
        return this.level;
    }

    @Override
    public Object getValue(DMTag t2) {
        return this.getRepComposite().getValue(t2);
    }

    @Override
    public void getValues(DMElement[] elements) {
        this.getRepComposite().getValues(elements);
    }

    @Override
    public void setValues(DMElement[] elements) {
        if (this.dicomdir.isReadOnly()) {
            throw new RuntimeException("Can't update: READ-ONLY Media");
        }
        throw new UnsupportedOperationException("Method setValues() is unsupported.");
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        DirectoryRecord thisDR = this.dicomdir.getDirectoryRecord(this.level, this.offset);
        DirectoryRecord[] drs = this.dicomdir.getAllCompositeDirectoryRecords(thisDR);
        ArrayList<DicomdirComposite> compList = new ArrayList<DicomdirComposite>(drs.length);
        for (int i2 = 0; i2 < drs.length; ++i2) {
            DicomdirObject obj = new DicomdirObject(drs[i2].level, this.dicomdir, drs[i2].myOffset);
            if (q2 != null && !q2.valid(obj)) continue;
            compList.add(new DicomdirComposite(new File(drs[i2].getRefFileIDPath()), this.dicomdir));
        }
        if (compList.size() > 0) {
            this.repComposite = (DicomdirComposite)compList.get(0);
        }
        return compList.toArray(new DMiComposite[compList.size()]);
    }

    @Override
    public int getNumberOfComposites(DMQuery q2) {
        return this.getComposites(q2).length;
    }

    public DicomdirComposite getRepComposite() {
        File fl;
        if (null != this.repComposite && (fl = new File(this.repComposite.getFilePath())).exists()) {
            return this.repComposite;
        }
        DirectoryRecord thisDR = this.dicomdir.getDirectoryRecord(this.level, this.offset);
        String compositePath = thisDR.getRefFileIDPath();
        if (null != compositePath) {
            this.repComposite = new DicomdirComposite(new File(compositePath), this.dicomdir);
        } else {
            thisDR = this.dicomdir.getAllCompositeDirectoryRecords(thisDR)[0];
            this.repComposite = new DicomdirComposite(new File(thisDR.getRefFileIDPath()), this.dicomdir);
        }
        Set<tagValue> tvs = thisDR.tvs;
        for (tagValue tv : tvs) {
            if (tv.group == 4) continue;
            this.repComposite.elemCache.put(new DMTag(tv.group, tv.element), tv);
        }
        return this.repComposite;
    }

    @Override
    public DMTag[] getTags() {
        return this.getRepComposite().getTags();
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>(comp.length);
        for (int i2 = 0; i2 < comp.length; ++i2) {
            BufferedImage[] imgs = comp[i2].getPixelData(tags);
            for (int k2 = 0; k2 < imgs.length; ++k2) {
                list.add(imgs[k2]);
            }
        }
        return list.toArray(new BufferedImage[list.size()]);
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<DMiImage> al2 = new ArrayList<DMiImage>(comp.length);
        for (int i2 = 0; i2 < comp.length; ++i2) {
            DMiImage[] imgs = comp[i2].getImages(tags);
            for (int k2 = 0; k2 < imgs.length; ++k2) {
                al2.add(imgs[k2]);
            }
        }
        fileImageManager.getInstance().setPause(false);
        return al2.toArray(new DMiImage[al2.size()]);
    }

    @Override
    public DMiObject[] getRelated(String deLevel, DMQuery q2) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(deLevel, q2, rcvr);
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String deLevel, DMQuery q2, DMiObjectReceiver cb) {
        String deLevelName;
        int queryLevel;
        int myLevel = DirectoryEntityLevel.getIndex(this.level);
        if (myLevel == (queryLevel = DirectoryEntityLevel.getIndex(deLevelName = deLevel.trim().toUpperCase(Locale.ENGLISH)))) {
            if ((q2 == null || q2.valid(this)) && !cb.gotOne(this)) {
                return;
            }
        } else if (queryLevel > myLevel) {
            DirectoryRecord dr = this.dicomdir.getDirectoryRecord(this.level, this.offset);
            DirectoryRecord[] drs = this.dicomdir.getChildDirectoryRecords(dr, deLevelName);
            for (int i2 = 0; i2 < drs.length; ++i2) {
                DicomdirObject obj = new DicomdirObject(deLevelName, this.dicomdir, drs[i2].myOffset);
                if (q2 != null && !q2.valid(obj) || cb.gotOne(obj)) continue;
                return;
            }
        } else {
            DirectoryRecord dr = this.dicomdir.getDirectoryRecord(this.level, this.offset);
            DirectoryRecord parentDR = this.dicomdir.getParentDirectoryRecord(dr, deLevelName);
            if (null == parentDR) {
                return;
            }
            DicomdirObject obj = new DicomdirObject(deLevelName, this.dicomdir, parentDR.myOffset);
            if ((q2 == null || q2.valid(obj)) && !cb.gotOne(obj)) {
                return;
            }
        }
    }

    @Override
    public int getNumberOfRelated(String deLevel, DMQuery q2) {
        return this.getRelated(deLevel, q2).length;
    }

    @Override
    public void delete() {
        if (this.dicomdir.isReadOnly()) {
            throw new RuntimeException("Can't Delete: READ-ONLY Media");
        }
        DirectoryRecord dr = this.dicomdir.getDirectoryRecord(this.level, this.offset);
        if ("PATIENT".equalsIgnoreCase(dr.level)) {
            this.dicomdir.deletePatient(dr);
            return;
        }
        DirectoryRecord parentDR = this.getParentDirectoryRecord(dr);
        if (dr.nextSibling > 0L) {
            if (parentDR != null) {
                int i2;
                DirectoryRecord[] childDRs = this.dicomdir.getChildDirectoryRecords(parentDR);
                boolean found = false;
                for (i2 = 0; i2 < childDRs.length; ++i2) {
                    if (childDRs[i2].nextSibling != this.offset) continue;
                    found = true;
                    break;
                }
                if (found) {
                    childDRs[i2].nextSibling = dr.nextSibling;
                    childDRs[i2].writeNextSiblingToDICOMDIR();
                    this.dicomdir.deletePhysicalFiles(dr);
                    return;
                }
                if (parentDR.firstChild == dr.myOffset) {
                    parentDR.firstChild = dr.nextSibling;
                    parentDR.writeChildToDICOMDIR();
                }
                this.dicomdir.deletePhysicalFiles(dr);
                return;
            }
        } else if (parentDR != null) {
            int i3;
            DirectoryRecord[] childDRs = this.dicomdir.getChildDirectoryRecords(parentDR);
            boolean found = false;
            for (i3 = 0; i3 < childDRs.length; ++i3) {
                if (childDRs[i3].myOffset != this.offset && childDRs[i3].nextSibling != this.offset) continue;
                found = true;
                break;
            }
            if (found) {
                childDRs[i3].nextSibling = 0L;
                childDRs[i3].writeNextSiblingToDICOMDIR();
                this.dicomdir.deletePhysicalFiles(dr);
            }
            if (childDRs.length == 1) {
                new DicomdirObject(parentDR.level, this.dicomdir, parentDR.myOffset).delete();
            }
        }
    }

    private DirectoryRecord getParentDirectoryRecord(DirectoryRecord child) {
        if ("PATIENT".equalsIgnoreCase(child.level)) {
            return null;
        }
        if ("STUDY".equalsIgnoreCase(child.level)) {
            return this.dicomdir.getParentDirectoryRecord(child, "PATIENT");
        }
        if ("SERIES".equalsIgnoreCase(child.level)) {
            return this.dicomdir.getParentDirectoryRecord(child, "STUDY");
        }
        if ("IMAGE".equalsIgnoreCase(child.level)) {
            return this.dicomdir.getParentDirectoryRecord(child, "SERIES");
        }
        return null;
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method setLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    public String toString() {
        String str = "[id=" + this.getID() + ", type=" + this.getType() + "]";
        return str;
    }
}

