/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.codec.Compression;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.dicomdir.Dicomdir;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirComposite;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirCompositeWriter;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirObject;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecord;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class DicomdirSession
implements DMiSession {
    private static final int BUFFER = 8192;
    private Dicomdir dicomdir;
    private Properties sessionProps = new Properties();
    private File dicomMountDir;
    private String cdWritePath = null;
    private ArrayList[] listenerList = new ArrayList[10];
    private DicomdirCompositeWriter compWriter;

    @Override
    public void init(String pathToFile, String[] args) {
        if (args != null && args.length > 0 && args[0].indexOf("=") != -1) {
            this.parseNamedParams(args);
        }
        this.dicomdir = new Dicomdir(pathToFile, this.sessionProps);
        this.dicomMountDir = new File(this.dicomdir.getMountFilePath());
        this.compWriter = new DicomdirCompositeWriter(this.dicomdir);
    }

    private void parseNamedParams(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            String param = args[i2];
            int ind = param.indexOf("=");
            if (ind == -1) {
                throw new IllegalArgumentException("Wrong parameter syntax: " + param);
            }
            String pname = param.substring(0, ind);
            String pvalue = param.substring(ind + 1);
            this.sessionProps.setProperty(pname, pvalue);
        }
    }

    public Dicomdir getDicomdir() {
        return this.dicomdir;
    }

    @Override
    public DMiObject[] getChildren(DMQuery q2) {
        return this.getRelated("PATIENT", q2);
    }

    @Override
    public void getChildren(DMQuery q2, DMiObjectReceiver cb) {
        this.getRelated("PATIENT", q2, cb);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q2) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q2, rcvr);
        return list.toArray(new DMiObject[0]);
    }

    @Override
    public void getRelated(String ieType, DMQuery q2, DMiObjectReceiver cb) {
        List<DirectoryRecord> drs = this.dicomdir.getDirectoryRecords(ieType);
        for (int i2 = 0; i2 < drs.size(); ++i2) {
            DicomdirObject obj = new DicomdirObject(ieType, this.dicomdir, drs.get((int)i2).myOffset);
            if (q2 != null && !q2.valid(obj) || cb.gotOne(obj)) continue;
            return;
        }
    }

    @Override
    public DMiComposite getComposite(String id) {
        File f2 = new File(id);
        if (f2.exists() && !f2.isDirectory()) {
            return new DicomdirComposite(f2, this.dicomdir);
        }
        return null;
    }

    @Override
    public DMiComposite[] getComposites() {
        List<DirectoryRecord> rootDRs = this.dicomdir.getDirectoryRecords("PATIENT");
        ArrayList<DirectoryRecord> compositeDRs = new ArrayList<DirectoryRecord>();
        for (DirectoryRecord dr : rootDRs) {
            compositeDRs.addAll(Arrays.asList(this.dicomdir.getAllCompositeDirectoryRecords(dr)));
        }
        DMiComposite[] compList = new DMiComposite[compositeDRs.size()];
        for (int i2 = 0; i2 < compList.length; ++i2) {
            compList[i2] = new DicomdirComposite(new File(((DirectoryRecord)compositeDRs.get(i2)).getRefFileIDPath()), this.dicomdir);
        }
        return compList;
    }

    @Override
    public int getNumberOfComposites() {
        return this.getComposites().length;
    }

    @Override
    public void save(DMiObject[] dmos, Hashtable prop) {
        for (int i2 = 0; i2 < dmos.length; ++i2) {
            this.save(dmos[i2], prop);
        }
    }

    @Override
    public void save(DMiObject dmo, Hashtable prop) {
        DMiComposite[] comps = dmo.getComposites(null);
        for (int i2 = 0; i2 < comps.length; ++i2) {
            this.save(comps[i2], prop);
        }
    }

    @Override
    public void save(DMiComposite comp, Hashtable prop) {
        Tap.log.log(Level.INFO, "Installing: " + comp.getFilePath());
        File[] toInstall = new File[]{new File(comp.getFilePath())};
        try {
            this.installFiles(toInstall, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void install(InputStream is) throws IOException {
        if (this.dicomdir.isReadOnly()) {
            throw new IllegalStateException("Can't install: READ-ONLY MEDIA");
        }
        File destFile = File.createTempFile("comp", ".dcm");
        destFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(destFile);
        int len = 1;
        byte[] bbuff = new byte[32768];
        while (len != -1) {
            len = is.read(bbuff);
            if (len <= 0) continue;
            fos.write(bbuff, 0, len);
        }
        fos.close();
        is.close();
        this.installFiles(new File[]{destFile}, true);
    }

    private void compressImage(File srcFile, File destFile) throws FileNotFoundException {
        this.compressImage(new FileInputStream(srcFile), new FileOutputStream(destFile));
    }

    private void compressImage(InputStream is, FileOutputStream fos) {
        DicomObject dcm = new DicomObject();
        try {
            dcm.read(is);
            Compression compressedDicom = new Compression(dcm);
            if (this.dicomdir.getEncoding().equalsIgnoreCase("JPEGLossLess")) {
                compressedDicom.compress(8197);
            }
            compressedDicom.getDicomObject().write(fos, true);
        }
        catch (Exception ex) {
            try {
                dcm.write(fos, true);
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
    }

    public void sendEvent(int eventType, String msg, Object source) {
        this.fireEvent(new DMEvent(eventType, msg, source));
    }

    public void fireEvent(DMEvent event) {
        try {
            if (this.listenerList[event.getID()] == null) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
        Iterator i2 = this.listenerList[event.getID()].iterator();
        while (i2.hasNext()) {
            ((DMEventListener)i2.next()).actionPerformed(event);
        }
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (this.listenerList[eventType] == null) {
            this.listenerList[eventType] = new ArrayList();
        }
        this.listenerList[eventType].add(listener);
    }

    @Override
    public void removeDMEventListener(DMEventListener l2) {
        if (this.listenerList != null) {
            for (int i2 = 0; i2 < this.listenerList.length; ++i2) {
                if (this.listenerList[i2] == null) continue;
                this.listenerList[i2].remove(l2);
            }
        }
    }

    @Override
    public String[] send(String str) {
        if (str.equalsIgnoreCase("endWrite")) {
            this.close();
        } else if (str.startsWith("Encoding")) {
            String encoding = this.processValue(str);
            this.dicomdir.setEncoding(encoding);
        } else if (str.startsWith("path")) {
            this.cdWritePath = this.processValue(str);
        } else if (str.startsWith("makeCD")) {
            try {
                String[] devs;
                int position = this.dicomdir.getBufferPosition();
                this.close();
                String iso = "archive.iso";
                String mkisofsCmd = "mkisofs -R -o " + iso + "  " + this.dicomMountDir;
                String cdrecordCmd = "cdrecord dev=1,0,0 ";
                File isoFile = new File(iso);
                if (isoFile.exists()) {
                    isoFile.delete();
                }
                if ((devs = DicomdirSession.getCdRom(this.cdWritePath)) == null || devs.length == 0) {
                    this.dicomdir.reMapFile(position);
                    throw new IllegalStateException("No CD-ROM drive found");
                }
                if (System.getProperty("os.name").startsWith("Windows")) {
                    if (this.cdWritePath == null) {
                        mkisofsCmd = "mkisofs -R -o " + iso + "  " + this.dicomMountDir;
                        cdrecordCmd = "cmd.exe /c start cdrecord ";
                    } else {
                        mkisofsCmd = this.cdWritePath + "\\mkisofs -R -o " + iso + "  " + this.dicomMountDir;
                        cdrecordCmd = "cmd.exe /c start " + this.cdWritePath + "\\cdrecord ";
                    }
                    cdrecordCmd = cdrecordCmd + "dev=" + devs[0] + " ";
                } else {
                    cdrecordCmd = "cdrecord dev=" + devs[0] + " ";
                }
                Process process = Runtime.getRuntime().exec(mkisofsCmd);
                int t2 = process.waitFor();
                t2 = process.exitValue();
                Tap.log.log(Level.INFO, "makeCD: exitValue = {0}" + process.exitValue());
                if (t2 == 0) {
                    process = Runtime.getRuntime().exec(cdrecordCmd + iso);
                    t2 = process.waitFor();
                    t2 = process.exitValue();
                    if (Tap.logLevel >= Tap.LEVEL_FINE) {
                        Tap.log.fine("exitValue===" + process.exitValue());
                        Tap.log.fine("position===" + position);
                    }
                }
                this.dicomdir.reMapFile(position);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private String processValue(String str) {
        int index = str.indexOf(61);
        if (index >= 0) {
            return str.substring(index + 1, str.length());
        }
        return null;
    }

    public static String[] getCdRom(String path) {
        ArrayList<String> al2 = new ArrayList<String>(3);
        try {
            String str;
            String scanBus = null;
            scanBus = System.getProperty("os.name").startsWith("Windows") ? (path == null ? "cdrecord -scanbus" : path + "\\cdrecord -scanbus") : "cdrecord -scanbus";
            Process p2 = Runtime.getRuntime().exec(scanBus);
            DicomdirSession.devnull(p2.getErrorStream());
            LineNumberReader l2 = new LineNumberReader(new InputStreamReader(p2.getInputStream()));
            while ((str = l2.readLine()) != null) {
                if (str.indexOf("Removable CD-ROM") <= 1) continue;
                StringTokenizer st = new StringTokenizer(str);
                al2.add(st.nextToken());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return al2.toArray(new String[al2.size()]);
    }

    public static void devnull(final InputStream is) {
        Thread t2 = new Thread(){

            @Override
            public void run() {
                byte[] buff = new byte[2000];
                try {
                    int len;
                    while ((len = is.read(buff)) >= 0) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t2.setDaemon(true);
        t2.setName("devnull");
        t2.start();
    }

    @Override
    public void close() {
        this.dicomdir.close();
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        if (this.dicomdir.isReadOnly()) {
            throw new IllegalStateException("Can't install: READ-ONLY MEDIA");
        }
        long start = System.currentTimeMillis();
        for (int i2 = 0; i2 < files.length; ++i2) {
            Tap.log.log(Level.INFO, "Installing [{0}]", files[i2].getAbsolutePath());
            this.compWriter.updateDicomdir(files[i2]);
            if (this.compWriter.isAlreadyExists()) continue;
            File destFile = new File(this.compWriter.getRefFileIDPath());
            File fDir = destFile.getParentFile();
            if (!fDir.exists()) {
                fDir.mkdirs();
            }
            if (this.dicomdir.getEncoding().equalsIgnoreCase("JPEGLossless")) {
                this.compressImage(files[i2], destFile);
            } else {
                this.copyFileNIO(files[i2], destFile);
            }
            this.sendEvent(1, "composite added", destFile.getAbsolutePath());
        }
        long timeExec = System.currentTimeMillis() - start;
        Tap.log.log(Level.FINE, "Total time taken for Installing: " + files.length + "  Files in millisecs : " + timeExec);
        if (destroy) {
            for (File f2 : files) {
                f2.delete();
            }
        }
    }

    @Override
    public DMiObject getDMiObject(String ieType, String offset) {
        DirectoryRecord dr = this.dicomdir.readDirectoryRecord(Long.parseLong(offset), null);
        if (null != dr && ieType.equalsIgnoreCase(dr.level)) {
            return new DicomdirObject(ieType, this.dicomdir, Integer.parseInt(offset));
        }
        return null;
    }

    @Override
    public DMiJob asynSend(String str) {
        throw new UnsupportedOperationException("Method asynSend() not yet implemented.");
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Method getJobs() not yet implemented.");
    }

    @Override
    public void ClearCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileNIO(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = new FileInputStream(sourceFile).getChannel();
        FileChannel dest = new FileOutputStream(destFile).getChannel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
        try {
            while (source.read(buffer) != -1) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    dest.write(buffer);
                }
                buffer.clear();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            DicomdirSession.closeOpenStream(source);
            DicomdirSession.closeOpenStream(dest);
        }
    }

    private static void closeOpenStream(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }
}

