/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dmtest;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import java.util.Vector;

public class FindDuplicateId {
    DMSession ses = null;
    DMObject[] comps = null;

    public FindDuplicateId(String[] args) {
        this.ses = new DMSession(args);
        this.comps = this.ses.getRelated("image");
    }

    private String getCompName(int i2) {
        return this.ses.send("GetFilePath" + this.comps[i2 / 3].getID())[1];
    }

    public void printChildren(DMObject obj, int indent) {
        if (obj.getType().equalsIgnoreCase("patient")) {
            DMObject[] kids = obj.getRelated("study");
            System.out.println("");
            System.out.println("+Patient" + indent + ": " + obj.getValue(16, 16));
            for (int i2 = 0; i2 < kids.length; ++i2) {
                this.printChildren(kids[i2], i2);
            }
        } else if (obj.getType().equalsIgnoreCase("study")) {
            DMObject[] kids = obj.getRelated("series");
            System.out.println("\t+Study" + indent + ": " + obj.getValue(32, 13));
            for (int i3 = 0; i3 < kids.length; ++i3) {
                this.printChildren(kids[i3], i3);
            }
        } else if (obj.getType().equalsIgnoreCase("series")) {
            DMObject[] kids = obj.getRelated("image");
            System.out.println("\t\t+Series" + indent + ": " + obj.getValue(32, 14));
            for (int i4 = 0; i4 < kids.length; ++i4) {
                this.printChildren(kids[i4], i4);
            }
        } else if (obj.getType().equalsIgnoreCase("image")) {
            System.out.println("\t\t\t+Image" + indent + ": " + obj.getValue(8, 24));
        }
    }

    public void reportContent() {
        DMObject[] pats = this.ses.getChildren();
        System.out.println("# patients= " + pats.length);
        for (int i2 = 0; i2 < pats.length; ++i2) {
            this.printChildren(pats[i2], i2);
        }
    }

    private String getTagName(int i2) {
        String tagName = "UNKNOWN";
        switch (i2 % 3) {
            case 0: {
                tagName = "SOP UID";
                break;
            }
            case 1: {
                tagName = "Series UID";
                break;
            }
            case 2: {
                tagName = "Study UID";
            }
        }
        return tagName;
    }

    public void reportDuplicateIds() {
        int i2;
        String[] ids = new String[this.comps.length * 3];
        for (i2 = 0; i2 < this.comps.length; ++i2) {
            ids[3 * i2] = (String)this.comps[i2].getValue(8, 24);
            ids[3 * i2 + 1] = (String)this.comps[i2].getValue(32, 14);
            ids[3 * i2 + 2] = (String)this.comps[i2].getValue(32, 13);
        }
        for (i2 = 0; i2 < ids.length; ++i2) {
            if (ids[i2] != null) continue;
            System.out.println(this.getCompName(i2) + " missing " + this.getTagName(i2));
            ids[i2] = "";
        }
        Vector dups = FindDuplicateId.findDuplicates(ids);
        for (int i3 = 0; i3 < dups.size(); ++i3) {
            Vector v2 = (Vector)dups.get(i3);
            System.out.println("\n" + this.getCompName((Integer)v2.get(0)) + " " + this.getTagName((Integer)v2.get(0)) + " same as ");
            for (int j2 = 1; j2 < v2.size(); ++j2) {
                System.out.println("" + this.getCompName((Integer)v2.get(j2)) + " " + this.getTagName((Integer)v2.get(j2)));
            }
        }
    }

    public static Vector findDuplicates(String[] str) {
        Vector v2 = new Vector();
        for (int i2 = 0; i2 < str.length - 1; ++i2) {
            for (int j2 = i2 + 1; j2 < str.length; ++j2) {
                Vector<Integer> dups = new Vector<Integer>();
                dups.add(new Integer(i2));
                boolean foundOne = false;
                if (str[i2].trim().equalsIgnoreCase(str[j2].trim())) {
                    dups.add(new Integer(j2));
                    foundOne = true;
                }
                if (!foundOne) continue;
                v2.add(dups);
            }
        }
        return v2;
    }

    public static void usage() {
        System.out.println("Usage: com.ge.med.terra.tap.dm.dmtest.FindDuplicateId [-showContent] <session args>");
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-showContent")) {
            String[] _args = new String[args.length - 1];
            for (int i2 = 1; i2 < args.length; ++i2) {
                _args[i2 - 1] = args[i2];
            }
            FindDuplicateId fd = new FindDuplicateId(_args);
            fd.reportContent();
        } else if (args.length > 2) {
            FindDuplicateId fd = new FindDuplicateId(args);
            fd.reportDuplicateIds();
        } else {
            FindDuplicateId.usage();
        }
    }
}

