/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dmtest;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.ImageCreator;

public class MemoryCheck {
    ImageCreator ic = null;
    DMSession session = new DMSession(new String[]{"terra", "terradb", "localhost"});
    DMTag[] ptTags = new DMTag[]{new DMTag(16, 32), new DMTag(8, 32), new DMTag(16, 16), new DMTag(9, 4123), new DMTag(9, 4115), new DMTag(9, 4116)};

    public MemoryCheck() {
        try {
            this.ic = new ImageCreator();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.session.addDMEventListener(1, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent event) {
                MemoryCheck.this.installHandler();
            }
        });
        this.session.addDMEventListener(2, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent event) {
                MemoryCheck.this.generalHandler();
            }
        });
    }

    public void installHandler() {
        this.doPatientTableQuery();
    }

    public void generalHandler() {
    }

    public void collect() {
        System.gc();
        SimpleUtilities.sleep(1000L);
        System.gc();
        SimpleUtilities.sleep(1000L);
        System.out.println("Hopefully forced garbage collection!");
        SimpleUtilities.sleep(5000L);
    }

    public void installTest() throws Exception {
        for (int i2 = 1; i2 <= 100; ++i2) {
            this.ic.install(1, 4, 1, 2, this.session);
            SimpleUtilities.sleep(50L);
            if (i2 % 10 != 0) continue;
            System.out.println("# of patients installed= " + i2);
            this.collect();
        }
    }

    public void doPatientTableQuery() {
        DMObject[] studies = this.session.getRelated("study");
        int i2 = 0;
        for (i2 = 0; i2 < studies.length && i2 < 20; ++i2) {
            for (int j2 = 0; j2 < this.ptTags.length; ++j2) {
                Object value = studies[i2].getValue(this.ptTags[j2]);
            }
        }
        System.out.println("read " + this.ptTags.length + " tags from " + i2 + " studies");
    }

    public void deleteAll() {
        DMObject[] pats = this.session.getChildren();
        for (int i2 = 0; i2 < pats.length; ++i2) {
            pats[i2].delete();
        }
    }

    public static void main(String[] args) {
        try {
            MemoryCheck mt = new MemoryCheck();
            mt.deleteAll();
            mt.installTest();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

