/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mem;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.mem.Mem;
import com.ge.med.terra.tap.dm.mem.MemComposite;
import com.ge.med.terra.tap.dm.mem.MemSession;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.util.dicom.TagValueList;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class MemObject
extends Mem
implements DMiObject,
DMTagValueInterface {
    MemSession ses;
    int level;
    Vector compVec = new Vector();
    Hashtable childTable = new Hashtable();
    MemComposite refComp;

    public MemObject(MemSession ses, int level, MemComposite comp, tagValue[] keyTags) {
        this.ses = ses;
        this.level = level;
        this.compVec.add(comp);
        if (level < 3) {
            this.addComposite(comp, keyTags);
        }
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    public void addComposite(MemComposite comp, tagValue[] keyTags) {
        TagValueList tvl = MemObject.buildTVList(MemObject.extractTagsGivenLevel(this.level + 1, keyTags));
        MemObject o2 = (MemObject)this.childTable.get(tvl);
        if (o2 == null) {
            this.childTable.put(tvl, new MemObject(this.ses, this.level + 1, comp, keyTags));
        } else {
            o2.addComposite(comp, keyTags);
        }
    }

    private DMiObject[] getChildren(DMQuery q2) {
        Iterator iter = this.childTable.values().iterator();
        ArrayList<MemObject> a2 = new ArrayList<MemObject>();
        while (iter.hasNext()) {
            MemObject item = (MemObject)iter.next();
            if (q2 != null && !q2.valid(item)) continue;
            a2.add(item);
        }
        return a2.toArray(new DMiObject[a2.size()]);
    }

    @Override
    public String getType() {
        return ieorder[this.level];
    }

    @Override
    public Object getValue(DMTag t2) {
        return ((MemComposite)this.compVec.get(0)).getValue(t2);
    }

    @Override
    public void getValues(DMElement[] elements) {
        ((MemComposite)this.compVec.get(0)).getValues(elements);
    }

    @Override
    public void setValues(DMElement[] elements) {
        for (MemComposite item : this.compVec) {
            item.setValues(elements);
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        ArrayList<MemComposite> a2 = new ArrayList<MemComposite>();
        for (MemComposite item : this.compVec) {
            if (q2 != null && !q2.valid(item)) continue;
            a2.add(item);
        }
        return a2.toArray(new DMiComposite[a2.size()]);
    }

    @Override
    public int getNumberOfComposites(DMQuery q2) {
        return this.compVec.size();
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q2) {
        int ieLevel = MemObject.getLevel(ieType);
        if (ieLevel == this.level) {
            return this.getChildren(q2);
        }
        Iterator iter = this.childTable.values().iterator();
        ArrayList<DMiObject> list = new ArrayList<DMiObject>();
        while (iter.hasNext()) {
            MemObject child = (MemObject)iter.next();
            DMiObject[] tmp = child.getRelated(ieType, null);
            for (int i2 = 0; i2 < tmp.length; ++i2) {
                if (q2 != null && !q2.valid((MemObject)tmp[i2])) continue;
                list.add(tmp[i2]);
            }
        }
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String ieType, DMQuery q2, DMiObjectReceiver cb) {
        int ieLevel = MemObject.getLevel(ieType);
        if (ieLevel == this.level) {
            if (q2 == null || q2.valid(this)) {
                cb.gotOne(this);
            }
        } else if (ieLevel == this.level + 1) {
            for (MemObject child : this.childTable.values()) {
                if (q2 != null && !q2.valid(child)) continue;
                cb.gotOne(child);
            }
            return;
        }
        for (MemObject child : this.childTable.values()) {
            DMiObject[] tmp = child.getRelated(ieType, null);
            for (int i2 = 0; i2 < tmp.length; ++i2) {
                if (q2 != null && !q2.valid((MemObject)tmp[i2])) continue;
                cb.gotOne(tmp[i2]);
            }
        }
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q2) {
        return this.getRelated(ieType, q2).length;
    }

    @Override
    public void delete() {
        System.err.println("in delete");
        this.destroy();
        System.err.println("destroy done");
        if (this.level == 0) {
            return;
        }
        try {
            ((MemObject[])this.getRelated("patient", null))[0].removeComposites(this.compVec, this.level);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        System.err.println("remove composites done");
    }

    void removeComposites(Vector vec, int blevel) {
        if (this.level == blevel) {
            return;
        }
        System.err.println("removecomposites " + this.level);
        if (this.compVec == null) {
            return;
        }
        Iterator iter = vec.iterator();
        while (iter.hasNext()) {
            this.compVec.remove(iter.next());
        }
        Enumeration child = this.childTable.keys();
        Vector v2 = new Vector();
        while (child.hasMoreElements()) {
            Object key = null;
            Object k2 = child.nextElement();
            key = k2;
            MemObject item = (MemObject)this.childTable.get(k2);
            if (item.compVec != null) continue;
            v2.add(key);
        }
        Iterator keyiter = v2.iterator();
        while (keyiter.hasNext()) {
            this.childTable.remove(keyiter.next());
        }
        for (MemObject item : this.childTable.values()) {
            item.removeComposites(vec, blevel);
        }
    }

    void destroy() {
        for (MemObject item : this.childTable.values()) {
            item.destroy();
            this.compVec = null;
        }
        this.childTable = null;
        this.refComp = null;
    }

    @Override
    public DMTag[] getTags() {
        return null;
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        ArrayList<BufferedImage> al2 = new ArrayList<BufferedImage>(this.compVec.size());
        for (MemComposite item : this.compVec) {
            BufferedImage[] tmp = item.getPixelData(tags);
            for (int i2 = 0; i2 < tmp.length; ++i2) {
                al2.add(tmp[i2]);
            }
        }
        return al2.toArray(new BufferedImage[al2.size()]);
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public String getID() {
        return this.toString();
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        try {
            DMiComposite[] comp = this.getComposites(null);
            ArrayList<DMiImage> al2 = new ArrayList<DMiImage>(comp.length);
            for (int i2 = 0; i2 < comp.length; ++i2) {
                DMiImage[] dmi = comp[i2].getImages(tags);
                for (int j2 = 0; j2 < dmi.length; ++j2) {
                    al2.add(dmi[j2]);
                }
            }
            return al2.toArray(new DMiImage[al2.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

