/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mwl;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.mwl.MwlSession;
import com.ge.med.terra.tap.dm.mwl.MwlUtils;
import com.ge.med.terra.tap.util.socket.SocketUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Level;

public class CEcho {
    public static final int OK = 0;
    public static final int NOT_OK = 1;
    private String calledAE;
    private String callingAE;
    private String calledHost;
    private int calledPort;
    private Socket socket;
    private boolean isSecureNode;
    private Association as;
    private int pContext = 4097;
    private int[] tsids = new int[]{8193};
    private int socketTmo = Integer.parseInt(Tap.getProperty("tap.dm.nw.socketTmo", "0"));

    public CEcho(String calledAE, String calledHost, int calledPort, String callingAE) throws Exception {
        this(calledAE, calledHost, calledPort, callingAE, null);
    }

    public CEcho(String calledAE, String calledHost, int calledPort, String callingAE, Properties props) throws Exception {
        String tp;
        this.calledAE = calledAE;
        this.callingAE = callingAE;
        this.calledHost = calledHost;
        this.calledPort = calledPort;
        if (props != null && (tp = props.getProperty("TransferParams")) != null) {
            this.tsids = MwlSession.parseTransferParams(tp);
        }
    }

    public CEcho(String calledAE, String calledHost, int calledPort, String callingAE, boolean isSecure, Properties props) throws Exception {
        this(calledAE, calledHost, calledPort, callingAE, props);
        this.isSecureNode = isSecure;
    }

    public int makeAssociation() throws Exception {
        if (this.socket != null && this.as != null) {
            return 0;
        }
        SocketUtil sockUtil = new SocketUtil();
        this.socket = this.isSecureNode ? sockUtil.getSSLSocket(this.calledHost, this.calledPort, this.socketTmo) : sockUtil.getSocket(this.calledHost, this.calledPort, this.socketTmo);
        this.as = MwlUtils.createAssociation(this.socket);
        Request request = new Request();
        request.setCalledTitle(this.calledAE);
        request.setCallingTitle(this.callingAE);
        request.setMaxPduSize(16352);
        request.addPresentationContext(this.pContext, this.tsids);
        this.as.sendAssociateRequest(request);
        this.socket.setSoTimeout(this.socketTmo);
        Response response = this.as.receiveAssociateResponse();
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, this.pContext);
            switch (result) {
                case 0: {
                    return 0;
                }
                case 3: {
                    Tap.log.log(Level.WARNING, "C-ECHO: abstract syntax not supported");
                    return 1;
                }
                case 4: {
                    Tap.log.log(Level.WARNING, "C-ECHO: transfer syntaxes not supported");
                    return 1;
                }
                case 1: {
                    Tap.log.log(Level.WARNING, "C-ECHO: user rejection of presentation context");
                    return 1;
                }
                case 2: {
                    Tap.log.log(Level.WARNING, "C-ECHO: presentation context refused, no reason given");
                    return 1;
                }
            }
            Tap.log.log(Level.WARNING, "C-ECHO: Unknown Result for Abstract Syntax");
            return 1;
        }
        if (response instanceof Reject) {
            Tap.log.log(Level.WARNING, "C-ECHO: association rejected: " + response);
            return 1;
        }
        if (response instanceof Abort) {
            Tap.log.log(Level.WARNING, "C-ECHO: association aborted: " + response);
            return 1;
        }
        Tap.log.log(Level.WARNING, "C-ECHO: unknown error");
        return 1;
    }

    public void releaseAssociation() throws IOException, IllegalValueException {
        if (this.socket != null && this.as != null) {
            this.as.sendReleaseRequest();
            this.as.receiveReleaseResponse();
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public void abortAssociation() throws IOException {
        if (this.socket != null && this.as != null) {
            this.as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public int doEcho() {
        try {
            this.makeAssociation();
            DicomObject echoreq = DimseUtil.createEchoRequest(new Integer(7), new Integer(this.pContext));
            this.as.send(this.pContext, echoreq, null);
            DicomObject echores = this.as.receiveCommand();
            int commandfield = echores.getI(3);
            if (commandfield != 32816) {
                Tap.log.log(Level.WARNING, "No C-ECHO RESPONSE command field: " + Integer.toHexString(commandfield));
                this.abortAssociation();
                return 1;
            }
            String sopclass = echores.getS(1);
            if (sopclass != null && UID.getUIDEntry(sopclass).getConstant() != 4097) {
                Tap.log.log(Level.WARNING, "Affected SOP Class UID in C-ECHO RESPONSE wrong: " + sopclass);
                this.abortAssociation();
                return 1;
            }
            int messageid = echores.getI(5);
            if (messageid != 7) {
                Tap.log.log(Level.WARNING, "Message ID in C-ECHO RESPONSE wrong: " + messageid);
                this.abortAssociation();
                return 1;
            }
            int status = echores.getI(9);
            if (status != 0) {
                Tap.log.log(Level.WARNING, "Status in C-ECHO RESPONSE wrong: " + status);
                this.abortAssociation();
                return 1;
            }
            this.releaseAssociation();
            return 0;
        }
        catch (Exception ex) {
            Tap.log.log(Level.SEVERE, "Error during C-ECHO: ", ex);
            return 1;
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Usage: " + CEcho.class.getName() + " calledAE calledHost calledPort callingAE");
                return;
            }
            String calledAE = args[0];
            String calledHost = args[1];
            String calledPort = args[2];
            String callingAE = args[3];
            System.out.println("CEcho( calledAE=\"" + calledAE + "\", calledHost=\"" + calledHost + "\", calledPort=" + calledPort + ", callingAE=\"" + callingAE + "\" )");
            CEcho ce = new CEcho(calledAE, calledHost, Integer.parseInt(calledPort), callingAE);
            if (ce.doEcho() == 0) {
                System.out.println("C-ECHO Successful");
            } else {
                System.out.println("C-ECHO Failed");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

