/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mwl;

import com.archimed.dicom.DicomObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.mwl.MwlSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import java.io.IOException;
import java.io.OutputStream;

public class MwlSequence
implements DMiSequence {
    private DicomObject seq;
    private DMTag tag;

    public MwlSequence(DicomObject dicomObject, int group, int element) {
        this.seq = dicomObject;
        this.tag = new DMTag(group, element);
    }

    @Override
    public Object getValue(int itemNumber, DMTag tag2) {
        DMiSeqItem item = this.getItem(itemNumber);
        return item.getValue(tag2);
    }

    @Override
    public int getNumberOfItems() {
        return this.seq.getSize_ge(this.tag.getGroup(), this.tag.getElement());
    }

    @Override
    public DMiSeqItem getItem(int n2) {
        DicomObject item = (DicomObject)this.seq.get_ge(this.tag.getGroup(), this.tag.getElement(), n2);
        return new MwlSeqItem(item);
    }

    public void printDebugInfo(OutputStream out) throws IOException {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer sb = new StringBuffer(3);
        sb.append("\\");
        sb.append(lineSeparator);
        int nItems = this.getNumberOfItems();
        for (int i2 = 0; i2 < nItems; ++i2) {
            if (i2 > 0) {
                out.write(sb.toString().getBytes());
            }
            ((DicomObject)this.seq.get_ge(this.tag.getGroup(), this.tag.getElement(), i2)).dumpVRs(out);
        }
    }
}

