/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.scp;
import java.util.Properties;

public class ScpEcho
implements ScpService {
    boolean init = false;
    scp scp;
    Properties props = null;
    boolean debug = false;
    int[] cmds = new int[]{48};
    int[] sops = new int[]{4097};

    @Override
    public void init(scp scp2, Properties props) {
        this.debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
        this.scp = scp2;
        this.props = props;
        this.init = true;
    }

    @Override
    public int[] getSupportedSOPClass() {
        return this.sops;
    }

    @Override
    public int[] getSupportedCommands() {
        return this.cmds;
    }

    @Override
    public boolean doCommand(int command2, Association as, DicomObject dcm, Request request, Response response) {
        if (command2 == 48) {
            return this.doEcho(as, dcm);
        }
        return false;
    }

    public boolean doEcho(Association as, DicomObject dcm) {
        try {
            String ve_sopclass = UID.getUIDEntry(4097).getValue();
            String sopclass = dcm.getS(1);
            if (!sopclass.equals(ve_sopclass)) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("wrong sop class in C-ECHO REQUEST: " + sopclass + " , aborting");
                }
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
                return false;
            }
            Integer messageid = (Integer)dcm.get(4);
            if (messageid == null) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("message ID missing from C-ECHO REQUEST, aborting");
                }
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
                return false;
            }
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("receive C-ECHO REQUEST");
            }
            DicomObject responsedcm = new DicomObject();
            responsedcm.set(3, new Integer(32816));
            responsedcm.set(5, messageid);
            responsedcm.set(8, new Integer(257));
            responsedcm.set(9, new Integer(0));
            as.send(4097, responsedcm, null);
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("sent C-ECHO RESPONSE");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }
}

