/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DDate;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Person;
import com.archimed.dicom.UID;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.network.DicomObjectReceiver;
import com.ge.med.terra.tap.dm.network.NWUtils;
import com.ge.med.terra.tap.dm.network.cecho;
import com.ge.med.terra.tap.dm.network.cfind;
import com.ge.med.terra.tap.dm.network.cstore;
import com.ge.med.terra.tap.dm.network.ncreate;
import com.ge.med.terra.tap.dm.network.networkJob;
import com.ge.med.terra.tap.dm.network.networkObject;
import com.ge.med.terra.tap.dm.network.nset;
import com.ge.med.terra.tap.dm.network.scp;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.FixedStream;
import com.ge.med.terra.tap.util.dicom.UsesJdt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;

public class networkSession
implements DMiSession {
    public static final String TRANSFER_PARAMS = "TransferParams";
    private static String[] nwparams = new String[]{DMUtils.NW_INIT_CALLED_AE, DMUtils.NW_INIT_CALLED_HOST, DMUtils.NW_INIT_CALLED_PORT, DMUtils.NW_INIT_CALLING_AE, DMUtils.NW_INIT_IMPL_CLASS_UID, "TransferParams"};
    private static HashSet supportedParams = new HashSet();
    private static String[] tsparams = new String[]{"ImplicitVRLittleEndian", "ExplicitVRLittleEndian", "ExplicitVRBigEndian"};
    private static int[] tsvalues = new int[]{8193, 8194, 8195};
    private static HashMap tsmap = new HashMap(tsparams.length);
    private static int threadCount = 0;
    Properties props = null;
    String repType;
    String calledAE;
    String callingAE;
    String calledHost;
    int calledPort;
    private boolean isSecureNode = false;
    int myServerPort = Integer.parseInt(Tap.getProperty("tap.dm.nw.serverPort", "4006").trim());
    int myInternalPort = 4010;
    boolean createSCP = true;
    private DMSession localSession;
    private static int sessionNumber = 0;
    private String cstore_dir;
    static scp server;
    private static Vector installEventQueue;
    boolean reuseAssociation = false;
    boolean associationMade = false;
    cstore global_cstore = null;
    int associationTransferSyntax = -1;
    protected Hashtable studyCache = new Hashtable();
    protected Hashtable seriesCache = new Hashtable();
    protected Hashtable imageCache = new Hashtable();
    protected int[][][] prefetch = new int[4][][];
    protected cfind cf;
    ArrayList jobs = new ArrayList(10);
    boolean stopPending = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            this.stopPending = true;
            AbstractList abstractList = this.jobs;
            synchronized (abstractList) {
                this.jobs.notifyAll();
            }
            this.cf.releaseAssociation();
            this.stopServer();
            if (this.createSCP) {
                this.localSession.close();
                abstractList = installEventQueue;
                synchronized (abstractList) {
                    installEventQueue.clear();
                }
                SimpleUtilities.deleteFilesRecursively(new File(this.cstore_dir));
            }
            super.finalize();
        }
        catch (Throwable e2) {
            Tap.log.log(Level.WARNING, "Exception caught in finalize: ", e2);
        }
    }

    public static boolean debug() {
        return Tap.getProperty("tap.dm.nw.debug", "false").equalsIgnoreCase("true");
    }

    @Override
    public DMiComposite getComposite(String id) {
        throw new UnsupportedOperationException("Method getComposite() not yet implemented.");
    }

    @Override
    public DMiComposite[] getComposites() {
        throw new UnsupportedOperationException("Method getComposites() not yet implemented.");
    }

    @Override
    public int getNumberOfComposites() {
        throw new UnsupportedOperationException("Method getNumberOfComposites() not yet implemented.");
    }

    @Override
    public DMiObject[] getChildren(DMQuery q2) {
        return this.internalGetRelated("patient", q2, null);
    }

    private networkObject[] internalGetRelated(String t2, DMQuery q2, DMiObjectReceiver cb) {
        final String ieType = t2;
        final DMiObjectReceiver callback = cb;
        final networkSession myself = this;
        DicomObject dataSet = this.tapToDicomQuery(ieType, q2);
        DicomObjectReceiver r2 = new DicomObjectReceiver(){

            @Override
            public boolean gotOne(DicomObject obj) {
                return callback.gotOne(new networkObject(ieType, myself, obj));
            }
        };
        try {
            if (this.cf.makeAssociation() == 0) {
                if (callback == null) {
                    this.cf.doFind(dataSet);
                    DicomObject[] objs = this.cf.getObjects();
                    networkObject[] nObjs = new networkObject[objs.length];
                    for (int i2 = 0; i2 < objs.length; ++i2) {
                        nObjs[i2] = new networkObject(ieType, myself, objs[i2]);
                    }
                    return nObjs;
                }
                this.cf.doFind(dataSet, r2);
                return null;
            }
            Tap.log.fine("Failed to make C-FIND association in internalGetRelated()");
        }
        catch (Exception ex) {
            throw new DMException(ex.getMessage());
        }
        return null;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q2) {
        return this.internalGetRelated(ieType, q2, null);
    }

    @Override
    public void getRelated(String ieType, DMQuery q2, DMiObjectReceiver cb) {
        this.internalGetRelated(ieType, q2, cb);
    }

    @Override
    public void getChildren(DMQuery q2, DMiObjectReceiver cb) {
        this.internalGetRelated("patient", q2, cb);
    }

    @Override
    public void init(String repType, String[] args) {
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            StringBuffer str = new StringBuffer();
            str.append("init(");
            str.append(repType);
            for (int i2 = 0; i2 < args.length; ++i2) {
                str.append(",");
                str.append(args[i2]);
            }
            str.append(")");
            Tap.log.fine(str.toString());
        }
        this.repType = repType;
        if (args[0].indexOf("=") == -1) {
            this.calledAE = args[0];
            this.callingAE = args[1];
            this.calledHost = args[2];
            this.calledPort = Integer.parseInt(args[3].trim());
            if (args.length > 4) {
                this.isSecureNode = Boolean.valueOf(args[4]);
            }
        } else {
            this.parseNamedParams(args);
            this.calledAE = this.props.getProperty(DMUtils.NW_INIT_CALLED_AE).trim();
            this.calledHost = this.props.getProperty(DMUtils.NW_INIT_CALLED_HOST).trim();
            this.calledPort = Integer.parseInt(this.props.getProperty(DMUtils.NW_INIT_CALLED_PORT).trim());
            this.callingAE = this.props.getProperty(DMUtils.NW_INIT_CALLING_AE).trim();
            String implclassuid = this.props.getProperty(DMUtils.NW_INIT_IMPL_CLASS_UID);
            this.isSecureNode = Boolean.valueOf(this.props.getProperty(DMUtils.NW_INIT_SECURE));
            if (null != implclassuid) {
                NWUtils.setImplementationClassUID(implclassuid);
            }
        }
        this.myServerPort = Integer.parseInt(this.getProperty("tap.dm.nw.serverPort", "4006"));
        this.createSCP = this.getProperty("tap.dm.nw.createSCP", "true").equalsIgnoreCase("true");
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine("createSCP flag is: " + this.createSCP);
        }
        if (this.createSCP) {
            try {
                this.cstore_dir = this.createTempDir();
                this.localSession = new DMSession(new String[]{"file", this.cstore_dir});
                this.localSession.addDMEventListener(1, new DMEventListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(DMEvent e2) {
                        Vector vector = installEventQueue;
                        synchronized (vector) {
                            installEventQueue.add(e2);
                            installEventQueue.notify();
                        }
                    }
                });
                this.startServer();
            }
            catch (Exception e2) {
                Tap.log.warning("Failed to setup scp");
            }
        }
        try {
            this.cf = new cfind(this.calledAE, this.calledHost, this.calledPort, this.callingAE, this.isSecureNode, repType, this.props);
            if (repType == null || repType.equalsIgnoreCase("mwl")) {
                this.cf.makeAssociation();
            }
        }
        catch (Exception ex) {
            Tap.log.warning("Unable to establish C-FIND association");
            this.close();
            throw new RuntimeException(ex);
        }
        this.setupJobManager();
    }

    private void parseNamedParams(String[] args) {
        this.props = new Properties();
        for (int i2 = 0; i2 < args.length; ++i2) {
            String param = args[i2];
            int ind = param.indexOf("=");
            if (ind == -1) {
                throw new RuntimeException("Wrong parameter syntax: " + param);
            }
            String pname = param.substring(0, ind);
            String pvalue = param.substring(ind + 1);
            if (pname.equals(TRANSFER_PARAMS)) {
                try {
                    networkSession.parseTransferParams(pvalue);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unknown transfer syntax: " + param);
                }
            }
            this.props.setProperty(pname, pvalue);
            if (supportedParams.contains(pname)) continue;
            Tap.log.log(Level.WARNING, "Non networkSession Parameter: {0}", pname);
        }
    }

    static int[] parseTransferParams(String tp) {
        String[] p2 = tp.split("\\,");
        int[] tsids = new int[p2.length];
        for (int i2 = 0; i2 < p2.length; ++i2) {
            tsids[i2] = (Integer)tsmap.get(p2[i2].trim());
        }
        return tsids;
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String def) {
        String prop = null;
        if (this.props != null) {
            prop = this.props.getProperty(name);
        }
        if (prop == null) {
            prop = Tap.getProperty(name, def);
        }
        return prop != null ? prop.trim() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(DMiObject o2, Hashtable prop) {
        networkJob j2 = new networkJob(o2);
        Enumeration en = prop.keys();
        String key = null;
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            j2.setProperty(key, prop.get(key));
        }
        ArrayList arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.add(j2);
            this.jobs.notify();
        }
        j2.waitForCompletion();
    }

    @Override
    public void save(DMiObject[] o2, Hashtable prop) {
        for (int i2 = 0; i2 < o2.length; ++i2) {
            this.save(o2[i2], prop);
        }
    }

    private void runJob(networkJob j2) {
        this.send(DMUtils.MSG_REUSE_NETWORK_ASSOCIATION);
        try {
            DMiComposite[] comps = j2.objectToSave.getComposites(null);
            j2.total = comps.length;
            j2.done = 0;
            for (int i2 = 0; i2 < comps.length && j2.getState() != 6; ++i2) {
                if (j2.getState() == 3) {
                    j2.waitForResume();
                    continue;
                }
                j2.setState(1);
                this.save(comps[i2], null);
                ++j2.done;
                j2.completed();
            }
        }
        catch (Exception e2) {
            j2.fail(e2);
        }
        this.send(DMUtils.MSG_CLOSE_NETWORK_ASSOCIATION);
        if (j2.done == j2.total) {
            j2.state = 0;
        } else if (j2.state != 6) {
            j2.state = 4;
        }
        if (j2.state == 0 || j2.state == 4) {
            this.jobs.remove(j2);
            j2 = null;
        }
    }

    @Override
    public void save(DMiComposite o2, Hashtable prop) {
        if (this.repType != null && this.repType.equalsIgnoreCase("pps")) {
            block11: {
                InputStream is = null;
                try {
                    nset ns = new nset(this.calledAE, this.calledHost, this.calledPort, this.callingAE);
                    if (ns.makeAssociation() != nset.OK) break block11;
                    DicomObject dataSet = new DicomObject();
                    is = o2.getInputStream();
                    if (is instanceof UsesJdt) {
                        dataSet = ((UsesJdt)((Object)is)).getDicomObject();
                    } else {
                        dataSet.read(is);
                    }
                    is.close();
                    if (ns.doNSet(dataSet) == nset.OK) {
                        ns.releaseAssociation();
                        break block11;
                    }
                    String errmsg = "N-SET Failed";
                    Tap.log.fine("N-SET Failed");
                    ns.abortAssociation();
                    throw new DMException("N-SET Failed");
                }
                catch (Exception e2) {
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw new DMException(e2.getMessage());
                }
            }
            return;
        }
        try {
            this.install(new FixedStream(o2.getInputStream()));
        }
        catch (IOException ex) {
            throw new DMException(ex.getMessage());
        }
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
    }

    @Override
    public void install(InputStream is) throws DMException {
        DicomObject dataSet = new DicomObject();
        try {
            if (is instanceof UsesJdt) {
                dataSet = ((UsesJdt)((Object)is)).getDicomObject();
            } else {
                dataSet.read(is);
            }
            this.install(dataSet);
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Exception caught in install: ", ex);
            throw new DMException(ex);
        }
    }

    public void install(DicomObject dataSet) throws Exception {
        block10: {
            if (this.repType != null && this.repType.equalsIgnoreCase("pps")) {
                block9: {
                    try {
                        ncreate nc = new ncreate(this.calledAE, this.calledHost, this.calledPort, this.callingAE);
                        if (nc.makeAssociation() != ncreate.OK) break block9;
                        if (nc.doNCreate(dataSet) == ncreate.OK) {
                            nc.releaseAssociation();
                            break block9;
                        }
                        String errmsg = "N-CREATE Failed";
                        Tap.log.warning("N-CREATE Failed");
                        nc.abortAssociation();
                        throw new DMException("N-CREATE Failed");
                    }
                    catch (Exception e2) {
                        throw new DMException(e2);
                    }
                }
                return;
            }
            try {
                String sopClassUID = (String)dataSet.get(62);
                cstore cs = this.makeAssociation(sopClassUID);
                this.associationTransferSyntax = cs.associationTransferSyntax;
                if (this.associationTransferSyntax == -1) break block10;
                if (cs.doStore(dataSet) == cstore.OK) {
                    if (!this.reuseAssociation) {
                        cs.releaseAssociation();
                        this.associationMade = false;
                        this.associationTransferSyntax = -1;
                    }
                    break block10;
                }
                String errmsg = "C-STORE Failed";
                Tap.log.warning("C-STORE Failed");
                if (!this.reuseAssociation) {
                    cs.abortAssociation();
                    this.associationMade = false;
                    this.associationTransferSyntax = -1;
                }
                throw new DMException("C-STORE Failed");
            }
            catch (Exception ex) {
                throw new DMException(ex);
            }
        }
    }

    private cstore makeAssociation(String sopClassUid) throws Exception {
        cstore cs = null;
        if (this.reuseAssociation) {
            if (this.global_cstore == null) {
                this.global_cstore = new cstore(this.calledAE, this.calledHost, this.calledPort, this.callingAE, this.props);
            }
            cs = this.global_cstore;
        } else {
            cs = new cstore(this.calledAE, this.calledHost, this.calledPort, this.callingAE, this.props);
        }
        if (!this.associationMade) {
            cs.makeAssociation(sopClassUid);
        }
        this.associationMade = true;
        return cs;
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        cstore cs = null;
        try {
            cs = new cstore(this.calledAE, this.calledHost, this.calledPort, this.callingAE, this.props);
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Exception caught when calling cstore: ", e2);
            return;
        }
        int failed = 0;
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                try {
                    fis = new FileInputStream(files[i2]);
                }
                catch (Exception e3) {
                    Tap.log.log(Level.WARNING, "Exception caught when creating input stream: ", e3);
                    continue;
                }
                DicomObject dataSet = new DicomObject();
                dataSet.read(fis);
                fis.close();
                if (cs.makeAssociation((String)dataSet.get(62)) != cstore.OK) continue;
                if (cs.doStore(dataSet) == cstore.OK) {
                    cs.releaseAssociation();
                    if (!destroy) continue;
                    files[i2].delete();
                    continue;
                }
                ++failed;
                Tap.log.warning("C-STORE Failed");
                cs.abortAssociation();
                continue;
            }
            catch (Exception e4) {
                Tap.log.log(Level.WARNING, "Exception caught in installFiles: ", e4);
                throw new DMException(e4.toString());
            }
        }
        if (failed > 0) {
            throw new DMException("C-STORE Failed for " + failed + " of " + files.length + " files");
        }
    }

    protected int[][] loadCache(String name, String str) {
        if (str.startsWith(name)) {
            int[][] t2 = new DMQuery(str.substring(name.length())).getTags();
            Arrays.sort(t2, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int[] i1 = (int[])o1;
                    int[] i2 = (int[])o2;
                    if (i1 != i2) {
                        return i1[0] - i2[0];
                    }
                    return i1[1] - i2[1];
                }
            });
            int k2 = 0;
            int i2 = 1;
            while (i2 < t2.length) {
                if (t2[i2][0] == t2[k2][0] && t2[i2][1] == t2[k2][1]) {
                    t2[k2] = t2[i2];
                }
                ++i2;
                ++k2;
            }
            HashSet set = new HashSet(Arrays.asList(t2));
            t2 = (int[][])set.toArray((T[])new int[set.size()][]);
            Arrays.sort(t2, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int[] i1 = (int[])o1;
                    int[] i2 = (int[])o2;
                    if (i1 != i2) {
                        return i1[0] - i2[0];
                    }
                    return i1[1] - i2[1];
                }
            });
            return t2;
        }
        return null;
    }

    @Override
    public String[] send(String str) {
        Tap.log.info("network send = " + str);
        String[] cache = new String[]{"PCACHE=", "ECACHE=", "SCACHE=", "ICACHE="};
        for (int i2 = 0; i2 < cache.length; ++i2) {
            int[][] tmp = this.loadCache(cache[i2], str);
            if (tmp == null) continue;
            this.prefetch[i2] = tmp;
            break;
        }
        if (str.equals(DMUtils.MSG_REUSE_NETWORK_ASSOCIATION)) {
            this.reuseAssociation = true;
        } else if (str.equals(DMUtils.MSG_CLOSE_NETWORK_ASSOCIATION)) {
            try {
                if (this.associationMade) {
                    this.global_cstore.releaseAssociation();
                }
            }
            catch (Exception e2) {
                Tap.log.log(Level.WARNING, "Exception caught while releasing association: ", e2);
            }
            this.associationMade = false;
            this.reuseAssociation = false;
            this.global_cstore = null;
        } else if (str.startsWith(DMUtils.MSG_CSTORE_DIR)) {
            this.cstore_dir = str.substring(DMUtils.MSG_CSTORE_DIR.length() + 2, str.length());
        } else if (str.startsWith(DMUtils.MSG_SCP_PORT)) {
            this.myServerPort = Integer.parseInt(str.substring(DMUtils.MSG_SCP_PORT.length() + 2, str.length()));
        } else if (str.equals(DMUtils.MSG_NETWORK_ASSOCIATION_TYPE)) {
            try {
                switch (UID.getUIDEntry(this.associationTransferSyntax).getConstant()) {
                    case 8195: {
                        return new String[]{DMUtils.TS_EBE};
                    }
                    case 8194: {
                        return new String[]{DMUtils.TS_ELE};
                    }
                    case 8193: {
                        return new String[]{DMUtils.TS_ILE};
                    }
                }
            }
            catch (IllegalValueException ex) {
                return new String[]{DMUtils.TS_UNKOWN};
            }
        } else if (str.startsWith(DMUtils.MSG_MAKE_NETWORK_ASSOCIATION)) {
            try {
                if (!this.reuseAssociation) {
                    throw new IllegalArgumentException();
                }
                String sopClassUid = str.substring(DMUtils.MSG_MAKE_NETWORK_ASSOCIATION.length() + 1, str.length());
                this.associationTransferSyntax = this.makeAssociation((String)sopClassUid).associationTransferSyntax;
                switch (UID.getUIDEntry(this.associationTransferSyntax).getConstant()) {
                    case 8195: {
                        return new String[]{DMUtils.TS_EBE};
                    }
                    case 8194: {
                        return new String[]{DMUtils.TS_ELE};
                    }
                    case 8193: {
                        return new String[]{DMUtils.TS_ILE};
                    }
                }
            }
            catch (Exception ex) {
                throw new DMException(ex);
            }
        } else {
            if (str.equals(DMUtils.MSG_PING_REMOTE_SCP)) {
                return new String[]{new Boolean(this.pingRemote()).toString()};
            }
            if (str.equals(DMUtils.MSG_NETWORK_STOP_SERVER)) {
                this.stopServer();
            }
        }
        return null;
    }

    @Override
    public DMiJob asynSend(String str) {
        throw new UnsupportedOperationException("Method asynSend() not yet implemented.");
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        throw new UnsupportedOperationException("Method getDMiObject() not yet implemented.");
    }

    @Override
    public void ClearCache() {
    }

    @Override
    public DMiJob[] getJobs() {
        return this.jobs.toArray(new DMiJob[0]);
    }

    private static void setDefaultQuery(DicomObject dataSet, String level, cfind cf) throws Exception {
        if (level.equalsIgnoreCase("Patient")) {
            if (cf.getQueryRetrieveInfoModel() == 4132) {
                dataSet.set(78, "PATIENT");
            } else {
                dataSet.set(78, "STUDY");
            }
            dataSet.set(147, "*");
            dataSet.set(148, null);
            dataSet.set(150, null);
            dataSet.set(151, null);
            dataSet.set(152, null);
        } else if (level.equalsIgnoreCase("Study") || level.equalsIgnoreCase("Exam")) {
            dataSet.set(147, "*");
            dataSet.set(148, null);
            dataSet.set(150, null);
            dataSet.set(151, null);
            dataSet.set(152, null);
            dataSet.set(78, "STUDY");
            dataSet.set(425, null);
            dataSet.set(427, null);
            dataSet.set(64, null);
            dataSet.set(70, null);
            dataSet.set(81, null);
            dataSet.set(95, null);
        } else if (level.equalsIgnoreCase("Series")) {
            dataSet.set(78, "SERIES");
            dataSet.set(426, null);
            dataSet.set(65, null);
            dataSet.set(71, null);
            dataSet.set(97, null);
            dataSet.set(428, null);
            dataSet.set(669, null);
            dataSet.set(147, "*");
        } else if (level.equalsIgnoreCase("Image")) {
            dataSet.set(78, "IMAGE");
            dataSet.set(63, null);
            dataSet.set(665, null);
            dataSet.set(430, null);
            dataSet.set(81, null);
        }
    }

    private static void setMWLQuery(DicomObject dataSet) throws Exception {
        dataSet.set(57, null);
        DicomObject spsSeq = new DicomObject();
        dataSet.set(587, spsSeq);
        spsSeq.set(574, null);
        spsSeq.set(575, null);
        spsSeq.set(576, null);
        spsSeq.set(81, null);
        spsSeq.set(579, null);
        spsSeq.set(580, null);
        spsSeq.set(581, null);
        spsSeq.set(582, null);
        dataSet.set(547, null);
        dataSet.set(548, null);
        dataSet.set(589, null);
        dataSet.set(425, null);
        dataSet.set(107, null);
        dataSet.set(77, null);
        dataSet.set(88, null);
        dataSet.set(147, "*");
        dataSet.set(148, null);
        dataSet.set(150, null);
        dataSet.set(152, null);
        dataSet.set(571, null);
        dataSet.set(173, null);
        dataSet.set(174, null);
        dataSet.set(165, null);
        dataSet.set(166, null);
        dataSet.set(568, null);
    }

    public DicomObject tapToDicomQuery(String level, DMQuery q2) {
        DicomObject dataSet = new DicomObject();
        try {
            if (this.repType != null && this.repType.equalsIgnoreCase("mwl")) {
                networkSession.setMWLQuery(dataSet);
            } else {
                networkSession.setDefaultQuery(dataSet, level, this.cf);
            }
            if (q2 != null) {
                DicomData dc = new DicomData(dataSet);
                q2.writeDicom(dc);
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error converting TAP query to DICOM stream: ", ex);
            return null;
        }
        return dataSet;
    }

    public static DicomObject apppendDMQuery(DicomObject dataSet, DMQuery q2) {
        try {
            if (q2.lhs == null && q2.rhs == null) {
                dataSet.set_ge(q2.group, q2.element, q2.sval);
            } else {
                if (q2.lhs != null) {
                    dataSet.set_ge(q2.lhs.group, q2.lhs.element, q2.lhs.sval);
                    dataSet = networkSession.apppendDMQuery(dataSet, q2.lhs);
                }
                if (q2.rhs != null) {
                    dataSet.set_ge(q2.rhs.group, q2.rhs.element, q2.rhs.sval);
                    dataSet = networkSession.apppendDMQuery(dataSet, q2.rhs);
                }
            }
            return dataSet;
        }
        catch (Exception ex) {
            return dataSet;
        }
    }

    public DicomObject[] clubTogether(DicomObject[] objects, String ieType) {
        Hashtable<Object, DicomObject> hash = new Hashtable<Object, DicomObject>();
        DicomObject[] clubbed = null;
        if (objects == null || ieType == null) {
            return clubbed;
        }
        for (int i2 = 0; i2 < objects.length; ++i2) {
            if (ieType.equalsIgnoreCase("Patient")) {
                hash.put(new patient(objects[i2]), objects[i2]);
                continue;
            }
            if (ieType.equalsIgnoreCase("Study") || ieType.equalsIgnoreCase("Exam")) {
                hash.put(objects[i2].get(425), objects[i2]);
                continue;
            }
            if (ieType.equalsIgnoreCase("Series")) {
                hash.put(objects[i2].get(426), objects[i2]);
                continue;
            }
            if (ieType.equalsIgnoreCase("Image")) {
                hash.put(objects[i2].get(63), objects[i2]);
                continue;
            }
            hash.put(new Integer(i2), objects[i2]);
            Tap.log.log(Level.WARNING, "Don't know how to club IE Type: {0}", ieType);
        }
        clubbed = new DicomObject[hash.size()];
        Enumeration en = hash.keys();
        int i3 = 0;
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            clubbed[i3] = (DicomObject)hash.get(key);
            ++i3;
        }
        return clubbed;
    }

    private void startServer() {
        if (!this.isServerAlive()) {
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("Starting Server");
            }
            try {
                server = new scp(this.callingAE, this.myServerPort, this.cstore_dir, this.props);
                scp.setSession(this.localSession);
                server.setDaemon(true);
                server.start();
            }
            catch (Exception e2) {
                Tap.log.log(Level.WARNING, "Exception caught in startServer: ", e2);
            }
        } else {
            Tap.log.info("Server already up");
        }
    }

    private void stopServer() {
        if (server != null) {
            server.end();
        }
    }

    private String createTempDir() {
        boolean ok;
        File tmp = new File(SimpleUtilities.getTempDir());
        if (!tmp.isDirectory()) {
            throw new DMException(tmp.getAbsolutePath() + " is not a directory.");
        }
        if (!tmp.canRead()) {
            throw new DMException("Cannot Read from temp directory " + tmp.getAbsolutePath());
        }
        if (!tmp.canWrite()) {
            throw new DMException("Cannot Write to temp directory " + tmp.getAbsolutePath());
        }
        String pid = Integer.toString(SimpleUtilities.getProcessID());
        File pidDir = new File(tmp, "TapNetwork" + File.separator + pid);
        File tempDir = new File(pidDir + File.separator + "session" + ++sessionNumber);
        if (!tempDir.exists() && !(ok = tempDir.mkdirs())) {
            throw new DMException("Cound not make temp directory " + tempDir.getAbsolutePath());
        }
        pidDir.deleteOnExit();
        return tempDir.getAbsolutePath();
    }

    public boolean isServerAlive() {
        try {
            cecho ce = new cecho(this.callingAE, "127.0.0.1", this.myServerPort, this.callingAE, this.props);
            return ce.doEcho() == 0;
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Exception caught in isServerAlive: ", e2);
            return false;
        }
    }

    public boolean pingRemote() {
        try {
            cecho ce = new cecho(this.calledAE, this.calledHost, this.calledPort, this.callingAE, this.isSecureNode, this.props);
            return ce.doEcho() == 0;
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Exception caught in pingRemote: ", e2);
            return false;
        }
    }

    @Override
    public void close() {
        Tap.log.fine("closing NW session ..");
        this.finalize();
        Tap.log.fine("NW sesion closed.");
    }

    private void setupJobManager() {
        Thread th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            Thread.sleep(200L);
                            ArrayList arrayList = networkSession.this.jobs;
                            synchronized (arrayList) {
                                while (networkSession.this.jobs.isEmpty() && !networkSession.this.stopPending) {
                                    networkSession.this.jobs.wait();
                                }
                                if (networkSession.this.stopPending) {
                                    break block4;
                                }
                                for (int i2 = 0; i2 < networkSession.this.jobs.size(); ++i2) {
                                    if (((networkJob)networkSession.this.jobs.get(i2)).getState() != 2) continue;
                                    networkSession.this.runJob((networkJob)networkSession.this.jobs.get(i2));
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        Tap.log.log(Level.WARNING, "Exception caught in setupJobManager: ", e2);
                        continue;
                    }
                    break;
                }
                Tap.log.fine("NW Jobs stopeed.");
            }
        });
        th.setDaemon(true);
        th.setName("nwjobmgr:" + threadCount);
        th.start();
        ++threadCount;
    }

    public static void main(String[] args) {
        networkSession nw = new networkSession();
        nw.send("foo");
    }

    static {
        installEventQueue = new Vector(10);
        for (int i2 = 0; i2 < tsparams.length; ++i2) {
            tsmap.put(tsparams[i2], new Integer(tsvalues[i2]));
        }
        supportedParams.addAll(Arrays.asList(nwparams));
    }

    class patient {
        String name;
        String id;
        String dob;

        public patient(DicomObject p2) {
            if (p2.get(147) != null) {
                this.name = ((Person)p2.get(147)).toDICOMString();
            }
            this.id = (String)p2.get(148);
            if (p2.get(150) != null) {
                this.dob = ((DDate)p2.get(150)).toDICOMString();
            }
        }

        public boolean equals(Object o2) {
            if (o2 instanceof patient) {
                patient p2 = (patient)o2;
                return (p2.name == null && this.name == null || p2.name != null && p2.name.equals(this.name)) && (p2.id == null && this.id == null || p2.id != null && p2.id.equals(this.id)) && (p2.dob == null && this.dob == null || p2.dob != null && p2.dob.equals(this.dob));
            }
            return false;
        }
    }
}

