/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.pesi;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectExt1;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.pesi.PesiComposite;
import com.ge.med.terra.tap.dm.pesi.PesiObjectBase;
import com.ge.med.terra.tap.dm.pesi.PesiSession;
import com.ge.med.terra.tap.dm.pesi.VheadersAuxObject;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class PesiObject
extends PesiObjectBase
implements DMiObjectExt1,
DMTagValueInterface {
    File path;
    protected int level;
    protected PesiComposite repComposite = null;
    protected PesiSession session = null;
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_SERIES = 1;
    public static final int TYPE_STUDY = 2;
    public static final int TYPE_PATIENT = 3;
    static AuxTag imgCount = new AuxTag(){

        @Override
        public Object getValue(PesiObject obj) {
            return new Integer(obj.getNumberOfComposites(null));
        }
    };
    static HashMap auxTagCalc = new HashMap();
    public static final String[] levels;

    public PesiObject(String type, File path, PesiSession ses) {
        if (type == null || path == null) {
            throw new DMException("Illegal arguments to PesiObject Constructor");
        }
        this.level = PesiObject.getLevelNumber(type);
        this.path = path;
        this.session = ses;
    }

    private PesiComposite getRepCompExists() {
        if (this.repComposite == null || !this.repComposite.path.exists()) {
            if (this.level == 0) {
                this.repComposite = this.session.makeNewPesiComposite(this.path);
            } else {
                this.repComposite = this.session.findAComposite(this.path);
                if (this.repComposite == null) {
                    throw new DMException("No composites found under: " + this.path.getAbsolutePath());
                }
            }
        }
        return this.repComposite;
    }

    @Override
    public String getType() {
        return levels[this.level];
    }

    @Override
    public Object getValue(DMTag t2) {
        if (t2.getGroup() == 1 && auxTagCalc.containsKey(t2)) {
            HashMap map;
            if (!this.session.auxCache.containsKey(t2)) {
                this.session.auxCache.put(t2, new HashMap());
            }
            if ((map = (HashMap)this.session.auxCache.get(t2)).containsKey(this.path)) {
                return map.get(this.path);
            }
            AuxTag at = (AuxTag)auxTagCalc.get(t2);
            Object o2 = at.getValue(this);
            map.put(this.path, o2);
            return o2;
        }
        PesiComposite pc = this.getRepCompExists();
        return pc.getValue(t2);
    }

    @Override
    public void getValues(DMElement[] elements) {
        this.getRepCompExists().getValues(elements);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            if (elements[i2].group != 1) continue;
            elements[i2].value = this.getValue(new DMTag(1, elements[i2].element));
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        try {
            this.setValuesWork(elements);
        }
        catch (Exception e2) {
            throw new DMException("Update failed ... someone else may be updating =" + e2.getLocalizedMessage());
        }
        if (this.repComposite != null) {
            PesiObject.clearTags(this.repComposite, elements);
        }
        if (this.session.useER) {
            PesiSession.er.sendEvent("DMEvent.GENERAL_EVENT", "update " + this.getID());
        }
    }

    private static void clearTags(PesiComposite p2, DMElement[] elements) {
        p2.clearCache();
    }

    private void setValuesWork(DMElement[] elements) throws IOException {
        File f2;
        int i2;
        File modifiedDir = new File(this.session.rootDir.getParentFile(), "update");
        modifiedDir.mkdir();
        PesiComposite[] comps = (PesiComposite[])this.getComposites(null);
        String[] source = new String[comps.length];
        File[] tmps = new File[comps.length];
        for (i2 = 0; i2 < comps.length; ++i2) {
            source[i2] = comps[i2].getFilePath();
            tmps[i2] = File.createTempFile("UPDATE", ".DCM", modifiedDir);
        }
        for (i2 = 0; i2 < comps.length; ++i2) {
            try {
                DicomComposite data = new DicomComposite();
                InputStream fis = comps[i2].getInputStream();
                data.read(fis);
                fis.close();
                data.setValues(elements);
                f2 = tmps[i2];
                FileOutputStream fos = new FileOutputStream(f2);
                data.write(fos, true);
                fos.close();
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        for (int i3 = 0; i3 < comps.length; ++i3) {
            File orig = new File(source[i3]);
            f2 = File.createTempFile("DELETE", ".DCM", modifiedDir);
            f2.delete();
            boolean ret = orig.renameTo(f2);
            if (!ret) {
                throw new RuntimeException("unable to rename \"" + source[i3] + "\" to \"" + f2 + "\"");
            }
            ret = tmps[i3].renameTo(new File(source[i3]));
            if (!ret) {
                System.err.println("unable to rename \"" + tmps[i3] + "\" to \"" + source[i3] + "\" ");
            } else {
                ret = f2.delete();
                if (!ret) {
                    System.err.println("unable to delete \"" + f2 + "\" someone might still have file open");
                }
            }
            PesiObject.clearTags(comps[i3], elements);
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        if (this.level == 0 && (q2 == null || q2.valid(this.getRepCompExists()))) {
            return new PesiComposite[]{this.getRepCompExists()};
        }
        ArrayList list = new ArrayList();
        this.session.recursivelyFindComposites(this.path, list);
        if (q2 != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (q2.valid((PesiComposite)list.get(i2))) continue;
                list.remove(i2);
                --i2;
            }
        }
        return list.toArray(new PesiComposite[list.size()]);
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getNumberOfComposites(DMQuery q2) {
        return this.countFiles(this.path);
    }

    public int countFiles(File f2) {
        if (f2.isDirectory()) {
            File[] all = f2.listFiles(this.session.ffilter);
            int sum = 0;
            for (int i2 = 0; i2 < all.length; ++i2) {
                if (all[i2].isDirectory()) {
                    sum += this.countFiles(all[i2]);
                    continue;
                }
                ++sum;
            }
            return sum;
        }
        return 1;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q2) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q2, rcvr);
        return list.toArray(new DMiObject[0]);
    }

    private static int getLevelNumber(String levelString) {
        for (int i2 = 0; i2 < levels.length; ++i2) {
            if (!levels[i2].equalsIgnoreCase(levelString)) continue;
            return i2;
        }
        return -1;
    }

    protected void recursivelyFindImages(File root, DMQuery q2, DMiObjectReceiver cb) {
        File[] children = root.listFiles();
        for (int i2 = 0; i2 < children.length; ++i2) {
            boolean b2;
            if (children[i2].isDirectory()) {
                this.recursivelyFindImages(children[i2], q2, cb);
                continue;
            }
            if (!children[i2].getName().startsWith("i")) continue;
            PesiObject obj = this.makePesiObject("image", children[i2], this.session);
            if (q2 != null && !q2.valid(obj) || (b2 = cb.gotOne(obj))) continue;
            return;
        }
    }

    @Override
    public void getRelated(String ieType, DMQuery q2, DMiObjectReceiver cb) {
        if (this.session.checkSOPQuery(ieType, q2, cb)) {
            return;
        }
        int delta = PesiObject.getLevelNumber(this.getType()) - PesiObject.getLevelNumber(ieType);
        if (delta == 0) {
            if (q2 == null || q2.valid(this)) {
                cb.gotOne(this);
            }
        } else if (delta < 0) {
            if (q2 != null && !q2.valid(this)) {
                return;
            }
            File f2 = this.path;
            for (int i2 = 0; i2 < -delta; ++i2) {
                f2 = f2.getParentFile();
            }
            cb.gotOne(this.makePesiObject(ieType, f2, this.session));
        } else {
            this.buildListAtN(this.path, ieType, q2, cb, delta);
        }
    }

    private void buildListAtN(File f2, String ieType, DMQuery q2, DMiObjectReceiver cb, int n2) {
        if (n2 == 0) {
            PesiObject po = this.makePesiObject(ieType, f2, this.session);
            if (q2 == null || q2.valid(po)) {
                cb.gotOne(po);
            }
        } else {
            if (f2.isFile()) {
                return;
            }
            File[] list = f2.listFiles(this.session.ffilter);
            for (int i2 = 0; i2 < list.length; ++i2) {
                this.buildListAtN(list[i2], ieType, q2, cb, n2 - 1);
            }
        }
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q2) {
        return this.getRelated(ieType, q2).length;
    }

    @Override
    public void delete() {
        File f2 = this.path.getParentFile();
        SimpleUtilities.deleteFilesRecursively(this.path);
        this.cleanup(f2);
        this.session.fireEvent(new DMEvent(2, this.path.getAbsolutePath()));
    }

    private void cleanup(File f2) {
        while (!f2.equals(this.session.rootDir) && f2.list().length <= 0) {
            File p2 = f2.getParentFile();
            f2.delete();
            f2 = p2;
        }
    }

    @Override
    public DMTag[] getTags() {
        return this.getRepCompExists().getTags();
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public String getID() {
        return this.path.getAbsolutePath();
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<fileImage> al2 = new ArrayList<fileImage>(comp.length);
        for (int i2 = 0; i2 < comp.length; ++i2) {
            fileImage[] imgs = fileImage.getImages(comp[i2], tags);
            if (imgs == null) continue;
            for (int k2 = 0; k2 < imgs.length; ++k2) {
                al2.add(imgs[k2]);
            }
        }
        fileImageManager.getInstance().setPause(false);
        return al2.toArray(new DMiImage[al2.size()]);
    }

    protected PesiObject makePesiObject(String type, File path, PesiSession session) {
        return new PesiObject(type, path, session);
    }

    @Override
    public DMAuxObject getAuxObject(String type, Properties info) {
        if ("vheader".equals(type) && VheadersAuxObject.viable(this.level, this.path)) {
            try {
                return new VheadersAuxObject(this.path);
            }
            catch (FileNotFoundException e2) {
                throw new DMException(e2);
            }
        }
        return null;
    }

    @Override
    public Object send(String[] str) {
        return null;
    }

    static {
        auxTagCalc.put(new DMTag(1, 1280), imgCount);
        auxTagCalc.put(new DMTag(1, 1536), imgCount);
        levels = new String[]{"image", "series", "study", "patient"};
    }

    static interface AuxTag {
        public Object getValue(PesiObject var1);
    }
}

