/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.dm.rm.RmQueryPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;

class Msg {
    public static final byte MSG_INIT = 1;
    public static final byte MSG_SGET_RELATED = 2;
    public static final byte MSG_SGET_A_RELATED = 3;
    public static final byte MSG_SGET_A_CANCEL = 4;
    public static final byte MSG_SGET_COMP = 5;
    public static final byte MSG_SGET_NCOMP = 6;
    public static final byte MSG_SSEND = 8;
    public static final byte MSG_SCLOSE = 9;
    public static final byte MSG_SCLEAR_CACHE = 10;
    public static final byte MSG_SINSTALL_FILE = 11;
    public static final byte MSG_SADD_ELISTEN = 12;
    public static final byte MSG_OGET_VALUE = 31;
    public static final byte MSG_OGET_VALUES = 32;
    public static final byte MSG_OSET_VALUES = 33;
    public static final byte MSG_OGET_RELATED = 34;
    public static final byte MSG_OGET_COMP = 35;
    public static final byte MSG_OGET_A_RELATED = 36;
    public static final byte MSG_OGET_A_CANCEL = 37;
    public static final byte MSG_OGET_NUMRELATED = 38;
    public static final byte MSG_OGET_DMIMAGE = 40;
    public static final byte MSG_OSAVE = 41;
    public static final byte MSG_ODELETE = 42;
    public static final byte MSG_CGET_VALUE = 61;
    public static final byte MSG_CGET_VALUES = 62;
    public static final byte MSG_CGET_FILE = 63;
    public static final byte MSG_AGET_INPUTSTREAM = 71;
    public static final byte MSG_EVENT = 72;
    public static final byte RSP_INIT = -1;
    public static final byte RSP_SGET_RELATED = -2;
    public static final byte RSP_SGET_A_RELATED = -3;
    public static final byte RSP_SGET_A_CANCEL = -4;
    public static final byte RSP_SGET_COMP = -5;
    public static final byte RSP_SGET_NCOMP = -6;
    public static final byte RSP_SSEND = -8;
    public static final byte RSP_SCLOSE = -9;
    public static final byte RSP_SCLEAR_CACHE = -10;
    public static final byte RSP_SINSTALL_FILE = -11;
    public static final byte RSP_OGET_VALUE = -31;
    public static final byte RSP_OGET_VALUES = -32;
    public static final byte RSP_OSET_VALUES = -33;
    public static final byte RSP_OGET_RELATED = -34;
    public static final byte RSP_OGET_COMP = -35;
    public static final byte RSP_OGET_A_RELATED = -36;
    public static final byte RSP_OGET_A_CANCEL = -37;
    public static final byte RSP_OGET_NUMRELATED = -38;
    public static final byte RSP_OGET_DMIMAGE = -40;
    public static final byte RSP_OSAVE = -41;
    public static final byte RSP_ODELETE = -42;
    public static final byte RSP_CGET_VALUE = -61;
    public static final byte RSP_CGET_VALUES = -62;
    public static final byte RSP_CGET_FILE = -63;
    public static final byte RSP_AGET_INPUTSTREAM = -71;
    public byte sid;
    public int tid;
    public Object data;

    public static String getMessageType(Msg message) {
        Class<Msg> mc = Msg.class;
        Field[] fields = mc.getFields();
        try {
            for (int f2 = 0; f2 < fields.length; ++f2) {
                int mod = fields[f2].getModifiers();
                if (!Modifier.isFinal(mod) || !Modifier.isStatic(mod) || fields[f2].getByte(null) != message.sid) continue;
                return fields[f2].getName();
            }
        }
        catch (Exception ex) {
            return "ex=" + ex;
        }
        return "MSG_?";
    }

    public static String getMessageDetails(Msg message) {
        String msgdata = "";
        if (message.data instanceof RmQueryPacket) {
            RmQueryPacket qp = (RmQueryPacket)message.data;
            msgdata = qp.id + ",query=" + qp.query + ",retLevel=" + qp.retLevel + ",srcLevel=" + qp.srcLevel;
        } else if (message.data instanceof String[]) {
            Object[] s2 = (String[])message.data;
            msgdata = Arrays.toString(s2);
        }
        String details = "[" + message.tid + "] " + Msg.getMessageType(message) + " (" + msgdata + ")";
        return details;
    }

    public static void printMessageType(Msg m2) {
        System.out.println(Msg.getMessageType(m2));
    }

    public final boolean isResponse() {
        return this.sid < 0;
    }

    public Msg(byte sid, int tid, Object data) {
        this.sid = sid;
        this.tid = tid;
        this.data = data;
        if (data == null) {
            throw new RuntimeException("data should not be null");
        }
    }

    public Msg() {
    }

    public Msg(byte[] buff) {
        ByteArrayInputStream bais = new ByteArrayInputStream(buff);
        try {
            ObjectInputStream is = new ObjectInputStream(bais);
            this.sid = is.readByte();
            this.tid = is.readInt();
            this.data = is.readObject();
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public final byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(baos);
            os.writeByte(this.sid);
            os.writeInt(this.tid);
            os.writeObject(this.data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public static int objectSize(Object o2) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray().length;
    }
}

