/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectExt1;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.rm.RmAuxObject;
import com.ge.med.terra.tap.dm.rm.RmComposite;
import com.ge.med.terra.tap.dm.rm.RmImage;
import com.ge.med.terra.tap.dm.rm.RmMFImage;
import com.ge.med.terra.tap.dm.rm.RmObjectBase;
import com.ge.med.terra.tap.dm.rm.RmQueryPacket;
import com.ge.med.terra.tap.dm.rm.RmService;
import com.ge.med.terra.tap.dm.rm.RmSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class RmObject
extends RmObjectBase
implements DMiObjectExt1,
DMTagValueInterface {
    RmObject parent;
    static final DMTag[] dicomIdTags = new DMTag[4];
    RmSession session;
    final HashMap cache = new HashMap();
    int level;
    String id;
    RmComposite refComposite;
    RmComposite[] composites;
    String filePath;
    private static final DMTag NOF;
    HashMap auxMap = new HashMap();

    public RmObject(RmSession session, int type, String id) {
        this.session = session;
        this.level = type;
        this.id = id;
    }

    public RmObject(RmSession session, int type, String id, RmObject parent) {
        this(session, type, id);
        this.parent = parent;
        if (parent != null) {
            DMTag idTag;
            if (parent.composites != null) {
                DMTag idTag2 = dicomIdTags[this.level];
                Object dicomId = this.getValue(idTag2);
                ArrayList<RmComposite> list = new ArrayList<RmComposite>(parent.composites.length);
                for (int i2 = 0; i2 < parent.composites.length; ++i2) {
                    RmComposite rc = parent.composites[i2];
                    if (!dicomId.equals(rc.getValue(idTag2))) continue;
                    list.add(rc);
                }
                if (list.size() > 0) {
                    this.composites = list.toArray(new RmComposite[list.size()]);
                    this.refComposite = this.composites[0];
                }
            } else if (parent.refComposite != null && this.getValue(idTag = dicomIdTags[this.level]).equals(parent.refComposite.getValue(idTag))) {
                this.refComposite = parent.refComposite;
            }
        }
    }

    @Override
    public String getType() {
        return RmSession.LEVEL[this.level];
    }

    public void addToCache(DMTag t2, Object value) {
        this.cache.put(t2, value);
    }

    boolean cacheContains(DMTag tag2) {
        if (this.cache.containsKey(tag2)) {
            return true;
        }
        return this.parent != null && this.parent.cacheContains(tag2);
    }

    private Object cacheGet(DMTag tag2) {
        if (this.cache.containsKey(tag2)) {
            return this.cache.get(tag2);
        }
        return this.parent.cacheGet(tag2);
    }

    private void cacheResetSet(DMTag tag2, Object value) {
        if (this.cache.containsKey(tag2)) {
            this.cache.put(tag2, value);
        }
        if (this.parent != null) {
            this.parent.cacheResetSet(tag2, value);
        }
    }

    @Override
    public Object getValue(DMTag tag2) {
        if (this.cacheContains(tag2)) {
            return this.cacheGet(tag2);
        }
        if (this.refComposite != null) {
            return this.refComposite.getValue(tag2);
        }
        Tap.log.warning(tag2 + " : not in cache");
        RmQueryPacket qp = new RmQueryPacket(-1, this.id, this.level, tag2, null);
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)31, tid, qp);
        Object[] o2 = (Object[])this.session.com.waitForResponse(-31, tid);
        this.cache.put(tag2, o2[0]);
        return o2[0];
    }

    @Override
    public void getValues(DMElement[] elements) {
        DMElement[] need = new DMElement[elements.length];
        int count = 0;
        boolean[] mustGet = new boolean[elements.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            DMTag tag2 = new DMTag(elements[i2].group, elements[i2].element);
            if (this.cacheContains(tag2)) {
                elements[i2].value = this.cacheGet(tag2);
                continue;
            }
            need[count++] = elements[i2];
            Tap.log.warning(tag2 + " not in cache");
            mustGet[i2] = true;
        }
        if (count == 0) {
            return;
        }
        if (need.length != count) {
            DMElement[] need2 = new DMElement[count];
            System.arraycopy(need, 0, need2, 0, count);
            need = need2;
        }
        if (this.refComposite != null) {
            this.refComposite.getValues(need);
        } else {
            RmQueryPacket qp = new RmQueryPacket(-1, this.id, this.level, need, null);
            int tid = RmService.newTid();
            this.session.com.sendMsg((byte)32, tid, qp);
            Object values = this.session.com.waitForResponse(-32, tid);
            Object[] v2 = (Object[])values;
            int k2 = 0;
            for (int i3 = 0; i3 < elements.length; ++i3) {
                if (!mustGet[i3]) continue;
                elements[i3].value = v2[k2++];
            }
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        RmQueryPacket qp = new RmQueryPacket(-1, this.id, this.level, elements, null);
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)33, tid, qp);
        this.session.com.waitForResponse(-33, tid);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            DMTag tag2 = new DMTag(elements[i2].group, elements[i2].element);
            this.cacheResetSet(tag2, elements[i2].value);
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        if (this.composites != null) {
            if (q2 == null) {
                return this.composites;
            }
            ArrayList<RmComposite> list = new ArrayList<RmComposite>(this.composites.length);
            for (int i2 = 0; i2 < this.composites.length; ++i2) {
                RmComposite rc = this.composites[i2];
                if (!q2.valid(rc)) continue;
                list.add(rc);
            }
            return list.toArray(new DMiComposite[list.size()]);
        }
        RmQueryPacket qp = new RmQueryPacket(0, this.id, this.level, null, this.qtoString(q2));
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)35, tid, qp);
        Object o2 = this.session.com.waitForResponse(-35, tid);
        String[] id = (String[])o2;
        DMiComposite[] dmc = new RmComposite[id.length];
        for (int i3 = 0; i3 < dmc.length; ++i3) {
            dmc[i3] = (RmComposite)this.session.getComposite(id[i3]);
        }
        if (q2 == null) {
            this.composites = dmc;
        }
        if (dmc.length > 0) {
            this.refComposite = dmc[0];
        }
        return dmc;
    }

    @Override
    public int getNumberOfComposites(DMQuery q2) {
        if (this.composites != null) {
            int count = 0;
            for (int i2 = 0; i2 < this.composites.length; ++i2) {
                if (!q2.valid(this.composites[i2])) continue;
                ++count;
            }
            return count;
        }
        RmQueryPacket qp = new RmQueryPacket(0, this.id, this.level, null, this.qtoString(q2));
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)35, tid, qp);
        Object o2 = this.session.com.waitForResponse(-35, tid);
        String[] id = (String[])o2;
        return id.length;
    }

    private String qtoString(DMQuery q2) {
        if (q2 == null) {
            return null;
        }
        return q2.toString();
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q2) {
        int relLevel = RmSession.getLevel(ieType);
        RmQueryPacket qp = new RmQueryPacket(relLevel, this.id, this.level, null, this.qtoString(q2));
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)34, tid, qp);
        Object o2 = this.session.com.waitForResponse(-34, tid);
        String[] id = (String[])o2;
        DMiObject[] dmo = new RmObject[id.length];
        for (int i2 = 0; i2 < dmo.length; ++i2) {
            dmo[i2] = new RmObject(this.session, relLevel, id[i2], relLevel > this.level ? this : null);
            if (relLevel >= this.level) continue;
            ((RmObject)dmo[i2]).refComposite = this.refComposite;
        }
        return dmo;
    }

    @Override
    public void getRelated(String ieType, DMQuery q2, DMiObjectReceiver cb) {
        Tap.log.fine("getRelated(\"" + ieType + "\",\"" + q2 + "\",...");
        int[][] tags = null;
        int relLevel = RmSession.getLevel(ieType);
        if (relLevel == this.level) {
            if (q2 == null || q2.valid(this)) {
                cb.gotOne(this);
            }
            return;
        }
        tags = this.session.prefetch[relLevel];
        RmQueryPacket p2 = new RmQueryPacket(relLevel, this.id, this.level, tags, this.qtoString(q2));
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)36, tid, p2);
        Object[] lastOarray = null;
        boolean cont = true;
        do {
            Object o2 = this.session.com.waitForResponse(-36, tid);
            Vector v2 = (Vector)o2;
            Iterator iter = v2.iterator();
            while (iter.hasNext() && cont) {
                lastOarray = (Object[])iter.next();
                if (lastOarray == null) continue;
                String id = (String)lastOarray[0];
                RmObject obj = new RmObject(this.session, relLevel, id, relLevel > this.level ? this : null);
                if (relLevel < this.level) {
                    obj.refComposite = this.refComposite;
                }
                int off = 1;
                if (tags != null) {
                    if (tags.length + 2 == lastOarray.length && relLevel == 3) {
                        obj.filePath = (String)lastOarray[1];
                        off = 2;
                    }
                    for (int k2 = 0; k2 < tags.length; ++k2) {
                        obj.addToCache(new DMTag(tags[k2][0], tags[k2][1]), lastOarray[k2 + off]);
                    }
                }
                cont = cb.gotOne(obj);
            }
        } while (lastOarray != null && cont);
        if (!cont) {
            this.session.com.sendMsg((byte)37, tid, "");
            this.session.com.waitForResponse(-4, tid);
            this.session.com.clearResponse(-36, tid);
        }
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q2) {
        int retLevel = RmSession.getLevel(ieType);
        RmQueryPacket qp = new RmQueryPacket(retLevel, this.id, this.level, null, this.qtoString(q2));
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)38, tid, qp);
        Object o2 = this.session.com.waitForResponse(-38, tid);
        return (Integer)o2;
    }

    @Override
    public void delete() {
        RmQueryPacket qp = new RmQueryPacket(0, this.id, this.level, null, null);
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)42, tid, qp);
        this.session.com.waitForResponse(-42, tid);
    }

    @Override
    public int getLock() {
        return 0;
    }

    @Override
    public void setLock(int lockType) {
    }

    @Override
    public DMTag[] getTags() {
        return null;
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        if (this.images == null) {
            final ArrayList al2 = new ArrayList();
            this.getRelated("image", null, new DMiObjectReceiver(){

                @Override
                public boolean gotOne(DMiObject o2) {
                    String str;
                    Object value = o2.getValue(NOF);
                    int frames = null == value ? 1 : Integer.parseInt(str.substring((str = ((String)value).trim()).charAt(0) == '+' ? 1 : 0));
                    if (frames == 1) {
                        for (int i2 = 0; i2 < frames; ++i2) {
                            al2.add(new RmImage((RmObject)o2, i2));
                        }
                    } else {
                        if (((RmObject)o2).filePath == null) {
                            throw new DMException("image object should have the filePath set");
                        }
                        for (int i3 = 0; i3 < frames; ++i3) {
                            al2.add(new RmMFImage((RmObject)o2, i3));
                        }
                    }
                    return true;
                }
            });
            this.images = al2.toArray(new DMiImage[al2.size()]);
        } else {
            for (int i2 = 0; i2 < this.images.length; ++i2) {
                this.images[i2].preLoad();
            }
        }
        return this.images;
    }

    @Override
    public DMAuxObject getAuxObject(String type, Properties info) {
        if (!this.auxMap.containsKey(type)) {
            RmAuxObject aux = new RmAuxObject(this, type, info);
            this.auxMap.put(type, aux);
        }
        return (DMAuxObject)this.auxMap.get(type);
    }

    @Override
    public Object send(String[] str) {
        if (str.length > 0 && "loadComposite".equals(str[0])) {
            try {
                DMiComposite[] c2 = this.getComposites(null);
                for (int i2 = 0; i2 < c2.length; ++i2) {
                    ((RmComposite)c2[i2]).waitForComposite();
                }
            }
            catch (InterruptedException e2) {
                throw new DMException(e2);
            }
            return "OK";
        }
        return null;
    }

    static {
        RmObject.dicomIdTags[0] = new DMTag(16, 32);
        RmObject.dicomIdTags[1] = new DMTag(32, 13);
        RmObject.dicomIdTags[2] = new DMTag(32, 14);
        RmObject.dicomIdTags[3] = new DMTag(8, 24);
        NOF = new DMTag(40, 8);
    }
}

