/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjCompressor;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.rm.BigHeaderFix;
import com.ge.med.terra.tap.dm.rm.IntHashSet;
import com.ge.med.terra.tap.dm.rm.Msg;
import com.ge.med.terra.tap.dm.rm.RemoteEvent;
import com.ge.med.terra.tap.dm.rm.RmImage;
import com.ge.med.terra.tap.dm.rm.RmQueryPacket;
import com.ge.med.terra.tap.dm.rm.RmServerBase;
import com.ge.med.terra.tap.dm.rm.RmService;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.Ftp;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;

public class RmServer
extends RmServerBase {
    DMSession dms;
    RmService com;
    Ftp ftp;
    File importDir;
    private XjCompressor iDicomComp;
    HashMap hCompressedFiles = null;
    private static final String strTaskMessageSeparator = "||";
    DMEventListener eventHandle = new DMEventListener(){

        @Override
        public void actionPerformed(DMEvent e2) {
            RmServer.this.com.sendMsg((byte)72, 0, new RemoteEvent(e2));
        }
    };
    Vector asyncTask = new Vector();
    IntHashSet continueSet = new IntHashSet(25);
    protected Vector installQueue = new Vector();
    protected Vector sendFileQueue = new Vector();
    protected Vector fileList = new Vector();
    protected Timer timer = new Timer();
    private TimerTask timerTask = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File[] files;
            Vector vector = RmServer.this.fileList;
            synchronized (vector) {
                files = RmServer.this.fileList.toArray(new File[RmServer.this.fileList.size()]);
                RmServer.this.fileList.clear();
            }
            try {
                RmServer.this.dms.installFiles(files, true);
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Unable to install DICOM files: ", ex);
            }
        }
    };
    TaskMonitor tel = new TaskMonitor(){

        @Override
        public void taskFailed(String taskName, String reason, Exception e2) {
            String strCompressFile = taskName.substring(taskName.indexOf(RmServer.strTaskMessageSeparator) + 2);
            String strDestFile = (String)RmServer.this.hCompressedFiles.get(strCompressFile);
            String strSrcFile = taskName.substring(0, taskName.indexOf(RmServer.strTaskMessageSeparator));
            String strMessageID = strDestFile.substring(strDestFile.indexOf(RmServer.strTaskMessageSeparator) + 2);
            strDestFile = strDestFile.substring(0, strDestFile.indexOf(RmServer.strTaskMessageSeparator));
            RmServer.this.ftp.putFile(strSrcFile, strDestFile);
            RmServer.this.hCompressedFiles.remove(strCompressFile);
            RmServer.this.com.sendMsg((byte)-63, Integer.parseInt(strMessageID), "nocompress");
        }

        @Override
        public void taskBegin(String taskName, int totalWork) {
        }

        @Override
        public void taskDone(String taskName) {
            String strDestFile = (String)RmServer.this.hCompressedFiles.get(taskName);
            String strMessageID = strDestFile.substring(strDestFile.indexOf(RmServer.strTaskMessageSeparator) + 2);
            strDestFile = strDestFile.substring(0, strDestFile.indexOf(RmServer.strTaskMessageSeparator));
            RmServer.this.ftp.putFile(taskName, strDestFile + ".comp");
            RmServer.this.hCompressedFiles.remove(taskName);
            File f2 = new File(taskName);
            f2.delete();
            RmServer.this.com.sendMsg((byte)-63, Integer.parseInt(strMessageID), "compress");
        }

        @Override
        public void taskProgress(String taskName, int units) {
        }
    };

    public RmServer(RmService com) {
        this.com = com;
        Thread t2 = new Thread(){

            @Override
            public void run() {
                RmServer.this.asyncSupport();
            }
        };
        t2.setDaemon(true);
        t2.setName("Async Support");
        t2.start();
        Thread installThread = new Thread(){

            @Override
            public void run() {
                RmServer.this.asyncInstall();
            }
        };
        installThread.setDaemon(true);
        installThread.setName("Async Image Install Thread");
        installThread.start();
        Thread sendFileThread = new Thread(){

            @Override
            public void run() {
                RmServer.this.asyncFileSend();
            }
        };
        sendFileThread.setDaemon(true);
        sendFileThread.setName("Async File Send Thread");
        sendFileThread.start();
        this.ftp = new Ftp(com.client);
    }

    public static void pl(String[] a2) {
        if (0 < a2.length) {
            StringBuffer buf = new StringBuffer(256 * a2.length);
            for (int i2 = 0; i2 < a2.length; ++i2) {
                buf.append((i2 == 0 ? "" : ",") + a2[i2]);
            }
            Tap.log.log(Level.FINE, buf.toString() + SimpleUtilities.getLineSeparator());
        }
    }

    @Override
    protected DMObject getObj(RmQueryPacket qp) {
        return this.dms.getDMObject(RmQueryPacket.levels[qp.srcLevel], qp.id);
    }

    public Msg processMessage(Msg message) {
        if (Tap.log.isLoggable(Level.FINEST)) {
            Tap.log.log(Level.FINEST, "TAP RmServer: processMessage {0}", Msg.getMessageDetails(message));
        }
        try {
            switch (message.sid) {
                case 1: {
                    String[] config = (String[])message.data;
                    for (int j2 = 0; j2 < config.length; ++j2) {
                        Tap.log.log(Level.FINE, ">{0}", config[j2]);
                        if (config[j2] == null || !config[j2].startsWith("$")) continue;
                        String s2 = System.getProperty(config[j2].substring(1));
                        if (s2 == null) {
                            Tap.log.log(Level.WARNING, "You must define system property \"{0}\"", config[j2].substring(1));
                            continue;
                        }
                        Tap.log.log(Level.FINE, "changing {0} to {1}", new Object[]{config[j2], s2});
                        config[j2] = s2;
                    }
                    this.dms = DMSession.getSession(config);
                    RmServer.pl((String[])message.data);
                    return new Msg(-1, message.tid, "ok");
                }
                case 31: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMTag tag2 = (DMTag)qp.info;
                    DMObject dmo = this.getObj(qp);
                    Object value = dmo.getValue(tag2);
                    return new Msg(-31, message.tid, new Object[]{value});
                }
                case 34: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject dmo = this.getObj(qp);
                    String type = RmQueryPacket.levels[qp.retLevel];
                    DMObject[] related = dmo.getRelated(type, RmServer.makeQuery(qp));
                    String[] ids = new String[related.length];
                    for (int i2 = 0; i2 < related.length; ++i2) {
                        ids[i2] = related[i2].getID();
                    }
                    return new Msg(-34, message.tid, ids);
                }
                case 38: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject dmo = this.getObj(qp);
                    String type = RmQueryPacket.levels[qp.retLevel];
                    int n2 = dmo.getNumberOfRelated(type);
                    return new Msg(-38, message.tid, new Integer(n2));
                }
                case 35: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject dmo = this.getObj(qp);
                    DMComposite[] dmc = dmo.getComposites();
                    String[] ids = new String[dmc.length];
                    for (int i3 = 0; i3 < dmc.length; ++i3) {
                        ids[i3] = dmc[i3].getID();
                    }
                    return new Msg(-35, message.tid, ids);
                }
                case 40: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject dmo = this.getObj(qp);
                    DMTag[] tags = (DMTag[])qp.info;
                    DMImage[] dmi = dmo.getImages(tags);
                    RmImage.Info[] info = new RmImage.Info[dmi.length];
                    for (int i4 = 0; i4 < dmi.length; ++i4) {
                        info[i4] = new RmImage.Info(dmi[i4].getComposite().getID(), dmi[i4].getFrameNumber());
                    }
                    return new Msg(-40, message.tid, info);
                }
                case 33: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject dmo = this.getObj(qp);
                    DMElement[] dme = (DMElement[])qp.info;
                    dmo.setValues(dme);
                    return new Msg(-33, message.tid, "ok");
                }
                case 32: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject dmo = this.getObj(qp);
                    DMElement[] dme = (DMElement[])qp.info;
                    dmo.getValues(dme);
                    Object[] values = new Object[dme.length];
                    for (int i5 = 0; i5 < dme.length; ++i5) {
                        values[i5] = dme[i5].value;
                    }
                    return new Msg(-32, message.tid, values);
                }
                case 12: {
                    int[] v2 = (int[])message.data;
                    this.dms.addDMEventListener(v2[0], v2[1], this.eventHandle);
                    return null;
                }
                case 2: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject[] dmo = this.dms.getRelated(RmQueryPacket.levels[qp.retLevel], RmServer.makeQuery(qp));
                    int[][] tags = (int[][])qp.info;
                    DMElement[] dme = new DMElement[tags == null ? 0 : tags.length];
                    for (int i6 = 0; i6 < dme.length; ++i6) {
                        dme[i6] = new DMElement(tags[i6][0], tags[i6][1]);
                    }
                    Object[][] pack = new Object[dmo.length][dme.length + 1];
                    for (int i7 = 0; i7 < dmo.length; ++i7) {
                        pack[i7][0] = dmo[i7].getID();
                        dmo[i7].getValues(dme);
                        for (int k2 = 0; k2 < dme.length; ++k2) {
                            pack[i7][k2 + 1] = dme[k2].value;
                        }
                    }
                    return new Msg(-2, message.tid, pack);
                }
                case 3: {
                    this.asyncGetRelated(message);
                    break;
                }
                case 36: {
                    this.asyncGetRelated(message);
                    break;
                }
                case 4: 
                case 37: {
                    if (this.continueSet.contains(message.tid)) {
                        this.continueSet.remove(message.tid);
                        return null;
                    }
                    return new Msg(-4, message.tid, "ok");
                }
                case 61: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMComposite dmc = this.dms.getComposite(qp.id);
                    DMTag tag3 = (DMTag)qp.info;
                    Object value = dmc.getValue(tag3);
                    return new Msg(-61, message.tid, new Object[]{value});
                }
                case 6: {
                    int n3 = this.dms.getNumberOfComposites();
                    return new Msg(-6, message.tid, new Integer(n3));
                }
                case 5: {
                    DMComposite[] dmc = this.dms.getComposites();
                    String[] ids = new String[dmc.length];
                    for (int i8 = 0; i8 < ids.length; ++i8) {
                        ids[i8] = dmc[i8].getID();
                    }
                    return new Msg(-5, message.tid, ids);
                }
                case 8: {
                    String str = (String)message.data;
                    if (str.startsWith("ICOMPRESS=")) {
                        this.setCompressionSettings(str.substring("ICOMPRESS=".length()), message.tid);
                        return new Msg(-8, message.tid, "ok");
                    }
                    this.dms.send(str);
                    return new Msg(-8, message.tid, "ok");
                }
                case 11: {
                    this.install(message);
                    break;
                }
                case 9: {
                    this.dms.close();
                    return new Msg(-9, message.tid, "ok");
                }
                case 10: {
                    this.dms.ClearCache();
                    return new Msg(-10, message.tid, "ok");
                }
                case 62: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMComposite dmc = this.dms.getComposite(qp.id);
                    DMElement[] dme = (DMElement[])qp.info;
                    dmc.getValues(dme);
                    Object[] values = new Object[dme.length];
                    for (int i9 = 0; i9 < dme.length; ++i9) {
                        values[i9] = dme[i9].value;
                    }
                    return new Msg(-62, message.tid, values);
                }
                case 63: {
                    this.pushFile(message);
                    break;
                }
                case 41: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    String[] sessionArgs = (String[])qp.info;
                    DMSession session = DMSession.getSession(sessionArgs);
                    DMObject dmo = session.getDMObject(RmQueryPacket.levels[qp.srcLevel], qp.id);
                    this.dms.save(dmo);
                    return new Msg(-41, message.tid, "ok");
                }
                case 42: {
                    RmQueryPacket qp = (RmQueryPacket)message.data;
                    DMObject dmo = this.getObj(qp);
                    dmo.delete();
                    return new Msg(-42, message.tid, "ok");
                }
                case 71: {
                    return this.msgAgetIstream(message);
                }
                default: {
                    throw new IllegalArgumentException("Invalid message type: " + message.sid);
                }
            }
        }
        catch (Exception e2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e2.printStackTrace(new PrintStream(baos));
            String str = "Caused by \"" + e2.toString() + "\" ON SERVER\n" + new String(baos.toByteArray());
            return new Msg((byte)(-1 * message.sid), message.tid, new DMException(str));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncGetRelated(Msg message) {
        Vector vector = this.asyncTask;
        synchronized (vector) {
            this.asyncTask.add(message);
            this.asyncTask.notifyAll();
        }
    }

    public void anyncSessionGetRelated(Msg message, final RmQueryPacket qp) {
        final int tid = message.tid;
        int[][] tags = (int[][])qp.info;
        final DMElement[] dme = new DMElement[tags == null ? 0 : tags.length];
        for (int i2 = 0; i2 < dme.length; ++i2) {
            dme[i2] = new DMElement(tags[i2][0], tags[i2][1]);
        }
        final boolean[] gotone = new boolean[1];
        DMObjectReceiver cb = new DMObjectReceiver(){

            @Override
            public boolean gotOne(DMObject o2) {
                Object[] pack;
                Vector<Object[]> v2 = new Vector<Object[]>();
                o2.getValues(dme);
                if ("image".equalsIgnoreCase(o2.getType()) && null == o2.getValue(8, 82)) {
                    pack = new Object[dme.length + 2];
                    pack[0] = o2.getID();
                    pack[1] = o2.getComposites()[0].getFilePath();
                    for (int k2 = 2; k2 < pack.length; ++k2) {
                        pack[k2] = dme[k2 - 2].value;
                    }
                    v2.add(pack);
                } else {
                    pack = new Object[dme.length + 1];
                    pack[0] = o2.getID();
                    for (int k3 = 1; k3 < pack.length; ++k3) {
                        pack[k3] = dme[k3 - 1].value;
                    }
                    v2.add(pack);
                }
                gotone[0] = true;
                byte sid = qp.id == null ? (byte)-3 : -36;
                RmServer.this.com.sendMsg(sid, tid, v2);
                if (!RmServer.this.continueSet.contains(tid)) {
                    Tap.log.log(Level.FINE, "#abort: The continue set does not contain tid={0}", tid);
                }
                return RmServer.this.continueSet.contains(tid);
            }
        };
        if (qp.id == null) {
            Tap.log.log(Level.INFO, "dms.getRelated(\"{0}\"...", RmQueryPacket.levels[qp.retLevel]);
            this.dms.getRelated(RmQueryPacket.levels[qp.retLevel], RmServer.makeQuery(qp), cb);
            Tap.log.info("... end dms.getRelated");
            if (!gotone[0]) {
                Tap.log.warning("Nothing returned from dms.getRelated");
            }
        } else {
            DMObject src = this.getObj(qp);
            Tap.log.log(Level.INFO, "dmo.getRelated(\"{0}\"...", RmQueryPacket.levels[qp.retLevel]);
            src.getRelated(RmQueryPacket.levels[qp.retLevel], RmServer.makeQuery(qp), cb);
            Tap.log.info("... end dmo.getRelated");
            if (!gotone[0]) {
                Tap.log.warning("Nothing returned from dmo.getRelated");
            }
        }
        if (this.continueSet.contains(tid)) {
            this.continueSet.remove(tid);
            Vector<Object> v2 = new Vector<Object>();
            v2.add(null);
            byte sid = qp.id == null ? (byte)-3 : -36;
            this.com.sendMsg(sid, tid, v2);
        } else {
            this.com.sendMsg((byte)-4, tid, "ok");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncSupport() {
        while (true) {
            RmQueryPacket qp;
            Msg message;
            Vector vector = this.asyncTask;
            synchronized (vector) {
                while (this.asyncTask.isEmpty()) {
                    try {
                        this.asyncTask.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                message = (Msg)this.asyncTask.remove(0);
                qp = (RmQueryPacket)message.data;
                this.continueSet.add(message.tid);
            }
            try {
                this.anyncSessionGetRelated(message, qp);
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Error calling asyncSessionGetRelated( Msg, RmQueryPacket ): ", ex);
            }
            this.continueSet.remove(message.tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(Msg message) {
        Vector vector = this.installQueue;
        synchronized (vector) {
            this.installQueue.add(message);
            this.installQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushFile(Msg message) {
        Vector vector = this.sendFileQueue;
        synchronized (vector) {
            this.sendFileQueue.add(message);
            this.sendFileQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncInstall() {
        while (true) {
            Msg message;
            Vector vector = this.installQueue;
            synchronized (vector) {
                while (this.installQueue.isEmpty()) {
                    try {
                        this.installQueue.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                message = (Msg)this.installQueue.remove(0);
            }
            try {
                String path = (String)message.data;
                if (this.importDir == null) {
                    this.importDir = this.getImportDir();
                }
                File file = File.createTempFile("image", "", this.importDir);
                file.deleteOnExit();
                this.ftp.getFile(path, file.getAbsolutePath());
                this.fileList.add(file);
                this.timer.schedule(this.timerTask, 2000L);
                this.com.sendMsg((byte)-11, message.tid, "ok");
                continue;
            }
            catch (Exception e2) {
                Tap.log.log(Level.WARNING, "Unable to install files asynchronously: ", e2);
                continue;
            }
            break;
        }
    }

    private void setCompressionSettings(String strCompressArgs, int iSessionID) {
        this.iDicomComp = null;
        if (!strCompressArgs.equalsIgnoreCase("null")) {
            try {
                this.iDicomComp = (XjCompressor)Class.forName(strCompressArgs).newInstance();
                this.iDicomComp.addTaskEventListener(this.tel);
                this.hCompressedFiles = new HashMap();
            }
            catch (IllegalAccessException iae) {
                Tap.log.log(Level.WARNING, "Unable to set compression settings: ", iae);
            }
            catch (ClassNotFoundException cnfe) {
                Tap.log.log(Level.WARNING, "Unable to set compression settings: ", cnfe);
            }
            catch (InstantiationException ie) {
                Tap.log.log(Level.WARNING, "Unable to set compression settings: ", ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncFileSend() {
        while (true) {
            Msg message;
            Vector vector = this.sendFileQueue;
            synchronized (vector) {
                while (this.sendFileQueue.isEmpty()) {
                    try {
                        this.sendFileQueue.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                message = (Msg)this.sendFileQueue.remove(0);
            }
            try {
                RmQueryPacket qp = (RmQueryPacket)message.data;
                final DMComposite dmc = this.dms.getComposite(qp.id);
                String destFile = (String)qp.info;
                String srcFile = dmc.getFilePath();
                boolean allowCompress = true;
                if (destFile.endsWith(".uncomp")) {
                    allowCompress = false;
                    destFile = destFile.substring(0, destFile.indexOf(".uncomp"));
                }
                XjDicomObject dcmWrap = new XjDicomObject(){

                    @Override
                    public Object getValue(int iGroup, int iElement) {
                        Object value = null;
                        try {
                            value = dmc.getValue(iGroup, iElement);
                        }
                        catch (Exception ex) {
                            Tap.log.log(Level.WARNING, "Error during getValue(" + tagValue.atToString(iGroup, iElement) + "): ", ex);
                        }
                        return value;
                    }

                    @Override
                    public int getValues(XjTagValue[] xjTagVals) {
                        DMElement[] dmElems = DMElement.genDMelements(xjTagVals);
                        try {
                            dmc.getValues(dmElems);
                        }
                        catch (Exception ex) {
                            Tap.log.log(Level.WARNING, "Error during getValues: ", ex);
                        }
                        for (int i2 = 0; i2 < dmElems.length; ++i2) {
                            xjTagVals[i2] = dmElems[i2].getXjTagValue(xjTagVals[i2]);
                        }
                        return dmElems.length;
                    }
                };
                BigHeaderFix bigHeaderFix = new BigHeaderFix(srcFile);
                boolean stripHeader = bigHeaderFix.isBigHeader();
                Tap.log.log(Level.FINER, "stripHeader = {0}", stripHeader);
                boolean compress = !stripHeader && allowCompress && this.iDicomComp != null && this.iDicomComp.isCompressible(dcmWrap);
                Tap.log.log(Level.FINER, "compress = {0}, allowCompress = {1}", new Object[]{String.valueOf(compress), String.valueOf(allowCompress)});
                boolean processFlag = stripHeader || compress;
                Tap.log.log(Level.FINE, "processFlag = {0}", processFlag);
                if (processFlag) {
                    String processedFileName;
                    File processedFile;
                    File tmpImgDir = new File(SimpleUtilities.getTempDir() + File.separator + "rmimages");
                    if (!tmpImgDir.exists()) {
                        tmpImgDir.mkdir();
                    }
                    if (stripHeader) {
                        processedFile = File.createTempFile("rmimage.", "", tmpImgDir);
                        processedFileName = processedFile.getAbsolutePath();
                        bigHeaderFix.removeBigHeader(processedFileName);
                        this.ftp.putFile(processedFileName, destFile);
                        this.com.sendMsg((byte)-63, message.tid, "nocompress");
                        boolean deleted = processedFile.delete();
                        if (deleted) continue;
                        Tap.log.log(Level.WARNING, "Unable to delete temporary file without the big header: {0}", processedFile);
                        continue;
                    }
                    if (!compress) continue;
                    processedFile = File.createTempFile("rmimage.", ".comp", tmpImgDir);
                    processedFileName = processedFile.getAbsolutePath();
                    this.hCompressedFiles.put(processedFileName, destFile + strTaskMessageSeparator + message.tid);
                    this.iDicomComp.compress(srcFile, processedFileName);
                    continue;
                }
                this.ftp.putFile(srcFile, destFile);
                this.com.sendMsg((byte)-63, message.tid, "nocompress");
                continue;
            }
            catch (Exception e2) {
                Tap.log.log(Level.WARNING, "Unable to send file asynchronously: ", e2);
                continue;
            }
            break;
        }
    }

    public static DMQuery makeQuery(RmQueryPacket qp) {
        Tap.log.log(Level.FINE, "qp.query = {0}", qp.query);
        return qp.query == null ? null : new DMQuery(qp.query);
    }

    private File getImportDir() {
        File dir;
        String dirPath = null;
        try {
            String[] results = this.dms.send("IMPORTDIR");
            if (results != null && results.length == 1) {
                dirPath = results[0];
            }
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Failed to get IMPORTDIR: ", e2);
        }
        if (dirPath == null && (dirPath = System.getProperty("IMPORTDIR")) == null) {
            dirPath = SimpleUtilities.getTempDir() + File.separator + "remoteImport";
        }
        if ((dir = new File(dirPath)).exists()) {
            File[] files = dir.listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                files[i2].delete();
            }
        } else {
            dir.mkdirs();
        }
        return dir;
    }
}

