/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.sessionFile.fileSession;
import com.ge.med.terra.tap.util.SimpleUtilitiesBase;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class peerToPeerComm {
    private static final int broadCastNo = 6789;
    private static final String broadCastIP = "229.5.6.7";
    private InetAddress addr;
    private MulticastSocket ms;
    private String UID;
    private WeakReference session;
    private String dir;
    private Thread daemon;
    private boolean interrupt;

    public peerToPeerComm(String dir, fileSession session) {
        block5: {
            this.interrupt = false;
            try {
                if (dir == null) {
                    return;
                }
                this.dir = dir.replace('\\', '/');
                this.UID = Long.toHexString(System.currentTimeMillis() + (long)session.hashCode());
                this.session = new WeakReference<fileSession>(session);
                this.addr = InetAddress.getByName(broadCastIP);
                this.ms = new MulticastSocket(6789);
                try {
                    this.ms.joinGroup(this.addr);
                }
                catch (Exception e2) {
                    System.out.println("Exception when peerToPeerComm tried to join group");
                    return;
                }
                this.daemon = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        peerToPeerComm.this.serverListen();
                    }
                });
                this.daemon.setName("peerToPeerComm Listen for event");
                this.daemon.setDaemon(true);
                this.daemon.start();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedIOException) break block5;
                ex.printStackTrace();
            }
        }
    }

    public void killThread() {
        try {
            this.interrupt = true;
            this.daemon.interrupt();
            this.ms.leaveGroup(this.addr);
            this.ms.close();
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
        }
    }

    public void sendMessage(String msg) {
        String data = this.dir + "]" + this.UID + "]" + msg;
        DatagramPacket dp = new DatagramPacket(data.getBytes(), data.length(), this.addr, 6789);
        try {
            if (this.ms != null) {
                this.ms.send(dp);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void serverListen() {
        byte[] buf = new byte[1000];
        try {
            Tap.log.log(Level.FINE, "{0}: Start listening to events", this.dir);
            DatagramPacket rp = new DatagramPacket(buf, buf.length);
            while (true) {
                this.ms.receive(rp);
                byte[] data = rp.getData();
                String str = new String(rp.getData(), rp.getOffset(), rp.getLength());
                final StringTokenizer st = new StringTokenizer(str, "]");
                String rdir = st.nextToken();
                String sourceID = st.nextToken();
                rdir.replace('\\', '/');
                Tap.log.log(Level.FINE, "{0}: Processing event {0} {1}", new Object[]{rdir, sourceID});
                if (!this.dir.equalsIgnoreCase(rdir) || sourceID.equals(this.UID)) continue;
                SimpleUtilitiesBase.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((fileSession)peerToPeerComm.this.session.get()).recivedEvent(st.nextToken("").substring(1));
                    }
                });
            }
        }
        catch (Exception ex) {
            if (ex instanceof SocketException && this.interrupt) {
                Tap.log.log(Level.FINE, "{0}: Stop listening to events", this.dir);
            } else {
                ex.printStackTrace();
            }
            return;
        }
    }
}

