/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.sql.SqlComposite;
import com.ge.med.terra.tap.dm.sql.SqlObject;
import com.ge.med.terra.tap.dm.sql.SqlSession;
import com.ge.med.terra.tap.dm.sql.SqlStudyObject;
import com.ge.med.terra.tap.dm.sql.SqlUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlPatientObject
extends SqlObject {
    static final Map tagToColumnMap = new HashMap();
    static final Map columnToTagMap;

    public SqlPatientObject(SqlSession session, ResultSet rs) throws SQLException {
        super(session, rs, columnToTagMap);
        this.level = 0;
        this.id = (String)this.cache.get(new DMTag(1, 256));
    }

    @Override
    protected SqlObject getParent() {
        return null;
    }

    @Override
    protected List getChildren(DMQuery q2) {
        ArrayList<SqlStudyObject> children = new ArrayList<SqlStudyObject>();
        try {
            String str = SqlUtils.getSqlString(q2, SqlStudyObject.tagToColumnMap);
            str = str.length() > 0 ? " AND " + str : str;
            String sort = (String)SqlStudyObject.tagToColumnMap.get(this.session.getSortTag(1));
            sort = sort == null || columnToTagMap.containsKey(sort) ? "" : " ORDER BY " + sort;
            String query = "SELECT * FROM examination_folder WHERE patient_id = '" + this.id + "'" + str + sort + ";";
            ResultSet rs = this.session.con.createStatement().executeQuery(query);
            while (rs.next()) {
                children.add(new SqlStudyObject(this.session, rs));
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return children;
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        ArrayList list = new ArrayList();
        try {
            ResultSet rs = this.session.getPatientComposites(this.id);
            while (rs.next()) {
                String seriesId = rs.getString(1);
                String tableName = rs.getString(2);
                list.addAll(this.getComposites(q2, seriesId, tableName));
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return this.filterComposites(list, q2);
    }

    @Override
    protected SqlComposite getComposite() {
        if (this.composite == null || !this.composite.file.exists()) {
            try {
                ResultSet rs = this.session.getAPatientComposite(this.id);
                if (rs.next()) {
                    String seriesId = rs.getString(1);
                    String tableName = rs.getString(2);
                    this.composite = this.getComposite(seriesId, tableName);
                }
                rs.close();
            }
            catch (SQLException e2) {
                throw new DMException(e2);
            }
        }
        return this.composite;
    }

    static {
        tagToColumnMap.put(new DMTag(16, 16), "patient_name");
        tagToColumnMap.put(new DMTag(16, 32), "orgl_patient_id");
        tagToColumnMap.put(new DMTag(1, 256), "patient_id");
        tagToColumnMap.put(new DMTag(1, 257), "patient_key");
        tagToColumnMap.put(new DMTag(1, 258), "patientfolder_path");
        tagToColumnMap.put(new DMTag(1, 259), "folder_creat_date");
        tagToColumnMap.put(new DMTag(1, 260), "total_exams");
        tagToColumnMap.put(new DMTag(1, 261), "birthdate");
        tagToColumnMap.put(new DMTag(1, 262), "maiden_name");
        tagToColumnMap.put(new DMTag(1, 263), "first_exam_uid");
        tagToColumnMap.put(new DMTag(1, 264), "name_kanji");
        tagToColumnMap.put(new DMTag(1, 265), "name_kana");
        tagToColumnMap.put(new DMTag(1, 272), "archive_flag");
        tagToColumnMap.put(new DMTag(1, 273), "delete");
        tagToColumnMap.put(new DMTag(1, 274), "hidden");
        tagToColumnMap.put(new DMTag(1, 275), "font_name");
        tagToColumnMap.put(new DMTag(1, 276), "last_study_date");
        tagToColumnMap.put(new DMTag(1, 277), "eligible");
        tagToColumnMap.put(new DMTag(1, 278), "update_timestamp");
        tagToColumnMap.put(new DMTag(1, 279), "committed");
        tagToColumnMap.put(new DMTag(1, 280), "print");
        tagToColumnMap.put(new DMTag(1, 281), "sent");
        columnToTagMap = SqlUtils.getReverse(tagToColumnMap);
    }
}

