/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;

public class ChangeDicom {
    int date_delta = 0;
    int time_delta = 0;
    int hashShift = 0;
    int randShift = 0;
    public static SimpleDateFormat dicomTMformat = new SimpleDateFormat("HHmmss");
    public static SimpleDateFormat dicomDAformat = new SimpleDateFormat("yyyyMMdd");
    dicomParser p = new dicomParser();
    tagValue[] tv = null;
    tagValue[] patientLevel = new tagValue[]{new tagValue(8, 24), new tagValue(8, 32), new tagValue(8, 48), new tagValue(8, 128), new tagValue(16, 16), new tagValue(16, 32), new tagValue(32, 13), new tagValue(32, 14)};
    tagValue[] examLevel = new tagValue[]{new tagValue(8, 24), new tagValue(8, 32), new tagValue(8, 48), new tagValue(16, 32), new tagValue(32, 13), new tagValue(32, 14)};
    tagValue[] seriesLevel = new tagValue[]{new tagValue(8, 24), new tagValue(32, 14)};
    tagValue[] imageLevel = new tagValue[]{new tagValue(8, 24)};
    public static final byte PATIENT_LEVEL = 0;
    public static final byte STUDY_LEVEL = 1;
    public static final byte SERIES_LEVEL = 2;
    public static final byte IMAGE_LEVEL = 3;
    Random r = new Random();
    Vector que;
    String[] workkingOn = new String[1];
    HashSet unique = new HashSet();

    public void setLevel(byte level) {
        this.tv = (new tagValue[][]{this.patientLevel, this.examLevel, this.seriesLevel, this.imageLevel})[level];
    }

    public static String[] listAllFiles(String baseDir) {
        ArrayList list = new ArrayList();
        ChangeDicom.listAllFiles(new File(baseDir), list);
        return list.toArray(new String[list.size()]);
    }

    private String getName(int len) {
        Random r2 = new Random(this.hashShift);
        long l2 = r2.nextLong();
        String p2 = "p" + l2;
        while (p2.length() < len) {
            p2 = p2 + l2;
        }
        return p2.substring(0, len);
    }

    private static void listAllFiles(File dir, ArrayList list) {
        File[] f2 = dir.listFiles();
        for (int i2 = 0; i2 < f2.length; ++i2) {
            if (f2[i2].isDirectory()) {
                ChangeDicom.listAllFiles(f2[i2], list);
                continue;
            }
            if (!f2[i2].getName().startsWith("i")) continue;
            list.add(f2[i2].getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileTest(int n2, String file) {
        RandomAccessFile raf = null;
        try {
            byte[] buff = new byte[20];
            raf = new RandomAccessFile(file, "rw");
            raf.seek(512L);
            raf.read(buff);
        }
        catch (Exception e2) {
            System.err.println(n2 + ">" + file);
        }
        finally {
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (IOException ioex) {}
                raf = null;
            }
        }
    }

    public String idAnon(String s2, boolean shift) {
        char[] cstr = s2.toCharArray();
        int shiftHash = shift ? this.hashShift : 0;
        this.r.setSeed(s2.hashCode() + shiftHash + this.randShift);
        byte[] hash = new byte[cstr.length];
        this.r.nextBytes(hash);
        for (int i2 = 0; i2 < cstr.length; ++i2) {
            if (Character.isDigit(cstr[i2])) {
                cstr[i2] = (char)(48 + (cstr[i2] - 48 + (128 + hash[i2])) % 10);
                continue;
            }
            if (Character.isLowerCase(cstr[i2])) {
                cstr[i2] = (char)(97 + (cstr[i2] - 97 + (128 + hash[i2])) % 26);
                continue;
            }
            if (!Character.isUpperCase(cstr[i2])) continue;
            cstr[i2] = (char)(65 + (cstr[i2] - 65 + (128 + hash[i2])) % 26);
        }
        return new String(cstr);
    }

    public String sopidAnon(String s2) {
        char[] cstr = s2.toCharArray();
        this.r.setSeed(System.nanoTime());
        byte[] hash = new byte[cstr.length];
        this.r.nextBytes(hash);
        for (int i2 = 0; i2 < cstr.length; ++i2) {
            if (Character.isDigit(cstr[i2])) {
                cstr[i2] = (char)(48 + (cstr[i2] - 48 + (128 + hash[i2])) % 10);
                continue;
            }
            if (Character.isLowerCase(cstr[i2])) {
                cstr[i2] = (char)(97 + (cstr[i2] - 97 + (128 + hash[i2])) % 26);
                continue;
            }
            if (!Character.isUpperCase(cstr[i2])) continue;
            cstr[i2] = (char)(65 + (cstr[i2] - 65 + (128 + hash[i2])) % 26);
        }
        return new String(cstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncProcessFile(String file) {
        if (this.que == null) {
            this.que = new Vector();
            Thread t2 = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    while (true) {
                        String f2;
                        String[] stringArray = ChangeDicom.this.que;
                        // MONITORENTER : ChangeDicom.this.que
                        while (ChangeDicom.this.que.isEmpty()) {
                            try {
                                ChangeDicom.this.que.wait();
                            }
                            catch (InterruptedException e2) {
                                // MONITOREXIT : stringArray
                                return;
                            }
                        }
                        ChangeDicom.this.workkingOn[0] = f2 = (String)ChangeDicom.this.que.remove(0);
                        // MONITOREXIT : stringArray
                        ChangeDicom.this.processFile(f2);
                        stringArray = ChangeDicom.this.workkingOn;
                        // MONITORENTER : ChangeDicom.this.workkingOn
                        ChangeDicom.this.workkingOn[0] = null;
                        ChangeDicom.this.workkingOn.notifyAll();
                        // MONITOREXIT : stringArray
                    }
                }
            };
            t2.setName("async");
            t2.start();
        }
        Vector vector = this.que;
        synchronized (vector) {
            this.que.add(file);
            this.que.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDone() {
        String[] stringArray = this.workkingOn;
        synchronized (this.workkingOn) {
            while (this.workkingOn[0] != null) {
                try {
                    this.workkingOn.wait();
                }
                catch (InterruptedException e2) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void processFile(String file) {
        RandomAccessFile raf = null;
        try {
            this.p.setFile(file);
            this.p.fill(this.tv);
            this.p.clearFile();
            raf = new RandomAccessFile(file, "rw");
            for (int i2 = 0; i2 < this.tv.length; ++i2) {
                if (this.tv[i2].value == null) continue;
                this.fixName(raf, this.tv[i2]);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
        finally {
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (IOException ioex) {}
                raf = null;
            }
            System.gc();
        }
    }

    public static String[] charSplit(String str) {
        char[] cstr = str.toCharArray();
        ArrayList<String> al2 = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < cstr.length; ++i2) {
            if (!Character.isLetter(cstr[i2])) {
                al2.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(cstr[i2]);
        }
        al2.add(sb.toString());
        return al2.toArray(new String[al2.size()]);
    }

    private void fixName(RandomAccessFile raf, tagValue nameTag) throws IOException {
        byte[] buff = new byte[nameTag.len];
        raf.seek(nameTag.fileOffset + 8L);
        raf.read(buff);
        String readValue = new String(buff).trim();
        if (readValue.equals(nameTag.value)) {
            Date d2;
            String ran = (String)nameTag.value;
            if (nameTag.group == 16 && nameTag.element == 16) {
                try {
                    ran = this.getName(nameTag.len);
                }
                catch (Exception ex) {
                    System.err.println("Error in processing \"" + (String)nameTag.value + "\"");
                    String[] sp = ChangeDicom.charSplit((String)nameTag.value);
                    for (int j2 = 0; j2 < sp.length; ++j2) {
                        if (j2 != 0) {
                            System.err.print(" , ");
                        }
                        System.err.print("\"" + sp[j2] + "\"");
                    }
                    System.err.println();
                    ex.printStackTrace();
                }
            } else if (nameTag.group == 8 && nameTag.element == 32) {
                try {
                    d2 = dicomDAformat.parse(ran);
                    int len = ran.length();
                    System.out.print("date \"" + ran + "\"=" + len + " ");
                    d2.setTime(d2.getTime() - (long)(this.date_delta * 24 * 60 * 60 * 1000));
                    ran = dicomDAformat.format(d2);
                    int nlen = ran.length();
                    System.out.println("\"" + ran + "\"=" + nlen);
                    if (nlen != len) {
                        ran = ran.substring(0, len);
                        System.out.println("trim to \"" + ran + "\"");
                    }
                }
                catch (ParseException e2) {
                    e2.printStackTrace();
                }
            } else if (nameTag.group == 8 && nameTag.element == 48) {
                try {
                    d2 = dicomTMformat.parse(ran);
                    int len = ran.length();
                    System.out.print("time \"" + ran + "\" ");
                    d2.setTime(d2.getTime() - (long)(this.time_delta * 60 * 1000));
                    ran = dicomTMformat.format(d2);
                    int nlen = ran.length();
                    System.out.println("\"" + ran + "\" ");
                    if (nlen != len) {
                        ran = ran.substring(0, len);
                        System.out.println("trim to \"" + ran + "\"");
                    }
                }
                catch (ParseException e3) {
                    e3.printStackTrace();
                }
            } else {
                ran = nameTag.group == 8 && nameTag.element == 24 ? this.sopidAnon((String)nameTag.value) : this.idAnon((String)nameTag.value, nameTag.group != 16 || nameTag.element != 32);
            }
            byte[] b2 = ran.getBytes();
            raf.seek(nameTag.fileOffset + 8L);
            raf.write(b2);
        } else {
            System.out.println(">\"" + readValue + "\"!=\"" + nameTag.value + "\"");
        }
    }

    public void copyUnique(String file, String dir) {
        try {
            this.p.setFile(file);
            this.p.fill(this.tv);
            this.p.clearFile();
            if (this.unique.add(this.tv[1].value)) {
                File f2 = new File(file);
                f2 = new File(dir, f2.getName());
                SimpleUtilities.copyFile(file, f2.getAbsolutePath());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public void listNames(String file) {
        try {
            this.p.setFile(file);
            this.p.fill(this.tv);
            this.p.clearFile();
            for (int i2 = 0; i2 < this.tv.length; ++i2) {
                if (i2 != 0) {
                    System.out.print("|");
                }
                System.out.print(this.tv[i2].value);
            }
            System.out.println();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public void testChar() {
        char[] a2 = new char[26];
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = (char)(65 + i2);
        }
        System.out.println(new String(a2));
        System.exit(0);
    }

    public static void copyRec(String src, String dest) {
        File srcd = new File(src);
        if (!srcd.isDirectory()) {
            ChangeDicom.copyFile(src, dest);
            return;
        }
        System.out.println("copying " + srcd.getAbsolutePath());
        File destd = new File(dest);
        destd.mkdir();
        File[] src_f = srcd.listFiles();
        for (int i2 = 0; i2 < src_f.length; ++i2) {
            ChangeDicom.copyRec(src_f[i2].getAbsolutePath(), new File(destd, src_f[i2].getName()).getAbsolutePath());
        }
    }

    public static void copyFile(String src, String dest) {
        try {
            FileInputStream fis = new FileInputStream(src);
            ChangeDicom.copyFile(fis, dest);
            fis.close();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void copyFile(InputStream src, String dest) {
        FileOutputStream fos = null;
        try {
            byte[] bbuff = new byte[32768];
            File newfile = new File(dest);
            if (!newfile.exists()) {
                newfile.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(dest);
            int len = 1;
            while (len != -1) {
                len = src.read(bbuff);
                if (len <= 0) continue;
                fos.write(bbuff, 0, len);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {
                    throw new RuntimeException(ioex);
                }
            }
        }
    }

    public static void main(String[] args) {
        ChangeDicom fz = new ChangeDicom();
        for (int n2 = 0; n2 < 4; ++n2) {
            String pat = "C:\\dev\\workspace\\SmartAnon\\p" + n2;
            ChangeDicom.copyRec("C:\\dev\\workspace\\SmartAnon\\p239", pat);
            fz.randShift += 511;
            File dir = new File(pat);
            File[] exams = dir.listFiles();
            for (int i2 = 0; i2 < exams.length; ++i2) {
                System.out.println(exams[i2].getAbsolutePath());
                fz.date_delta += 235 + n2 * 51;
                fz.time_delta += 37 + n2;
                fz.hashShift += 31 + n2;
                String[] list = ChangeDicom.listAllFiles(exams[i2].getAbsolutePath());
                for (int j2 = 0; j2 < list.length; ++j2) {
                    fz.processFile(list[j2]);
                }
            }
        }
    }
}

