/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;

public class ReadIndex {
    BaseIndex[][] bi = new BaseIndex[4][];
    RelationIndex[][] ri = new RelationIndex[4][];
    BufferedReader in;
    String line;
    static String[] levels = new String[]{"Patient", "Exam", "Series", "Image", "Composite"};
    Comparator comp = new Comparator(){

        public int compare(Object o1, Object o2) {
            BaseIndex b1 = (BaseIndex)o1;
            BaseIndex b2 = (BaseIndex)o2;
            int i1 = Integer.parseInt(b1.id);
            int i2 = Integer.parseInt(b2.id);
            return i1 - i2;
        }
    };

    public static int getLevel(String level) {
        for (int i2 = 0; i2 < levels.length; ++i2) {
            if (!level.equalsIgnoreCase(levels[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static String getNextLevel(String level) {
        for (int i2 = 0; i2 < levels.length; ++i2) {
            if (!level.equalsIgnoreCase(levels[i2])) continue;
            return levels[i2 + 1];
        }
        return null;
    }

    public tagValue readTagValue(String line) {
        tagValue t2 = new tagValue();
        StringTokenizer tok = new StringTokenizer(line);
        String str = tok.nextToken();
        String g2 = str.substring("group===".length(), str.indexOf("element==="));
        String e2 = str.substring(str.indexOf("element===") + "element===".length());
        t2.group = Integer.parseInt(g2);
        t2.element = Integer.parseInt(e2);
        for (int i2 = 0; i2 < 5; ++i2) {
            tok.nextToken();
        }
        t2.value = tok.nextToken();
        return t2;
    }

    public String readId(String line) {
        if (line.startsWith("_rid ==")) {
            return line.substring("_rid ==".length());
        }
        String id = line.substring("_myID ===".length());
        if (id.indexOf("_isRID===") != -1) {
            id = id.substring(0, id.indexOf("_isRID==="));
        }
        if (id.indexOf("_parentID====") != -1) {
            id = id.substring(0, id.indexOf("_parentID===="));
        }
        id = id.trim();
        return id;
    }

    public int readNumChildren(String line) {
        if (line.indexOf("_numChild=") == -1) {
            return -1;
        }
        return Integer.parseInt(line.split("_numChild=")[1]);
    }

    public BaseIndex readBaseindex(String level) throws Exception {
        BaseIndex bi = new BaseIndex();
        bi.level = level;
        ArrayList<tagValue> tags = new ArrayList<tagValue>(4);
        this.line = this.in.readLine();
        while (!this.line.startsWith("group===")) {
            this.line = this.in.readLine();
        }
        while (this.line.startsWith("group===")) {
            tags.add(this.readTagValue(this.line));
            this.line = this.in.readLine();
        }
        bi.tags = tags.toArray(new tagValue[tags.size()]);
        bi.id = this.readId(this.in.readLine());
        return bi;
    }

    public RelationIndex readRelationIndex(String level) throws Exception {
        RelationIndex ri = new RelationIndex();
        ArrayList<String> children = new ArrayList<String>(4);
        ri.level = level;
        while (!this.line.startsWith("_myID ===")) {
            this.line = this.in.readLine();
        }
        ri.id = this.readId(this.line);
        int numChildren = this.readNumChildren(this.line);
        if (numChildren <= 0) {
            System.out.print("Invalid children" + numChildren + " for:");
            System.out.println("" + ri);
            System.exit(1);
        }
        ri.childrenids = new String[numChildren];
        if (level.equals(levels[3])) {
            while (!this.line.startsWith("_rid ==")) {
                this.line = this.in.readLine();
            }
            children.add(this.readId(this.line));
        }
        ArrayList<tagValue> tags = new ArrayList<tagValue>(4);
        while (!this.line.startsWith("group===")) {
            this.line = this.in.readLine();
        }
        while (this.line.startsWith("group===")) {
            tags.add(this.readTagValue(this.line));
            this.line = this.in.readLine();
        }
        if (!this.line.equals("_auxiliaryTags.size()====0")) {
            this.line = this.in.readLine();
            while (this.line.startsWith("group===")) {
                tags.add(this.readTagValue(this.line));
                this.line = this.in.readLine();
            }
        }
        ri.tags = tags.toArray(new tagValue[tags.size()]);
        if (!level.equals(levels[3])) {
            while (!this.line.startsWith("_myID ===") && !this.line.startsWith("_rid ==")) {
                this.line = this.in.readLine();
            }
            while (children.size() < numChildren) {
                if (this.line.startsWith("_myID ===")) {
                    children.add(this.readId(this.line));
                }
                this.line = this.in.readLine();
            }
        }
        ri.childrenids = children.toArray(new String[children.size()]);
        return ri;
    }

    public void read(String file) throws Exception {
        int i2;
        ArrayList[] base = new ArrayList[4];
        ArrayList[] rel = new ArrayList[4];
        this.in = new BufferedReader(new FileReader(file));
        this.line = this.in.readLine();
        while (this.line.indexOf("Printing Key-ID Indexx") == -1) {
            this.line = this.in.readLine();
        }
        for (i2 = 0; i2 < levels.length - 1; ++i2) {
            System.out.println("Processing " + levels[i2] + " base indexes");
            this.line = this.in.readLine();
            base[i2] = new ArrayList(10);
            while (this.line.indexOf("Printing Key-ID Indexx") == -1 && this.line.indexOf("Printing Relation Index") == -1) {
                BaseIndex b2 = this.readBaseindex(levels[i2]);
                base[i2].add(b2);
                this.line = this.in.readLine();
            }
        }
        for (i2 = 0; i2 < levels.length - 1; ++i2) {
            System.out.println("Processing " + levels[i2] + "-" + ReadIndex.getNextLevel(levels[i2]) + " relation indexes");
            this.line = this.in.readLine();
            rel[i2] = new ArrayList(10);
            while (this.line.indexOf("Printing Relation Index") == -1 && this.line.indexOf("printing Composite Keys.....") == -1) {
                RelationIndex r2 = this.readRelationIndex(levels[i2]);
                rel[i2].add(r2);
                if (i2 == 3) continue;
                this.line = this.in.readLine();
            }
        }
        this.in.close();
        for (i2 = 0; i2 < base.length; ++i2) {
            int dups;
            int j2;
            this.bi[i2] = base[i2].toArray(new BaseIndex[base[i2].size()]);
            this.ri[i2] = rel[i2].toArray(new RelationIndex[rel[i2].size()]);
            Arrays.sort(this.bi[i2], this.comp);
            Arrays.sort(this.ri[i2], this.comp);
            String last = this.bi[i2][0].id;
            for (j2 = 1; j2 < this.bi[i2].length; ++j2) {
                dups = 0;
                if (this.bi[i2][j2].id.equals(last)) {
                    ++dups;
                    continue;
                }
                if (dups > 0) {
                    System.out.println("" + last + " duplicated " + dups + " times");
                }
                last = this.bi[i2][j2].id;
                dups = 0;
            }
            last = this.ri[i2][0].id;
            for (j2 = 1; j2 < this.ri[i2].length; ++j2) {
                dups = 0;
                if (this.ri[i2][j2].id.equals(last)) {
                    ++dups;
                    continue;
                }
                if (dups > 0) {
                    System.out.println("" + last + " duplicated " + dups + " times");
                }
                last = this.ri[i2][j2].id;
                dups = 0;
            }
        }
    }

    public void report() {
        for (int i2 = 0; i2 < levels.length - 1; ++i2) {
            System.out.println("");
            int baseCount = this.bi[i2].length;
            int relCount = this.ri[i2].length;
            if (baseCount != relCount) {
                System.out.println("ERROR: " + levels[i2] + " count mismatch");
                continue;
            }
            int notFound = 0;
            for (int j2 = 0; j2 < baseCount; ++j2) {
                BaseIndex b2 = this.bi[i2][j2];
                RelationIndex r2 = this.ri[i2][j2];
                if (b2.id.equals(r2.id)) continue;
                System.out.println("ERROR: " + levels[i2] + " id: " + b2.id + " not found in " + levels[i2] + "-" + ReadIndex.getNextLevel(levels[i2]) + " relation index (" + r2.id + ")");
                ++notFound;
            }
            if (notFound <= 0) continue;
            System.out.println("" + notFound + " of " + baseCount + " " + levels[i2] + "s not found");
        }
        ArrayList<String> children = new ArrayList<String>();
        for (int i3 = 0; i3 < levels.length - 1; ++i3) {
            System.out.println("");
            children.clear();
            for (int j3 = 0; j3 < this.ri[i3].length; ++j3) {
                for (int k2 = 0; k2 < this.ri[i3][j3].childrenids.length; ++k2) {
                    children.add(this.ri[i3][j3].childrenids[k2]);
                }
            }
            String[] idstrings = children.toArray(new String[0]);
            Arrays.sort(idstrings, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int i1 = Integer.parseInt((String)o1);
                    int i2 = Integer.parseInt((String)o2);
                    return i1 - i2;
                }
            });
            if (i3 < 3) {
                String curTable = levels[i3] + "-" + ReadIndex.getNextLevel(levels[i3]);
                String nxtTable = ReadIndex.getNextLevel(levels[i3]) + "-" + ReadIndex.getNextLevel(ReadIndex.getNextLevel(levels[i3]));
                if (idstrings.length > this.ri[i3 + 1].length) {
                    System.out.println("ERROR: " + curTable + " has more " + ReadIndex.getNextLevel(levels[i3]) + "s than " + nxtTable + " index");
                    continue;
                }
                if (idstrings.length >= this.ri[i3 + 1].length) continue;
                System.out.println("ERROR: " + nxtTable + " has more " + ReadIndex.getNextLevel(levels[i3]) + "s than " + curTable + " index");
                continue;
            }
            int nulls = 0;
            for (int j4 = 0; j4 < idstrings.length; ++j4) {
                try {
                    int rid = Integer.parseInt(idstrings[j4]);
                    if (rid > 0) continue;
                    ++nulls;
                    continue;
                }
                catch (Exception e2) {
                    ++nulls;
                }
            }
            if (nulls <= 0) continue;
            System.out.println("ERROR: " + nulls + " of " + idstrings.length + " composites are null");
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java com.ge.med.terra.tap.dm.tools.ReadIndex dbprintindex.output");
            System.exit(1);
        }
        ReadIndex ri = new ReadIndex();
        try {
            ri.read(args[0]);
            System.out.println("\nReport:");
            ri.report();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class RelationIndex
    extends BaseIndex {
        String[] childrenids;

        RelationIndex() {
        }

        @Override
        public String toString() {
            String str = "\n" + this.level + "-" + ReadIndex.getNextLevel(this.level) + " relation index---------------\n";
            if (this.tags == null) {
                str = str + "null tags\n";
            } else {
                for (int i2 = 0; i2 < this.tags.length; ++i2) {
                    str = str + this.tags[i2].toString() + "\n";
                }
            }
            str = str + "ID= " + this.id + "\n";
            String childLevel = ReadIndex.getNextLevel(this.level);
            for (int i3 = 0; i3 < this.childrenids.length; ++i3) {
                str = str + childLevel + "[" + i3 + "]= " + this.childrenids[i3] + "\n";
            }
            str = str + "-----------------------------------------\n";
            return str;
        }
    }

    class BaseIndex {
        tagValue[] tags;
        String level;
        String id;

        BaseIndex() {
        }

        public String toString() {
            String str = "\n" + this.level + " base index---------------\n";
            for (int i2 = 0; i2 < this.tags.length; ++i2) {
                str = str + this.tags[i2].toString() + "\n";
            }
            str = str + "ID= " + this.id;
            str = str + "\n-----------------------------------\n";
            return str;
        }
    }
}

