/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.tools.TagTableModel;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tag;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.vr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TagPanel
extends JPanel
implements FramePositioningCapable,
Printable,
Pageable,
SelectionCapable,
MouseListener {
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    TagTableModel tm = new TagTableModel(){

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TagPanel.this.changeValue(aValue, rowIndex, columnIndex);
        }
    };
    BorderLayout borderLayout2 = new BorderLayout();
    JComboBox jComboBox1 = new JComboBox<String>(new String[]{"All tags", "Patient tags", "Exam tags", "Series tags"});
    JCheckBox jCheckBox1 = new JCheckBox();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable1 = new JTable();
    BorderLayout borderLayout3 = new BorderLayout();
    Vector allData = new Vector();
    int numPages;
    static dicomParser dp = new dicomParser();
    TagChangeListener listener;
    DMComposite[] composites;
    int currentIndex;
    boolean repaint;
    JButton jButton1 = new JButton();
    int selection = -99;

    public void changeValue(Object aValue, int rowIndex, int columnIndex) {
        if (this.listener == null) {
            return;
        }
        tag tag2 = (tag)this.tm.getValueAt(rowIndex, 0);
        this.listener.tvChanged(tag2.group, tag2.element, aValue);
    }

    public void addChangeListener(TagChangeListener l2) {
        this.listener = l2;
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("PesiEditor");
        JMenuBar bar = new JMenuBar();
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)bar, "North");
        JMenu fileMenu = new JMenu("File");
        bar.add(fileMenu);
        JMenuItem fileItem = new JMenuItem("Open");
        fileMenu.add(fileItem);
        final TagPanel p22 = new TagPanel();
        fileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setMultiSelectionEnabled(false);
                int ret = fc.showDialog((Component)arg0.getSource(), "Load");
                if (ret == 0) {
                    DMSession dms = new DMSession("pesi", fc.getSelectedFile().getAbsolutePath(), null);
                    p22.setComposites(dms.getComposites());
                }
            }
        });
        p2.add((Component)p22, "Center");
        f2.setContentPane(p2);
        f2.setBounds(100, 100, 512, 512);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
    }

    @Override
    public Capable getCapable(String capableIFName) {
        if (capableIFName.equals("com.ge.med.idc.FramePositioningCapable") || capableIFName.equals("java.awt.print.Printable") || capableIFName.equals("java.awt.print.Pageable") || capableIFName.equals("com.ge.med.idc.SelectionCapable") || capableIFName.equals("java.awt.event.MouseListener")) {
            return this;
        }
        return null;
    }

    public TagPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.jTable1.setModel(this.tm);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TagPanel.this.setComponentSelection(0);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.addMouseListener(this);
    }

    public void setFile(String file) {
        this.parse(file);
        this.tm.setData(this.allData, this.getTagViewingMode());
    }

    public void setComposites(DMComposite[] images) {
        this.composites = images;
        this.currentIndex = 0;
        if (this.composites != null && this.composites.length > 0) {
            this.setFile(this.composites[0].getFilePath());
        } else {
            this.setFile(null);
        }
        this.repaint();
    }

    private void parse(String file) {
        this.allData.clear();
        try {
            dp.clearFile();
            if (file == null) {
                return;
            }
            dp.setFile(file);
            Vector[] vect = new Vector[this.jTable1.getModel().getColumnCount()];
            for (int i2 = 0; i2 < vect.length; ++i2) {
                vect[i2] = new Vector();
                this.allData.add(vect[i2]);
            }
            while (dp.hasMoreTags()) {
                tagValue tv = dp.readNext();
                String tag2 = tagValue.atToString(tv.group, tv.element);
                vect[0].add(new tag((short)tv.group, (short)tv.element));
                int vrV = dicomParser.getDictionary().getVR(tv.group, tv.element);
                String desc = dicomParser.getDictionary().getDescription(tv.group, tv.element);
                if (vrV != 0) {
                    vect[2].add(vr.toString(vrV));
                } else {
                    vect[2].add("NULL");
                }
                if (desc != null) {
                    vect[4].add(desc);
                } else {
                    vect[4].add("UNKNOWN");
                }
                if (tv.value != null && tv.value.getClass() == Object[].class) {
                    vect[1].add("Sequence");
                } else if (tv.value instanceof Object[]) {
                    Object[] o2 = (Object[])tv.value;
                    String str = "[" + o2.length + "]";
                    for (int i3 = 0; i3 < o2.length && i3 < 2; ++i3) {
                        str = str + o2[i3].toString() + ",";
                    }
                    str = str + "...";
                    vect[1].add(str);
                } else {
                    vect[1].add(tv.value);
                }
                vect[3].add(new Integer(tv.len));
                if (tv.value == null || tv.value.getClass() != Object[].class) continue;
                this.appendSeq(vect, (Object[])tv.value, "");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        dp.clearFile();
    }

    private void appendSeq(Vector[] vect, Object[] seq, String indent) {
        indent = indent + ">";
        for (int i2 = 0; i2 < seq.length; ++i2) {
            Object[] item = (Object[])seq[i2];
            vect[0].add(indent + "ITEM");
            vect[1].add("");
            vect[2].add("");
            vect[3].add("");
            vect[4].add("");
            for (int j2 = 0; j2 < item.length; ++j2) {
                tagValue elem = (tagValue)item[j2];
                String tag2 = tagValue.atToString(elem.group, elem.element);
                vect[0].add(indent + tag2);
                int vrV = dicomParser.getDictionary().getVR(elem.group, elem.element);
                String desc = dicomParser.getDictionary().getDescription(elem.group, elem.element);
                if (vrV != 0) {
                    vect[2].add(vr.toString(vrV));
                } else {
                    vect[2].add("NULL");
                }
                if (desc != null) {
                    vect[4].add(desc);
                } else {
                    vect[4].add("UNKNOWN");
                }
                if (elem.value instanceof Object[]) {
                    Object[] o2 = (Object[])elem.value;
                    if (o2.length > 0) {
                        vect[1].add(o2[0].getClass().getName() + "[" + o2.length + "]");
                    } else {
                        vect[1].add("EMPTY ARRAY");
                    }
                } else {
                    vect[1].add(elem.value);
                }
                vect[3].add(new Integer(elem.len));
                if (elem.value == null || elem.value.getClass() != Object[].class) continue;
                this.appendSeq(vect, (Object[])elem.value, indent);
            }
        }
        vect[0].add(indent + "ITEM END");
        vect[1].add("");
        vect[2].add("");
        vect[3].add("");
        vect[4].add("");
    }

    private String looseQuotes(String str) {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        if (str.charAt(0) == '\"') {
            str = str.substring(1);
        }
        if (str.charAt(str.length() - 1) == '\"') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private Vector getMaxStringLen() {
        int rowCount = this.jTable1.getRowCount();
        int colCount = this.jTable1.getColumnCount();
        Vector<Integer> vec = new Vector<Integer>();
        for (int colC = 0; colC < colCount; ++colC) {
            int max = 0;
            for (int i2 = 0; i2 < rowCount; ++i2) {
                String str = (String)this.jTable1.getValueAt(i2, colC);
                int len = str.length();
                if (len <= max) continue;
                max = str.length();
            }
            vec.add(new Integer(max));
        }
        return vec;
    }

    @Override
    public int print(Graphics g2, PageFormat pageFormat, int pageIndex) {
        Graphics2D g22 = (Graphics2D)g2;
        g22.setColor(Color.black);
        int fontHeight = g22.getFontMetrics().getHeight();
        int fontDesent = g22.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        double tableWidth = this.jTable1.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        double headerHeightOnPage = (double)this.jTable1.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)(this.jTable1.getRowHeight() + this.jTable1.getRowMargin()) * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight) - 1;
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage - 7.0;
        int totalNumPages = (int)Math.ceil((double)this.jTable1.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g22.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g22.drawString("Page: " + (pageIndex + 1), (int)pageWidth / 2 - 35, (int)(pageHeight - (double)fontHeight - (double)fontDesent));
        g22.translate(0.0, headerHeightOnPage);
        g22.translate(0.0, (double)(-pageIndex) * pageHeightForTable);
        if (pageIndex + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageIndex;
            int numRowsLeft = this.jTable1.getRowCount() - lastRowPrinted;
            g22.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else {
            g22.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g22.scale(scale, scale);
        this.jTable1.paint(g22);
        g22.scale(1.0 / scale, 1.0 / scale);
        g22.translate(0.0, (double)pageIndex * pageHeightForTable);
        g22.translate(0.0, -headerHeightOnPage);
        g22.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g22.scale(scale, scale);
        this.jTable1.getTableHeader().paint(g22);
        return 0;
    }

    @Override
    public void print(Graphics g2) {
        Color c2 = this.getBackground();
        this.setBackground(Color.white);
        this.paint(g2);
        this.setBackground(c2);
    }

    @Override
    public int getNumFrames() {
        if (this.composites == null) {
            return 0;
        }
        return this.composites.length;
    }

    @Override
    public void setFrameIndex(int parm1) {
        if (this.composites == null) {
            return;
        }
        int temp = this.currentIndex;
        this.currentIndex = parm1;
        this.setFile(this.composites[parm1].getFilePath());
        this.repaint();
        this.firePropertyChange("FrameIndex", this.currentIndex, temp);
    }

    @Override
    public int getFrameIndex() {
        return this.currentIndex;
    }

    @Override
    public boolean isAutoRepaint() {
        return this.repaint;
    }

    @Override
    public void setAutoRepaint(boolean parm1) {
        this.repaint = parm1;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jCheckBox1.setText("Private-Tags");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TagPanel.this.jCheckBox1_actionPerformed(e2);
            }
        });
        this.jPanel2.setLayout(this.borderLayout3);
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jTable1.setIntercellSpacing(new Dimension(1, 1));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TagPanel.this.jComboBox1_actionPerformed(e2);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                TagPanel.this.this_componentResized(e2);
            }
        });
        this.jButton1.setText("Print");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TagPanel.this.jButton1_actionPerformed(e2);
            }
        });
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jComboBox1, null);
        this.jPanel3.add((Component)this.jCheckBox1, null);
        this.jPanel3.add((Component)this.jButton1, null);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
    }

    void jComboBox1_actionPerformed(ActionEvent e2) {
        this.tm.filterThis(this.getTagViewingMode());
    }

    void jCheckBox1_actionPerformed(ActionEvent e2) {
        if (this.jComboBox1.getSelectedIndex() == 0) {
            this.tm.filterThis(this.getTagViewingMode());
        }
    }

    public void setTagVieweingMode(int mode) {
        this.jComboBox1.setSelectedIndex(mode == 0 ? 0 : mode - 1);
        this.tm.filterThis(mode);
    }

    private int getTagViewingMode() {
        int index = this.jComboBox1.getSelectedIndex() == 0 ? (this.jCheckBox1.isSelected() ? 0 : 1) : this.jComboBox1.getSelectedIndex() + 1;
        return index;
    }

    void this_componentResized(ComponentEvent e2) {
        this.adjustCol();
    }

    public void adjustCol() {
        this.jTable1.setAutoResizeMode(4);
        int[] colWidths = new int[]{100, 164, 31, 35, 100};
        int noc = this.jTable1.getModel().getColumnCount();
        TableColumnModel cm = this.jTable1.getColumnModel();
        for (int i2 = 0; i2 < noc; ++i2) {
            TableColumn column = cm.getColumn(i2);
            column.setPreferredWidth(colWidths[i2]);
        }
        cm.getColumn(0).setMaxWidth(colWidths[0] + 20);
        cm.getColumn(2).setMaxWidth(colWidths[2]);
        cm.getColumn(3).setMaxWidth(colWidths[3]);
    }

    @Override
    public int getNumberOfPages() {
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return new PageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    void jButton1_actionPerformed(ActionEvent e2) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        boolean rt = pj.printDialog();
        try {
            if (rt) {
                pj.print();
            }
        }
        catch (Exception PrintException2) {
            // empty catch block
        }
    }

    @Override
    public int getNumComponents() {
        return 0;
    }

    @Override
    public int getComponentSelection() {
        return this.selection;
    }

    @Override
    public void setComponentSelection(int parm1) {
        if (this.selection == parm1) {
            return;
        }
        this.selection = parm1;
        this.firePropertyChange("ComponentSelection", -99, parm1);
    }

    @Override
    public JComponent getViewportComponent(int parm1) {
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent parm1) {
        int clickCount = parm1.getClickCount();
        if (clickCount == 1) {
            this.setComponentSelection(0);
        }
    }

    @Override
    public void mouseEntered(MouseEvent parm1) {
    }

    @Override
    public void mouseExited(MouseEvent parm1) {
    }

    @Override
    public void mousePressed(MouseEvent parm1) {
    }

    @Override
    public void mouseReleased(MouseEvent parm1) {
    }

    public static interface TagChangeListener {
        public void tvChanged(int var1, int var2, Object var3);
    }
}

