/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.dm.volume.ImageWrap;
import com.ge.med.terra.tap.dm.volume.VolumeInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class DMLikeVolume
extends DMVolume {
    public static final int ByteVoxel = 0;
    public static final int ShortVoxel = 1;
    int m_voxelType = 0;
    int m_bitsPerVoxel = 8;
    String filePath;
    RandomAccessFile raf;
    int pixelType;
    double[] RASOfOrigin;
    int[] volDim;
    XjVolume m_likeVolume;
    boolean m_isLittleEndian = false;
    double[] xDirectionRAS;
    double[] yDirectionRAS;
    double[] zDirectionRAS;
    VolumeInfo vinfo;

    public DMLikeVolume(XjVolume likeVolume, int voxelType) {
        this.m_likeVolume = likeVolume;
        this.m_voxelType = voxelType;
        this.pixelType = this.m_likeVolume.getPixelType();
        this.RASOfOrigin = this.m_likeVolume.getRASOfOrigin(null);
        this.volDim = this.m_likeVolume.getVolumeDimensions(null);
        this.xDirectionRAS = this.m_likeVolume.getXDirectionRAS(null);
        this.yDirectionRAS = this.m_likeVolume.getYDirectionRAS(null);
        this.zDirectionRAS = this.m_likeVolume.getZDirectionRAS(null);
        switch (this.m_voxelType) {
            case 0: {
                this.m_bitsPerVoxel = 8;
                break;
            }
            case 1: {
                this.m_bitsPerVoxel = 16;
            }
        }
        int size = this.volDim[0] * this.volDim[1] * this.volDim[1] * (this.m_bitsPerVoxel / 8);
        this.makeTmpVolume(size);
    }

    private void makeTmpVolume(int size) {
        try {
            File f2 = File.createTempFile("volume", ".map");
            this.filePath = f2.getAbsolutePath();
            this.raf = new RandomAccessFile(f2, "rw");
            f2.deleteOnExit();
            this.raf.setLength(size);
            String infoName = f2.getAbsolutePath();
            infoName = infoName.substring(0, infoName.length() - 3) + "vif";
            File info = new File(infoName);
            if (!info.createNewFile()) {
                throw new RuntimeException("file should not exist " + infoName);
            }
            info.deleteOnExit();
            this.vinfo = new VolumeInfo(infoName, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        if (dims == null) {
            dims = new int[3];
        }
        System.arraycopy(this.volDim, 0, dims, 0, this.volDim.length);
        return dims;
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        if (ras_ulc == null) {
            ras_ulc = new double[3];
        }
        System.arraycopy(this.RASOfOrigin, 0, ras_ulc, 0, this.volDim.length);
        return ras_ulc;
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        if (ras_dx == null) {
            ras_dx = new double[3];
        }
        System.arraycopy(this.xDirectionRAS, 0, ras_dx, 0, this.volDim.length);
        return ras_dx;
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        if (ras_dy == null) {
            ras_dy = new double[3];
        }
        System.arraycopy(this.yDirectionRAS, 0, ras_dy, 0, this.volDim.length);
        return ras_dy;
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dz) {
        if (ras_dz == null) {
            ras_dz = new double[3];
        }
        System.arraycopy(this.zDirectionRAS, 0, ras_dz, 0, this.volDim.length);
        return ras_dz;
    }

    @Override
    public long getVSliceOffset(int sliceNo) {
        return this.volDim[0] * this.volDim[1] * sliceNo;
    }

    @Override
    public String getVSlicePath(int sliceNo) {
        return this.filePath;
    }

    @Override
    public int getBitsPerVoxel() {
        return this.m_bitsPerVoxel;
    }

    @Override
    public int getPixelType() {
        return 1;
    }

    @Override
    public boolean isVolumeLittleEndian() {
        return true;
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        return this.m_likeVolume.getVSliceValue(sliceNo, group, element);
    }

    @Override
    public Object getValue(int group, int element) {
        return this.m_likeVolume.getValue(group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        return this.getValues(tv);
    }

    @Override
    public ByteBuffer getSliceBuffer(int slice) throws IOException {
        long sliceSizeInBytes = this.volDim[0] * this.volDim[1] * (this.m_bitsPerVoxel / 8);
        return this.raf.getChannel().map(FileChannel.MapMode.READ_WRITE, this.getVSliceOffset(slice), sliceSizeInBytes);
    }

    @Override
    public String getRelatedComposite() {
        return this.m_likeVolume.getRelatedComposite();
    }

    @Override
    public VolumeInfo getInfoFileName() {
        return this.vinfo;
    }

    public XjImage getImage(int slice) {
        return new ImageWrap(this, slice);
    }
}

