/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dmui.DmuResourceManager;
import com.ge.med.terra.tap.dmui.table.DmuFormatterAdapter;
import java.util.ArrayList;
import java.util.Comparator;

public class DmuFormatAS
extends DmuFormatterAdapter {
    private static final String[] DICOM_VALUES = new String[]{"D", "W", "M", "Y"};
    protected String tagStr = "(0x0010, 0x1010)";
    protected Comparator<DMObject> agecomp = new Comparator<DMObject>(){

        @Override
        public int compare(DMObject dmo1, DMObject dmo2) {
            int idx2;
            if (dmo1 == null) {
                return 1;
            }
            if (dmo2 == null) {
                return -1;
            }
            String str1 = (String)dmo1.getValue(DmuFormatAS.this.tagStr);
            String str2 = (String)dmo2.getValue(DmuFormatAS.this.tagStr);
            int age1 = -1;
            int age2 = -1;
            String type1 = null;
            String type2 = null;
            if (str1 != null) {
                age1 = Integer.parseInt(str1.substring(0, str1.length() - 1));
                type1 = str1.substring(str1.length() - 1);
            }
            if (str2 != null) {
                age2 = Integer.parseInt(str2.substring(0, str2.length() - 1));
                type2 = str2.substring(str2.length() - 1);
            }
            if (null == type1 || -1 == age1) {
                if (null == type2 || -1 == age2) {
                    return 0;
                }
                return 1;
            }
            if (null == type2 || -1 == age2) {
                return -1;
            }
            if (type1.equals(type2)) {
                if (age1 < age2) {
                    return -1;
                }
                if (age1 > age2) {
                    return 1;
                }
                return 0;
            }
            int idx1 = DmuFormatAS.getTypeIndex(type1);
            if (idx1 < (idx2 = DmuFormatAS.getTypeIndex(type2))) {
                return -1;
            }
            if (idx1 > idx2) {
                return 1;
            }
            return 0;
        }
    };

    public DmuFormatAS() {
    }

    public DmuFormatAS(String str) {
        this.tagStr = str;
    }

    public static int getTypeIndex(String str) {
        for (int i2 = 0; i2 < DICOM_VALUES.length; ++i2) {
            if (!DICOM_VALUES[i2].equalsIgnoreCase(str)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String getName() {
        return "AS Formatter";
    }

    @Override
    public int getPreferredWidth() {
        return 50;
    }

    @Override
    public Comparator<DMObject> getComparator() {
        return this.agecomp;
    }

    @Override
    public DMTag[] getNeededTags() {
        String[] tagStrs = Util.breakupString(this.tagStr);
        ArrayList<DMTag> tags = new ArrayList<DMTag>(tagStrs.length);
        for (int i2 = 0; i2 < tagStrs.length; ++i2) {
            if ((i2 & 1) != 0) continue;
            tags.add(DMTag.parseTagString(tagStrs[i2]));
        }
        return tags.toArray(new DMTag[tags.size()]);
    }

    public static String[] getDisplayValues() {
        String[] displayValues = new String[]{DmuResourceManager.getString((String)"AGE_DAYS"), DmuResourceManager.getString((String)"AGE_WEEKS"), DmuResourceManager.getString((String)"AGE_MONTHS"), DmuResourceManager.getString((String)"AGE_YEARS")};
        return displayValues;
    }

    @Override
    public Object getValue(DMTagValueInterface tagValIF) {
        String ageStr = (String)Util.getValue(tagValIF, this.tagStr);
        try {
            if (ageStr != null && 4 == ageStr.length()) {
                int age = Integer.parseInt(ageStr.substring(0, ageStr.length() - 1));
                String type = ageStr.substring(ageStr.length() - 1);
                int idx = DmuFormatAS.getTypeIndex(type);
                ageStr = age + " " + DmuFormatAS.getDisplayValues()[idx];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ageStr;
    }

    @Override
    public String getToolTip(DMTagValueInterface tagValIF) {
        String exchangeFormat = null;
        if (null != tagValIF) {
            exchangeFormat = (String)Util.getValue(tagValIF, this.tagStr);
        }
        return exchangeFormat;
    }
}

