/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dmui.table.DmuFormatterAdapter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;

public class DmuFormatTM
extends DmuFormatterAdapter {
    public static final SimpleDateFormat TM_FORMAT_PARSE = new SimpleDateFormat("HHmmss.SSS");
    protected String tagStr = "(0x0010,0x0040)";
    protected Comparator<DMObject> timecomp = new Comparator<DMObject>(){

        @Override
        public int compare(DMObject dmo1, DMObject dmo2) {
            if (dmo1 == null) {
                return 1;
            }
            if (dmo2 == null) {
                return -1;
            }
            String s1 = DmuFormatTM.getTMValue(dmo1, DmuFormatTM.this.tagStr);
            String s2 = DmuFormatTM.getTMValue(dmo2, DmuFormatTM.this.tagStr);
            Date time1 = null;
            Date time2 = null;
            if (s1 != null) {
                time1 = DmuFormatTM.parse(s1);
            }
            if (s2 != null) {
                time2 = DmuFormatTM.parse(s2);
            }
            if (time1 == null) {
                if (time2 == null) {
                    return 0;
                }
                return 1;
            }
            if (time2 == null) {
                return -1;
            }
            return time1.compareTo(time2);
        }
    };

    public DmuFormatTM() {
    }

    public DmuFormatTM(String str) {
        this.tagStr = str;
    }

    @Override
    public String getName() {
        return "TM Formatter";
    }

    @Override
    public int getPreferredWidth() {
        return 50;
    }

    @Override
    public Comparator<DMObject> getComparator() {
        return this.timecomp;
    }

    @Override
    public DMTag[] getNeededTags() {
        String[] tagStrs = Util.breakupString(this.tagStr);
        ArrayList<DMTag> tags = new ArrayList<DMTag>(tagStrs.length);
        for (int i2 = 0; i2 < tagStrs.length; ++i2) {
            if ((i2 & 1) != 0) continue;
            tags.add(DMTag.parseTagString(tagStrs[i2]));
        }
        return tags.toArray(new DMTag[tags.size()]);
    }

    public static String getTMValue(DMTagValueInterface tagValIF, String tagStr) {
        String time = (String)Util.getValue(tagValIF, tagStr);
        if (null != time) {
            time = time.replaceAll("\\:", "");
        }
        return time;
    }

    @Override
    public Object getValue(DMTagValueInterface tagValIF) {
        String tmStr = "";
        String str = DmuFormatTM.getTMValue(tagValIF, this.tagStr);
        if (null != str) {
            Date time = DmuFormatTM.parse(str);
            tmStr = null == time ? str : DateFormat.getTimeInstance(3).format(time);
        }
        return tmStr;
    }

    @Override
    public String getToolTip(DMTagValueInterface tagValIF) {
        String exchangeFormat = null;
        if (null != tagValIF) {
            exchangeFormat = (String)Util.getValue(tagValIF, this.tagStr);
        }
        return exchangeFormat;
    }

    public static Date parse(String str) {
        int len;
        Date time = null;
        if (null == str) {
            return time;
        }
        int st = 0;
        for (len = str.length(); st < len && str.charAt(len - 1) <= ' '; --len) {
        }
        String timeStr = st > 0 || len < str.length() ? str.substring(st, len) : str;
        timeStr = timeStr.replaceAll("\\:", "");
        int dotIndex = timeStr.indexOf(46);
        if (timeStr.length() < 2 || timeStr.length() > 13 || -1 != dotIndex && 6 != dotIndex || ' ' == timeStr.charAt(0)) {
            return time;
        }
        if (timeStr.length() == 2) {
            timeStr = timeStr + "0000.0";
        } else if (timeStr.length() == 4) {
            timeStr = timeStr + "00.0";
        } else if (-1 == dotIndex && timeStr.length() == 6) {
            timeStr = timeStr + ".0";
        }
        if (0 < dotIndex) {
            String frac = DmuFormatTM.fracInMS(timeStr.substring(dotIndex + 1));
            timeStr = timeStr.substring(0, dotIndex) + "." + frac;
        }
        try {
            time = TM_FORMAT_PARSE.parse(timeStr);
        }
        catch (ParseException pex) {
            // empty catch block
        }
        return time;
    }

    protected static String fracInMS(String frac) {
        String padded = frac.length() > 3 ? frac.substring(0, 3) : (frac.length() == 0 ? "000" : frac);
        return padded;
    }
}

