/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dmui.table.DmuFormatDefault;
import com.ge.med.terra.tap.dmui.table.DmuFormatNull;
import com.ge.med.terra.tap.dmui.table.DmuFormatter;
import com.ge.med.terra.tap.dmui.table.DmuRowFormatter;
import com.ge.med.terra.tap.dmui.table.DmuRowFormatterAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;

public class DmuTableModel
extends DefaultTableModel {
    private static HashMap<String, String> formatMap = new HashMap();
    protected int sortCol = -1;
    protected boolean sortDown = true;
    private Object[] colNames = new String[]{"Patient Name", "Date Of Birth", "Series No", "Date", "Description"};
    private String[] columns = new String[]{"PatientName", "PatientDOB", "0x0020,0x0011", "StudyDate", "0x0020,0x10"};
    private DmuFormatter[] formatters = null;
    private DmuRowFormatter rowFormatter = new DmuRowFormatterAdapter();
    private DmuRowFormatter selectedRowFormatter = new DmuRowFormatterAdapter();
    private DMElement[] elem;
    private DMQuery query = null;
    private int level = 1;
    private static String[] model;
    private boolean[] loaded = new boolean[20];
    private Vector data = new Vector();
    private int lastUpdate = -1;
    private int unInserted = -1;
    private boolean autoSort = false;
    private Comparator sortUsing = null;
    private Object timerLock = new Object();
    private Timer tim = new Timer(100, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e2) {
            int u2 = DmuTableModel.this.unInserted;
            if (u2 != -1) {
                if (DmuTableModel.this.autoSort) {
                    DmuTableModel.this.fireTableDataChanged();
                } else {
                    DmuTableModel.this.fireTableRowsInserted(DmuTableModel.this.lastUpdate, u2);
                    DmuTableModel.this.sortCol = -1;
                }
            }
            DmuTableModel.this.lastUpdate = u2;
            Object object = DmuTableModel.this.timerLock;
            synchronized (object) {
                DmuTableModel.this.tim.stop();
                DmuTableModel.this.timerLock.notifyAll();
            }
        }
    });
    private ModelReceiver rec;

    public DmuTableModel() {
        this.setColumnTypes(this.columns);
    }

    @Override
    public String getColumnName(int columnIndex) {
        Object col = this.colNames[columnIndex];
        return col instanceof String ? (String)col : "";
    }

    public Object getColName(int columnIndex) {
        return this.colNames[columnIndex];
    }

    public Object[] getColNames() {
        return this.colNames;
    }

    public void setColNames(Object[] colNames) {
        this.colNames = colNames;
        this.fireTableStructureChanged();
    }

    public String[] getColumnTypes() {
        return this.columns;
    }

    public void setColumnTypes(String[] cols) {
        this.columns = cols;
        this.formatters = new DmuFormatter[cols.length];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            String f2 = formatMap.get(cols[i2]);
            if (f2 != null) {
                try {
                    int bracket = f2.indexOf("(");
                    if (bracket > 0) {
                        String fclass = f2.substring(0, bracket);
                        String arg = f2.substring(bracket + 1, f2.length() - 1);
                        Class[] strarg = new Class[]{String.class};
                        Constructor<?> c2 = Class.forName(fclass).getConstructor(strarg);
                        this.formatters[i2] = (DmuFormatter)c2.newInstance(arg);
                        continue;
                    }
                    this.formatters[i2] = (DmuFormatter)Class.forName(f2).newInstance();
                }
                catch (Exception ex) {
                    this.formatters[i2] = new DmuFormatNull();
                }
                continue;
            }
            this.formatters[i2] = new DmuFormatDefault(cols[i2]);
        }
        this.setNeededTags();
    }

    private void setNeededTags() {
        ArrayList<DMTag> al2 = new ArrayList<DMTag>(this.formatters.length);
        for (int i2 = 0; i2 < this.formatters.length; ++i2) {
            DMTag[] tag2 = this.formatters[i2].getNeededTags();
            for (int k2 = 0; k2 < tag2.length; ++k2) {
                al2.add(tag2[k2]);
            }
        }
        DMTag[] tags = this.rowFormatter.getNeededTags();
        for (int i3 = 0; i3 < tags.length; ++i3) {
            al2.add(tags[i3]);
        }
        DMTag[] neededTags = al2.toArray(new DMTag[al2.size()]);
        Object[] el = new DMElement[neededTags.length];
        for (int i4 = 0; i4 < neededTags.length; ++i4) {
            el[i4] = new DMElement(neededTags[i4].getGroup(), neededTags[i4].getElement());
        }
        Arrays.sort(el);
        this.elem = el;
        this.fireTableStructureChanged();
    }

    public DmuFormatter[] getFormatters() {
        return this.formatters;
    }

    public DmuFormatter getFormatter(int columnIndex) {
        return this.formatters[columnIndex];
    }

    public static void addFormatter(String name, String classname) {
        formatMap.put(name, classname);
    }

    public DmuRowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    public void setRowFormatter(DmuRowFormatter rf) {
        this.rowFormatter = rf;
    }

    public DmuRowFormatter getSelectedRowFormatter() {
        return this.selectedRowFormatter;
    }

    public void setSelectedRowFormatter(DmuRowFormatter rf) {
        this.selectedRowFormatter = rf;
    }

    public DMQuery getQuery() {
        return this.query;
    }

    public void setQuery(DMQuery q2) {
        this.query = q2;
    }

    public String getLevel() {
        return model[this.level];
    }

    public void setLevel(String levelStr) {
        for (int i2 = 0; i2 < model.length; ++i2) {
            if (!model[i2].equalsIgnoreCase(levelStr)) continue;
            this.level = i2;
            return;
        }
        throw new IllegalArgumentException("unknown level \"" + levelStr + "\"");
    }

    public boolean isAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(boolean autoSort) {
        this.autoSort = autoSort;
    }

    public DMObject getNextInBrowser(DMObject dmo, boolean reverse) {
        int i2;
        int[] rows = new int[this.getRowCount()];
        for (int i3 = 0; i3 < rows.length; ++i3) {
            rows[i3] = i3;
        }
        DMObject[] dmos = this.getData(rows);
        for (i2 = 0; i2 < dmos.length && !dmo.equals(dmos[i2]); ++i2) {
        }
        if (reverse) {
            if (i2 == 0) {
                return dmos[dmos.length - 1];
            }
            return dmos[--i2];
        }
        if (i2 == dmos.length - 1) {
            return dmos[0];
        }
        return dmos[++i2];
    }

    public DMObject[] getData(int[] rows) {
        if (rows == null) {
            return null;
        }
        DMObject[] dmo = new DMObject[rows.length];
        for (int i2 = 0; i2 < dmo.length; ++i2) {
            dmo[i2] = this.getData(rows[i2]);
        }
        return dmo;
    }

    public DMObject getData(int row) {
        DMObject object = null;
        if (this.data != null && this.data.size() > row) {
            object = (DMObject)this.data.get(row);
        }
        return object;
    }

    public void addObject(DMObject dmo) {
        if (this.rec == null) {
            this.rec = new ModelReceiver();
            this.data.clear();
            this.data = new Vector();
            this.fireTableDataChanged();
        }
        this.rec.gotOne(dmo);
        this.waitForTableUpdate();
    }

    public void setData(DMObject dmo) {
        if (this.rec != null) {
            this.rec.stop();
        }
        this.rec = new ModelReceiver();
        this.data.clear();
        this.data = new Vector();
        this.fireTableDataChanged();
        if (dmo != null) {
            dmo.getRelated(model[this.level], this.query, this.rec);
        }
        this.waitForTableUpdate();
    }

    public void setData(DMObject[] dmo) {
        if (this.rec != null) {
            this.rec.stop();
        }
        this.rec = new ModelReceiver();
        this.data.clear();
        this.data = new Vector();
        this.fireTableDataChanged();
        if (dmo != null) {
            for (int i2 = 0; i2 < dmo.length; ++i2) {
                dmo[i2].getRelated(model[this.level], this.query, this.rec);
            }
        }
        this.waitForTableUpdate();
    }

    public void setData(DMSession dms) {
        if (this.rec != null) {
            this.rec.stop();
        }
        this.rec = new ModelReceiver();
        this.data.clear();
        this.data = new Vector();
        this.fireTableDataChanged();
        dms.getRelated(model[this.level], this.query, this.rec);
        this.waitForTableUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTableUpdate() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        Object object = this.timerLock;
        synchronized (object) {
            while (this.tim.isRunning()) {
                try {
                    this.timerLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (!this.loaded[rowIndex]) {
                if (this.elem != null) {
                    ((DMObject)this.data.get(rowIndex)).getValues(this.elem);
                }
                this.loaded[rowIndex] = true;
            }
            return this.formatters[columnIndex].getValue((DMObject)this.data.get(rowIndex));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public String getToolTipAt(int rowIndex, int colIndex) {
        String tip = null;
        try {
            if (!this.loaded[rowIndex]) {
                if (this.elem != null) {
                    ((DMObject)this.data.get(rowIndex)).getValues(this.elem);
                }
                this.loaded[rowIndex] = true;
            }
            tip = this.formatters[colIndex].getToolTip((DMObject)this.data.get(rowIndex));
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            // empty catch block
        }
        return tip;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void sort(int col) {
        Vector v2 = this.data;
        this.data = new Vector();
        Object[] arr = v2.toArray();
        this.sortUsing = this.formatters[col].getComparator();
        Arrays.sort(arr, this.sortUsing);
        if (this.sortCol == col && this.sortDown) {
            for (int i2 = arr.length - 1; i2 >= 0; --i2) {
                this.data.add(arr[i2]);
            }
            this.sortDown = false;
        } else {
            for (int i3 = 0; i3 < arr.length; ++i3) {
                this.data.add(arr[i3]);
            }
            this.sortDown = true;
        }
        this.sortCol = col;
        this.fireTableDataChanged();
    }

    public void sort(int col, boolean down) {
        Vector v2 = this.data;
        this.data = new Vector();
        Object[] arr = v2.toArray();
        this.sortUsing = this.formatters[col].getComparator();
        Arrays.sort(arr, this.sortUsing);
        this.sortDown = down;
        this.sortCol = col;
        if (this.sortDown) {
            for (int i2 = arr.length - 1; i2 >= 0; --i2) {
                this.data.add(arr[i2]);
            }
        } else {
            for (int i3 = 0; i3 < arr.length; ++i3) {
                this.data.add(arr[i3]);
            }
        }
        this.fireTableDataChanged();
    }

    public boolean isSortDown() {
        return this.sortDown;
    }

    public void setSortDirection(boolean down) {
        this.sort(this.sortCol, down);
    }

    public int getSortCol() {
        return this.sortCol;
    }

    public void setSortCol(int col) {
        this.sort(col, this.sortDown);
    }

    static /* synthetic */ boolean[] access$802(DmuTableModel x0, boolean[] x1) {
        x0.loaded = x1;
        return x1;
    }

    static {
        DmuTableModel.addFormatter("PatientName", "com.ge.med.terra.tap.dmui.table.DmuFormatPN");
        DmuTableModel.addFormatter("PatientDOB", "com.ge.med.terra.tap.dmui.table.DmuFormatDA");
        DmuTableModel.addFormatter("StudyDate", "com.ge.med.terra.tap.dmui.table.DmuFormatDA(0x0008,0x0020)");
        model = new String[]{"patient", "study", "series", "image"};
    }

    private class ModelReceiver
    implements DMObjectReceiver {
        private int row;
        private boolean cont = true;
        private Comparator reverse = new Comparator(){

            public int compare(Object o1, Object o2) {
                return -DmuTableModel.this.sortUsing.compare(o1, o2);
            }
        };

        private ModelReceiver() {
        }

        public void stop() {
            this.cont = false;
        }

        public boolean addRow(int row) {
            try {
                DmuTableModel.this.unInserted = row;
                DmuTableModel.this.tim.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }

        public int insertSorted(Vector v2, Object o2, Comparator c2) {
            if (c2 == null) {
                v2.add(o2);
                return 0;
            }
            if (!DmuTableModel.this.sortDown) {
                c2 = this.reverse;
            }
            if (v2.isEmpty()) {
                v2.add(o2);
                return 0;
            }
            int start = 0;
            int end = v2.size() - 1;
            while (end - start > 0) {
                int sum = start + end;
                int mid = sum >> 1;
                sum &= 1;
                int diff = c2.compare(o2, v2.get(mid));
                if (diff > 0) {
                    start = mid + sum;
                    continue;
                }
                if (diff < 0) {
                    end = mid;
                    continue;
                }
                start = end = mid;
            }
            v2.add(start + (start == end && c2.compare(o2, v2.get(start)) > 0 ? 1 : 0), o2);
            return end;
        }

        public void printData() {
            int i2 = 0;
            for (DMObject item : DmuTableModel.this.data) {
                System.out.println(i2 + ">" + item);
                ++i2;
            }
        }

        @Override
        public boolean gotOne(DMObject o2) {
            if (this.cont) {
                if (DmuTableModel.this.autoSort & DmuTableModel.this.sortUsing != null) {
                    int pos = this.insertSorted(DmuTableModel.this.data, o2, DmuTableModel.this.sortUsing);
                    this.row = DmuTableModel.this.data.size() - 1;
                    if (DmuTableModel.this.loaded.length <= this.row) {
                        boolean[] tmp = new boolean[DmuTableModel.this.loaded.length * 2];
                        System.arraycopy(DmuTableModel.this.loaded, 0, tmp, 0, DmuTableModel.this.loaded.length);
                        DmuTableModel.access$802(DmuTableModel.this, tmp);
                    }
                    System.arraycopy(DmuTableModel.this.loaded, pos, DmuTableModel.this.loaded, pos + 1, DmuTableModel.this.loaded.length - pos - 1);
                    ((DmuTableModel)DmuTableModel.this).loaded[pos] = false;
                    this.addRow(this.row);
                } else {
                    DmuTableModel.this.data.add(o2);
                    this.row = DmuTableModel.this.data.size() - 1;
                    if (DmuTableModel.this.loaded.length <= this.row) {
                        boolean[] tmp = new boolean[DmuTableModel.this.loaded.length * 2];
                        System.arraycopy(DmuTableModel.this.loaded, 0, tmp, 0, DmuTableModel.this.loaded.length);
                        DmuTableModel.access$802(DmuTableModel.this, tmp);
                    }
                    ((DmuTableModel)DmuTableModel.this).loaded[this.row] = false;
                    this.addRow(this.row);
                }
            }
            return this.cont;
        }
    }
}

