/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.ui.listSelect;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class DbFilterPane
extends JPanel {
    final short[] ARCHIVE_TAGS = new short[0];
    final short[] UNARCHIVE_TAGS = new short[0];
    final short[] PATIENT_NAME_TAGS = new short[]{16, 16};
    final short[] DATE_TAGS = new short[]{8, 32};
    final short[] MODALITY_TAGS = new short[]{8, 96};
    final short[] EXAM_TYPE_TAGS = new short[]{32, 16};
    final int ALL = 0;
    final int ARCHIVED = 1;
    final int UNARCHIVED = 2;
    final int CT = 3;
    final int MR = 4;
    final int US = 5;
    final int X_RAY = 6;
    final int PET = 7;
    final int NUCLEAR = 8;
    final int PATIENT_NAME = 9;
    final int DATE = 10;
    final int EXAM_TYPE = 11;
    public final int TEXT_ENABLED_INDEX = 8;
    protected JComboBox categoryCombo_ = new JComboBox();
    String currentCategory = "All";
    String conffile;
    String[] queryString;
    String[] categoryList_;
    int selIndex = 0;
    protected JTextField valueField_ = new JTextField();
    protected JLabel titleLabel_ = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    Border border1;

    public DbFilterPane() {
        if (System.getProperty("FILTER_CONFIG_FILE") != null) {
            System.out.println("CONFIG FILE = " + System.getProperty("FILTER_CONFIG_FILE"));
            this.parseConfigfile(System.getProperty("FILTER_CONFIG_FILE"));
        } else {
            this.parseConfigfile(this.getClass().getResourceAsStream("filter.txt"));
        }
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void parseConfigfile(String file) {
        try {
            this.parseConfigfile(new BufferedReader(new FileReader(file)));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void parseConfigfile(InputStream file) {
        this.parseConfigfile(new BufferedReader(new InputStreamReader(file)));
    }

    public void parseConfigfile(BufferedReader br) {
        try {
            String line;
            ArrayList<String> l1 = new ArrayList<String>();
            ArrayList<String> l2 = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                StringTokenizer t2 = new StringTokenizer(line, ":");
                String tmp = t2.nextToken();
                l1.add(tmp);
                this.categoryCombo_.addItem(tmp);
                try {
                    l2.add(t2.nextToken());
                }
                catch (NoSuchElementException ex) {
                    System.out.println("No query string for- \"" + tmp + "\"");
                    l2.add(null);
                }
            }
            this.categoryList_ = l1.toArray(new String[0]);
            this.queryString = l2.toArray(new String[0]);
            br.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public JComboBox getComboBox() {
        return this.categoryCombo_;
    }

    public JTextField getTextField() {
        return this.valueField_;
    }

    public String getCurrentCategory() {
        return this.currentCategory;
    }

    public String getValueEnetred() {
        return this.valueField_.getText();
    }

    private void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.valueField_.setEnabled(false);
        this.valueField_.setPreferredSize(new Dimension(120, 27));
        this.titleLabel_.setFont(new Font("Lucida Sans Typewriter ", 1, 15));
        this.titleLabel_.setToolTipText("");
        this.titleLabel_.setText("Show :");
        this.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(20);
        this.add((Component)this.titleLabel_, null);
        this.add((Component)this.categoryCombo_, null);
        this.add((Component)this.valueField_, null);
    }

    public void setPtkLAF() {
    }

    public String getQueryString(int selIndex) {
        if (selIndex <= this.queryString.length) {
            if (this.queryString[selIndex] == null) {
                return null;
            }
            if (this.queryString[selIndex].indexOf("=") > 0 || this.queryString[selIndex].indexOf(">") > 0 || this.queryString[selIndex].indexOf("<") > 0) {
                return this.queryString[selIndex];
            }
            this.valueField_.setEnabled(true);
            String str = this.valueField_.getText();
            String qryString = str.indexOf("=") > 0 || str.indexOf(">") > 0 || str.indexOf("<") > 0 ? this.queryString[selIndex] + str : this.queryString[selIndex] + " = " + str;
            return qryString;
        }
        return null;
    }

    public static void main(String[] args) {
        DbFilterPane DBDisplayFilter1 = new DbFilterPane();
        JFrame frame = new JFrame("Display filter");
        frame.setSize(830, 600);
        frame.setBackground(Color.gray);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        frame.getContentPane().add((Component)DBDisplayFilter1, "Center");
        frame.setVisible(true);
    }
}

