/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.ui.network;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;

public class NetworkTableModel
extends AbstractTableModel {
    private String[] name = new String[0];
    private String[] aetitle = new String[0];
    private String[] address = new String[0];
    private String[] port = new String[0];
    private String myAE;
    String[] columnNames = new String[]{"name", "aetitle", "address", "port"};

    public void setMyAeTitle(String aeTitle) {
        this.myAE = aeTitle;
    }

    public String getMyAeTitle() {
        return this.myAE;
    }

    public NetworkTableModel() {
        try {
            this.myAE = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public int getRowCount() {
        return this.name.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && this.name.length > rowIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.name[rowIndex];
                }
                case 1: {
                    return this.aetitle[rowIndex];
                }
                case 2: {
                    return this.address[rowIndex];
                }
                case 3: {
                    return this.port[rowIndex];
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.name[rowIndex] = (String)aValue;
                return;
            }
            case 1: {
                this.aetitle[rowIndex] = (String)aValue;
                return;
            }
            case 2: {
                this.address[rowIndex] = (String)aValue;
                return;
            }
            case 3: {
                this.port[rowIndex] = (String)aValue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String fileName) {
        Properties p2 = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            p2.load(fis);
        }
        catch (IOException ex) {
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
        int size = Integer.parseInt(p2.getProperty("length", "0"));
        String[] t_name = new String[size];
        String[] t_aetitle = new String[size];
        String[] t_address = new String[size];
        String[] t_port = new String[size];
        for (int i2 = 0; i2 < t_name.length; ++i2) {
            StringTokenizer st = new StringTokenizer(p2.getProperty("entry" + i2), ",");
            t_name[i2] = st.nextToken();
            t_aetitle[i2] = st.nextToken();
            t_address[i2] = st.nextToken();
            t_port[i2] = st.nextToken();
        }
        this.myAE = p2.getProperty("MyAE", this.myAE);
        this.name = t_name;
        this.aetitle = t_aetitle;
        this.address = t_address;
        this.port = t_port;
        System.out.println("loaded file- " + fileName);
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(String fileName) {
        Properties p2 = new Properties();
        p2.setProperty("length", Integer.toString(this.name.length));
        for (int i2 = 0; i2 < this.name.length; ++i2) {
            p2.setProperty("entry" + i2, this.name[i2] + "," + this.aetitle[i2] + "," + this.address[i2] + "," + this.port[i2]);
        }
        p2.setProperty("MyAE", this.myAE);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            p2.store(fos, "HOSTLIST");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public void addRow() {
        int size = this.name.length + 1;
        String[] t_name = new String[size];
        String[] t_aetitle = new String[size];
        String[] t_address = new String[size];
        String[] t_port = new String[size];
        System.arraycopy(this.name, 0, t_name, 0, this.name.length);
        System.arraycopy(this.aetitle, 0, t_aetitle, 0, this.aetitle.length);
        System.arraycopy(this.address, 0, t_address, 0, this.address.length);
        System.arraycopy(this.port, 0, t_port, 0, this.port.length);
        this.name = t_name;
        this.aetitle = t_aetitle;
        this.address = t_address;
        this.port = t_port;
        this.fireTableStructureChanged();
    }

    public void deleteRow(int row) {
        if (this.name == null || this.name.length == 0) {
            return;
        }
        int size = this.name.length - 1;
        String[] t_name = new String[size];
        String[] t_aetitle = new String[size];
        String[] t_address = new String[size];
        String[] t_port = new String[size];
        int j2 = 0;
        for (int i2 = 0; i2 < this.name.length; ++i2) {
            if (i2 == row) continue;
            t_name[j2] = this.name[i2];
            t_aetitle[j2] = this.aetitle[i2];
            t_address[j2] = this.address[i2];
            t_port[j2] = this.port[i2];
            ++j2;
        }
        this.name = t_name;
        this.aetitle = t_aetitle;
        this.address = t_address;
        this.port = t_port;
        this.fireTableRowsDeleted(row, row);
    }

    public String[] getNames() {
        return this.name;
    }
}

