/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.ui.wl;

import com.ge.med.terra.tap.ui.wl.WindowLevelModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

public class WindowLevelControl
extends JPanel {
    protected int minimum_;
    protected int maximum_;
    protected WindowLevelModel model_ = null;
    protected boolean minMaxControlsVisible_ = true;
    protected boolean windowLevelControlsVisible_ = true;
    protected Color[] colorMap_;
    protected List listeners_ = new ArrayList();
    ChangeListener modelListener_ = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e2) {
            WindowLevelControl.this.fromModel();
            WindowLevelControl.this.fireStateChanged();
        }
    };
    protected static final int RANGE_MINIMUM = 0;
    protected static final int RANGE_MAXIMUM = 1;
    protected static final int WINDOW_MAXIMUM = 2;
    protected static final int WINDOW_MINIMUM = 4;
    protected static final int WINDOW_CENTER = 3;
    protected JSlider[] slider_ = new JSlider[]{new JSlider(-100, 100, 0), new JSlider(-100, 100, 0), new JSlider(-100, 100, 0), new JSlider(-100, 100, 0), new JSlider(-100, 100, 0)};
    protected int modelUpdate_ = 0;
    adaptor mouseUP = null;

    public int getMinimum() {
        return this.model_.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model_.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model_.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model_.setMaximum(maximum);
    }

    public int getWindowCenter() {
        return this.model_.getCenter();
    }

    public void setWindowCenter(int center) {
        this.model_.setCenter(center);
    }

    public int getWindowWidth() {
        return this.model_.getWidth();
    }

    public void setWindowWidth(int width) {
        this.model_.setWidth(width);
    }

    public WindowLevelModel getModel() {
        return this.model_;
    }

    public void setModel(WindowLevelModel model) {
        if (this.model_ != null) {
            this.model_.removeChangeListener(this.modelListener_);
        }
        this.model_ = model;
        this.model_.addChangeListener(this.modelListener_);
    }

    public int getOrientation() {
        return this.slider_[0].getOrientation();
    }

    public void setOrientation(int orientation) {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setOrientation(orientation);
        }
    }

    public boolean getPaintLabels() {
        return this.slider_[0].getPaintLabels();
    }

    public void setPaintLabels(boolean paintLabels) {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setPaintLabels(paintLabels);
        }
    }

    public boolean getPaintTicks() {
        return this.slider_[0].getPaintTicks();
    }

    public void setPaintTicks(boolean paintTicks) {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setPaintTicks(paintTicks);
        }
    }

    public boolean getMinMaxControlsVisible() {
        return this.minMaxControlsVisible_;
    }

    public void setMinMaxControlsVisible(boolean mmcv) {
        this.minMaxControlsVisible_ = mmcv;
        this.revalidate();
    }

    public boolean getWindowLevelControlsVisible() {
        return this.windowLevelControlsVisible_;
    }

    public void setWindowLevelControlsVisible(boolean wlcv) {
        this.windowLevelControlsVisible_ = wlcv;
        this.revalidate();
    }

    public Color[] getColorMap() {
        return this.colorMap_;
    }

    public void setColorMap(Color[] colorMap) {
        this.colorMap_ = colorMap;
        this.slider_[0].setBackground(this.colorMap_[0]);
        this.slider_[4].setBackground(this.colorMap_[0]);
        this.slider_[1].setBackground(this.colorMap_[this.colorMap_.length - 1]);
        this.slider_[2].setBackground(this.colorMap_[this.colorMap_.length - 1]);
        this.slider_[3].setBackground(this.colorMap_.length > 2 ? this.colorMap_[this.colorMap_.length / 2] : new Color((this.colorMap_[0].getRed() + this.colorMap_[this.colorMap_.length - 1].getRed()) / 2, (this.colorMap_[0].getGreen() + this.colorMap_[this.colorMap_.length - 1].getGreen()) / 2, (this.colorMap_[0].getBlue() + this.colorMap_[this.colorMap_.length - 1].getBlue()) / 2));
    }

    public void setColorMap(int[] colorMap) {
        Color[] cm = new Color[colorMap.length];
        for (int i2 = 0; i2 < colorMap.length; ++i2) {
            cm[i2] = new Color(colorMap[i2]);
        }
        this.setColorMap(cm);
    }

    public void addChangeListener(ChangeListener l2) {
        this.listeners_.add(l2);
    }

    public void removeChangeListener(ChangeListener l2) {
        this.listeners_.remove(l2);
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator i2 = this.listeners_.iterator();
        while (i2.hasNext()) {
            ((ChangeListener)i2.next()).stateChanged(event);
        }
    }

    protected void updateRange() {
        int i2;
        int i3;
        int minimum = this.model_.getMinimum();
        int maximum = this.model_.getMaximum();
        for (i3 = 0; i3 < 5; ++i3) {
            minimum = Math.min(minimum, Math.min(this.slider_[i3].getMinimum(), this.slider_[i3].getValue()));
        }
        for (i3 = 0; i3 < 5; ++i3) {
            maximum = Math.max(maximum, Math.max(this.slider_[i3].getMaximum(), this.slider_[i3].getValue()));
        }
        for (i3 = 0; i3 < 5; ++i3) {
            BoundedRangeModel model = this.slider_[i3].getModel();
            model.setRangeProperties(model.getValue(), model.getExtent(), minimum, maximum, model.getValueIsAdjusting());
        }
        int tick = 1;
        for (i2 = (maximum - minimum) / 2; i2 > 10; i2 /= 10) {
            tick *= 10;
        }
        for (i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setMajorTickSpacing(tick);
            this.slider_[i2].setMinorTickSpacing(tick / 10);
            if (i2 != 3) continue;
            this.slider_[i2].setLabelTable(this.slider_[i2].createStandardLabels(tick, minimum / tick * tick));
        }
    }

    protected void toModel(int i2) {
        if (this.modelUpdate_ > 0) {
            return;
        }
        switch (i2) {
            case 0: {
                this.model_.setMinimum(this.slider_[i2].getValue());
                break;
            }
            case 1: {
                this.model_.setMaximum(this.slider_[i2].getValue());
                break;
            }
            case 2: {
                if (this.slider_[i2].getValue() < this.model_.getMinimum()) {
                    this.model_.setMaximum(this.slider_[i2].getValue());
                    break;
                }
                this.model_.setWidth(2 * (this.slider_[i2].getValue() - this.model_.getCenter()));
                break;
            }
            case 3: {
                this.model_.setCenter(this.slider_[i2].getValue());
                break;
            }
            case 4: {
                if (this.slider_[i2].getValue() > this.model_.getMaximum()) {
                    this.model_.setMinimum(this.slider_[i2].getValue());
                    break;
                }
                this.model_.setWidth(2 * (this.model_.getCenter() - this.slider_[i2].getValue()));
            }
        }
    }

    protected void fromModel() {
        ++this.modelUpdate_;
        this.updateRange();
        for (int i2 = 0; i2 < 5; ++i2) {
            int v2 = 0;
            switch (i2) {
                case 0: {
                    v2 = this.model_.getMinimum();
                    break;
                }
                case 1: {
                    v2 = this.model_.getMaximum();
                    break;
                }
                case 2: {
                    v2 = this.model_.getMaximum();
                    break;
                }
                case 3: {
                    v2 = this.model_.getCenter();
                    break;
                }
                case 4: {
                    v2 = this.model_.getMinimum();
                }
            }
            this.slider_[i2].setValue(v2);
        }
        --this.modelUpdate_;
    }

    public WindowLevelControl() {
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return WindowLevelControl.this.slider_[3].getMinimumSize();
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return WindowLevelControl.this.slider_[3].getPreferredSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                Dimension size = parent.getSize();
                for (int i2 = 0; i2 < WindowLevelControl.this.slider_.length; ++i2) {
                    WindowLevelControl.this.slider_[i2].setSize(size);
                }
            }
        });
        this.setModel(new WindowLevelModel());
        for (int i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setUI(new WLSliderUI(this.slider_[i2], i2));
            this.slider_[i2].setSnapToTicks(true);
            this.slider_[i2].setOpaque(false);
            final int iF = i2;
            this.slider_[i2].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e2) {
                    WindowLevelControl.this.toModel(iF);
                }
            });
            this.add(this.slider_[i2]);
        }
        this.setColorMap(new Color[]{Color.black, Color.white});
        this.fromModel();
    }

    public static void main(String[] argv) {
        for (int i2 = 0; i2 < argv.length; ++i2) {
            if (!argv[i2].equals("-version") && !argv[i2].equals("-v")) continue;
            System.out.println("@(#)@BUILD_INFO@");
            System.exit(0);
        }
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        WindowLevelControl wlc = new WindowLevelControl();
        wlc.setOrientation(1);
        wlc.setPaintLabels(true);
        wlc.setPaintTicks(true);
        wlc.setColorMap(new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta});
        wlc.setForeground(Color.white);
        frame.getContentPane().add(wlc);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void setRangeMinimum(int min) {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setMinimum(min);
        }
    }

    public int getRangeMinimum() {
        return this.slider_[0].getMinimum();
    }

    public void setRangeMaximum(int max) {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setMaximum(max);
        }
    }

    public int getRangeMaximum() {
        return this.slider_[0].getMaximum();
    }

    public void setMinMaxAndRange(int min, int max, int rmax, int rmin) {
        int i2;
        for (i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setMaximum(Short.MAX_VALUE);
            this.slider_[i2].setMinimum(Short.MIN_VALUE);
        }
        this.model_.setMinimum(min);
        this.model_.setMaximum(max);
        for (i2 = 0; i2 < 5; ++i2) {
            this.slider_[i2].setMaximum(rmax);
            this.slider_[i2].setMinimum(rmax);
        }
    }

    public void addActionListener(ActionListener l2) {
        if (this.mouseUP == null) {
            this.mouseUP = new adaptor();
            for (int i2 = 0; i2 < 5; ++i2) {
                this.slider_[i2].addMouseListener(this.mouseUP);
            }
        }
        this.listenerList.add(ActionListener.class, l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.listenerList.remove(ActionListener.class, l2);
    }

    protected void fireActionPerformed(MouseEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ActionListener.class) continue;
            if (e2 == null) {
                e2 = new ActionEvent(this, 1001, "Mouseup", event.getModifiers());
            }
            ((ActionListener)listeners[i2 + 1]).actionPerformed(e2);
        }
    }

    class adaptor
    extends MouseAdapter {
        adaptor() {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            WindowLevelControl.this.fireActionPerformed(e2);
        }
    }

    protected class WLSliderUI
    extends BasicSliderUI {
        protected int k_;

        public WLSliderUI(JSlider s2, int k2) {
            super(s2);
            this.k_ = k2;
        }

        @Override
        protected void calculateThumbLocation() {
            super.calculateThumbLocation();
            if (WindowLevelControl.this.getMinMaxControlsVisible() && WindowLevelControl.this.getWindowLevelControlsVisible()) {
                if (this.slider.getOrientation() == 0) {
                    this.thumbRect.height = this.trackRect.height / 2;
                    if (this.k_ > 1) {
                        this.thumbRect.y = this.trackRect.y + this.trackRect.height - this.thumbRect.height;
                    }
                } else {
                    this.thumbRect.width = this.trackRect.width / 2;
                    if (this.k_ > 1) {
                        this.thumbRect.x = this.trackRect.x + this.trackRect.width - this.thumbRect.width;
                    }
                }
            } else {
                if (this.k_ < 1 && !WindowLevelControl.this.getMinMaxControlsVisible()) {
                    this.thumbRect.height = 0;
                    this.thumbRect.width = 0;
                }
                if (this.k_ >= 2 && !WindowLevelControl.this.getWindowLevelControlsVisible()) {
                    this.thumbRect.height = 0;
                    this.thumbRect.width = 0;
                }
            }
        }

        @Override
        public boolean contains(JComponent c2, int x2, int y2) {
            return this.thumbRect.contains(x2, y2);
        }

        @Override
        protected void calculateTrackBuffer() {
            this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
        }

        @Override
        protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
            final JSlider sliderF = slider;
            return new BasicSliderUI.TrackListener(){
                protected int pressedPosition_;
                protected int pressedValue_;
                protected double pressedScale_;

                @Override
                public void mousePressed(MouseEvent e2) {
                    super.mousePressed(e2);
                    this.pressedPosition_ = sliderF.getOrientation() == 0 ? e2.getX() : e2.getY();
                    this.pressedValue_ = sliderF.getValue();
                    this.pressedScale_ = (double)(sliderF.getMaximum() - sliderF.getMinimum()) / (double)(sliderF.getOrientation() == 0 ? ((WLSliderUI)WLSliderUI.this).trackRect.width : -((WLSliderUI)WLSliderUI.this).trackRect.height);
                }

                @Override
                public void mouseDragged(MouseEvent e2) {
                    if (!sliderF.isEnabled()) {
                        return;
                    }
                    this.currentMouseX = e2.getX();
                    this.currentMouseY = e2.getY();
                    if (this.offset == 0) {
                        return;
                    }
                    int currentPosition = sliderF.getOrientation() == 0 ? e2.getX() : e2.getY();
                    int currentValue = this.pressedValue_ + (int)Math.round((double)(currentPosition - this.pressedPosition_) * this.pressedScale_);
                    BoundedRangeModel model = sliderF.getModel();
                    model.setRangeProperties(currentValue, model.getExtent(), Math.min(model.getMinimum(), currentValue), Math.max(model.getMaximum(), currentValue), model.getValueIsAdjusting());
                    if (sliderF.getOrientation() == 0) {
                        int halfThumbWidth = ((WLSliderUI)WLSliderUI.this).thumbRect.width / 2;
                        int finalPosition = WLSliderUI.this.xPositionForValue(sliderF.getValue());
                        WLSliderUI.this.setThumbLocation(finalPosition - halfThumbWidth, ((WLSliderUI)WLSliderUI.this).thumbRect.y);
                        this.pressedPosition_ = WLSliderUI.this.xPositionForValue(this.pressedValue_);
                    } else {
                        int halfThumbHeight = ((WLSliderUI)WLSliderUI.this).thumbRect.height / 2;
                        int finalPosition = WLSliderUI.this.yPositionForValue(sliderF.getValue());
                        WLSliderUI.this.setThumbLocation(((WLSliderUI)WLSliderUI.this).thumbRect.x, finalPosition - halfThumbHeight);
                        this.pressedPosition_ = WLSliderUI.this.yPositionForValue(this.pressedValue_);
                    }
                }
            };
        }

        @Override
        public void paintLabels(Graphics g2) {
            if (this.k_ != 3) {
                return;
            }
            super.paintLabels(g2);
        }

        @Override
        public void paintTrack(Graphics g2) {
            if (this.k_ != 4) {
                return;
            }
            Rectangle lowBounds = new Rectangle(this.trackRect);
            Rectangle rampBounds = new Rectangle(this.trackRect);
            Rectangle highBounds = new Rectangle(this.trackRect);
            if (this.slider.getOrientation() == 0) {
                rampBounds.x = this.xPositionForValue(WindowLevelControl.this.model_.getMinimum());
                lowBounds.width = rampBounds.x - lowBounds.x;
                highBounds.x = this.xPositionForValue(WindowLevelControl.this.model_.getMaximum());
                rampBounds.width = highBounds.x - rampBounds.x;
                highBounds.width -= lowBounds.width + rampBounds.width;
                g2.setColor(WindowLevelControl.this.colorMap_[0]);
                g2.fillRect(lowBounds.x, lowBounds.y, lowBounds.width, lowBounds.height);
                g2.setColor(WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1]);
                g2.fillRect(highBounds.x, highBounds.y, highBounds.width, highBounds.height);
                if (WindowLevelControl.this.colorMap_.length < 3) {
                    ((Graphics2D)g2).setPaint(new GradientPaint(rampBounds.x, 0.0f, WindowLevelControl.this.colorMap_[0], rampBounds.x + rampBounds.width, 0.0f, WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1]));
                    g2.fillRect(rampBounds.x, rampBounds.y, rampBounds.width, rampBounds.height);
                } else {
                    for (int i2 = 0; i2 < rampBounds.width - 1; ++i2) {
                        g2.setColor(WindowLevelControl.this.colorMap_[i2 * WindowLevelControl.this.colorMap_.length / rampBounds.width]);
                        g2.fillRect(rampBounds.x + i2, rampBounds.y, 1, rampBounds.height);
                    }
                }
            } else {
                rampBounds.y = this.yPositionForValue(WindowLevelControl.this.model_.getMaximum());
                highBounds.height = rampBounds.y - highBounds.y;
                lowBounds.y = this.yPositionForValue(WindowLevelControl.this.model_.getMinimum());
                rampBounds.height = lowBounds.y - rampBounds.y;
                lowBounds.height -= highBounds.height + rampBounds.height;
                g2.setColor(WindowLevelControl.this.colorMap_[0]);
                g2.fillRect(lowBounds.x, lowBounds.y, lowBounds.width, lowBounds.height);
                g2.setColor(WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1]);
                g2.fillRect(highBounds.x, highBounds.y, highBounds.width, highBounds.height);
                if (WindowLevelControl.this.colorMap_.length < 3) {
                    ((Graphics2D)g2).setPaint(new GradientPaint(0.0f, rampBounds.y, WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1], 0.0f, rampBounds.y + rampBounds.height, WindowLevelControl.this.colorMap_[0]));
                    g2.fillRect(rampBounds.x, rampBounds.y, rampBounds.width, rampBounds.height);
                } else {
                    for (int i3 = 0; i3 < rampBounds.height - 1; ++i3) {
                        g2.setColor(WindowLevelControl.this.colorMap_[i3 * WindowLevelControl.this.colorMap_.length / rampBounds.height]);
                        g2.fillRect(rampBounds.x, rampBounds.y + rampBounds.height - i3 - 1, rampBounds.width, 1);
                    }
                }
            }
        }

        @Override
        public void paintTicks(Graphics g2) {
            if (this.k_ != 3) {
                return;
            }
            Rectangle tickBounds = this.tickRect;
            int w2 = tickBounds.width;
            int h2 = tickBounds.height;
            g2.setColor(this.slider.getForeground());
            int maj = this.slider.getMajorTickSpacing();
            int min = this.slider.getMinorTickSpacing();
            if (this.slider.getOrientation() == 0) {
                int xPos;
                int value;
                g2.translate(0, tickBounds.y);
                if (this.slider.getMinorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMinorTickSpacing() * this.slider.getMinorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMinorTickSpacing()) {
                        xPos = this.xPositionForValue(value);
                        this.paintMinorTickForHorizSlider(g2, tickBounds, xPos);
                    }
                }
                if (this.slider.getMajorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMajorTickSpacing() * this.slider.getMajorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMajorTickSpacing()) {
                        xPos = this.xPositionForValue(value);
                        this.paintMajorTickForHorizSlider(g2, tickBounds, xPos);
                    }
                }
                g2.translate(0, -tickBounds.y);
            } else {
                int yPos;
                int value;
                g2.translate(tickBounds.x, 0);
                if (this.slider.getMinorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMinorTickSpacing() * this.slider.getMinorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMinorTickSpacing()) {
                        yPos = this.yPositionForValue(value);
                        this.paintMinorTickForVertSlider(g2, tickBounds, yPos);
                    }
                }
                if (this.slider.getMajorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMajorTickSpacing() * this.slider.getMajorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMajorTickSpacing()) {
                        yPos = this.yPositionForValue(value);
                        this.paintMajorTickForVertSlider(g2, tickBounds, yPos);
                    }
                }
                g2.translate(-tickBounds.x, 0);
            }
        }
    }
}

