/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.SimpleUtilitiesBase;
import com.ge.med.terra.tap.util.clientServer.RemoteObjectManager;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.tap.version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class SimpleUtilities
extends SimpleUtilitiesBase {
    private static Vector debugInfo = new Vector();

    public static void addDebugInfoNotify(Runnable r2) {
        debugInfo.add(r2);
    }

    public static void removeDebugInfoNotify(Runnable r2) {
        debugInfo.remove(r2);
    }

    public static void generateDebugInfo() {
        Iterator i2 = debugInfo.iterator();
        while (i2.hasNext()) {
            ((Runnable)i2.next()).run();
        }
    }

    public static String getLineSeparator() {
        String sep;
        try {
            sep = System.getProperty("line.separator");
        }
        catch (Exception ex) {
            sep = "\n";
        }
        return sep;
    }

    public static String getTempDir() {
        try {
            return System.getProperty("java.io.tmpdir");
        }
        catch (Exception e2) {
            return "/tmp";
        }
    }

    public static String[] cmdArgsToSessionArgs(String[] args) {
        if (args.length == 1 && args[0].indexOf(",") > 0) {
            return SimpleUtilities.cmdArgsToSessionArgs(args[0].split("\\,"));
        }
        String[] ret = new String[args.length];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = args[i2].equalsIgnoreCase("null") ? null : (args[i2].startsWith("\"") && args[i2].endsWith("\"") ? args[i2].substring(1, args[i2].length() - 1) : args[i2]);
        }
        return ret;
    }

    public static void copyFile(String src, String dest) {
        try {
            FileInputStream fis = new FileInputStream(src);
            SimpleUtilities.copyFile(fis, dest);
            fis.close();
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Unable to copy " + src + " to " + dest, e2);
            Tap.log.throwing(SimpleUtilities.class.getName(), "copyFile", e2);
            throw new RuntimeException(e2);
        }
    }

    public static void copyFile(InputStream src, String dest) {
        FileOutputStream fos = null;
        try {
            byte[] bbuff = new byte[32768];
            File newfile = new File(dest);
            if (!newfile.exists()) {
                newfile.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(dest);
            int len = 1;
            while (len != -1) {
                len = src.read(bbuff);
                if (len <= 0) continue;
                fos.write(bbuff, 0, len);
            }
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Unable to copy to " + dest, e2);
            Tap.log.throwing(SimpleUtilities.class.getName(), "copyFile", e2);
            throw new RuntimeException(e2);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static File[] getFilesRecursively(File rootDir) {
        ArrayList<File> arr = new ArrayList<File>();
        if (!rootDir.isDirectory()) {
            return new File[]{rootDir};
        }
        File[] list = rootDir.listFiles();
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (list[i2].isDirectory()) {
                File[] temp = SimpleUtilities.getFilesRecursively(list[i2]);
                for (int x2 = 0; x2 < temp.length; ++x2) {
                    arr.add(temp[x2]);
                }
                continue;
            }
            arr.add(list[i2]);
        }
        return arr.toArray(new File[0]);
    }

    public static File[] getFilesRecursively(String[] files) {
        File[] f2 = new File[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            f2[i2] = new File(files[i2]);
        }
        return SimpleUtilities.getFilesRecursively(f2);
    }

    public static File[] getFilesRecursively(File[] files) {
        Vector<File> vect = new Vector<File>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            vect.addAll(Arrays.asList(SimpleUtilities.getFilesRecursively(files[i2])));
        }
        File[] actualFiles = new File[vect.size()];
        for (int i3 = 0; i3 < actualFiles.length; ++i3) {
            actualFiles[i3] = (File)vect.get(i3);
        }
        return actualFiles;
    }

    public static void byteSwap(byte[] b2) {
        for (int i2 = 0; i2 < b2.length - 1; i2 += 2) {
            byte temp = b2[i2 + 1];
            b2[i2 + 1] = b2[i2];
            b2[i2] = temp;
        }
    }

    public static byte[] shortToByte(short[] s2) {
        return SimpleUtilities.shortToByte(s2, true);
    }

    public static byte[] shortToByte(short[] s2, boolean BE) {
        byte[] b2 = new byte[s2.length * 2];
        if (BE) {
            for (int i2 = 0; i2 < s2.length; ++i2) {
                b2[2 * i2] = (byte)(s2[i2] & 0xFF);
                b2[2 * i2 + 1] = (byte)(s2[i2] >> 8 & 0xFF);
            }
        } else {
            for (int i3 = 0; i3 < s2.length; ++i3) {
                b2[2 * i3] = (byte)(s2[i3] >> 8 & 0xFF);
                b2[2 * i3 + 1] = (byte)(s2[i3] & 0xFF);
            }
        }
        return b2;
    }

    public static short[] bytesToShort(byte[] b2, boolean BE) {
        short[] s2 = new short[b2.length / 2];
        if (BE) {
            for (int i2 = 0; i2 < s2.length; ++i2) {
                int tmp = i2 << 1;
                s2[i2] = (short)((b2[tmp] & 0xFF) << 8 | b2[tmp + 1] & 0xFF);
            }
        } else {
            for (int i3 = 0; i3 < s2.length; ++i3) {
                int tmp = i3 << 1;
                s2[i3] = (short)((b2[tmp + 1] & 0xFF) << 8 | b2[tmp] & 0xFF);
            }
        }
        return s2;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean deleteFilesRecursively(File root) {
        boolean flag = true;
        File[] children = root.listFiles();
        if (children == null || children.length == 0) {
            flag = flag && root.delete();
            return flag;
        }
        for (int i2 = 0; i2 < children.length; ++i2) {
            flag = flag && SimpleUtilities.deleteFilesRecursively(children[i2]);
        }
        flag = flag && root.delete();
        return flag;
    }

    public static int getPID() throws IOException, NumberFormatException {
        return Integer.parseInt(new File("/proc/self").getCanonicalFile().getName());
    }

    public static int getProcessID() {
        int pid = SimpleUtilities.getProcessIDFromName();
        if (0 == pid) {
            pid = SimpleUtilities.getProcessIDAndroid();
        }
        return pid;
    }

    public static int getProcessIDFromName() {
        String processName = "";
        try {
            Method method1 = Class.forName("java.lang.management.ManagementFactory").getMethod("getRuntimeMXBean", null);
            Method method2 = Class.forName("java.lang.management.RuntimeMXBean").getMethod("getName", null);
            Object bean = method1.invoke(null, (Object[])null);
            processName = (String)method2.invoke(bean, (Object[])null);
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to determine JVM process ID: ", ex);
        }
        Pattern pattern = Pattern.compile("^([0-9]+)@.+$", 2);
        Matcher matcher = pattern.matcher(processName);
        int pid = 0;
        if (matcher.matches()) {
            pid = Integer.parseInt(matcher.group(1));
        }
        return pid;
    }

    public static int getProcessIDAndroid() {
        int pid = 0;
        try {
            Method method = Class.forName("android.os.Process").getMethod("myTid", null);
            pid = (Integer)method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to determine process ID: ", ex);
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileFromURL(URLConnection urlConn, File destFile) throws IOException, MalformedURLException {
        byte[] buff = new byte[32768];
        InputStream is = urlConn.getInputStream();
        FileOutputStream os = new FileOutputStream(destFile.getAbsolutePath());
        try {
            int n2;
            while ((n2 = is.read(buff)) >= 0) {
                ((OutputStream)os).write(buff, 0, n2);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static boolean runWithMoreMemory(int mem, String[] args, String[] jvmargs) {
        int i2;
        if (args == null) {
            args = new String[]{};
        }
        if (jvmargs == null) {
            jvmargs = new String[]{};
        }
        String cp = System.getProperty("java.class.path");
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaw";
        Runtime run = Runtime.getRuntime();
        int max = (int)(run.maxMemory() / 0x100000L) + 1;
        if (max + 64 >= mem) {
            return false;
        }
        String classname = new Exception().getStackTrace()[1].getClassName();
        ArrayList<String> al2 = new ArrayList<String>(6 + args.length + jvmargs.length);
        al2.add(java);
        al2.add("-Xmx" + mem + "m");
        for (i2 = 0; i2 < jvmargs.length; ++i2) {
            al2.add(jvmargs[i2]);
        }
        al2.add("-cp");
        al2.add(cp);
        for (i2 = 0; i2 < args.length; ++i2) {
            al2.add(args[i2]);
        }
        al2.add(classname);
        String[] str = al2.toArray(new String[al2.size()]);
        try {
            Process p2 = Runtime.getRuntime().exec(str);
            SimpleUtilities.map(System.err, p2.getErrorStream(), true);
            SimpleUtilities.map(System.out, p2.getInputStream(), true);
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to execute command: ", ex);
        }
        return true;
    }

    public static void callStaticInNewJVM(Method m2, String[] args) {
        if (!Modifier.isStatic(m2.getModifiers())) {
            throw new IllegalArgumentException(m2 + " must be static");
        }
        if (args == null) {
            args = new String[]{};
        }
        String[] allargs = new String[args.length + 2];
        allargs[0] = m2.getDeclaringClass().getName();
        allargs[1] = m2.getName();
        System.arraycopy(args, 0, allargs, 2, args.length);
        try {
            Process p2 = SimpleUtilities.callInNewJVM(new String[0], SimpleUtilities.class.getName(), allargs);
            SimpleUtilities.map(System.err, p2.getErrorStream());
            SimpleUtilities.map(System.out, p2.getInputStream());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void callInNewJVM(Method m2) {
        String cp = System.getProperty("java.class.path");
        String[] args = new String[]{m2.getClass().getName(), m2.getName()};
        try {
            Process p2 = SimpleUtilities.callInNewJVM(cp, new String[0], SimpleUtilities.class.getName(), args);
            SimpleUtilities.map(System.err, p2.getErrorStream(), true);
            p2.waitFor();
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Unable to run method in new JVM: ", e2);
        }
    }

    public static void callInNewJVMAndWait(String classPath, String[] jvmArgs, String className, String[] cmdArgs) throws IOException, InterruptedException {
        Process p2 = SimpleUtilities.callInNewJVM(classPath, jvmArgs, className, cmdArgs);
        SimpleUtilities.map(System.err, p2.getErrorStream());
        SimpleUtilities.map(System.out, p2.getInputStream());
        p2.waitFor();
    }

    public static Process callInNewJVM(String classPath, String[] jvmArgs, String className, String[] args) throws IOException {
        String[] cmdStr = SimpleUtilities.buildExecStrings(classPath, jvmArgs, className, args);
        return Runtime.getRuntime().exec(cmdStr);
    }

    public static Process callInNewJVM(String[] jvmArgs, String className, String[] args) throws IOException {
        String[] str = SimpleUtilities.buildExecStrings(jvmArgs, className, args);
        return Runtime.getRuntime().exec(str);
    }

    public static String[] buildExecStrings(String[] jvmArgs, String className, String[] args) {
        String cp = System.getProperty("java.class.path");
        return SimpleUtilities.buildExecStrings(cp, jvmArgs, className, args);
    }

    public static String[] buildExecStrings(String classPath, String[] jvmArgs, String className, String[] args) {
        int i2;
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> al2 = new ArrayList<String>();
        al2.add(java);
        if (jvmArgs != null) {
            for (i2 = 0; i2 < jvmArgs.length; ++i2) {
                al2.add(jvmArgs[i2]);
            }
        }
        if (System.getProperty("java.vm.name").contains("Server")) {
            al2.add("-server");
        }
        al2.add("-classpath");
        al2.add(classPath);
        al2.add(className);
        if (args != null) {
            for (i2 = 0; i2 < args.length; ++i2) {
                al2.add(args[i2]);
            }
        }
        String[] cmdStr = al2.toArray(new String[al2.size()]);
        return cmdStr;
    }

    public static void map(OutputStream os, InputStream is) {
        SimpleUtilities.map(os, is, false);
    }

    public static void map(final OutputStream os, final InputStream is, final boolean exitOnBreak) {
        Thread t2 = new Thread(){

            @Override
            public void run() {
                byte[] buff = new byte[32768];
                try {
                    int n2;
                    while ((n2 = is.read(buff)) >= 0) {
                        os.write(buff, 0, n2);
                    }
                }
                catch (IOException ex) {
                    if (exitOnBreak) {
                        System.exit(0);
                    }
                    Tap.log.log(Level.WARNING, "Unable to read from the input stream: ", ex);
                }
            }
        };
        t2.setName("SimpleUtilies:map(exitOnBreak=" + exitOnBreak + ")");
        t2.start();
    }

    public static void main(String[] args) {
        Tap.setLogLevel(Level.WARNING);
        System.setOut(System.err);
        String className = args[0];
        String method = args[1];
        Object[] ret = new Object[1];
        try {
            Class<?> c2 = Class.forName(className);
            Method[] m2 = c2.getMethods();
            for (int i2 = 0; i2 < m2.length; ++i2) {
                if (!m2[i2].getName().equals(method) || !Modifier.isStatic(m2[i2].getModifiers())) continue;
                if (m2[i2].getParameterTypes().length == 1) {
                    if (m2[i2].getParameterTypes()[0].equals(String[].class)) {
                        String[] newArgs = new String[args.length - 2];
                        System.arraycopy(args, 2, newArgs, 0, newArgs.length);
                        ret[0] = m2[i2].invoke(null, new Object[]{newArgs});
                    }
                    if (m2[i2].getParameterTypes()[0].equals(String.class)) {
                        ret[0] = m2[i2].invoke(null, args[2]);
                    }
                } else if (m2[i2].getParameterTypes().length == 0) {
                    ret[0] = m2[i2].invoke(null, new Object[0]);
                }
                break;
            }
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Error during execution of main(): ", e2);
        }
    }

    public static Method getStaticMethod(String name) {
        Throwable t2 = new Throwable();
        try {
            Class<?> c2 = Class.forName(t2.getStackTrace()[1].getClassName());
            return c2.getMethod(name, null);
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Unable to get static method: ", e2);
            return null;
        }
    }

    public static String execReturnStr(String[] cmd) {
        try {
            Process p2 = Runtime.getRuntime().exec(cmd);
            StreamToString is = new StreamToString(p2.getInputStream());
            p2.waitFor();
            return is.toString();
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to execute command: ", ex);
            return null;
        }
    }

    public static void launchWebBrowser(String theUrl) {
        String cmdLine = "start " + theUrl;
        cmdLine = "cmd.exe /c " + cmdLine;
        try {
            Process p2 = Runtime.getRuntime().exec(cmdLine);
        }
        catch (Exception e2) {
            Tap.log.log(Level.WARNING, "Unable to launch web browser: ", e2);
        }
    }

    public static XmSession startServer() {
        try {
            SimpleUtilities.callStaticInNewJVM(SimpleUtilities.getStaticMethod("server_runServer"), null);
            SimpleUtilities.sleep(500L);
        }
        catch (RuntimeException e2) {
            Tap.log.log(Level.WARNING, "Unable to start server in separate JVM: ", e2);
        }
        XmSession xms = new XmSession("127.0.0.1", 7483);
        SimpleUtilities.sleep(1000L);
        return xms;
    }

    public static void endServer(XmSession xms) {
        RemoteObjectManager rom = new RemoteObjectManager(xms);
        rom.callStaticRMethod(SimpleUtilities.class.getName(), "server_exitInSecond", new Object[0], new Class[0]);
        xms.close();
        SimpleUtilities.sleep(1000L);
    }

    public static int server_exitInSecond() {
        Thread t2 = new Thread(){

            @Override
            public void run() {
                SimpleUtilities.sleep(1000L);
                System.exit(0);
                Tap.log.warning("JVM running server did not exit!");
            }
        };
        t2.start();
        return 1;
    }

    public static void dumpSystemInfo() {
        SimpleUtilities.logSystemInfo(null);
    }

    public static void logSystemInfo(Logger logger) {
        String LINE_SEPARATOR = SimpleUtilities.getLineSeparator();
        StringBuffer buffer = new StringBuffer(1024);
        try {
            buffer.append(SimpleUtilities.tab("JVM Process ID") + " = " + SimpleUtilities.getProcessID() + LINE_SEPARATOR);
            Properties p2 = System.getProperties();
            Object[] keys = new String[p2.size()];
            Enumeration<Object> e2 = p2.keys();
            String[] remove = new String[]{"java.class.path", "file.separator", "java.library.path", "java.specification.name", "java.specification.vendor", "line.separator", "sun.boot.class.path"};
            HashSet<String> rset = new HashSet<String>(Arrays.asList(remove));
            int i2 = 0;
            while (e2.hasMoreElements()) {
                keys[i2++] = (String)e2.nextElement();
            }
            Arrays.sort(keys);
            for (int j2 = 0; j2 < keys.length; ++j2) {
                if (rset.contains(keys[j2])) continue;
                String value = (String)p2.get(keys[j2]);
                buffer.append(SimpleUtilities.tab((String)keys[j2]) + " = \"" + value + "\"" + LINE_SEPARATOR);
            }
            Runtime r2 = Runtime.getRuntime();
            int ncpu = r2.availableProcessors();
            buffer.append(SimpleUtilities.tab("Number Of cores") + " = " + ncpu + LINE_SEPARATOR);
            long free = r2.freeMemory();
            buffer.append(SimpleUtilities.tab("freeMemory") + " = " + (float)(free / 1024L) / 1024.0f + "MB" + LINE_SEPARATOR);
            long max = r2.maxMemory();
            buffer.append(SimpleUtilities.tab("maxMemory") + " = " + (float)(max / 1024L) / 1024.0f + "MB" + LINE_SEPARATOR);
            InetAddress ip = InetAddress.getLocalHost();
            buffer.append(SimpleUtilities.tab("HostName") + " = " + ip.getCanonicalHostName() + LINE_SEPARATOR);
            buffer.append(SimpleUtilities.tab("HostAddress") + " = " + ip.getHostAddress() + LINE_SEPARATOR);
            buffer.append(SimpleUtilities.tab("Creation Time") + " = " + new Date(SimpleUtilities.getCreationTime()) + LINE_SEPARATOR);
            version v2 = version.getVersion();
            buffer.append(SimpleUtilities.tab("TAP version") + " = " + v2.getVersionString() + LINE_SEPARATOR);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            buffer.append(SimpleUtilities.tab("TAP build date") + " = " + df.parse(v2.getBuildDate()) + LINE_SEPARATOR);
        }
        catch (Exception e3) {
            Tap.log.log(Level.WARNING, "Error while dumping system properties: ", e3);
        }
        if (0 < buffer.length()) {
            buffer.insert(0, "Begin System Information" + LINE_SEPARATOR);
            buffer.append("INFO: End System Information" + LINE_SEPARATOR);
        }
        if (null == logger) {
            System.out.print(buffer.toString());
        } else {
            logger.info(buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCreationTime() {
        String subFile = SimpleUtilities.class.getName().replace('.', File.separatorChar) + ".class";
        String s2 = System.getProperty("java.class.path");
        String[] sp = s2.split(File.pathSeparator);
        for (int i2 = 0; i2 < sp.length; ++i2) {
            File f2 = new File(sp[i2]);
            if (f2.isDirectory()) {
                File path = new File(f2, subFile);
                if (!path.exists()) continue;
                return path.lastModified();
            }
            JarFile zf = null;
            try {
                long time;
                zf = new JarFile(f2);
                ZipEntry ze = zf.getEntry(SimpleUtilities.class.getName().replace('.', '/') + ".class");
                if (null == ze) continue;
                long l2 = time = ze.getTime();
                return l2;
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Unable to load JAR file " + f2.getAbsolutePath(), ioex);
                continue;
            }
            finally {
                if (null != zf) {
                    try {
                        zf.close();
                    }
                    catch (IOException ioex) {}
                }
            }
        }
        return -1L;
    }

    private static String tab(String s2) {
        int l2 = s2.length() / 8;
        String tabs = "\t\t\t";
        if ("\t\t\t".length() > l2) {
            return s2 + "\t\t\t".substring(l2);
        }
        return s2 + "\t";
    }

    public static void listThreads(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        try {
            ThreadGroup g2 = Thread.currentThread().getThreadGroup();
            while (g2.getParent() != null) {
                g2 = g2.getParent();
            }
            Thread[] t2 = new Thread[1024];
            int len = g2.enumerate(t2, true);
            for (int i2 = 0; i2 < len; ++i2) {
                out.println("[debug] [" + i2 + "]  " + t2[i2].getName() + " " + t2[i2]);
                StackTraceElement[] st = t2[i2].getStackTrace();
                for (int j2 = 0; j2 < st.length; ++j2) {
                    out.println("[debug]  at " + st[j2].getClassName() + "." + st[j2].getMethodName() + "(" + st[j2].getFileName() + ":" + st[j2].getLineNumber() + ")");
                }
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to list threads in given stream: ", ex);
        }
    }

    public static File creatRandomFile(String prefix, String suffix, int lengthKB, long seed) {
        FileOutputStream fos = null;
        try {
            File f2 = File.createTempFile(prefix, suffix);
            byte[] data = new byte[1024];
            Random r2 = new Random(seed);
            r2.nextBytes(data);
            fos = new FileOutputStream(f2);
            for (int i2 = 0; i2 < lengthKB; ++i2) {
                fos.write(data);
            }
            File file = f2;
            return file;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static void compareFiles(String file1, String file2) throws IOException {
        byte[] data1 = new byte[1024];
        byte[] data2 = new byte[1024];
        File fd1 = new File(file1);
        File fd2 = new File(file2);
        if (fd1.length() != fd2.length()) {
            System.out.println("file lengths differ " + fd1.length() + " != " + fd2.length());
        }
        FileInputStream fs1 = new FileInputStream(file1);
        FileInputStream fs2 = new FileInputStream(file2);
        try {
            long off = 0L;
            while (true) {
                int i2;
                int r2;
                int r1;
                if ((r1 = fs1.read(data1)) != (r2 = fs2.read(data2))) {
                    return;
                }
                if (r1 == -1 || r2 == -1) {
                    return;
                }
                boolean same = true;
                for (i2 = 0; i2 < r1; ++i2) {
                    if (data1[i2] == data2[i2]) continue;
                    same = false;
                }
                if (!same) {
                    String s2;
                    System.out.println("bytes not the same starting at offset = " + off);
                    for (i2 = 0; i2 < r1; ++i2) {
                        s2 = "0" + Integer.toHexString(data1[i2]);
                        s2 = s2.substring(s2.length() - 2);
                        if (i2 % 4 == 0) {
                            s2 = " " + s2;
                        }
                        System.out.print(s2);
                    }
                    System.out.println();
                    for (i2 = 0; i2 < r1; ++i2) {
                        s2 = "0" + Integer.toHexString(data2[i2]);
                        s2 = s2.substring(s2.length() - 2);
                        if (i2 % 4 == 0) {
                            s2 = " " + s2;
                        }
                        System.out.print(s2);
                    }
                    System.out.println("\n");
                    return;
                }
                off += (long)r1;
            }
        }
        finally {
            fs1.close();
            fs2.close();
        }
    }

    public static void verifyRandomFile(String file, int lengthKB, long seed) {
        FileInputStream fis = null;
        try {
            byte[] data = new byte[1024];
            byte[] data2 = new byte[1024];
            Random r2 = new Random(seed);
            r2.nextBytes(data);
            File f2 = new File(file);
            if (f2.length() != (long)(lengthKB * 1024)) {
                throw new RuntimeException("file of wrong length");
            }
            fis = new FileInputStream(file);
            for (int i2 = 0; i2 < lengthKB; ++i2) {
                int n2;
                for (int gotten = 0; gotten < data2.length; gotten += n2) {
                    n2 = fis.read(data2, gotten, data2.length - gotten);
                    if (n2 >= 0) continue;
                    throw new IOException("error in reading file ");
                }
                for (int j2 = 0; j2 < data2.length; ++j2) {
                    if (data2[i2] == data[i2]) continue;
                    throw new RuntimeException("file of bytes starting at " + (i2 * 1024 + j2));
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static void loadSystemProperties(String baseName) {
        ResourceBundle systemProperties = ResourceBundle.getBundle(baseName);
        String LINE_SEPARATOR = SimpleUtilities.getLineSeparator();
        StringBuffer buffer = new StringBuffer();
        Enumeration<String> e2 = systemProperties.getKeys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement();
            if (null != System.getProperty(key)) continue;
            String val = systemProperties.getString(key);
            buffer.append("\t" + key + " = \"" + val + "\"" + LINE_SEPARATOR);
            System.setProperty(key, val);
        }
        if (0 < buffer.length()) {
            buffer.insert(0, "Begin Loaded System Properties" + LINE_SEPARATOR);
            buffer.append("INFO: End Loaded System Properties");
            Tap.log.info(buffer.toString());
        }
    }

    public static void loadSystemProperties(Properties properties) {
        String LINE_SEPARATOR = SimpleUtilities.getLineSeparator();
        StringBuffer buffer = new StringBuffer();
        Enumeration<Object> e2 = properties.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            if (null != System.getProperty(key)) continue;
            String val = properties.getProperty(key);
            buffer.append("\t" + key + " = \"" + val + "\"" + LINE_SEPARATOR);
            System.setProperty(key, val);
        }
        if (0 < buffer.length()) {
            buffer.insert(0, "Begin Loaded System Properties" + LINE_SEPARATOR);
            buffer.append("INFO: End Loaded System Properties");
            Tap.log.info(buffer.toString());
        }
    }

    public static Properties getProperties(InputStream propstream, String property) {
        return SimpleUtilities.getProperties(propstream, property, false);
    }

    public static Properties getPropertiesCreate(InputStream propstream, String property) {
        return SimpleUtilities.getProperties(propstream, property, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(InputStream propstream, String property, boolean createFile) {
        Properties props = new Properties();
        FileInputStream cfgstream = null;
        FileOutputStream fos = null;
        try {
            String config;
            if (null != propstream) {
                props.load(propstream);
            }
            if ((config = System.getProperties().getProperty(property)) != null) {
                if (new File(config).exists()) {
                    cfgstream = new FileInputStream(config);
                    props.load(cfgstream);
                } else if (createFile) {
                    fos = new FileOutputStream(config);
                    props.store(fos, SimpleUtilities.class.getName());
                }
            }
        }
        catch (IOException ioex) {
            Tap.log.log(Level.WARNING, "Unable to load properties: ", ioex);
        }
        finally {
            if (null != cfgstream) {
                try {
                    cfgstream.close();
                }
                catch (IOException ioex) {}
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
        }
        return props;
    }
}

