/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DisplayDemoService
extends JPanel
implements XmService {
    XmServiceStatus status;
    XmSession xms;
    short serviceType;
    byte[] sbuff = new byte[100];
    ByteBuffer readBuffer = ByteBuffer.wrap(this.sbuff);
    BufferedImage img;
    byte[] bytedata = new byte[0];
    boolean server = true;
    BufferedImage serverimg = null;
    byte[] serverData = null;

    public DisplayDemoService() {
        this.status = new XmServiceStatus();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("DisplayDemoService");
        DisplayDemoService p2 = new DisplayDemoService();
        f2.setContentPane(p2);
        f2.setDefaultCloseOperation(3);
        f2.setBounds(10, 10, 512, 512);
        f2.setVisible(true);
        XmSession xms = new XmSession("3.70.208.122", 5248);
        xms.installHandle(p2);
    }

    @Override
    public void setID(short type) {
        this.serviceType = type;
    }

    @Override
    public short getID() {
        return this.serviceType;
    }

    @Override
    public void setParent(XmSession client) {
        this.xms = client;
        this.server = !client.isClient();
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (this.img != null) {
            g2.drawImage(this.img, 0, 0, null);
        }
    }

    @Override
    public int readMessage(InputStream is) throws IOException {
        return this.server ? this.readServerMessage(is) : this.readClientMessage(is);
    }

    public int readClientMessage(InputStream is) throws IOException {
        int n2;
        int[] imgbuf;
        if (this.img == null || this.img.getWidth() != this.getWidth() || this.img.getHeight() != this.getHeight()) {
            this.img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        if (this.bytedata.length != (imgbuf = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData()).length * 4) {
            this.bytedata = new byte[imgbuf.length * 4];
        }
        int len = 0;
        while ((len += (n2 = is.read(this.bytedata, len, this.bytedata.length - len))) < this.bytedata.length) {
        }
        ByteBuffer.wrap(this.bytedata).asIntBuffer().get(imgbuf);
        this.repaint();
        return len;
    }

    public int readServerMessage(InputStream is) throws IOException {
        int n2;
        int len = 0;
        while ((len += (n2 = is.read(this.sbuff, len, this.sbuff.length - len))) < this.sbuff.length) {
        }
        this.readBuffer.position(0);
        int w2 = this.readBuffer.getInt();
        int h2 = this.readBuffer.getInt();
        int x2 = this.readBuffer.getInt();
        int y2 = this.readBuffer.getInt();
        if (this.serverimg == null || this.serverimg.getWidth() != w2) {
            this.serverimg = new BufferedImage(w2, h2, 1);
            this.serverData = new byte[4 * w2 * h2];
        }
        Graphics g2 = this.serverimg.getGraphics();
        g2.setColor(Color.black);
        g2.fillRect(0, 0, w2, h2);
        g2.setColor(Color.red);
        g2.drawArc(x2 - 20, y2 - 20, 40, 40, 0, 360);
        g2.setColor(Color.blue);
        g2.drawString("(" + x2 + "," + y2 + ")", 20, 50);
        int[] imgbuf = ((DataBufferInt)this.serverimg.getRaster().getDataBuffer()).getData();
        ByteBuffer bdata = ByteBuffer.wrap(this.serverData);
        bdata.asIntBuffer().put(imgbuf);
        XmServiceAdapter s2 = new XmServiceAdapter(){

            @Override
            public short getID() {
                return DisplayDemoService.this.serviceType;
            }

            @Override
            public int writeMessage(OutputStream is, short mid) throws IOException {
                is.write(DisplayDemoService.this.serverData);
                return DisplayDemoService.this.serverData.length;
            }
        };
        this.xms.writeMessage(s2);
        return this.serverData.length;
    }

    @Override
    public int writeMessage(OutputStream is, short mid) throws IOException {
        return 0;
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                DisplayDemoService.this.this_mouseDragged(e2);
            }
        });
    }

    public void this_mouseDragged(MouseEvent e2) {
        final byte[] data = new byte[this.sbuff.length];
        ByteBuffer b2 = ByteBuffer.wrap(data);
        b2.putInt(this.getWidth());
        b2.putInt(this.getHeight());
        b2.putInt(e2.getX());
        b2.putInt(e2.getY());
        XmServiceAdapter s2 = new XmServiceAdapter(){

            @Override
            public short getID() {
                return DisplayDemoService.this.serviceType;
            }

            @Override
            public int writeMessage(OutputStream is, short mid) throws IOException {
                is.write(data);
                return data.length;
            }
        };
        this.xms.writeMessage(s2);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    @Override
    public void connectionLost() {
    }

    @Override
    public XmServiceStatus getStatus() {
        return this.status;
    }
}

