/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.clientServer.SyncManager;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

public class RemoteObjectManager {
    XmOService xos = new XmOService();

    public RemoteObjectManager(XmSession xms) {
        xms.installHandle(this.xos);
    }

    public short getID() {
        return this.xos.getID();
    }

    public XmServiceStatus getStatus() {
        return this.xos.getStatus();
    }

    public boolean isClosed() {
        return this.xos.isClosed();
    }

    public void close() {
        this.xos.close();
    }

    public Object createProxyObject(Class interfaceClass, String className, Object[] constructorArguments) {
        final int id = this.createObject(className, constructorArguments);
        InvocationHandler handler = new InvocationHandler(){
            int oid;
            {
                this.oid = id;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return RemoteObjectManager.this.callRemoteMethod(this.oid, method.getName(), args);
            }
        };
        Class<?> proxyClass = Proxy.getProxyClass(interfaceClass.getClassLoader(), interfaceClass);
        try {
            return proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public int createObject(Class c2, Object[] arguments) {
        return this.createObject(c2.getName(), arguments);
    }

    public int createObject(String className, Object[] arguments) {
        int tid = this.xos.sman.newTid();
        Msg m2 = new Msg(1, tid, new Object[]{className, arguments});
        this.xos.sendMessage(m2);
        Object k2 = this.xos.sman.waitForResponse(2001, tid);
        if (k2 instanceof Exception) {
            throw new RuntimeException((Exception)k2);
        }
        return (Integer)k2;
    }

    public Object callRemoteMethod(int ObjectId, String method, Object[] arguments) {
        int tid = this.xos.sman.newTid();
        Msg m2 = new Msg(2, tid, new Object[]{new Integer(ObjectId), method, arguments});
        this.xos.sendMessage(m2);
        Object o2 = this.xos.sman.waitForResponse(2002, tid);
        if ("null01".equals(o2)) {
            return null;
        }
        if (o2 instanceof Exception) {
            throw new RuntimeException((Exception)o2);
        }
        return o2;
    }

    public Object callRemoteMethod(int ObjectId, String method, Object[] arguments, Class[] param) {
        int tid = this.xos.sman.newTid();
        Msg m2 = new Msg(2, tid, new Object[]{new Integer(ObjectId), method, arguments, param});
        this.xos.sendMessage(m2);
        Object o2 = this.xos.sman.waitForResponse(2002, tid);
        if ("null01".equals(o2)) {
            return null;
        }
        if (o2 instanceof Exception) {
            throw new RuntimeException((Exception)o2);
        }
        return o2;
    }

    public Object callStaticRMethod(String className, String method, Object[] arguments) {
        int tid = this.xos.sman.newTid();
        Msg m2 = new Msg(3, tid, new Object[]{className, method, arguments});
        this.xos.sendMessage(m2);
        Object o2 = this.xos.sman.waitForResponse(2003, tid);
        if ("null01".equals(o2)) {
            return null;
        }
        if (o2 instanceof Exception) {
            throw new RuntimeException((Exception)o2);
        }
        return o2;
    }

    public Object callStaticRMethod(String className, String method, Object[] arguments, Class[] param) {
        int tid = this.xos.sman.newTid();
        Msg m2 = new Msg(3, tid, new Object[]{className, method, arguments, param});
        this.xos.sendMessage(m2);
        Object o2 = this.xos.sman.waitForResponse(2003, tid);
        if ("null01".equals(o2)) {
            return null;
        }
        if (o2 instanceof Exception) {
            throw new RuntimeException((Exception)o2);
        }
        return o2;
    }

    static class MsgQue {
        Vector mQue = new Vector();
        boolean destroy = false;

        MsgQue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMsg(Msg msg) {
            Vector vector = this.mQue;
            synchronized (vector) {
                this.mQue.add(msg);
                this.mQue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            this.destroy = true;
            Vector vector = this.mQue;
            synchronized (vector) {
                this.mQue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Msg getMsg() {
            Vector vector = this.mQue;
            synchronized (vector) {
                while (this.mQue.isEmpty() && !this.destroy) {
                    try {
                        this.mQue.wait();
                    }
                    catch (InterruptedException e2) {
                        if (!this.destroy) continue;
                        return null;
                    }
                }
                if (this.destroy) {
                    return null;
                }
                return (Msg)this.mQue.remove(0);
            }
        }
    }

    static class Msg {
        private int type;
        private int tid;
        private Object ldata;

        public Object getData() {
            return this.ldata;
        }

        public Msg(int type, int tid, Object data) {
            this.type = type;
            this.tid = tid;
            this.ldata = data;
        }

        public Msg() {
        }

        public Msg(byte[] buff) {
            ByteArrayInputStream bais = new ByteArrayInputStream(buff);
            try {
                ObjectInputStream o2 = new ObjectInputStream(bais);
                this.type = o2.readInt();
                this.tid = o2.readInt();
                this.ldata = o2.readObject();
                if (this.ldata instanceof String && ((String)this.ldata).equals("null01")) {
                    this.ldata = null;
                }
            }
            catch (ClassNotFoundException ex1) {
                ex1.printStackTrace();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }

        public final byte[] toByteArray() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(this.type);
                oos.writeInt(this.tid);
                if (this.ldata == null) {
                    oos.writeObject("null01");
                } else {
                    oos.writeObject(this.ldata);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return baos.toByteArray();
        }
    }

    static class XmOService
    extends XmServiceAdapter {
        public static final int RSP = 2000;
        public static final int CREATE_OBJECT = 1;
        public static final int CALL_METHOD = 2;
        public static final int CALL_STATIC_METHOD = 3;
        private static int tcount = 1;
        XmServiceStatus status;
        XmSession xms;
        SyncManager sman = new SyncManager();
        boolean server = true;
        HashMap objTable = new HashMap();
        Vector out = new Vector();
        byte[] readBytes = new byte[4];
        MsgQue readQue = new MsgQue();
        private Object lock = new Object();

        public XmOService() {
            this.status = new XmServiceStatus();
            this.setupReaderThread();
        }

        @Override
        public void setParent(XmSession client) {
            this.xms = client;
            this.server = !client.isClient();
        }

        private void readAll(InputStream is, byte[] buff) throws IOException {
            int n2;
            int off = 0;
            do {
                if ((n2 = is.read(buff, off, buff.length - off)) >= 0) continue;
                throw new RuntimeException("unable to read " + buff.length);
            } while ((off += n2) < buff.length);
        }

        @Override
        public int readMessage(InputStream is) throws IOException {
            this.readAll(is, this.readBytes);
            int len = Utils.getInt(this.readBytes, 0);
            byte[] data = new byte[len];
            this.readAll(is, data);
            Msg m2 = new Msg(data);
            this.readQue.addMsg(m2);
            return this.readBytes.length + len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosed() {
            Object object = this.lock;
            synchronized (object) {
                return null == this.xms.getHandle(this.getID());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.xms.uninstallHandle(this.getID());
            }
        }

        @Override
        public void connectionLost() {
            Tap.log.log(Level.INFO, "Connection lost with service type {0}", Short.toString(this.getID()));
            this.readQue.destroy();
        }

        public void setupReaderThread() {
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    Msg m2;
                    while ((m2 = XmOService.this.readQue.getMsg()) != null) {
                        if (m2.type > 2000) {
                            XmOService.this.sman.sendResponse(m2.type, m2.tid, m2.getData());
                            continue;
                        }
                        XmOService.this.processMessage(m2);
                    }
                    return;
                }
            };
            t2.setDaemon(true);
            t2.setName("RemoteObjectManager:233");
            t2.start();
        }

        public void processMessage(Msg m2) {
            try {
                switch (m2.type) {
                    case 1: {
                        Integer nid = new Integer(++tcount);
                        Object[] v2 = (Object[])m2.getData();
                        Object[] args = (Object[])v2[1];
                        String cname = (String)v2[0];
                        Class[] ptype = args == null ? new Class[]{} : new Class[args.length];
                        for (int i2 = 0; i2 < ptype.length; ++i2) {
                            ptype[i2] = args[i2].getClass();
                        }
                        Class<?> c2 = Class.forName(cname);
                        Object o2 = c2.getConstructor(ptype).newInstance(args);
                        this.objTable.put(nid, o2);
                        this.sendMessage(new Msg(2000 + m2.type, m2.tid, nid));
                        return;
                    }
                    case 2: {
                        Object[] v3 = (Object[])m2.getData();
                        Integer objectID = (Integer)v3[0];
                        String methodName = (String)v3[1];
                        Object[] args = (Object[])v3[2];
                        Method met = null;
                        Object o3 = this.objTable.get(objectID);
                        if (args != null) {
                            Class[] ptype;
                            if (v3.length == 4) {
                                ptype = (Class[])v3[3];
                            } else {
                                ptype = new Class[args.length];
                                for (int i3 = 0; i3 < ptype.length; ++i3) {
                                    ptype[i3] = args[i3].getClass();
                                }
                            }
                            try {
                                met = o3.getClass().getMethod(methodName, ptype);
                            }
                            catch (NoSuchMethodException e2) {
                                Method[] methods = o3.getClass().getMethods();
                                for (int i4 = 0; i4 < methods.length; ++i4) {
                                    Class<?>[] c3;
                                    if (!methodName.equals(methods[i4].getName()) || (c3 = methods[i4].getParameterTypes()).length != ptype.length) continue;
                                    met = methods[i4];
                                }
                            }
                        } else {
                            met = o3.getClass().getMethod(methodName, null);
                        }
                        Object ret = met.invoke(o3, args);
                        this.sendMessage(new Msg(2000 + m2.type, m2.tid, ret));
                        return;
                    }
                    case 3: {
                        Object[] v4 = (Object[])m2.getData();
                        String className = (String)v4[0];
                        String methodName = (String)v4[1];
                        Object[] args = (Object[])v4[2];
                        Method met = null;
                        if (args != null) {
                            Class[] ptype;
                            if (v4.length == 4) {
                                ptype = (Class[])v4[3];
                            } else {
                                ptype = new Class[args.length];
                                for (int i5 = 0; i5 < ptype.length; ++i5) {
                                    ptype[i5] = args[i5].getClass();
                                }
                            }
                            met = Class.forName(className).getMethod(methodName, ptype);
                        } else {
                            met = Class.forName(className).getMethod(methodName, null);
                        }
                        Object ret = met.invoke(null, args);
                        this.sendMessage(new Msg(2000 + m2.type, m2.tid, ret));
                        return;
                    }
                }
                this.sendMessage(new Msg(2000 + m2.type, m2.tid, new RuntimeException("unknown command")));
            }
            catch (Exception ex) {
                this.sendMessage(new Msg(2000 + m2.type, m2.tid, ex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage(Msg m2) {
            Object object = this.lock;
            synchronized (object) {
                final byte[] msg = m2.toByteArray();
                final byte[] lenBytes = new byte[4];
                Utils.putInt(lenBytes, 0, msg.length);
                XmServiceAdapter s2 = new XmServiceAdapter(){

                    @Override
                    public short getID() {
                        return XmOService.this.getID();
                    }

                    @Override
                    public int writeMessage(OutputStream os, short mid) throws IOException {
                        os.write(lenBytes);
                        os.write(msg);
                        return lenBytes.length + msg.length;
                    }
                };
                this.xms.writeMessage(s2);
            }
        }

        public static int objectSize(Object o2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return baos.toByteArray().length;
        }

        @Override
        public int writeMessage(OutputStream os, short mid) throws IOException {
            return 0;
        }

        @Override
        public XmServiceStatus getStatus() {
            return this.status;
        }
    }
}

