/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Utils {
    public static boolean getBoolean(byte[] b2, int off) {
        return b2[off] != 0;
    }

    public static void putBoolean(byte[] b2, int off, boolean val) {
        b2[off] = (byte)(val ? 1 : 0);
    }

    public static char getChar(byte[] b2, int off) {
        return (char)(((b2[off + 1] & 0xFF) << 0) + ((b2[off + 0] & 0xFF) << 8));
    }

    public static void putChar(byte[] b2, int off, char val) {
        b2[off + 1] = (byte)(val >>> 0);
        b2[off + 0] = (byte)(val >>> 8);
    }

    public static short getShort(byte[] b2, int off) {
        return (short)(((b2[off + 1] & 0xFF) << 0) + ((b2[off + 0] & 0xFF) << 8));
    }

    public static void putShort(byte[] b2, int off, short val) {
        b2[off + 1] = (byte)(val >>> 0);
        b2[off + 0] = (byte)(val >>> 8);
    }

    public static int getInt(byte[] b2, int off) {
        return ((b2[off + 3] & 0xFF) << 0) + ((b2[off + 2] & 0xFF) << 8) + ((b2[off + 1] & 0xFF) << 16) + ((b2[off + 0] & 0xFF) << 24);
    }

    public static void putInt(byte[] b2, int off, int val) {
        b2[off + 3] = (byte)(val >>> 0);
        b2[off + 2] = (byte)(val >>> 8);
        b2[off + 1] = (byte)(val >>> 16);
        b2[off + 0] = (byte)(val >>> 24);
    }

    public static long getLong(byte[] b2, int off) {
        return (((long)b2[off + 7] & 0xFFL) << 0) + (((long)b2[off + 6] & 0xFFL) << 8) + (((long)b2[off + 5] & 0xFFL) << 16) + (((long)b2[off + 4] & 0xFFL) << 24) + (((long)b2[off + 3] & 0xFFL) << 32) + (((long)b2[off + 2] & 0xFFL) << 40) + (((long)b2[off + 1] & 0xFFL) << 48) + (((long)b2[off + 0] & 0xFFL) << 56);
    }

    public static void putLong(byte[] b2, int off, long val) {
        b2[off + 7] = (byte)(val >>> 0);
        b2[off + 6] = (byte)(val >>> 8);
        b2[off + 5] = (byte)(val >>> 16);
        b2[off + 4] = (byte)(val >>> 24);
        b2[off + 3] = (byte)(val >>> 32);
        b2[off + 2] = (byte)(val >>> 40);
        b2[off + 1] = (byte)(val >>> 48);
        b2[off + 0] = (byte)(val >>> 56);
    }

    public static float getFloat(byte[] b2, int off) {
        int i2 = ((b2[off + 3] & 0xFF) << 0) + ((b2[off + 2] & 0xFF) << 8) + ((b2[off + 1] & 0xFF) << 16) + ((b2[off + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(i2);
    }

    public static void putFloat(byte[] b2, int off, float val) {
        int i2 = Float.floatToIntBits(val);
        b2[off + 3] = (byte)(i2 >>> 0);
        b2[off + 2] = (byte)(i2 >>> 8);
        b2[off + 1] = (byte)(i2 >>> 16);
        b2[off + 0] = (byte)(i2 >>> 24);
    }

    public static double getDouble(byte[] b2, int off) {
        long j2 = (((long)b2[off + 7] & 0xFFL) << 0) + (((long)b2[off + 6] & 0xFFL) << 8) + (((long)b2[off + 5] & 0xFFL) << 16) + (((long)b2[off + 4] & 0xFFL) << 24) + (((long)b2[off + 3] & 0xFFL) << 32) + (((long)b2[off + 2] & 0xFFL) << 40) + (((long)b2[off + 1] & 0xFFL) << 48) + (((long)b2[off + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(j2);
    }

    public static void putDouble(byte[] b2, int off, double val) {
        long j2 = Double.doubleToLongBits(val);
        b2[off + 7] = (byte)(j2 >>> 0);
        b2[off + 6] = (byte)(j2 >>> 8);
        b2[off + 5] = (byte)(j2 >>> 16);
        b2[off + 4] = (byte)(j2 >>> 24);
        b2[off + 3] = (byte)(j2 >>> 32);
        b2[off + 2] = (byte)(j2 >>> 40);
        b2[off + 1] = (byte)(j2 >>> 48);
        b2[off + 0] = (byte)(j2 >>> 56);
    }

    public static String getString(byte[] b2, int off) {
        int offset = off;
        int len = Utils.getShort(b2, offset);
        offset += 2;
        char[] charArray = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            charArray[i2] = Utils.getChar(b2, offset);
            offset += 2;
        }
        return new String(charArray);
    }

    public static final int getStringLengthInBytes(String s2) {
        return s2.length() * 2 + 2;
    }

    public static void putString(byte[] b2, int off, String s2) {
        int offset = off;
        Utils.putShort(b2, offset, (short)s2.length());
        offset += 2;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            Utils.putChar(b2, offset, s2.charAt(i2));
            offset += 2;
        }
    }

    public static void readFully(InputStream is, byte[] buff, int off, int len) throws IOException {
        int n2;
        int rlen = 0;
        do {
            if ((n2 = is.read(buff, off + rlen, len - rlen)) >= 0) continue;
            throw new IOException("end of stream");
        } while ((rlen += n2) < len);
    }

    public static void readFully(InputStream is, byte[] buff) throws IOException {
        Utils.readFully(is, buff, 0, buff.length);
    }

    public static short readShort(InputStream is, byte[] buff) throws IOException {
        Utils.readFully(is, buff, 0, 2);
        return Utils.getShort(buff, 0);
    }

    public static int readInt(InputStream is, byte[] buff) throws IOException {
        Utils.readFully(is, buff, 0, 4);
        return Utils.getInt(buff, 0);
    }

    public static long readLong(InputStream is, byte[] buff) throws IOException {
        Utils.readFully(is, buff, 0, 8);
        return Utils.getLong(buff, 0);
    }

    public static float readFloat(InputStream is, byte[] buff) throws IOException {
        Utils.readFully(is, buff, 0, 4);
        return Utils.getFloat(buff, 0);
    }

    public static double readDouble(InputStream is, byte[] buff) throws IOException {
        Utils.readFully(is, buff, 0, 8);
        return Utils.getDouble(buff, 0);
    }

    public static byte[] objectToBytes(Object o2) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(baos);
            os.writeObject(o2);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("object must be serializable");
        }
    }

    public static Object bytesToObject(byte[] buff) {
        try {
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(buff);
                return new ObjectInputStream(baos).readObject();
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalArgumentException("object must be serializable");
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("object must be serializable");
        }
    }

    public static Object bytesToObject(byte[] buff, int off, int len) {
        try {
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(buff, off, len);
                return new ObjectInputStream(baos).readObject();
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalArgumentException("object must be serializable");
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("object must be serializable");
        }
    }
}

