/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Vector;

public class XmProxy {
    private XmSession ses;
    public static final int PACKET_SIZE = 1000;

    public static void main(String[] args) {
        System.out.println("running the client....");
        try {
            XmProxy.readSomething(4664);
            Thread.sleep(1000L);
            XmSession ses = new XmSession("127.0.0.1", 5248);
            System.out.println("new XmSession");
            XmProxy prox = new XmProxy(ses);
            prox.mapPort(8080, 4664);
            System.out.println("prox.mapPort(8080,4664) ");
            Thread.sleep(200000L);
            System.out.println("shutting down.");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void readSomething(int n2) {
        try {
            String s2;
            URL u2 = new URL("http://127.0.0.1:" + n2 + "/search&s=ZKoS4CLfsMnrtEum-5x9iigmjZE?q=&ie=UTF-8");
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(u2.openStream()));
            int k2 = 0;
            while ((s2 = lnr.readLine()) != null) {
                ++k2;
            }
            System.out.println(">>>> read " + k2 + " lines <<<<<<<");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        System.out.println("-----------------------------");
    }

    public XmProxy(XmSession ses) {
        this.ses = ses;
    }

    public void mapPort(final int local, final int remote) {
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSocket ss = null;
                try {
                    try {
                        System.out.println("## accept  " + local);
                        ss = new ServerSocket(local);
                        while (true) {
                            Socket s2 = ss.accept();
                            System.out.println("## got connection " + s2.getInetAddress());
                            ProxyService p2 = new ProxyService();
                            p2.db = "##";
                            XmProxy.this.ses.installHandle(p2);
                            p2.connect(XmProxy.this.ses, s2, remote, local);
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        if (null != ss) {
                            try {
                                ss.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (null != ss) {
                        try {
                            ss.close();
                        }
                        catch (IOException ioex) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        };
        t2.setDaemon(true);
        t2.setName("map" + local + " to " + remote);
        t2.start();
    }

    static class ProxyService
    implements XmService {
        private XmServiceStatus status;
        private short type;
        private XmSession client;
        private Socket soc;
        private OutputStream os;
        private String db = "&&";
        private Vector outGoing = new Vector();
        private Vector unUsed = new Vector();
        private byte[] readlen;
        private byte[] readBuff;
        private short lastMID;

        public ProxyService() {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.unUsed.add(new Buff());
            }
            this.readlen = new byte[2];
            this.readBuff = new byte[1000];
            this.lastMID = (short)-1;
            this.status = new XmServiceStatus();
            this.db = "$$";
            System.out.println(this.db + "server side!!!");
            new Exception().printStackTrace();
        }

        public void queMsg(Buff out) {
            System.out.println(this.db + "queMsg " + out.len + " bytes");
            if (this.outGoing.isEmpty()) {
                this.outGoing.add(out);
                this.client.writeMessage(this);
            } else {
                this.outGoing.add(out);
            }
        }

        public void connect(XmSession ses, Socket s2, int remotePort, int localPort) {
            this.client = ses;
            this.soc = s2;
            Buff b2 = (Buff)this.unUsed.remove(0);
            b2.setToOpenSocket(remotePort);
            this.queMsg(b2);
            this.startReader(localPort);
        }

        private void startReader(int localPort) {
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    InputStream is;
                    try {
                        is = ProxyService.this.soc.getInputStream();
                        ProxyService.this.os = ProxyService.this.soc.getOutputStream();
                    }
                    catch (IOException e1) {
                        ProxyService.this.queMsg(((Buff)ProxyService.this.unUsed.remove(0)).close());
                        e1.printStackTrace();
                        return;
                    }
                    while (true) {
                        try {
                            Buff b2;
                            int k2;
                            while ((k2 = (b2 = (Buff)ProxyService.this.unUsed.remove(0)).read(is)) != -1) {
                                ProxyService.this.queMsg(b2);
                            }
                        }
                        catch (IOException e2) {
                            ProxyService.this.queMsg(((Buff)ProxyService.this.unUsed.remove(0)).close());
                            e2.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            t2.setDaemon(true);
            t2.setName("XmProxy read on " + localPort);
            t2.start();
        }

        synchronized void sendOne() {
        }

        @Override
        public void setID(short type) {
            this.type = type;
        }

        @Override
        public short getID() {
            return this.type;
        }

        @Override
        public void setParent(XmSession client) {
            System.out.println("public void setClient(XmSession client)");
            this.client = client;
        }

        @Override
        public void connectionLost() {
        }

        @Override
        public int readMessage(InputStream is) throws IOException {
            System.out.println(this.db + " readMessage ");
            Utils.readFully(is, this.readlen);
            short len = Utils.getShort(this.readlen, 0);
            if (len == 0) {
                this.os.close();
            }
            System.out.println(this.db + " reading " + len + " bytes");
            Utils.readFully(is, this.readBuff, 0, len);
            if (this.soc == null) {
                int localPort = Utils.getInt(this.readBuff, 0);
                this.soc = new Socket("127.0.0.1", localPort);
                System.out.println(this.db + " soc = new Socket(127.0.0.1," + localPort + ");");
                this.os = this.soc.getOutputStream();
                this.startReader(localPort);
                return len;
            }
            this.os.write(this.readBuff, 0, len);
            return len;
        }

        @Override
        public int writeMessage(OutputStream os, short mid) throws IOException {
            if (this.lastMID < mid || this.lastMID > mid + 10) {
                Buff b2 = (Buff)this.outGoing.remove(0);
                System.out.println(this.db + " Write " + b2.len + " bytes");
                os.write(b2.data, 0, b2.len);
                b2.mid = mid;
                this.unUsed.add(b2);
                if (!this.outGoing.isEmpty()) {
                    this.client.writeMessage(this);
                }
                this.lastMID = mid;
                return b2.len;
            }
            System.err.println(this.db + "Warning have to resend!");
            for (Buff b3 : this.unUsed) {
                if (b3.mid != mid) continue;
                os.write(b3.data, 0, b3.len);
                return b3.len;
            }
            return -1;
        }

        @Override
        public XmServiceStatus getStatus() {
            return this.status;
        }

        class Buff {
            short mid;
            int len;
            byte[] data = new byte[1002];

            Buff() {
            }

            int read(InputStream is) throws IOException {
                short ret = (short)is.read(this.data, 2, 1000);
                this.len = ret + 2;
                Utils.putShort(this.data, 0, ret);
                return ret;
            }

            void setToOpenSocket(int remotePort) {
                this.len = 6;
                Utils.putShort(this.data, 0, (short)4);
                Utils.putInt(this.data, 2, remotePort);
            }

            Buff close() {
                this.len = 2;
                Utils.putShort(this.data, 0, (short)0);
                return this;
            }
        }
    }
}

