/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class DemoFindFile {
    public static tagValue[] buildTagsToFind() {
        short[][] tags = new short[][]{{40, 16}, {40, 17}};
        tagValue[] tv = new tagValue[tags.length];
        for (int i2 = 0; i2 < tags.length; ++i2) {
            tv[i2] = new tagValue(tags[i2][0], tags[i2][1]);
        }
        return tv;
    }

    public static String[] getAllFiles(File file) {
        File[] f2 = file.listFiles();
        ArrayList<String> al2 = new ArrayList<String>();
        for (int i2 = 0; i2 < f2.length; ++i2) {
            if (f2[i2].isDirectory()) {
                String[] a2 = DemoFindFile.getAllFiles(f2[i2]);
                for (int k2 = 0; k2 < a2.length; ++k2) {
                    al2.add(a2[k2]);
                }
                continue;
            }
            al2.add(f2[i2].getAbsolutePath());
        }
        String[] strings = new String[al2.size()];
        for (int i3 = 0; i3 < strings.length; ++i3) {
            strings[i3] = (String)al2.get(i3);
        }
        return strings;
    }

    public static void main(String[] args) {
        int i2;
        String[] str = null;
        int errors = 0;
        int noDicom = 0;
        if (args.length != 1) {
            System.out.println("Missing top-level directory or file name to parse");
            return;
        }
        File f2 = new File(args[0]);
        str = f2.isDirectory() ? DemoFindFile.getAllFiles(f2) : new String[]{f2.getAbsolutePath()};
        System.out.println("searching " + str.length + " files ...");
        dicomParser dp = new dicomParser();
        tagValue[] tget = DemoFindFile.buildTagsToFind();
        System.out.println("SAMPLE... " + tget.length + " tags");
        long t1 = System.currentTimeMillis();
        for (i2 = 0; i2 < str.length; ++i2) {
            try {
                dp.setFile(str[i2]);
                dp.fill(tget);
                dp.clearFile();
                Object v1 = tget[0].value;
                Object v2 = tget[1].value;
                if (!(v1 instanceof Integer) || !(v1 instanceof Integer) || (Integer)v1 != 128 || (Integer)v2 != 128) continue;
                System.out.println(str[i2]);
                continue;
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) {
                    ++noDicom;
                    continue;
                }
                ++errors;
                System.out.println("file = " + str[i2] + "(" + i2 + "/" + str.length + ")");
                ex.printStackTrace();
            }
        }
        t1 = System.currentTimeMillis() - t1;
        System.out.println("Non dicom file = " + noDicom);
        System.out.println("parse errors   = " + noDicom);
        System.out.println("parsing " + str.length + " files in " + (double)t1 / 1000.0 + " avg = " + (double)t1 / (1.0 * (double)str.length) + " ms/file");
        tget = DemoFindFile.buildTagsToFind();
        System.out.println("DB  KEYS... " + tget.length + " tags");
        t1 = System.currentTimeMillis();
        for (i2 = 0; i2 < str.length; ++i2) {
            try {
                dp.setFile(str[i2]);
                dp.fill(tget);
                dp.clearFile();
                continue;
            }
            catch (FileNotFoundException ex) {
                System.out.println("file = " + str[i2]);
                ex.printStackTrace();
            }
        }
        t1 = System.currentTimeMillis() - t1;
        System.out.println("parsing " + str.length + " files in " + (double)t1 / 1000.0 + " avg = " + (double)t1 / (1.0 * (double)str.length) + " ms/file");
        System.exit(0);
        System.out.println("full");
        int count = 0;
        int inFileCount = 0;
        t1 = System.currentTimeMillis();
        int i3 = 0;
        tagValue tag2 = null;
        try {
            for (i3 = 0; i3 < str.length; ++i3) {
                try {
                    System.gc();
                    dp.setFile(str[i3]);
                    inFileCount = 0;
                    while (dp.hasMoreTags()) {
                        tag2 = dp.readNext();
                        ++count;
                        ++inFileCount;
                    }
                    dp.clearFile();
                    continue;
                }
                catch (FileNotFoundException ex) {
                    System.out.println("file = " + str[i3]);
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            System.err.println("crashed in reading " + i3 + " file= \"" + str[i3] + "\"");
            System.err.println("tag " + inFileCount + " = " + tag2);
            ex.printStackTrace();
        }
        t1 = System.currentTimeMillis() - t1;
        System.out.println("full parsing " + str.length + " files in " + (double)t1 / 1000.0 + " avg = " + (float)((double)t1 / (1.0 * (double)str.length)) + " ms/file");
        System.out.println("parsed " + count + " tags");
    }
}

